<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class TH90_E_Copyright extends \Elementor\Widget_Base {

	public function get_name() {
		return 'e-copyright';
	}

	public function get_title() {
		return __( 'Copyright', 'atlas-core' );
	}

	public function get_icon() {
		return 'eicon-info th90-widget-icon';
	}

	public function get_keywords() {
		return [ 'footer' ];
	}

	public function get_categories() {
		return [ sanitize_key( wp_get_theme()->name ) . '-elements' ];
	}

	protected function register_controls() {

		/* Section General */
		$this->start_controls_section(
			'section_block_general',
			[
				'label' => __( 'Copyright', 'atlas-core' ),
			]
		);

		$this->add_control(
			'shortcode',
			[
				'label'   => __( 'Copyright Text', 'atlas-core' ),
				'type'    => \Elementor\Controls_Manager::TEXTAREA,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( 'Copyright © [th90_current_year] [th90_site_title] | Powered by WordPress.', 'atlas-core' ),
			]
		);

		$this->add_control(
			'link',
			[
				'label'       => __( 'Link', 'atlas-core' ),
				'type'        => \Elementor\Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'atlas-core' ),
			]
		);

		$this->add_control(
			'align',
			[
				'label' => esc_html__( 'Alignments', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'toggle' => false,
				'options' => [
					'left'    => [
						'title' => esc_html__( 'Left', 'atlas-core' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'atlas-core' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'atlas-core' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'left',
				'prefix_class' => 'text-',
			]
		);

		$this->add_control(
			'color',
			[
				'label' => esc_html__('Text color', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .copyright-wrapper a, {{WRAPPER}} .copyright-wrapper' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'typography',
				'label' => esc_html__( 'Text typography', 'atlas-core' ),
				'selector' => '{{WRAPPER}} .copyright-wrapper a, {{WRAPPER}} .copyright-wrapper',
			]
		);

		$this->end_controls_section();

	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();

		$link = isset( $atts['link']['url'] ) ? $atts['link']['url'] : '';

		if ( ! empty( $link ) ) {
			$this->add_link_attributes( 'link', $atts['link'] );
		}

		$copyright_shortcode = do_shortcode( shortcode_unautop( $atts['shortcode'] ) ); ?>
		<div class="copyright-wrapper">
			<?php if ( ! empty( $link ) ) { ?>
				<a <?php echo wp_kses_post( $this->get_render_attribute_string( 'link' ) ); ?>>
					<span><?php echo wp_kses_post( $copyright_shortcode ); ?></span>
				</a>
			<?php } else { ?>
				<span><?php echo wp_kses_post( $copyright_shortcode ); ?></span>
			<?php } ?>
		</div>
		<?php

	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */
	protected function content_template() {}
}
