<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class TH90_E_Button extends \Elementor\Widget_Base {

	public function get_name() {
		return 'e_button';
	}

	public function get_title() {
		return __( 'Button', 'atlas-core' );
	}

	public function get_icon() {
		return 'eicon-button th90-widget-icon';
	}

	public function get_categories() {
		return [ sanitize_key( wp_get_theme()->name ) . '-elements' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_general',
			[
				'label' => __( 'General', 'atlas-core' ),
			]
		);

		$this->add_control(
			'text',
			[
				'label' => esc_html__( 'Text', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => esc_html__( 'Button Text', 'elementor' ),
				'placeholder' => esc_html__( 'Button Text', 'elementor' ),
			]
		);

		$this->add_control(
			'icon',
			[
				'label'       => esc_html__( 'SVG icon', 'atlas-core' ),
				'placeholder' => '<svg ...> ... </svg>',
				'type'        => \Elementor\Controls_Manager::TEXTAREA,
				'default'     => '',
				'label_block' => true,
			]
		);

		$this->add_control(
			'icon_pos',
			[
				'label'     => esc_html__( 'SVG icon position', 'atlas-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'left',
				'options'   => array(
					'left' => esc_html__( 'Left', 'elementor' ),
					'right' => esc_html__( 'Right', 'elementor' ),
				),
			]
		);

		$this->add_control(
			'link',
			[
				'label' => esc_html__( 'Link', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::URL,
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => esc_html__( 'https://your-link.com', 'atlas-core' ),
				'default' => [
					'url' => '#',
				],
			]
		);

		$this->add_control(
			'style',
			[
				'label'     => esc_html__( 'Button Style', 'atlas-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'default',
				'options'   => th90_default_options()['btn_style'],
			]
		);

		$this->add_control(
			'size',
			[
				'label'     => esc_html__( 'Button Size', 'atlas-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'medium',
				'options'   => th90_default_options()['btn_size'],
			]
		);

		$this->add_control(
			'_radius',
			[
				'label' => esc_html__( 'Button Radius', 'atlas-core' ),
				'type'  => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .button' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
                'condition'   => [
					 'style!' => ['text','text_color','text_underline'],
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'        => 'btn_typo',
				'label'       => esc_html__( 'Button typography', 'atlas-core' ),
				'selector'    => '{{WRAPPER}} .button',
			]
		);

		$this->end_controls_section();

	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render() {
		$atts = $this->get_settings_for_display();

		$classes = array(
			'button',
			'btn-' . $atts['size'],
			'btn-' . $atts['style'],
			'icon-' . $atts['icon_pos'],
		);

		if ( ! empty( $atts['link']['url'] ) ) {
			$this->add_link_attributes( 'button', $atts['link'] );
		}
		$this->add_render_attribute( 'button', 'class', implode( ' ', array_filter( $classes ) ) );

		if ( $atts['text'] ) {
			$this->add_render_attribute( 'button', 'title', $atts['text'] );
			?>
				<a <?php $this->print_render_attribute_string( 'button' ); ?>>
					<?php
					if ( $atts['icon'] ) {
						th90_svg_icon_custom( $atts['icon'] );
					}
					?>
					<span><?php echo esc_html( $atts['text'] ); ?></span>
				</a>
			<?php
		}
	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */
	protected function content_template() {}
}
