<?php
add_action('elementor/element/before_section_end', function( $element, $section_id, $args ) {
    if( $element->get_name() == 'container' && $section_id == 'section_layout_container' ){
        $skins = array();
        foreach ( th90_default_options()['skins_section'] as $key => $value ) {
            $skins[$key]['title'] = 'Style ' . $key;
            $skins[$key]['imagesmall'] = $value['img'];
            $skins[$key]['width'] = '33.3%';
            $skins[$key]['maxwidth'] = '95px';
        }
        $element->add_control(
			'_head_sticky_cont', [
				'separator' => 'before',
				'label' => wp_get_theme()->name . __( ' - Sticky Container', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);
        $element->add_control(
			'sticky_cont',
			[
                'label'        => esc_html__( 'Sticky Container?', 'atlas-core' ),
				'type'      => \Elementor\Controls_Manager::SWITCHER,
				'default'   => 'no',
                'return_value' => 'yes',
                'prefix_class' => 'sticky-',
			]
		);
        $element->add_control(
			'_head_skin', [
				'separator' => 'before',
				'label' => wp_get_theme()->name . __( ' - Container Skin', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);
        $element->add_control(
			'cont_skin', [
				'label' => esc_html__('Skin', 'atlas-core'),
                'description'	=> sprintf( esc_html__( 'You can customize the skin elements color from %1$sskin colors settings%2$s.', 'atlas-core' ), '<a target="_blank" href="' . admin_url('?page=th90_options&tab=3') . '"><strong>', '</strong></a>' ),
				'type' => 'imagechoose',
				'default' => 'inherit',
				'options' => $skins,
                'prefix_class' => 'is-skin bg-el bg-',
			]
		);
        $element->add_control(
			'cont_skin_inherit',
			[
				'label' => esc_html__( 'Inherit Skin', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HIDDEN,
				'default' => th90_opt_override_blank( 'site_skin' ),
                'prefix_class' => 'bg-',
                'conditions' => [
 					'terms' => [
 						['name' => 'cont_skin', 'operator' => 'in', 'value' => ['inherit']],
 					],
 				],
			]
		);
        $element->add_control(
			'cont_bg_nochange',
			[
                'label'        => esc_html__( 'No change when skin switch?', 'atlas-core' ),
                'description'	=> esc_html__( 'Skin is not change when you switch the skin from light to dark or otherwise.', 'atlas-core' ),
				'type'      => \Elementor\Controls_Manager::SWITCHER,
				'default'   => 'no',
                'return_value' => 'yes',
                'prefix_class' => 'nochange-',
			]
		);
        $element->add_control(
			'cont_bg_trans',
			[
                'label'        => esc_html__( 'Transparent background?', 'atlas-core' ),
				'type'      => \Elementor\Controls_Manager::SWITCHER,
				'default'   => 'no',
                'return_value' => 'transparent',
                'prefix_class' => 'bg-',
			]
		);
        $element->add_control(
			'cont_bg_sec',
			[
                'label'        => esc_html__( 'Secondary color background?', 'atlas-core' ),
				'type'      => \Elementor\Controls_Manager::SWITCHER,
				'default'   => 'no',
                'return_value' => 'sec',
                'prefix_class' => 'bg-',
                'condition'   => [
                     'cont_bg_trans!' => ['transparent'],
                ],
			]
		);

        $element->add_control(
			'_head_light_custom', [
				'separator' => 'before',
				'label' => wp_get_theme()->name . __( ' - Custom Light Skin', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::HEADING,
                'condition'   => [
                     'cont_bg_trans!' => ['transparent'],
                ],
			]
		);
        $element->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'light_cont_bg_color',
				'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}}.bg-light',
                'condition'   => [
                     'cont_bg_trans!' => ['transparent'],
                ],
			]
		);
        $element->add_control(
			'_head_dark_custom', [
				'separator' => 'before',
				'label' => wp_get_theme()->name . __( ' - Custom Dark Skin', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::HEADING,
                'condition'   => [
                     'cont_bg_trans!' => ['transparent'],
                ],

			]
		);
        $element->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'dark_cont_bg_color',
				'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}}.bg-dark',
                'condition'   => [
                     'cont_bg_trans!' => ['transparent'],
                ],
			]
		);
        /*$element->add_control(
			'_head_noise', [
				'separator' => 'before',
				'label' => wp_get_theme()->name . __( ' - Noise Container', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::HEADING,
			]
		);

        $element->add_control(
			'cont_bg_noise',
			[
                'label'        => esc_html__( 'Enable noise background?', 'atlas-core' ),
				'type'      => \Elementor\Controls_Manager::SWITCHER,
				'default'   => 'no',
                'return_value' => 'noise',
                'prefix_class' => 'bg-',
			]
		);
        $element->add_control(
		  'cont_bg_noise_op',
		  [
			  'label' =>esc_html__( 'Noise opacity', 'atlas-core' ),
			  'type' => \Elementor\Controls_Manager::SLIDER,
			  'range' => [
				  'px' => [
					  'min' => 0,
					  'max' => 1,
                      'step' => 0.01,
				  ],
			  ],
              'default' => [
					'unit' => 'px',
					'size' => 0.2,
                ],
			  'selectors' => [
				  '{{WRAPPER}}.bg-noise::after' => 'opacity: {{SIZE}};',
			  ],
              'condition'   => [
                   'cont_bg_noise' => ['noise'],
              ],

		  ]
      );*/

        $element->add_control(
			'_head_box_cont', [
				'separator' => 'before',
				'label' => wp_get_theme()->get( 'Name' ) . __( ' - Box Container', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::HEADING,
                'conditions' => [
 					'terms' => [
                        ['name' => 'content_width', 'operator' => 'in', 'value' => ['boxed']],
 					],
 				],
			]
		);
        $element->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'border_inner',
				'selector' => '{{WRAPPER}} > .e-con-inner',
                'conditions' => [
 					'terms' => [
                        ['name' => 'content_width', 'operator' => 'in', 'value' => ['boxed']],
 					],
 				],
			]
		);
        $element->add_control(
			'cont_box',
			[
                'label'        => esc_html__( 'Enable box?', 'atlas-core' ),
				'type'      => \Elementor\Controls_Manager::SWITCHER,
				'default'   => 'no',
                'return_value' => 'cont',
                'prefix_class' => 'box-',
                'condition'   => [
                     'content_width' => ['boxed'],
                ],
			]
		);
        /*$element->add_control(
			'solid_box',
			[
                'label'        => esc_html__( 'Solid box?', 'atlas-core' ),
				'type'      => \Elementor\Controls_Manager::SWITCHER,
				'default'   => 'yes',
                'return_value' => 'solid',
                'prefix_class' => 'box-',
                'conditions' => [
 					'terms' => [
 						['name' => 'cont_box', 'operator' => 'in', 'value' => ['cont']],
 					],
 				],
			]
		);*/
        $element->add_control(
			'_cont_box_bg_light',
			[
				'label' => esc_html__('Box background color - Light Skin', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}}.bg-light.e-con.box-cont > .e-con-inner' => 'background-color: {{VALUE}};',
				],
                'conditions' => [
 					'terms' => [
 						['name' => 'cont_box', 'operator' => 'in', 'value' => ['cont']],
                        ['name' => 'content_width', 'operator' => 'in', 'value' => ['boxed']],
 					],
 				],
			]
		);
        $element->add_control(
			'_cont_box_bg_dark',
			[
				'label' => esc_html__('Box background color - Dark Skin', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}}.bg-dark.e-con.box-cont > .e-con-inner' => 'background-color: {{VALUE}};',
				],
                'conditions' => [
 					'terms' => [
 						['name' => 'cont_box', 'operator' => 'in', 'value' => ['cont']],
                        ['name' => 'content_width', 'operator' => 'in', 'value' => ['boxed']],
 					],
 				],
			]
		);

        $element->add_responsive_control(
			'_cont_box_padding',
			[
				'label' => esc_html__( 'Box padding', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}}.e-con.box-cont > .e-con-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'conditions' => [
 					'terms' => [
 						['name' => 'cont_box', 'operator' => 'in', 'value' => ['cont']],
                        ['name' => 'content_width', 'operator' => 'in', 'value' => ['boxed']],
 					],
 				],
			]
		);

        $element->add_responsive_control(
			'_cont_box_margin',
			[
				'label' => esc_html__( 'Box margin', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'allowed_dimensions' => 'vertical',
				'selectors' => [
					'{{WRAPPER}}.e-con.box-cont > .e-con-inner' => 'margin: {{TOP}}{{UNIT}} auto {{BOTTOM}}{{UNIT}} auto;',
				],
                'conditions' => [
 					'terms' => [
 						['name' => 'cont_box', 'operator' => 'in', 'value' => ['cont']],
                        ['name' => 'content_width', 'operator' => 'in', 'value' => ['boxed']],
 					],
 				],
			]
		);

        $element->add_responsive_control(
			'_cont_box_radius',
			[
				'label' => esc_html__( 'Box radius', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}}.e-con.box-cont > .e-con-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'conditions' => [
 					'terms' => [
 						['name' => 'cont_box', 'operator' => 'in', 'value' => ['cont']],
                        ['name' => 'content_width', 'operator' => 'in', 'value' => ['boxed']],
 					],
 				],
			]
		);
    }
}, 10, 3 );

add_action( 'admin_menu', 'th90_register_builder_pages', 9 );
if ( ! function_exists( 'th90_register_builder_pages' ) ) {
    function th90_register_builder_pages() {
        add_menu_page(
            esc_html__('Template Builder', 'atlas-core'),
            esc_html__('Template Builder', 'atlas-core'),
            'manage_options',
            'th90-builder',
            '__return_null',
            'dashicons-align-wide',
            41
        );
        add_submenu_page( 'th90-builder', '', '', 'manage_options', 'th90-builder', '__return_null' );
        remove_submenu_page( 'th90-builder', 'th90-builder' );
    }
}

add_action( 'init', 'th90_builder_post_type' );
if ( ! function_exists( 'th90_builder_post_type' ) ) {
	function th90_builder_post_type() {
        $args = array(
            'public'              => true,
            'show_in_nav_menus'   => false,
            'show_in_menu'        => 'th90-builder',
            'show_in_admin_bar'   => true,
            'exclude_from_search' => true,
            'hierarchical'        => false,
            'map_meta_cap'        => true,
            'capability_type'     => 'post',
            'show_ui'             => true,
            'show_in_rest'        => true,
            'rewrite'             => false,
            'supports'            => array( 'title' ),
        );
        $post_types = array(
            'block' => 'Block',
            'sidebar' => 'Sidebar',
            'adv' => 'Advertisement',
        );
        foreach ( $post_types as $key => $value ) {
            register_post_type( 'th90_' . $key,
                array_merge(
                    $args,
                    array(
        				'labels' => array(
                            'menu_name'                => $value,
        					'name'                     => $value . ' Builder',
        					'singular_name'            => $value . ' Builder',
        					'add_new'                  => 'Add New ' . $value,
        					'add_new_item'             => 'Add New ' . $value,
        					'edit_item'                => 'Edit ' . $value,
        					'new_item'                 => 'New ' . $value,
        					'view_item'                => 'View ' . $value,
        					'search_items'             => 'Search ' . $value,
        					'not_found'                => 'No ' . $value . ' found',
        					'not_found_in_trash'       => 'No ' . $value . ' found in Trash',
        				),
        			)
                )
    		);
        }
	}
}

function th90_load_canvas_template( $single_template ) {
    global $post;
    if ( 'th90_sidebar' == $post->post_type ) {
        return TH90_CORE_PATH . '/elementor/templates/sidebar.php';
    } elseif ( 'th90_block' == $post->post_type ) {
        return TH90_CORE_PATH . '/elementor/templates/block.php';
    }

    return $single_template;
}
add_filter( 'single_template', 'th90_load_canvas_template' );

/*
function th90_render_skin_section_elementor( Elementor\Element_Base $element ) {

    if('section' === $element->get_name()){
        if ( $element->get_settings( 'section_skin' ) ) {

            $element->add_render_attribute( '_wrapper', [
                'class' => 'is-skin',
                'data-skin' => $element->get_settings( 'section_skin' ),
            ] ) ;
        }
    }
}
add_action( 'elementor/frontend/section/before_render', 'th90_render_skin_section_elementor' );

add_action( 'elementor/frontend/after_register_styles', function() {
	foreach( [ 'solid', 'regular', 'brands' ] as $style ) {
		wp_deregister_style( 'elementor-icons-fa-' . $style );
	}
}, 20 );

add_action( 'wp_enqueue_scripts', function() {
	if ( ! is_user_logged_in() ) {
		wp_deregister_style( 'elementor-icons' );
	}
}, 20 );
*/
