<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class TH90_Controls extends \Elementor\Widget_Base {
    public function get_name() {
		return 'th90-controls';
	}

    public function logo_settings( $controls ) {
        $controls->add_control(
			'logo_type',
			[
				'label'   => esc_html__( 'Logo type', 'atlas-core' ),
				'description' =>esc_html__( 'The default logo is the logo that you have set via the theme options.', 'atlas-core' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'default',
				'options' => [
					'default' => esc_html__( 'Default', 'atlas-core' ),
					'image' => esc_html__( 'Image', 'atlas-core' ),
					'svg'   => esc_html__( 'SVG codes', 'atlas-core' ),
					'text'  => esc_html__( 'Text', 'atlas-core' ),
				],
			]
		);

		/* Logo Image */
		$controls->add_control(
			'logo',
			[
				'label'       => esc_html__( 'Logo', 'atlas-core' ),
				'type'        => \Elementor\Controls_Manager::MEDIA,
				'condition'   => [
					 'logo_type' => ['image'],
				],
			]
		);

		$controls->add_control(
			'logo_retina',
			[
				'label'       => esc_html__( 'Retina Logo', 'atlas-core' ),
				'type'        => \Elementor\Controls_Manager::MEDIA,
				'condition'   => [
					 'logo_type' => ['image'],
				],
			]
		);

		$controls->add_control(
			'logo_dark',
			[
				'label'       => esc_html__( 'Logo (Dark Skin)', 'atlas-core' ),
				'type'        => \Elementor\Controls_Manager::MEDIA,
				'condition'   => [
					 'logo_type' => ['image'],
				],
			]
		);

		$controls->add_control(
			'logo_dark_retina',
			[
				'label'       => esc_html__( 'Retina Logo (Dark Skin)', 'atlas-core' ),
				'type'        => \Elementor\Controls_Manager::MEDIA,
				'media_types' => [ 'image', 'svg' ],
				'condition'   => [
					 'logo_type' => ['image'],
				],
			]
		);
        $controls->add_control(
			'logo_width',
			[
				'label' => esc_html__( 'Logo width', 'atlas-core' ),
				'type'  => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'vw' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 2000,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
					'vw' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .logo-site .logo-img' => 'max-width: {{SIZE}}{{UNIT}};',
				],
                'default' => [
					'unit' => 'px',
					'size' => 80,
				],
				'condition'   => [
					 'logo_type' => ['image'],
				],
			]
		);

		/* Logo SVG */
		$controls->add_control(
			'logo_svg',
			[
				'label'       => esc_html__( 'Logo svg codes', 'atlas-core' ),
				'type'        => \Elementor\Controls_Manager::TEXTAREA,
				'default'     => th90_default_options()['logo_svg'],
				'label_block' => true,
				'condition'   => [
					 'logo_type' => ['svg'],
				],
			]
		);
		$controls->add_control(
			'dark_logo_svg',
			[
				'label'       => esc_html__( 'Logo svg codes (Dark Skin)', 'atlas-core' ),
				'type'        => \Elementor\Controls_Manager::TEXTAREA,
				'default'     => th90_default_options()['logo_dark_svg'],
				'label_block' => true,
				'condition'   => [
					 'logo_type' => ['svg'],
				],
			]
		);
		$controls->add_control(
			'logo_svg_width',
			[
				'label' => esc_html__( 'Logo svg width', 'atlas-core' ),
				'type'  => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'vw' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 2000,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
					'vw' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .logo-site-svg svg' => 'max-width: {{SIZE}}{{UNIT}};',
				],
				'default' => [
					'unit' => 'px',
					'size' => 180,
				],
				'condition'   => [
					 'logo_type' => ['svg'],
				],
			]
		);

		/* Logo Text */
		$controls->add_control(
			'logo_text',
			[
				'label'       => esc_html__( 'Logo text', 'atlas-core' ),
				'type'        => \Elementor\Controls_Manager::TEXTAREA,
				'default'     => get_bloginfo( 'name' ),
				'label_block' => true,
				'condition'   => [
					 'logo_type' => ['text'],
				],
			]
		);
		$controls->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'        => 'logo_text_typography',
				'label'       => esc_html__( 'Logo typography', 'atlas-core' ),
				'selector'    => '{{WRAPPER}} .logo-text',
				'condition'   => [
					 'logo_type' => ['text'],
				],
			]
		);
		$controls->add_group_control(
			\Elementor\Group_Control_Text_Stroke::get_type(),
			[
				'name' => 'logo_text_stroke',
				'selector' => '{{WRAPPER}} .logo-text',
				'condition'   => [
					 'logo_type' => ['text'],
				],
			]
		);

		$controls->add_group_control(
			\Elementor\Group_Control_Text_Shadow::get_type(),
			[
				'name' => 'logo_text_shadow',
				'selector' => '{{WRAPPER}} .logo-text',
				'condition'   => [
					 'logo_type' => ['text'],
				],
			]
		);

		$controls->add_control(
			'custom_link',
			[
				'label' => esc_html__( 'Custom Link', 'atlas-core' ),
				'description' =>esc_html__( 'If you want to custom the Logo link. By default logo is linked to homepage.', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::URL,
				'dynamic' => [
					'active' => true,
				],
				'default' => [
					'url' => '',
				],
				'conditions' => [
                    'terms' => [
                        ['name' => 'logo_type', 'operator' => '!in', 'value' => ['default']],
                    ],
                ],
			]
		);
    }

    public function slider_settings( $controls ) {
        $controls->add_responsive_control(
			'columns',
			[
				'label' => __( 'Slider Columns', 'atlas-core' ),
				'type'  => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 15,
					],
				],
				'default' => [
					'size' => 1,
					'unit' => 'px',
				],
			]
		);
		$controls->add_responsive_control(
			'spaceBetween',
			[
				'label' =>esc_html__( 'Space beetween slider item', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'size' => 0,
					'unit' => 'px',
				],
                'selectors' => [
                    '{{WRAPPER}} .slick-list' => 'margin-left: calc(({{SIZE}}{{UNIT}}/2)*-1); margin-right: calc(({{SIZE}}{{UNIT}}/2)*-1);',
                    '{{WRAPPER}} .slick-slide' => 'margin-left: calc({{SIZE}}{{UNIT}}/2); margin-right: calc({{SIZE}}{{UNIT}}/2);',
				],
			]
		);
		$controls->add_responsive_control(
			'_loading_height',
			[
				'label' =>esc_html__( 'Slider loading height', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 30,
						'max' => 2000,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .slick-slider:not(.slick-initialized)' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$controls->add_control(
			'slider_autoHeight',
			[
				'label' => esc_html__('Auto height?', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'atlas-core'),
				'label_off' => esc_html__('No', 'atlas-core'),
				'default' => 'no',
			]
		);

		$controls->add_control(
			'slider_center',
			[
				'label' => esc_html__('Centered items?', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'atlas-core'),
				'label_off' => esc_html__('No', 'atlas-core'),
				'default' => 'no',
			]
		);
		$controls->add_control(
			'slider_speed',
			[
				'label' => __( 'Slider speed', 'atlas-core' ),
				'description' => __( 'Speed in milliseconds', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 200,
				'max' => 3000,
				'step' => 1,
				'default' => 500,
			]
		);
		$controls->add_control(
			'slider_auto',
			[
				'label' => esc_html__('Automatic slider?', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'atlas-core'),
				'label_off' => esc_html__('No', 'atlas-core'),
				'default' => 'no',
			]
		);
		$controls->add_control(
			'slider_delay',
			[
				'label' => __( 'Autoplay delay', 'atlas-core' ),
				'description' => __( 'Autoplay delay in milliseconds', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1000,
				'max' => 10000,
				'step' => 1,
				'default' => 3000,
			]
		);
		$controls->add_control(
			'slider_loop',
			[
				'label' => esc_html__('Loop Mode / Infinite Loop?', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'atlas-core'),
				'label_off' => esc_html__('No', 'atlas-core'),
				'default' => 'no',
			]
		);
        $controls->add_control(
			'slider_fade',
			[
				'label' => esc_html__('Fade animation?', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'atlas-core'),
				'label_off' => esc_html__('No', 'atlas-core'),
				'default' => 'no',
			]
		);

		/* Pagination */
		$controls->add_control(
			'slider_pagi',
			[
				'label' => esc_html__('Activate slider pagination?', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'atlas-core'),
				'label_off' => esc_html__('No', 'atlas-core'),
				'default' => 'no',
				'separator' => 'before',
			]
		);
        $controls->add_control(
			'pagi_dot_align',
			[
				'label'   => esc_html__( 'Pagination dot align', 'atlas-core' ),
				'type'    => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'atlas-core' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'atlas-core' ),
						'icon'  => 'eicon-text-align-center',
					],
				],
				'default' => 'center',
                'condition' => [
					'slider_pagi' => ['yes'],
				],
			]
		);
		$controls->add_control(
			'pagi_dot_size',
			[
				'label' =>esc_html__( 'Pagination dot size', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 20,
					],
				],
				'default' => [
					'size' => 4,
				],
				'selectors' => [
					'{{WRAPPER}} ul.slick-dots' => 'font-size: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'slider_pagi' => ['yes'],
				],

			]
		);

		$controls->add_control(
			'pagi_dot_color',
			[
				'label' => esc_html__('Pagination dot color', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} ul.slick-dots button' => 'background-color: {{VALUE}};',
				],
				'condition' => [
					'slider_pagi' => ['yes'],
				],
			]
		);
		/*$controls->add_control(
			'pagi_dot_color_active',
			[
				'label' => esc_html__('Pagination dot active color', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} ul.slick-dots button' => 'background-color: {{VALUE}};',
				],
				'condition' => [
					'slider_pagi' => ['yes'],
				],
			]
		);*/
		$controls->add_control(
			'_pagi_space',
			[
				'label' =>esc_html__( 'Pagination space from slider', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .slider-dots' => 'margin-top: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'slider_pagi' => ['yes'],
				],
			]
		);

        /* Slider Progress Bar */
		$controls->add_control(
			'slider_progress',
			[
				'label' => esc_html__('Activate slider progress bar?', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'atlas-core'),
				'label_off' => esc_html__('No', 'atlas-core'),
				'default' => 'no',
				'separator' => 'before',
			]
		);
        $controls->add_control(
			'progress_color',
			[
				'label' => esc_html__('Progress bar color', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .slick-progress::before, {{WRAPPER}} .slick-progress span' => 'background-color: {{VALUE}};',
				],
				'condition' => [
					'slider_progress' => ['yes'],
				],
			]
		);
        $controls->add_control(
			'progress_absolute',
			[
				'label' => esc_html__('Progress bar absolute position?', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'atlas-core'),
				'label_off' => esc_html__('No', 'atlas-core'),
				'default' => 'no',
                'return_value' => 'yes',
                'prefix_class' => 'progressabsolute-',
                'condition' => [
					'slider_progress' => ['yes'],
				],
			]
		);

        /* Slider Navigation */
		$controls->add_control(
			'slider_nav',
			[
				'label' => esc_html__('Activate slider navigation?', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'atlas-core'),
				'label_off' => esc_html__('No', 'atlas-core'),
				'default' => 'no',
				'separator' => 'before',
			]
		);
		/*$controls->add_control(
			'nav_style',
			[
				'label'     => esc_html__( 'Navigation style', 'atlas-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'default',
				'options'   => th90_default_options()['btn_style'],
				'condition' => [
					'slider_nav' => ['yes'],
				],
			]
		);
		$controls->add_control(
			'_nav_radius',
			[
				'label' => esc_html__( 'Navigation radius', 'atlas-core' ),
				'type'  => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .slider-arrow button' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'slider_nav' => ['yes'],
				],
			]
		);*/
        $controls->add_control(
			'nav_size',
			[
				'label' =>esc_html__( 'Navigation size', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'size' => 18,
				],
				'selectors' => [
					'{{WRAPPER}} .slider-arrow .button .icon-svg' => 'font-size: {{SIZE}}{{UNIT}} !important;',
				],
				'condition' => [
					'slider_nav' => ['yes'],
				],

			]
		);

		/*$controls->add_control(
			'nav_color',
			[
				'label' => esc_html__('Navigation color', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .slider-arrow .button' => 'color: {{VALUE}} !important;',
				],
				'condition' => [
					'slider_nav' => ['yes'],
				],
			]
		);*/
		$controls->add_control(
			'nav_position',
			[
				'label'   => esc_html__( 'Navigation  position', 'atlas-core' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'top_right',
				'options' => [
					'top_left' => esc_html__( 'Top Left', 'atlas-core' ),
					'top_right'   => esc_html__( 'Top Right', 'atlas-core' ),
					'bottom_left'   => esc_html__( 'Bottom Left', 'atlas-core' ),
					'bottom_right'   => esc_html__( 'Bottom Right', 'atlas-core' ),
                    'on_heading'   => esc_html__( 'On Block Heading', 'atlas-core' ),
				],
				'conditions' => [
					'terms' => [
						['name' => 'slider_nav', 'operator' => 'in', 'value' => ['yes']],
					],
				],
			]
		);
        $controls->add_responsive_control(
            '_nav_padding',
            [
                'label' => esc_html__( 'Navigation padding', 'atlas-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .slider-arrow' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
                'conditions' => [
					'terms' => [
						['name' => 'slider_nav', 'operator' => 'in', 'value' => ['yes']],
					],
				],
            ]
        );
    }

    public function general_socials( $controls ) {
        $controls->add_control(
			'style',
			[
				'label'     => esc_html__( 'Social style', 'atlas-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'simple',
				'options'   => th90_default_options()['social_style'],
			]
		);

        /*$controls->add_control(
			'btn_style',
			[
				'label'     => esc_html__( 'Button Style', 'atlas-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'white',
				'options'   => th90_default_options()['btn_style'],
                'conditions' => [
					'terms' => [
						['name' => 'style', 'operator' => 'in', 'value' => ['btn']],
					],
				],
			]
		);

        $controls->add_control(
			'btn_size',
			[
				'label'     => esc_html__( 'Button Size', 'atlas-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'medium',
				'options'   => th90_default_options()['btn_size'],
                'conditions' => [
					'terms' => [
						['name' => 'style', 'operator' => 'in', 'value' => ['btn']],
					],
				],
			]
		);*/

		$controls->add_control(
			'social_space',
			[
				'label' => esc_html__( 'Space between icon', 'atlas-core' ),
				'type'  => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'vw' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
					'vw' => [
						'min' => 0,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .social-icons' => 'gap: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$controls->add_control(
			'custom_social_size',
			[
				'label' => esc_html__( 'Custom social size', 'atlas-core' ),
				'type'  => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .social-icon, .s-front {{WRAPPER}} .social-btn .button.btn-content_icon .icon-svg' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
	}

	public function account_socials( $controls ) {

		foreach ( th90_default_options()['social_networks'] as $key => $value  ) {
			if ( 'facebook' == $key || 'twitter' == $key || 'linkedin' == $key || 'youtube' == $key || 'instagram' == $key ) {
				$default = '#';
			} else {
				$default = '';
			}
			$controls->add_control(
				th90_convert_to_id( $key ),
				[
					'label' => $value . ' URL',
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => $default,
					'label_block' => true,
				]
			);
		}
	}

    public function general_query_default( $controls ) {
        $controls->add_control(
			'_query_for',
			[
				'label'   => esc_html__( 'Block For?', 'atlas-core' ),
				'description' => esc_html__('Select where you want to use this block.', 'atlas-core'),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'custom',
				'label_block' => true,
				'options' => [
					'custom'  => esc_html__( 'Custom', 'atlas-core' ),
					'archive'   => esc_html__( 'Archive or Search Page Template', 'atlas-core' ),
					'related'   => esc_html__( 'Related Posts Template', 'atlas-core' ),
				],
			]
		);
		$controls->add_control(
			'_query_note_archive',
			[
				'type' => \Elementor\Controls_Manager::RAW_HTML,
				'raw' => esc_html__('Use this block for archive(category, tag, author, date, custom post type, and custom taxonomy based archives) or search page template.', 'atlas-core'),
				//'content_classes' => 'elementor-descriptor',
				'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
				'condition' => [
					'_query_for' => ['archive'],
				],
			]
		);
		$controls->add_control(
			'_query_note_related',
			[
				'type' => \Elementor\Controls_Manager::RAW_HTML,
				'raw' => esc_html__('Use this block for related posts template on single post.', 'atlas-core'),
				//'content_classes' => 'elementor-descriptor',
				'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
				'condition' => [
					'_query_for' => ['related'],
				],
			]
		);
	}

	public function query_default( $controls ) {
		$controls->add_control(
			'_query_related_by',
			[
				'label'   => esc_html__( 'Related Posts By?', 'atlas-core' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'cat',
				'options' => [
					'cat'  => esc_html__( 'Category', 'atlas-core' ),
					'tag'   => esc_html__( 'Tag', 'atlas-core' ),
				],
				'condition' => [
					'_query_for' => ['related'],
				],
			]
		);
		$controls->add_control(
			'posts',
			[
				'label'       => esc_html__('Select Post', 'atlas-core'),
				'description' => esc_html__('The categories, tags and others options will not used.', 'atlas-core'),
				'type'        => \Elementor\Controls_Manager::SELECT2,
				'options'     => th90_get_posts_id( 'post' ),
				'label_block' => true,
				'multiple'    => true,
				'condition' => [
					'_query_for!' => ['archive','related'],
				],
			]
		);
		$controls->add_control(
			'categories',
			[
				'label'       => esc_html__('Categories', 'atlas-core'),
				'type'        => \Elementor\Controls_Manager::SELECT2,
				'options'     => th90_get_terms( 'category', 'slug' ),
				'label_block' => true,
				'multiple'    => true,
				'condition' => [
					'_query_for!' => ['archive','related'],
				],
			]
		);
		$controls->add_control(
			'tags',
			[
				'label'       => esc_html__('Tags', 'atlas-core'),
				'description' => esc_html__('Will override categories', 'atlas-core'),
				'type'        => \Elementor\Controls_Manager::SELECT2,
				'options'     => th90_get_terms( 'post_tag', 'slug' ),
				'label_block' => true,
				'multiple'    => true,
				'condition' => [
					'_query_for!' => ['archive','related'],
				],
			]
		);
		$controls->add_control(
			'number',
			[
				'label'       => esc_html__( 'Number', 'atlas-core' ),
				'description' => esc_html__('Number of posts to show', 'atlas-core'),
				'type'        => \Elementor\Controls_Manager::NUMBER,
				'default'     => '6',
				'condition' => [
					'_query_for!' => ['archive'],
				],
			]
		);
		$controls->add_control(
			'offset',
			[
				'label'       => esc_html__( 'Offset', 'atlas-core' ),
				'description' => esc_html__('Number of posts to pass over', 'atlas-core'),
				'type'        => \Elementor\Controls_Manager::NUMBER,
				'condition' => [
					'_query_for!' => ['related'],
				],
			]
		);
        $controls->add_control(
			'formats',
			[
				'label'       => esc_html__('Posts Format', 'atlas-core'),
				'type'        => \Elementor\Controls_Manager::SELECT2,
				'options'     => th90_get_terms( 'post_format', 'slug' ),
				'label_block' => true,
				'multiple'    => true,
				'condition' => [
					'_query_for!' => ['archive','related'],
				],
			]
		);
		$controls->add_control(
			'orderby',
			[
				'label'   => esc_html__( 'Post sort by', 'atlas-core' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'date',
				'options' => th90_default_options()['post_sort'],
				'condition' => [
					'_query_for!' => ['related'],
				],
			]
		);
		$controls->add_control(
			'order',
			[
				'label'   => esc_html__( 'Post order', 'atlas-core' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'DESC',
				'options' => [
					'DESC'  => esc_html__( 'Descending', 'atlas-core' ),
					'ASC'   => esc_html__( 'Ascending', 'atlas-core' ),
				],
				'condition' => [
					'_query_for!' => ['related'],
				],
			]
		);
		$controls->add_control(
			'not_show_duplicate',
			[
				'label'     => esc_html__('Don\'t duplicate this posts?', 'atlas-core'),
				'description' => sprintf( esc_html__( 'If you don\'t want to show the posts result in %1$sanother block afterwards%2$s on the same page.', 'atlas-core' ), '<strong>', '</strong>' ),
				'type'      => \Elementor\Controls_Manager::SWITCHER,
				'label_on'  => esc_html__('Yes', 'atlas-core'),
				'label_off' => esc_html__('No', 'atlas-core'),
				'default'   => 'no',
			]
		);
	}

	public function post_default( $controls, $type = '', $sufix = '', $is_group = false ) {
        $css_type = '';
        if ( $sufix) {
            $css_type = '.post' . $sufix . ' ';
        }

        if ( ! $is_group ) {
            if ( 'small' != $type ) {
                /* Post Style */
        		$controls->add_control(
        			'_head_post_style', [
        				'separator' => 'before',
        				'label' => __( 'Post Style', 'atlas-core' ),
        				'type' => \Elementor\Controls_Manager::HEADING,
        			]
        		);
        		$controls->add_control(
        			'post_style', [
        				'label' => esc_html__('Select Style', 'atlas-core'),
        				'type' => 'imagechoose',
        				'default' => 'medium1',
        				'options' => \TH90ElementorOptions\Options::get_array_post_selective(),
        			]
        		);
            } elseif ( 'small' == $type ) {
                /* Post Style */
        		$controls->add_control(
        			'_head_post_style', [
        				'separator' => 'before',
        				'label' => __( 'Post Style', 'atlas-core' ),
        				'type' => \Elementor\Controls_Manager::HEADING,
        			]
        		);
                $controls->add_control(
        			'post_style', [
        				'label' => esc_html__('Select Style', 'atlas-core'),
        				'type' => 'imagechoose',
        				'default' => 'small1',
        				'options' => \TH90ElementorOptions\Options::get_array_post_small(),
        			]
        		);
            }
        }

        if ( 'small' != $type ) {
            $controls->add_responsive_control(
                '_post_height' . $sufix,
    			[
    				'label' =>esc_html__( 'Post height', 'atlas-core' ),
    				'type' => \Elementor\Controls_Manager::SLIDER,
    				'size_units' => [ 'px', 'vh' ],
    				'range' => [
    					'px' => [
    						'min' => 30,
    						'max' => 2000,
    					],
    					'vh' => [
    						'min' => 10,
    						'max' => 100,
    					],
    				],
    				'selectors' => [
                        '{{WRAPPER}} .slider-main .slick-slider:not(.slick-initialized)' => 'height: {{SIZE}}{{UNIT}};',
    					'{{WRAPPER}} ' . $css_type . '.post-hero .thumb-container' => 'padding-bottom: {{SIZE}}{{UNIT}} !important;',
    				],
                    'conditions' => [
     					'terms' => [
     						['name' => 'post_style', 'operator' => 'in', 'value' => ['hero']],
     					],
     				],
    			]
    		);
            /* Post List Options */
            $controls->add_control(
                'post_vertical_center' . $sufix,
                [
                    'label'      => esc_html__('Vertical centered content?', 'atlas-core'),
                    'type'       => \Elementor\Controls_Manager::SWITCHER,
                    'label_on'   => esc_html__('Yes', 'atlas-core'),
                    'label_off'  => esc_html__('No', 'atlas-core'),
                    'default'    => 'yes',
                    'conditions' => [
                        'terms' => [
                            ['name' => 'post_style', 'operator' => 'in', 'value' => ['list1', 'list2']],
                        ],
                    ],
                ]
            );
            $controls->add_responsive_control(
                '_thumbnail_width' . $sufix,
                [
                    'label' =>esc_html__( 'Thumbnail Width', 'atlas-core' ),
                    'type' => \Elementor\Controls_Manager::SLIDER,
                    'size_units' => ['px', '%'],
                    'range' => [
                        'px' => [
                            'min' => 50,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 20,
                            'max' => 80,
                        ],
                    ],
                    'default' => [
                        'unit' => '%',
                        'size' => 50,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .post-list .post-list-thumbnail' => 'width: {{SIZE}}{{UNIT}}; max-width: {{SIZE}}{{UNIT}};',
                    ],
                    'conditions' => [
                        'terms' => [
                            ['name' => 'post_style', 'operator' => 'in', 'value' => ['list1', 'list2']],
                        ],
                    ],

                ]
            );
            $controls->add_responsive_control(
                '_post_list_space' . $sufix,
                [
                    'label' =>esc_html__( 'Space between thumbnail & desc', 'atlas-core' ),
                    'type' => \Elementor\Controls_Manager::SLIDER,
                    'devices' => [ 'desktop', 'tablet' ],
                    'size_units' => ['px'],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 200,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 30,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .post-list' => 'gap: {{SIZE}}{{UNIT}};',
                    ],
                    'conditions' => [
                        'terms' => [
                            ['name' => 'post_style', 'operator' => 'in', 'value' => ['list1', 'list2']],
                        ],
                    ],
                ]
            );
        }

        // Thumbnail
        if ( 'small' == $type ) {
            $controls->add_control(
                '_thumbnail_head' . $sufix, [
                    'separator' => 'before',
                    'label' => __( 'Posts Thumbnail', 'atlas-core' ),
                    'type' => \Elementor\Controls_Manager::HEADING,
                ]
            );
            $controls->add_control(
                'thumbnail_type' . $sufix,
                [
                    'label'     => esc_html__( 'Thumbnail type', 'atlas-core' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'default'   => 'image',
                    'options'   => array(
                        'image' => 'Default',
                        'char' => 'First Char of Title Only',
                    ),
                    'conditions' => [
     					'terms' => [
                            ['name' => 'thumbnail_disable' . $sufix, 'operator' => '!in', 'value' => ['yes']],
     					],
     				],
                ]
            );
            $controls->add_control(
                'image_ratio' . $sufix,
                [
                    'label'     => esc_html__( 'Thumbnail ratio', 'atlas-core' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'default'   => '1_1',
                    'options'   => th90_default_options()['image_ratio'],
                    'conditions' => [
     					'terms' => [
                            ['name' => 'thumbnail_disable' . $sufix, 'operator' => '!in', 'value' => ['yes']],
     					],
     				],
                ]
            );
            $controls->add_responsive_control(
                '_image_ratio_c' . $sufix,
                [
                    'label' =>esc_html__( 'Custom Image Ratio', 'atlas-core' ),
                    'type' => \Elementor\Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 30,
                            'max' => 200,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 100,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} ' . $css_type . '.thumb-container.thumb-custom' => 'padding-bottom: {{SIZE}}%;',
                    ],
                    'conditions' => [
     					'terms' => [
                            ['name' => 'image_ratio' . $sufix, 'operator' => 'in', 'value' => ['custom']],
     					],
     				],
                ]
            );
            $controls->add_responsive_control(
                '_thumbnail_width' . $sufix,
                [
                    'label'      => esc_html__( 'Thumbnail Width', 'atlas-core' ),
                    'type'       => \Elementor\Controls_Manager::SLIDER,
                    'size_units' => ['px', '%'],
                    'range' => [
                        'px' => [
                            'min' => 50,
                            'max' => 200,
                        ],
                        '%' => [
                            'min' => 20,
                            'max' => 80,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .post-small .post-small-thumbnail' => 'min-width: {{SIZE}}{{UNIT}};',
                    ],
                    'conditions' => [
     					'terms' => [
                            ['name' => 'thumbnail_disable' . $sufix, 'operator' => '!in', 'value' => ['yes']],
     					],
     				],
                ]
            );
            $controls->add_control(
                'thumbnail_circle' . $sufix,
                [
                    'label'     => esc_html__('Circle thumbnail?', 'atlas-core'),
                    'type'      => \Elementor\Controls_Manager::SWITCHER,
                    'label_on'  => esc_html__('Yes', 'atlas-core'),
                    'label_off' => esc_html__('No', 'atlas-core'),
                    'default'   => 'no',
                    'conditions' => [
                        'terms' => [
                            ['name' => 'thumbnail_disable' . $sufix, 'operator' => '!in', 'value' => ['yes']],
                        ],
                    ],
                ]
            );
            $controls->add_control(
                'thumbnail_disable' . $sufix,
                [
                    'label'     => esc_html__('Disable thumbnail?', 'atlas-core'),
                    'type'      => \Elementor\Controls_Manager::SWITCHER,
                    'label_on'  => esc_html__('Yes', 'atlas-core'),
                    'label_off' => esc_html__('No', 'atlas-core'),
                    'default'   => 'no',
                ]
            );
        } else {
            $controls->add_control(
                '_thumbnail_head' . $sufix, [
                    'separator' => 'before',
                    'label' => __( 'Posts Thumbnail', 'atlas-core' ),
                    'type' => \Elementor\Controls_Manager::HEADING,
                    'conditions' => [
     					'terms' => [
     						['name' => 'post_style', 'operator' => '!in', 'value' => ['hero']],
     					],
     				],
                ]
            );
            $controls->add_control(
                'thumbnail_type' . $sufix,
                [
                    'label'     => esc_html__( 'Thumbnail type', 'atlas-core' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'default'   => 'image',
                    'options'   => array(
                        'image' => 'Default',
                        'char' => 'First Char of Title Only',
                    ),
                    'conditions' => [
     					'terms' => [
     						['name' => 'post_style', 'operator' => '!in', 'value' => ['hero']],
                            ['name' => 'thumbnail_disable' . $sufix, 'operator' => '!in', 'value' => ['yes']],
     					],
     				],
                ]
            );
            $controls->add_control(
                'image_ratio' . $sufix,
                [
                    'label'     => esc_html__( 'Thumbnail ratio', 'atlas-core' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'default'   => '4_3',
                    'options'   => th90_default_options()['image_ratio'],
                    'conditions' => [
     					'terms' => [
                            ['name' => 'thumbnail_disable' . $sufix, 'operator' => '!in', 'value' => ['yes']],
     						['name' => 'post_style', 'operator' => '!in', 'value' => ['hero']],
     					],
     				],
                ]
            );
            $controls->add_responsive_control(
                '_image_ratio_c' . $sufix,
                [
                    'label' =>esc_html__( 'Custom Image Ratio', 'atlas-core' ),
                    'type' => \Elementor\Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 30,
                            'max' => 200,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 100,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} ' . $css_type . '.thumb-container.thumb-custom' => 'padding-bottom: {{SIZE}}%;',
                    ],
                    'conditions' => [
     					'terms' => [
                            ['name' => 'image_ratio' . $sufix, 'operator' => 'in', 'value' => ['custom']],
     						['name' => 'post_style', 'operator' => '!in', 'value' => ['hero']],
     					],
     				],
                ]
            );

            /*$controls->add_control(
                'image_position' . $sufix,
                [
                    'label'     => esc_html__( 'Image position', 'atlas-core' ),
                    'description' => esc_html__( 'Image position on thumbnail container.', 'atlas-core' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'default'   => 'center',
                    'options'   => th90_default_options()['image_position'],
                    'conditions' => [
     					'terms' => [
                            ['name' => 'thumbnail_disable' . $sufix, 'operator' => '!in', 'value' => ['yes']],
     						['name' => 'post_style', 'operator' => '!in', 'value' => ['hero']],
     					],
     				],
                ]
            );*/
            $controls->add_control(
                'thumbnail_disable' . $sufix,
                [
                    'label'     => esc_html__('Disable thumbnail?', 'atlas-core'),
                    'type'      => \Elementor\Controls_Manager::SWITCHER,
                    'label_on'  => esc_html__('Yes', 'atlas-core'),
                    'label_off' => esc_html__('No', 'atlas-core'),
                    'default'   => 'no',
                    'conditions' => [
     					'terms' => [
     						['name' => 'post_style', 'operator' => '!in', 'value' => ['hero']],
     					],
     				],
                ]
            );
        }

        // Title
        $controls->add_control(
            '_post_title_head' . $sufix, [
                'separator' => 'before',
                'label' => __( 'Posts Title', 'atlas-core' ),
                'type' => \Elementor\Controls_Manager::HEADING,
            ]
        );
        $controls->add_control(
            'title_tag' . $sufix,
            [
                'label'   => esc_html__( 'Post title size', 'atlas-core' ),
                'type'    => \Elementor\Controls_Manager::CHOOSE,
                'label_block' => true,
                'options' => [
                    'h1' => [
                        'title' => esc_html__( 'H1', 'atlas-core' ),
                        'icon'  => 'eicon-editor-h1',
                    ],
                    'h2' => [
                        'title' => esc_html__( 'H2', 'atlas-core' ),
                        'icon'  => 'eicon-editor-h2',
                    ],
                    'h3' => [
                        'title' => esc_html__( 'H3', 'atlas-core' ),
                        'icon'  => 'eicon-editor-h3',
                    ],
                    'h4' => [
                        'title' => esc_html__( 'H4', 'atlas-core' ),
                        'icon'  => 'eicon-editor-h4',
                    ],
                    'h5' => [
                        'title' => esc_html__( 'H5', 'atlas-core' ),
                        'icon'  => 'eicon-editor-h5',
                    ],
                    'h6' => [
                        'title' => esc_html__( 'H6', 'atlas-core' ),
                        'icon'  => 'eicon-editor-h6',
                    ],
                ],
                'default' => '',
            ]
        );
        $controls->add_responsive_control(
            '_title_clamp' . $sufix,
            [
                'label' => esc_html__( 'Title line limit', 'atlas-core' ),
                'description' => esc_html__( 'Limiting the post title to the specified number of lines. Leave blank if no needed.', 'atlas-core' ),
                'type'  => \Elementor\Controls_Manager::NUMBER,
                'selectors' => [
                    '{{WRAPPER}} ' . $css_type . '.entry-title' => '-webkit-line-clamp: {{VALUE}};',
                ],
            ]
        );

        // Post Info
        $controls->add_control(
            '_post_info_head' . $sufix, [
                'separator' => 'before',
                'label' => __( 'Posts Info', 'atlas-core' ),
                'type' => \Elementor\Controls_Manager::HEADING,
            ]
        );
        $controls->add_control(
            'post_info' . $sufix,
            [
                'label'    => esc_html__('Post Info', 'atlas-core'),
                'type'     => \Elementor\Controls_Manager::SELECT2,
                'options'  => th90_default_options()['post_infos'],
                'multiple' => true,
                'default'  => [ 'date', 'review' ],
                'label_block' => true,
            ]
        );
        if ( 'small' !== $type ) {
            $controls->add_control(
                'meta_modern' . $sufix,
                [
                    'label'     => esc_html__('Post info modern?', 'atlas-core'),
                    'type'      => \Elementor\Controls_Manager::SWITCHER,
                    'label_on'  => esc_html__('Yes', 'atlas-core'),
                    'label_off' => esc_html__('No', 'atlas-core'),
                    'default'   => 'no',
                ]
            );
        }
        /*$controls->add_control(
            'info_icon' . $sufix,
            [
                'label'     => esc_html__('Post info with icon?', 'atlas-core'),
                'type'      => \Elementor\Controls_Manager::SWITCHER,
                'label_on'  => esc_html__('Yes', 'atlas-core'),
                'label_off' => esc_html__('No', 'atlas-core'),
                'default'   => 'no',
            ]
        );

        $controls->add_control(
            'readmore_side' . $sufix,
            [
                'label'     => esc_html__('Readmore on right side?', 'atlas-core'),
                'type'      => \Elementor\Controls_Manager::SWITCHER,
                'label_on'  => esc_html__('Yes', 'atlas-core'),
                'label_off' => esc_html__('No', 'atlas-core'),
                'default'   => 'no',
            ]
        );*/
        if ( 'small' != $type ) {
            $controls->add_control(
                'author_avatar' . $sufix,
                [
                    'label'     => esc_html__('Show author avatar?', 'atlas-core'),
                    'type'      => \Elementor\Controls_Manager::SWITCHER,
                    'label_on'  => esc_html__('Yes', 'atlas-core'),
                    'label_off' => esc_html__('No', 'atlas-core'),
                    'default'   => 'no',
                ]
            );
        }
        $controls->add_control(
            'info_position' . $sufix,
            [
                'label'   => esc_html__( 'Post info position', 'atlas-core' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'default' => 'bottom',
                'options' => th90_default_options()['info_position'],
            ]
        );
        $controls->add_control(
            'first_cat_loc' . $sufix,
            [
                'label'   => esc_html__( 'Category location', 'atlas-core' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'default' => 'title',
                'options' => th90_default_options()['first_cat_loc'],
            ]
        );
        $controls->add_control(
            'cat_style' . $sufix,
            [
                'label'   => esc_html__( 'Category style', 'atlas-core' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'default' => 'text',
                'options' => th90_default_options()['cats_style'],
            ]
        );
        $controls->add_control(
            'time_format' . $sufix,
            [
                'label'   => esc_html__( 'Time format', 'atlas-core' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'default' => 'standard',
                'options' => [
                    'standard' => esc_html__( 'Wordpress Default', 'atlas-core' ),
                    'modern'   => esc_html__( 'Relative Date (ago)', 'atlas-core' ),
                ],
            ]
        );

        // Post Content
        $controls->add_control(
            '_post_content_head' . $sufix, [
                'separator' => 'before',
                'label' => __( 'Posts Content', 'atlas-core' ),
                'type' => \Elementor\Controls_Manager::HEADING,
            ]
        );
        $controls->add_control(
            'excerpt' . $sufix,
            [
                'label'     => esc_html__('Show excerpt?', 'atlas-core'),
                'type'      => \Elementor\Controls_Manager::SWITCHER,
                'label_on'  => esc_html__('Yes', 'atlas-core'),
                'label_off' => esc_html__('No', 'atlas-core'),
                'default'   => 'no',
            ]
        );
        $controls->add_responsive_control(
            '_excerpt' . $sufix,
            [
                'label' => esc_html__( 'Excerpt line limit', 'atlas-core' ),
                'description' => esc_html__( 'Limiting the post excerpt to the specified number of lines. Leave blank if no needed.', 'atlas-core' ),
                'type'  => \Elementor\Controls_Manager::NUMBER,
                'selectors' => [
                    '{{WRAPPER}} ' . $css_type . '.entry-excerpt' => '-webkit-line-clamp: {{VALUE}};',
                ],
                'condition' => [
                    'excerpt' . $sufix => ['yes'],
                ],
            ]
        );
        $controls->add_control(
            'post_center' . $sufix,
            [
                'label' => esc_html__('Centered content?', 'atlas-core'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'atlas-core'),
                'label_off' => esc_html__('No', 'atlas-core'),
                'default' => 'no',
            ]
        );
        if ( 'small' == $type ) {
            $controls->add_control(
                '_v_center' . $sufix,
                [
                    'label' => esc_html__('Vertical centered content?', 'atlas-core'),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'label_on' => esc_html__('Yes', 'atlas-core'),
                    'label_off' => esc_html__('No', 'atlas-core'),
                    'default' => false,
                    'selectors' => [
                        '{{WRAPPER}} ' . $css_type . '.post-small' => 'align-items:center;',
                    ],
                ]
            );
        }
        if ( 'small' != $type ) {
            $controls->add_group_control(
    			\Elementor\Group_Control_Background::get_type(),
    			[
    				'name' => 'background' . $sufix,
    				'types' => [ 'gradient' ],
    				'selector' => '{{WRAPPER}} ' . $css_type . '.post-hero .thumb-container::after',
                    'conditions' => [
     					'terms' => [
     						['name' => 'post_style', 'operator' => 'in', 'value' => ['hero']],
     					],
     				],
    			]
    		);
            $controls->add_responsive_control(
    			'_hero_content_width' . $sufix,
    			[
    				'label' =>esc_html__( 'Content width', 'atlas-core' ),
    				'type' => \Elementor\Controls_Manager::SLIDER,
    				'range' => [
    					'%' => [
    						'min' => 30,
    						'max' => 100,
    					],
    				],
    				'selectors' => [
    					'{{WRAPPER}} ' . $css_type . '.desc-hero .post-desc-inner' => 'max-width: {{SIZE}}%;',
    				],
                    'conditions' => [
     					'terms' => [
     						['name' => 'post_style', 'operator' => 'in', 'value' => ['hero']],
     					],
     				],
    			]
    		);
        }
        $controls->add_responsive_control(
            '_content_gap' . $sufix,
            [
                'label' => esc_html__( 'Content gap', 'atlas-core' ),
                'description' => esc_html__( 'Space between title, post info & excerpt.', 'atlas-core' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} ' . $css_type . '.entry-header, {{WRAPPER}} ' . $css_type . '.post-desc, {{WRAPPER}} ' . $css_type . '.post-desc-inner, {{WRAPPER}} ' . $css_type . '.post-small-desc' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $controls->add_responsive_control(
            '_content_padding' . $sufix,
            [
                'label' => esc_html__( 'Content padding', 'atlas-core' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} ' . $css_type . '.post-desc .post-desc-inner, {{WRAPPER}} ' . $css_type . '.post-list-desc .post-desc-inner, {{WRAPPER}} ' . $css_type . '.post-small-desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
            ]
        );
		//$this->post_basic( $controls, $type );
	}

    public function post_style_default( $controls, $type = '', $sufix = '' ) {
        $css_type = '';
        if ( $sufix) {
            $css_type = '.post' . $sufix . ' ';
        }

		/* Title Style */
		$controls->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => '_title_typography' . $sufix,
				'label' => esc_html__( 'Title typography', 'atlas-core' ),
				'selector' => '{{WRAPPER}} ' . $css_type . '.entry-title',
			]
		);
		$controls->add_control(
			'_title_color' . $sufix,
			[
				'label' => esc_html__('Title color', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} ' . $css_type . '.entry-title a' => 'color: {{VALUE}};',
				],
			]
		);
		$controls->add_control(
		   '_title_hv_color' . $sufix,
		   [
			  'label' => esc_html__('Title hover color', 'atlas-core'),
			  'type' => \Elementor\Controls_Manager::COLOR,
			  'default' => '',
			  'selectors' => [
				  '{{WRAPPER}} ' . $css_type . '.entry-title a:hover' => 'color: {{VALUE}};',
			  ],
		   ]
		);
		$controls->add_control(
			'_title_bg_color' . $sufix,
			[
				'label' => esc_html__('Title background color', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} ' . $css_type . '.entry-title a' => 'background-color: {{VALUE}}; padding: 0 10px;',
				],
			]
		);
		$controls->add_responsive_control(
			'_title_gap' . $sufix,
			[
				'label' => esc_html__( 'Title gap', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'allowed_dimensions' => 'vertical',
				'selectors' => [
					'{{WRAPPER}} ' . $css_type . '.entry-title' => 'margin: {{TOP}}{{UNIT}} 0 {{BOTTOM}}{{UNIT}} 0;',
				],
                'separator' => 'after',
			]
		);

		/* Post Info Style */
		$controls->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => '_post_info_typography' . $sufix,
				'label' => esc_html__( 'Post info typography', 'atlas-core' ),
				'selector' => '{{WRAPPER}} ' . $css_type . '.entry-meta > *',
			]
		);
		$controls->add_control(
			'_post_info_color' . $sufix,
			[
			   'label' => esc_html__('Post info color', 'atlas-core'),
			   'type' => \Elementor\Controls_Manager::COLOR,
			   'default' => '',
			   'selectors' => [
				   '{{WRAPPER}} ' . $css_type . '.meta-color, {{WRAPPER}} ' . $css_type . '.meta-color a' => 'color: {{VALUE}};',
			   ],
			]
		);
        $controls->add_responsive_control(
			'_post_info_gap' . $sufix,
			[
				'label' => esc_html__( 'Post info gap', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'allowed_dimensions' => 'vertical',
				'selectors' => [
					'{{WRAPPER}} ' . $css_type . '.entry-meta' => 'margin: {{TOP}}{{UNIT}} 0 {{BOTTOM}}{{UNIT}} 0;',
				],
                'separator' => 'after',
			]
		);

		/* Excerpt Style */
		$controls->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => '_excerpt_typography' . $sufix,
				'label' => esc_html__( 'Excerpt typography', 'atlas-core' ),
				'selector' => '{{WRAPPER}} ' . $css_type . '.entry-excerpt',
			]
		);
		$controls->add_control(
			'_excerpt_color' . $sufix,
			[
			   'label' => esc_html__('Excerpt color', 'atlas-core'),
			   'type' => \Elementor\Controls_Manager::COLOR,
			   'default' => '',
			   'selectors' => [
				   '{{WRAPPER}} ' . $css_type . '.entry-excerpt' => 'color: {{VALUE}};',
			   ],
			]
		);
		$controls->add_responsive_control(
			'_excerpt_gap' . $sufix,
			[
				'label' => esc_html__( 'Excerpt gap', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'allowed_dimensions' => 'vertical',
				'selectors' => [
					'{{WRAPPER}} ' . $css_type . '.entry-excerpt' => 'margin: {{TOP}}{{UNIT}} 0 {{BOTTOM}}{{UNIT}} 0;',
				],
                'separator' => 'after',
			]
		);

        /* Readmore Style */
		$controls->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => '_more_typography' . $sufix,
				'label' => esc_html__( 'Read more typography', 'atlas-core' ),
				'selector' => '{{WRAPPER}} ' . $css_type . '.read-more a',
			]
		);
		$controls->add_control(
			'_more_color' . $sufix,
			[
			   'label' => esc_html__('Read more color', 'atlas-core'),
			   'type' => \Elementor\Controls_Manager::COLOR,
			   'default' => '',
			   'selectors' => [
				   '{{WRAPPER}} ' . $css_type . '.read-more a' => 'color: {{VALUE}};',
			   ],
			]
		);
		$controls->add_responsive_control(
			'_more_gap' . $sufix,
			[
				'label' => esc_html__( 'Read more gap', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'allowed_dimensions' => 'vertical',
				'selectors' => [
					'{{WRAPPER}} ' . $css_type . '.read-more' => 'margin: {{TOP}}{{UNIT}} 0 {{BOTTOM}}{{UNIT}} 0;',
				],
                'separator' => 'after',
			]
		);

        /* First Cat Style */
		$controls->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => '_cat_typography' . $sufix,
				'label' => esc_html__( 'Category typography', 'atlas-core' ),
				'selector' => '{{WRAPPER}}' . $css_type . '.entry-cats a',
			]
		);
		$controls->add_control(
			'_cat_color' . $sufix,
			[
			   'label' => esc_html__('Category color', 'atlas-core'),
			   'type' => \Elementor\Controls_Manager::COLOR,
			   'default' => '',
			   'selectors' => [
				   '{{WRAPPER}} ' . $css_type . '.entry-cats a' => 'color: {{VALUE}};',
			   ],
			]
		);
		$controls->add_responsive_control(
			'_cat_gap' . $sufix,
			[
				'label' => esc_html__( 'Category gap', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'allowed_dimensions' => 'vertical',
				'selectors' => [
					'{{WRAPPER}} ' . $css_type . '.entry-cats' => 'margin: {{TOP}}{{UNIT}} 0 {{BOTTOM}}{{UNIT}} 0;',
				],
                'separator' => 'after',
			]
		);

        /* Post Count Style */
        if ( 'small' == $type ) {
    		$controls->add_group_control(
    			\Elementor\Group_Control_Typography::get_type(),
    			[
    				'name' => '_post_count_typography' . $sufix,
    				'label' => esc_html__( 'Post count typography', 'atlas-core' ),
    				'selector' => '{{WRAPPER}} ' . $css_type . '.thumb-count, {{WRAPPER}} ' . $css_type . '.post-count',
    			]
    		);
    		$controls->add_control(
    			'_post_count_color' . $sufix,
    			[
    				'label' => esc_html__('Post count color', 'atlas-core'),
    				'type' => \Elementor\Controls_Manager::COLOR,
    				'default' => '',
    				'selectors' => [
    					'{{WRAPPER}} ' . $css_type . '.thumb-count' => 'color: {{VALUE}};',
    				],
    			]
    		);
        }
	}

	public function pagination_default( $controls ) {
		$controls->add_control(
			'pagi',
			[
				'label'     => esc_html__( 'Pagination mode', 'atlas-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => '',
				'options'   => [
					''      	=> esc_html__( 'Disable', 'atlas-core' ),
					'numeric'   => esc_html__( 'Numeric', 'atlas-core' ),
					'show-more' => esc_html__( 'Show More Ajax', 'atlas-core' ),
					'load-more' => esc_html__( 'Load More Ajax', 'atlas-core' ),
					'next-prev' => esc_html__( 'Next Prev Ajax', 'atlas-core' ),
					'infinite' => esc_html__( 'Infinite Scroll', 'atlas-core' ),
				],
			]
		);
        $controls->add_control(
			'pagi_style',
			[
				'label'     => esc_html__( 'Navigation style', 'atlas-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'default',
				'options'   => th90_default_options()['btn_style'],
                'conditions' => [
 					'terms' => [
 						['name' => 'pagi', 'operator' => '!in', 'value' => ['', 'infinite']],
 					],
 				],
			]
		);
		$controls->add_control(
			'_pagi_show_text',
			[
				'label'       => esc_html__( 'Show More text', 'atlas-core' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => esc_html__( 'Show More', 'atlas-core' ),
				'label_block' => true,
				'condition'   => [ 'pagi' => ['show-more'] ],
			]
		);
		$controls->add_control(
			'_pagi_load_text',
			[
				'label'       => esc_html__( 'Load More text', 'atlas-core' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => esc_html__( 'Load More', 'atlas-core' ),
				'label_block' => true,
				'condition'   => [ 'pagi' => ['load-more'] ],
			]
		);
		$controls->add_control(
			'_pagi_prev_text',
			[
				'label'       => esc_html__( 'Prev text', 'atlas-core' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => esc_html__( 'Prev', 'atlas-core' ),
				'label_block' => true,
				'condition'   => [ 'pagi' => ['next-prev'] ],
			]
		);
		$controls->add_control(
			'_pagi_next_text',
			[
				'label'       => esc_html__( 'Next text', 'atlas-core' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => esc_html__( 'Next', 'atlas-core' ),
				'label_block' => true,
				'condition'   => [ 'pagi' => ['next-prev'] ],
			]
		);
		$controls->add_control(
			'_pagi_align',
			[
				'label'   => esc_html__( 'Alignment', 'atlas-core' ),
				'type'    => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'atlas-core' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'atlas-core' ),
						'icon'  => 'eicon-text-align-center',
					],
				],
				'default' => 'left',
				'conditions' => [
 					'terms' => [
 						['name' => 'pagi', 'operator' => '!in', 'value' => ['', 'infinite']],
 					],
 				],
			]
		);
        /*$controls->add_control(
			'_pagi_align',
			[
				'label' => esc_html__( 'Alignment', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::HIDDEN,
				'default' => 'inherit',
                'conditions' => [
 					'terms' => [
 						['name' => 'pagi', 'operator' => '!in', 'value' => ['', 'infinite']],
 					],
 				],
			]
		);*/
		$controls->add_responsive_control(
			'_pagi_space',
			[
				'label' => esc_html__( 'Space from content', 'atlas-core' ),
				'type'  => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 150,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .nav-wrap' => 'margin-top: {{SIZE}}{{UNIT}};',
				],
				'conditions' => [
 					'terms' => [
 						['name' => 'pagi', 'operator' => '!in', 'value' => ['', 'infinite']],
 					],
 				],

			]
		);
		$controls->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' =>'_pagi_typography',
				'label' => esc_html__( 'Pagination typography', 'atlas-core' ),
				'selector' => '{{WRAPPER}} .nav-wrap .button, {{WRAPPER}} .nav-wrap .pagination .pagi-item',
				'conditions' => [
 					'terms' => [
 						['name' => 'pagi', 'operator' => '!in', 'value' => ['', 'infinite']],
 					],
 				],
			]
		);
	}

    public function sort_default( $controls ) {
        $controls->start_controls_section(
			'_section_sort',
			[
				'label' => __( 'Post Sort', 'mooda-core' ),
			]
		);
        $controls->add_control(
			'_sort',
			[
				'type'      => \Elementor\Controls_Manager::SWITCHER,
				'label'   => esc_html__( 'Show posts sort(order by)?', 'katerio-core' ),
                'description' => esc_html__( 'The post sort on showed when you give the heading of the block.', 'atlas-core' ),
				'label_on'    => esc_html__('Yes', 'katerio-core'),
				'label_off'   => esc_html__('No', 'katerio-core'),
				'default'     => 'no',
			]
		);

        $controls->add_control(
			'_sort_popular',
			[
				'label' => esc_html__('Show popular posts sort?', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'atlas-core'),
				'label_off' => esc_html__('No', 'atlas-core'),
				'default' => 'yes',
				'condition' => [
					'_sort' => ['yes'],
				],
			]
		);

        $controls->add_control(
			'_sort_views',
			[
				'label' => esc_html__('Show most viewed posts sort?', 'atlas-core'),
                'description' => esc_html__( 'Make sure you have activated post views plugin.', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'atlas-core'),
				'label_off' => esc_html__('No', 'atlas-core'),
				'default' => 'no',
				'condition' => [
					'_sort' => ['yes'],
				],
			]
		);

        $controls->add_control(
			'_sort_reviews',
			[
				'label' => esc_html__('Show best review posts sort?', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'atlas-core'),
				'label_off' => esc_html__('No', 'atlas-core'),
				'default' => 'no',
				'condition' => [
					'_sort' => ['yes'],
				],
			]
		);

        $controls->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' =>'_sort_font',
				'label' => esc_html__( 'Post sort typography', 'katerio-core' ),
				'selector' => '{{WRAPPER}} .module-sort',
				'condition' => [
					'_sort' => ['yes'],
				],
			]
		);

        $controls->add_responsive_control(
			'_sort_gap',
			[
				'label' => esc_html__( 'Post sort gap', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'allowed_dimensions' => 'vertical',
				'selectors' => [
					'{{WRAPPER}} .module-sorts' => 'margin: {{TOP}}{{UNIT}} 0 {{BOTTOM}}{{UNIT}} 0;',
				],
                'condition' => [
					'_sort' => ['yes'],
				],
			]
		);
        $controls->end_controls_section();
    }

    public function btn_trigger( $controls, $type = '' ) {
        if ( 'offcanvas' == $type ) {
            $controls->add_control(
                'icon_offcanvas',
    			[
    				'label'     => esc_html__( 'Offcanvas icon', 'atlas-core' ),
    				'type'      => \Elementor\Controls_Manager::SELECT,
    				'default'   => 'menu',
    				'options'   => array(
                        'menu'  => 'Icon 1',
                        'menu2' => 'Icon 2',
                        'menu3' => 'Icon 3',
                        'menu4' => 'Icon 4',
                    ),
    			]
    		);
        }

        $controls->add_control(
			'content',
			[
				'label'     => esc_html__( 'Button Content', 'atlas-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'icon',
				'options'   => th90_default_options()['btn_content'],
			]
		);

        $controls->add_control(
            'icon_pos',
			[
				'label'     => esc_html__( 'Icon Position', 'atlas-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'left',
				'options'   => array(
                    'left'  => 'Left',
                    'right' => 'Right',
                ),
                'condition'   => [
					 'content' => ['icon_text'],
				],
			]
		);

		$controls->add_control(
			'style',
			[
				'label'     => esc_html__( 'Button Style', 'atlas-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'text',
				'options'   => th90_default_options()['btn_style'],
			]
		);

		$controls->add_control(
			'size',
			[
				'label'     => esc_html__( 'Button Size', 'atlas-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'medium',
				'options'   => th90_default_options()['btn_size'],
			]
		);

        $controls->add_control(
			'_radius',
			[
				'label' => esc_html__( 'Button Radius', 'atlas-core' ),
				'type'  => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .button' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
                'condition'   => [
					 'style!' => ['text','text_color','text_underline'],
				],
			]
		);

		$controls->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'shadow',
				'label' => esc_html__( 'Button shadow', 'atlas-core' ),
				'description' => esc_html__( 'Add the shadow to button.', 'atlas-core' ),
				'selector' => '{{WRAPPER}} .button',
			]
		);

		if ( 'skin' == $type ) {
			$controls->add_control(
				'custom_icon_dark',
				[
					'label'       => esc_html__( 'Custom SVG icon - Dark', 'atlas-core' ),
					'placeholder' => '<svg ...> ... </svg>',
					'type'        => \Elementor\Controls_Manager::TEXTAREA,
					'default'     => '',
					'label_block' => true,
					'condition'   => [
						 'content!' => ['text'],
					],
				]
			);
			$controls->add_control(
				'custom_icon_light',
				[
					'label'       => esc_html__( 'Custom SVG icon - Light', 'atlas-core' ),
					'placeholder' => '<svg ...> ... </svg>',
					'type'        => \Elementor\Controls_Manager::TEXTAREA,
					'default'     => '',
					'label_block' => true,
					'condition'   => [
						 'content!' => ['text'],
					],
				]
			);
		} else {
			$controls->add_control(
				'custom_icon',
				[
					'label'       => esc_html__( 'Custom SVG icon', 'atlas-core' ),
					'placeholder' => '<svg ...> ... </svg>',
					'type'        => \Elementor\Controls_Manager::TEXTAREA,
					'default'     => '',
					'label_block' => true,
					'condition'   => [
						 'content!' => ['text'],
					],
				]
			);
		}

		$controls->add_responsive_control(
			'custom_icon_size',
			[
				'label' => __( 'Custom SVG icon size', 'atlas-core' ),
				'type'  => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .icon-svg' => 'font-size: {{SIZE}}{{UNIT}};',
				],
				'condition'   => [
					 'content!' => ['text'],
				],
			]
		);

		if ( 'skin' == $type ) {
			$controls->add_control(
				'custom_text_dark',
				[
					'label'       => esc_html__( 'Custom text - Dark', 'atlas-core' ),
					'type'        => \Elementor\Controls_Manager::TEXTAREA,
					'default'     => '',
					'label_block' => true,
					'condition'   => [
						 'content!' => ['icon'],
					],
				]
			);
			$controls->add_control(
				'custom_text_light',
				[
					'label'       => esc_html__( 'Custom text - light', 'atlas-core' ),
					'type'        => \Elementor\Controls_Manager::TEXTAREA,
					'default'     => '',
					'label_block' => true,
					'condition'   => [
						 'content!' => ['icon'],
					],
				]
			);
		} else {
			$controls->add_control(
				'custom_text',
				[
					'label'       => esc_html__( 'Custom text', 'atlas-core' ),
					'type'        => \Elementor\Controls_Manager::TEXTAREA,
					'default'     => '',
					'label_block' => true,
					'condition'   => [
						 'content!' => ['icon'],
					],
				]
			);
		}

		$controls->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'        => 'text_typo',
				'label'       => esc_html__( 'Text typography', 'atlas-core' ),
				'selector'    => '{{WRAPPER}} .text-btn',
				'condition'   => [
					 'content!' => ['icon'],
				],
			]
		);

		$controls->add_responsive_control(
			'btn_padding',
			[
				'label' => esc_html__( 'Button Padding', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'allowed_dimensions' => 'horizontal',
				'selectors' => [
					'{{WRAPPER}} .button' => 'padding: 0 {{RIGHT}}{{UNIT}} 0 {{LEFT}}{{UNIT}};',
				],
				'condition'   => [
					 'content!' => ['icon'],
				],
			]
		);
	}

    public function tax_query_default( $controls ) {
        /* Section Query */
		$controls->start_controls_section(
			'section_query_filter',
			[
				'label' => __( 'Taxonomy Query Filter', 'atlas-core' ),
			]
		);

		$controls->add_control(
			'taxonomy',
			[
				'label'     =>esc_html__( 'Taxonomy', 'atlas-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'category',
				'options'   => [
					'category'      => esc_html__( 'Category', 'atlas-core' ),
					'post_tag'       => esc_html__( 'Tag', 'atlas-core' ),
				],
			]
		);
		$controls->add_control(
			'selected_tags',
			[
				'label' => esc_html__('Show only selected tags?', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'atlas-core'),
				'label_off' => esc_html__('No', 'atlas-core'),
				'default' => 'no',
				'condition' => [
					'taxonomy' => ['post_tag'],
				],
			]
		);
		$controls->add_control(
			'tags',
			[
				'label' =>esc_html__('Tags', 'atlas-core'),
				'type'      => \Elementor\Controls_Manager::SELECT2,
				'options'   => th90_get_terms( 'post_tag', 'id' ),
				'label_block' => true,
				'multiple' => true,
				'conditions' => [
					'terms' => [
						['name' => 'taxonomy', 'operator' => 'in', 'value' => ['post_tag']],
						['name' => 'selected_tags', 'operator' => 'in', 'value' => ['yes']],
					],
				],
			]
		);

		$controls->add_control(
			'selected_cats',
			[
				'label' => esc_html__('Show only selected categories?', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'atlas-core'),
				'label_off' => esc_html__('No', 'atlas-core'),
				'default' => 'no',
				'condition' => [
					'taxonomy' => ['category'],
				],
			]
		);
		$controls->add_control(
			'categories',
			[
				'label' =>esc_html__('Categories', 'atlas-core'),
				'type'      => \Elementor\Controls_Manager::SELECT2,
				'options'   => th90_get_terms( 'category', 'id' ),
				'label_block' => true,
				'multiple' => true,
				'condition' => [
					'selected_cats' => ['yes'],
				],
				'conditions' => [
					'terms' => [
						['name' => 'taxonomy', 'operator' => 'in', 'value' => ['category']],
						['name' => 'selected_cats', 'operator' => 'in', 'value' => ['yes']],
					],
				],
			]
		);
		$controls->add_control(
			'number',
			[
				'label'         => esc_html__( 'Number', 'atlas-core' ),
				'description' 	=> esc_html__('Number of categories to show', 'atlas-core'),
				'type'          => \Elementor\Controls_Manager::NUMBER,
				'default'       => '10',
				'conditions' => [
					'relation' => 'or',
					'terms' => [
						[
							'relation' => 'and',
							'terms' => [
								['name' => 'taxonomy', 'operator' => 'in', 'value' => ['category']],
								['name' => 'selected_cats', 'operator' => '!in', 'value' => ['yes']],
							],
						],
						[
							'relation' => 'and',
							'terms' => [
								['name' => 'taxonomy', 'operator' => 'in', 'value' => ['post_tag']],
								['name' => 'selected_tags', 'operator' => '!in', 'value' => ['yes']],
							],
						],
					],
				],
			]
		);
		$controls->add_control(
			'orderby',
			[
				'label'     =>esc_html__( 'Sort by', 'atlas-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'name',
				'options'   => [
					'name'      => esc_html__( 'Name', 'atlas-core' ),
					'count'       => esc_html__( 'Count', 'atlas-core' ),
				],
				'conditions' => [
					'relation' => 'or',
					'terms' => [
						[
							'relation' => 'and',
							'terms' => [
								['name' => 'taxonomy', 'operator' => 'in', 'value' => ['category']],
								['name' => 'selected_cats', 'operator' => '!in', 'value' => ['yes']],
							],
						],
						[
							'relation' => 'and',
							'terms' => [
								['name' => 'taxonomy', 'operator' => 'in', 'value' => ['post_tag']],
								['name' => 'selected_tags', 'operator' => '!in', 'value' => ['yes']],
							],
						],
					],
				],
			]
		);
		$controls->add_control(
			'order',
			[
				'label'     =>esc_html__( 'Order', 'atlas-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'DESC',
				'options'   => [
					'DESC'      => esc_html__( 'Descending', 'atlas-core' ),
					'ASC'       => esc_html__( 'Ascending', 'atlas-core' ),
				],
				'conditions' => [
					'relation' => 'or',
					'terms' => [
						[
							'relation' => 'and',
							'terms' => [
								['name' => 'taxonomy', 'operator' => 'in', 'value' => ['category']],
								['name' => 'selected_cats', 'operator' => '!in', 'value' => ['yes']],
							],
						],
						[
							'relation' => 'and',
							'terms' => [
								['name' => 'taxonomy', 'operator' => 'in', 'value' => ['post_tag']],
								['name' => 'selected_tags', 'operator' => '!in', 'value' => ['yes']],
							],
						],
					],
				],
			]
		);

		$controls->add_control(
			'hide_empty',
			[
				'label' => esc_html__('Hide empty category?', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'atlas-core'),
				'label_off' => esc_html__('No', 'atlas-core'),
				'default' => 'yes',
			]
		);

		$controls->end_controls_section();
	}

    public function banner_default( $controls ) {
        $controls->add_control(
			'b_ads',
			[
				'label'       => esc_html__('Advertisement', 'atlas-core'),
				'description' => sprintf( esc_html__( 'You can create ads from %1$sadvertisement builder%2$s.', 'atlas-core' ), '<a target="_blank" href="' . admin_url('edit.php?post_type=th90_adv') . '"><strong>', '</strong></a>' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'options'     => th90_get_posts_id( 'th90_adv' ),
                'conditions' => [
                    'terms' => [
                        ['name' => 'b_ads_custom', 'operator' => '!in', 'value' => ['yes']],
                    ],
                ],
			]
		);
        $controls->add_control(
			'b_ads_custom',
			[
				'label' => esc_html__('Custom advertisement?', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'atlas-core'),
				'label_off' => esc_html__('No', 'atlas-core'),
				'default' => 'no',
			]
		);

        $controls->add_control(
            '_b_ads_custom', [
                'separator' => 'before',
                'label' => __( 'Custom Advertisement', 'atlas-core' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'conditions' => [
                    'terms' => [
                        ['name' => 'b_ads_custom', 'operator' => 'in', 'value' => ['yes']],
                    ],
                ],
            ]
        );

        $controls->add_control(
			'b_heading',
			[
				'label' => esc_html__( 'Ads heading', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'Advertisement',
				'label_block' => true,
                'conditions' => [
                    'terms' => [
                        ['name' => 'b_ads_custom', 'operator' => 'in', 'value' => ['yes']],
                    ],
                ],
			]
		);

        $controls->add_control(
			'b_type',
			[
				'label'   => esc_html__( 'Ads type', 'atlas-core' ),
				'description' => '',
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'image',
				'options' => [
					'image' => esc_html__( 'Image', 'atlas-core' ),
					'codes'   => esc_html__( 'Codes', 'atlas-core' ),
				],
                'conditions' => [
                    'terms' => [
                        ['name' => 'b_ads_custom', 'operator' => 'in', 'value' => ['yes']],
                    ],
                ],

			]
		);
        $controls->add_control(
            'b_codes',
            [
                'label'       => esc_html__( 'Ads Codes', 'atlas-core' ),
                'type'        => \Elementor\Controls_Manager::TEXTAREA,
                'default'     => '',
                'label_block' => true,
                'conditions' => [
                    'terms' => [
                        ['name' => 'b_type', 'operator' => 'in', 'value' => ['codes']],
                        ['name' => 'b_ads_custom', 'operator' => 'in', 'value' => ['yes']],
                    ],
                ],
            ]
        );

        $controls->add_control(
			'b_link',
			[
				'label' => esc_html__( 'Banner URL', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::URL,
                'options' => [ 'url', 'is_external', 'nofollow' ],

                'default' => [
					'url' => '',
					'is_external' => false,
					'nofollow' => false,
					// 'custom_attributes' => '',
				],
                'label_block' => true,
                'conditions' => [
                    'terms' => [
                        ['name' => 'b_type', 'operator' => 'in', 'value' => ['image']],
                        ['name' => 'b_ads_custom', 'operator' => 'in', 'value' => ['yes']],
                    ],
                ],
			]
		);
		$controls->add_control(
			'b_image',
			[
				'label'       => esc_html__( 'Image', 'atlas-core' ),
				'type'        => \Elementor\Controls_Manager::MEDIA,
                'conditions' => [
                    'terms' => [
                        ['name' => 'b_type', 'operator' => 'in', 'value' => ['image']],
                        ['name' => 'b_ads_custom', 'operator' => 'in', 'value' => ['yes']],
                    ],
                ],
			]
		);

		$controls->add_responsive_control(
			'_b_max_width',
			[
				'label' => esc_html__( 'Maximum width', 'atlas-core' ),
				'description' => esc_html__( '(Optional) Leave blank if you want to use full image width.', 'atlas-core' ),
				'type'  => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'vw' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 2000,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
					'vw' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .banner-box-inner' => 'max-width: {{SIZE}}{{UNIT}} !important;',
				],
                'conditions' => [
                    'terms' => [
                        ['name' => 'b_type', 'operator' => 'in', 'value' => ['image']],
                        ['name' => 'b_ads_custom', 'operator' => 'in', 'value' => ['yes']],
                    ],
                ],
			]
		);

		$controls->add_responsive_control(
			'_b_image_radius',
			[
				'label' => esc_html__( 'Image radius', 'atlas-core' ),
				'type'  => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .banner-box-inner' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
				'default' => [
					'unit' => 'px',
				],
                'conditions' => [
                    'terms' => [
                        ['name' => 'b_type', 'operator' => 'in', 'value' => ['image']],
                        ['name' => 'b_ads_custom', 'operator' => 'in', 'value' => ['yes']],
                    ],
                ],
			]
		);

		$controls->add_control(
			'_b_banner_align',
			[
				'label' => esc_html__( 'Banner Alignments', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'flex-start'    => [
						'title' => esc_html__( 'Start', 'atlas-core' ),
						'icon' => 'eicon-align-start-h',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'atlas-core' ),
						'icon' => 'eicon-align-center-h',
					],
					'flex-end' => [
						'title' => esc_html__( 'End', 'atlas-core' ),
						'icon' => 'eicon-align-end-h',
					],
				],
				'default' => 'center',
				//'prefix_class' => 'halign-',
				'selectors' => [
					'{{WRAPPER}} .banner-box' => 'justify-content: {{VALUE}};',
				],
                'conditions' => [
                    'terms' => [
                        ['name' => 'b_ads_custom', 'operator' => 'in', 'value' => ['yes']],
                    ],
                ],
			]
		);
    }

    public function box_settings( $controls, $active = 'no' ) {
        $controls->start_controls_section(
			'_section_box',
			[
				'label' => __( 'Box Settings', 'atlas-core' ),
			]
		);
        $controls->add_control(
			'box_active',
			[
				'label' => esc_html__('Activate box widget?', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'atlas-core'),
				'label_off' => esc_html__('No', 'atlas-core'),
				'default' => $active,
			]
		);

        /*$controls->add_control(
			'_box_bg_light',
			[
				'label' => esc_html__('Box background color - Light Skin', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}}.bg-light .th90-block.box-wrap' => 'background-color: {{VALUE}};',
				],
                'conditions' => [
 					'terms' => [
 						['name' => 'box_active', 'operator' => 'in', 'value' => ['yes']],
 					],
 				],
			]
		);
        $controls->add_control(
			'_box_bg_dark',
			[
				'label' => esc_html__('Box background color - Dark Skin', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}}.bg-dark .th90-block.box-wrap' => 'background-color: {{VALUE}};',
				],
                'conditions' => [
 					'terms' => [
 						['name' => 'box_active', 'operator' => 'in', 'value' => ['yes']],
 					],
 				],
			]
		);*/

        $controls->add_responsive_control(
			'_box_padding',
			[
				'label' => esc_html__( 'Box padding', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .th90-block.box-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'condition' => [
                    'box_active' => ['yes'],
                ],
			]
		);
        $controls->add_responsive_control(
			'_box_margin',
			[
				'label' => esc_html__( 'Box margin', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'allowed_dimensions' => 'vertical',
				'selectors' => [
					'{{WRAPPER}} .th90-block.box-wrap' => 'margin: {{TOP}}{{UNIT}} 0 {{BOTTOM}}{{UNIT}} 0;',
				],
                'condition' => [
                    'box_active' => ['yes'],
                ],
			]
		);

        $controls->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => '_box_bg',
				'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .th90-block.box-wrap',
                'condition'   => [
                     'box_active' => ['yes'],
                ],
			]
		);
        $controls->add_control(
			'_box_height',
			[
				'label' => esc_html__( 'Box height', 'atlas-core' ),
				'type'  => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ '%' ],
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .box-wrap.th90-block' => 'height: {{SIZE}}%;',
				],
                'condition'   => [
                     'box_active' => ['yes'],
                ],
			]
		);

        /*$controls->add_control(
			'_head_box_bg_light', [
				'separator' => 'before',
				'label' => __( 'Custom background - Light Skin', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::HEADING,
                'condition'   => [
                     'box_active' => ['yes'],
                ],
			]
		);
        $controls->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => '_box_bg_light',
				'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}}.bg-light .th90-block.box-wrap',
                'condition'   => [
                      'box_active' => ['yes'],
                ],
			]
		);
        $controls->add_control(
			'_head_box_bg_dark', [
				'separator' => 'before',
				'label' => __( 'Custom background - Dark Skin', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::HEADING,
                'condition'   => [
                     'box_active' => ['yes'],
                ],
			]
		);
        $controls->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => '_box_bg_dark',
				'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}}.bg-dark .th90-block.box-wrap',
                'condition'   => [
                      'box_active' => ['yes'],
                ],
			]
		);*/

        $controls->end_controls_section();

        $controls->start_controls_section(
			'_section_heading',
			[
				'label' => __( 'Heading Settings', 'atlas-core' ),
			]
		);

        $controls->add_control(
			'_heading_active',
			[
				'label' => esc_html__('Activate heading?', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'atlas-core'),
				'label_off' => esc_html__('No', 'atlas-core'),
				'default' => false,
                'separator' => 'before',
			]
		);

        $this->heading_settings( $controls, ['_heading_active' => ['yes']] );

        $controls->end_controls_section();

    }

    public function heading_settings( $controls, $condition = array() ) {

        $controls->add_control(
			'_heading',
			[
				'label' => esc_html__( 'Heading text', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'Heading',
				'label_block' => true,
                'condition' => $condition,
			]
		);

        $controls->add_control(
			'_heading_color',
			[
				'label' => esc_html__('Heading text color', 'atlas-core'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .widget-heading .title' => 'color: {{VALUE}};',
				],
                'condition' => $condition,
			]
		);

        $controls->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => '_heading_typography',
				'label' => esc_html__( 'Heading typography', 'atlas-core' ),
				'selector' => '{{WRAPPER}} .widget-heading .title',
                'condition' => $condition,
			]
		);

        $controls->add_control(
			'_heading_viewall',
			[
				'label' => esc_html__( 'View all text', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
				'label_block' => true,
                'condition' => $condition,
			]
		);

        $controls->add_control(
			'_heading_viewall_url',
			[
				'label' => esc_html__( 'View all URL', 'atlas-core' ),
				'type' => \Elementor\Controls_Manager::URL,
                'options' => [ 'url', 'is_external', 'nofollow' ],

                'default' => [
					'url' => '',
					'is_external' => false,
					'nofollow' => false,
					// 'custom_attributes' => '',
				],
                'label_block' => true,
                'condition' => $condition,
			]
		);
        $controls->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => '_heading_viewall_typo',
				'label' => esc_html__( 'View all typography', 'atlas-core' ),
				'selector' => '{{WRAPPER}} .viewAll',
                'condition' => $condition,
			]
		);
    }
}
