<?php
/*
 * Plugin Name:       Atlas Core
 * Plugin URI:        https://tmrwstudio.me/
 * Description:       This is core plugin for Atlas theme
 * Version:           1.3.4
 * Author:            tmrwstudio
 * Author URI:        https://themeforest.net/user/tmrwstudio
 * License:           GPL-2.0+
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       atlas-core
 * Domain Path:       /languages
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/*
--------------------------------------------------------------------------------
* Plugin Localize
* ------------------------------------------------------------------------------
*/
add_action( 'plugins_loaded', 'th90_atlas_core_load_textdomain' );
function th90_atlas_core_load_textdomain() {
	load_plugin_textdomain( 'atlas-core', false, basename( dirname( __FILE__ ) ) . '/languages' );
}

/*
--------------------------------------------------------------------------------
* Check if the plugin is compatible
* ------------------------------------------------------------------------------
*/
if ( ! function_exists( 'th90_is_theme_atlas' ) ) {
	function th90_is_theme_atlas() {
		if ( function_exists( 'atlas_theme_setup' ) ) {
			return true;
		}
	    return false;
	}
}


/*
--------------------------------------------------------------------------------
* Atlas Core
* ------------------------------------------------------------------------------
*/
if( ! function_exists( 'th90_atlas_core_plugin' ) ){
	function th90_atlas_core_plugin() {
		if ( th90_is_theme_atlas() ) {

			define( 'TH90_THEME_NAME', 'Atlas' );
			define( 'TH90_CORE_URL', plugin_dir_url( __FILE__ ) );
			define( 'TH90_CORE_PATH', plugin_dir_path( __FILE__ ) );

			if( TH90_ACF_IS_ACTIVE ) {
				require plugin_dir_path( __FILE__ ) . 'framework/acf-pro/acf-pro.php';
			}

			require plugin_dir_path( __FILE__ ) . 'framework/redux-core.php';
			require plugin_dir_path( __FILE__ ) . 'functions/social-networks.php';
			require plugin_dir_path( __FILE__ ) . 'functions/social-shares.php';
			require plugin_dir_path( __FILE__ ) . 'functions/user-profile.php';
			require plugin_dir_path( __FILE__ ) . 'functions/shortcodes.php';
			require plugin_dir_path( __FILE__ ) . 'functions/utilities.php';
			require plugin_dir_path( __FILE__ ) . 'elementor/elementor.php';
			require plugin_dir_path( __FILE__ ) . 'functions/seo.php';
			require plugin_dir_path( __FILE__ ) . 'functions/lazyload.php';
			require plugin_dir_path( __FILE__ ) . 'functions/speed.php';
			require plugin_dir_path( __FILE__ ) . 'functions/redux-sections.php';
			require plugin_dir_path( __FILE__ ) . 'functions/acf/acf-fields.php';
			require plugin_dir_path( __FILE__ ) . 'functions/acf/filters.php';
			require plugin_dir_path( __FILE__ ) . 'functions/menu-fields-custom.php';
			require plugin_dir_path( __FILE__ ) . 'functions/import.php';
		}
	}
	add_action( 'after_setup_theme', 'th90_atlas_core_plugin' );
}

function custom_admin_styles() {
  echo '<style>
    a.toplevel_page_th90-builder .wp-menu-name,
	a.toplevel_page_th90_options .wp-menu-name,
	a.toplevel_page_th90-builder .wp-menu-image:before,
	a.toplevel_page_th90_options .wp-menu-image:before { color: #ff5722 !important; }
  </style>';
}
add_action('admin_head', 'custom_admin_styles');
