<?php

namespace AxtraEssentialApp\Widgets;

use Elementor\Controls_Manager;
use Elementor\Control_Media;
use Elementor\Group_Control_Background;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Text_Stroke;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Group_Control_Image_Size;
use Elementor\Repeater;
use Elementor\Group_Control_Css_Filter;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;
use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) {
	exit;   // Exit if accessed directly.
}

class Blog_Post_Meta_Info extends \Elementor\Widget_Base {

	public function get_name() {
		return 'wcf--blog--post--meta-info';
	}

	public function get_title() {
		return wcf_elementor_widget_concat_prefix( 'Meta Info' );
	}
	
	public function get_icon() {
		return 'wcf eicon-meta-data';
	}

	public function get_categories() {
		return [ 'wcf-blog-single' ];
	}

	public function get_keywords() {
		return ['meta data', 'post meta' ];
	}

	public function get_style_depends() {
		wp_register_style( 'meta-info', AXTRA_ESSENTIAL_ASSETS_URL . 'css/meta-info.css' );
		return [ 'wcf--button', 'meta-info' ];
	}
	  	
	protected function register_controls() {
	    // Layout
		$this->start_controls_section(
			'section_layout',
			[
				'label' => __( 'Layout', 'axtra-essential' ),
			]
		);

		$this->add_control(
			'layout_style',
			[
				'label' => esc_html__( 'Layout Style', 'axtra-essential' ),
				'type' => Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1' => esc_html__( 'One', 'axtra-essential' ),
					'2' => esc_html__( 'Two', 'axtra-essential' ),
				],
			]
		);

		$this->add_responsive_control(
			'layout_align',
			[
				'label'     => esc_html__( 'Alignment', 'axtra-essential' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => [
					'flex-start'    => [
						'title' => esc_html__( 'Left', 'axtra-essential' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center'  => [
						'title' => esc_html__( 'Center', 'axtra-essential' ),
						'icon'  => 'eicon-text-align-center',
					],
					'flex-end'   => [
						'title' => esc_html__( 'Right', 'axtra-essential' ),
						'icon'  => 'eicon-text-align-right',
					],
				],
				'default'   => '',
				'separator' => 'before',
				'selectors' => [
					'{{WRAPPER}} .wcf--meta-list' => 'justify-content: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

		// Content
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'Content', 'axtra-essential' ),
			]
		);
		
		$repeater = new Repeater();

		$repeater->add_control(
			'list_title',
			[
				'label' => esc_html__( 'Title', 'axtra-essential' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'List Title' , 'axtra-essential' ),
				'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'list_type',
			[
				'label' => esc_html__( 'Meta', 'axtra-essential' ),
				'type' => Controls_Manager::SELECT,
				'default' => '',
				'options' => [
					'category' => esc_html__('Category','axtra-essential'),
					'date' => esc_html__('Date','axtra-essential'),
					'author' => esc_html__('Author','axtra-essential'),
					'view' => esc_html__('View','axtra-essential'),
					'reading_time' => esc_html__('Reading Time','axtra-essential'),
					'comment' => esc_html__('Comment','axtra-essential'),
				],
				'label_block' => true,
			]
		);


		$repeater->add_control(
			'list_icon',
			[
				'label' => esc_html__( 'Icon', 'axtra-essential' ),
				'type' => Controls_Manager::ICONS,
			]
		);

		$repeater->add_control(
			'meta_separator',
			[
				'label' => esc_html__( 'Separator', 'axtra-essential' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '|', 'axtra-essential' ),
				'placeholder' => esc_html__( 'Enter your separator', 'axtra-essential' ),
			]
		);

		$repeater->add_control(
			'multiple_category',
			[
				'label' => esc_html__( 'Multiple Category', 'axtra-essential' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'axtra-essential' ),
				'label_off' => esc_html__( 'No', 'axtra-essential' ),
				'return_value' => 'yes',
				'default' => 'yes',
                'condition' => [
                        'list_type' => ['category']
                ]
			]
		);

		$repeater->add_responsive_control(
			'category_limit',
			[
				'label' => esc_html__( 'Category Limit', 'axtra-essential' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 10,
				'step' => 1,
				'condition' => [
					'list_type' => ['category'],
                    'multiple_category' => 'yes',
				]
			]
		);
	
		$this->add_control(
			'list',
			[
				'label' => esc_html__( 'Social List', 'axtra-essential' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ list_title }}}',
			]
		);

		$this->end_controls_section();

		// Style Tab
		$this->start_controls_section(
			'section_style',
			[
				'label' => __( 'Style', 'axtra-essential' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'text_color',
			[
				'label' => esc_html__( 'Text Color', 'axtra-essential' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wcf--meta-list li, {{WRAPPER}} .wcf--meta-list li a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .wcf--meta-date, {{WRAPPER}} .wcf--meta-view' => 'color: {{VALUE}}',
					'{{WRAPPER}} .wcf--meta-list li svg' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'text_typo',
				'selector' => '{{WRAPPER}} .wcf--meta-list li, {{WRAPPER}} .wcf--meta-list li a, {{WRAPPER}} .wcf--meta-date, {{WRAPPER}} .wcf--meta-view',
			]
		);

		// Label Style
		$this->add_control(
			'label_color',
			[
				'label' => esc_html__( 'Label Color', 'axtra-essential' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wcf--meta-list li .label' => 'color: {{VALUE}}',
					'{{WRAPPER}} .wcf--meta-list li .label svg' => 'fill: {{VALUE}}',
				],
				'condition' => [
					'layout_style' => '2',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'label_typo',
				'selector' => '{{WRAPPER}} .wcf--meta-list li .label',
				'condition' => [
					'layout_style' => '2',
				],
			]
		);

		// Gap
		$this->add_responsive_control(
			'meta_col_gap',
			[
				'label' => esc_html__( 'Column Gap', 'axtra-essential' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wcf--meta-list' => 'column-gap: {{SIZE}}{{UNIT}};',
				],
                'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'meta_row_gap',
			[
				'label' => esc_html__( 'Row Gap', 'axtra-essential' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wcf--meta-list' => 'row-gap: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'meta_spacing',
			[
				'label' => esc_html__( 'Spacing', 'axtra-essential' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wcf--meta-list' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'separator' => 'before',
			]
		);

		$this->end_controls_section();


		// Separator Style
		$this->start_controls_section(
			'separator_style',
			[
				'label' => __( 'Separator', 'axtra-essential' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'separator_color',
			[
				'label' => esc_html__( 'Color', 'axtra-essential' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wcf--meta-list.style-2 > li::after' => 'background-color: {{VALUE}}',
				],
				'condition' => [
					'layout_style' => '2',
				],
			]
		);

		$this->add_responsive_control(
			'separator_width',
			[
				'label' => esc_html__( 'width', 'axtra-essential' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 20,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wcf--meta-list.style-2 > li::after' => 'width: {{SIZE}}{{UNIT}};',
				],
                'condition' => [
                        'layout_style' => '2',
                ],
			]
		);

		$this->add_responsive_control(
			'separator_height',
			[
				'label' => esc_html__( 'Height', 'axtra-essential' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wcf--meta-list.style-2 > li::after' => 'height: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'layout_style' => '2',
				],
			]
		);

		$this->add_responsive_control(
			'separator_position_2',
			[
				'label' => esc_html__( 'Position', 'axtra-essential' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wcf--meta-list.style-2 > li::after' => 'inset-inline-end: -{{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'layout_style' => '2',
				],
			]
		);

		$this->add_responsive_control(
			'separator_position',
			[
				'label' => esc_html__( 'Position', 'axtra-essential' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wcf-separator::after' => 'margin-inline-start: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'layout_style' => '1',
				],
			]
		);

		$this->end_controls_section();

		// Category Styles
        $this->category_styles();

        // Author Styles
        $this->author_styles();

        // Date Styles
        $this->date_styles();

        // View Styles
        $this->view_count_styles();

		// Comment Styles
		$this->comment_styles();
	}

    // Category Styles Control
	protected function category_styles() {
		$this->start_controls_section(
			'category_styles_section',
			[
				'label' => esc_html__( 'Category', 'axtra-essential' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'category_align',
			[
				'label' => esc_html__( 'Alignment', 'axtra-essential' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'start' => [
						'title' => esc_html__( 'Left', 'axtra-essential' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'axtra-essential' ),
						'icon' => 'eicon-text-align-center',
					],
					'end' => [
						'title' => esc_html__( 'Right', 'axtra-essential' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .wcf--meta-category' => 'align-items: {{VALUE}}; text-align: {{VALUE}};',
				],
				'condition' => [
					'layout_style' => '2',
				],
			]
		);

		$this->add_responsive_control(
			'category_col_gap',
			[
				'label' => esc_html__( 'Column Gap', 'axtra-essential' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wcf--category-list' => 'column-gap: {{SIZE}}{{UNIT}};',
				],
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'category_row_gap',
			[
				'label' => esc_html__( 'Row Gap', 'axtra-essential' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wcf--category-list' => 'row-gap: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'category_separator_position',
			[
				'label' => esc_html__( 'Separator Position', 'axtra-essential' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wcf-separator::after' => 'margin-inline-start: {{SIZE}}{{UNIT}};',
				],
				'separator' => 'after',
			]
		);

		$this->add_control(
			'category_hover_list',
			[
				'label'   => esc_html__( 'Hover Style', 'axtra-essential' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'hover-none',
				'options' => [
					'hover-none'      => esc_html__( 'None', 'axtra-essential' ),
					'hover-divide'    => esc_html__( 'Divided', 'axtra-essential' ),
					'hover-cross'     => esc_html__( 'Cross', 'axtra-essential' ),
					'hover-cropping'  => esc_html__( 'Cropping', 'axtra-essential' ),
					'rollover-top'    => esc_html__( 'Rollover Top', 'axtra-essential' ),
					'rollover-left'   => esc_html__( 'Rollover Left', 'axtra-essential' ),
					'parallal-border' => esc_html__( 'Parallel Border', 'axtra-essential' ),
					'rollover-cross'  => esc_html__( 'Rollover Cross', 'axtra-essential' ),
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'category_typo',
				'selector' => '{{WRAPPER}} .wcf--meta-list .wcf--meta-category a',
			]
		);

		$this->add_control(
			'category_padding',
			[
				'label' => esc_html__( 'Padding', 'axtra-essential' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 100,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wcf--meta-category a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'layout_style' => '1',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'category_border',
				'selector' => '{{WRAPPER}} a, {{WRAPPER}} a.btn-parallal-border:before, {{WRAPPER}} a.btn-parallal-border:after, {{WRAPPER}} a.btn-rollover-cross:before, {{WRAPPER}} a.btn-rollover-cross:after',
				'condition' => [
					'layout_style' => '1',
				],
			]
		);

		$this->add_control(
			'category_radius',
			[
				'label' => esc_html__( 'Border Radius', 'axtra-essential' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 100,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wcf--meta-category a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'layout_style' => '1',
				],
			]
		);

		$this->add_control(
			'category_transition',
			[
				'label' => esc_html__( 'Transition', 'axtra-essential' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1,
						'step' => .1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wcf--meta-category a' => 'transition: all {{SIZE}}s;',
				],
			]
		);

		$this->start_controls_tabs(
			'category_tabs'
		);

		$this->start_controls_tab(
			'category_normal_tab',
			[
				'label' => esc_html__( 'Normal', 'axtra-essential' ),
			]
		);

		$this->add_control(
			'category_color',
			[
				'label' => esc_html__( 'Color', 'axtra-essential' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wcf--meta-list .wcf--meta-category a, {{WRAPPER}} .wcf--meta-list .wcf--meta-category' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'category_bg',
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} a:not(.wcf-btn-ellipse), {{WRAPPER}} a.wcf-btn-mask:after, {{WRAPPER}} a.wcf-btn-ellipse:before',
				'condition' => [
					'layout_style' => '1',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'category_shadow',
				'selector' => '{{WRAPPER}} .wcf--meta-category a',
				'condition' => [
					'layout_style' => '1',
				],
			]
		);

		$this->end_controls_tab();


		$this->start_controls_tab(
			'category_hover_tab',
			[
				'label' => esc_html__( 'Hover', 'axtra-essential' ),
			]
		);

		$this->add_control(
			'category_hover_color',
			[
				'label' => esc_html__( 'Color', 'axtra-essential' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wcf--meta-list .wcf--meta-category a:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'category_hover_bg',
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} a:not(.btn-item, .btn-parallal-border, .btn-rollover-cross, .wcf-btn-ellipse):after, {{WRAPPER}} .btn-hover-bgchange span, {{WRAPPER}} .btn-rollover-cross:hover, {{WRAPPER}} .btn-parallal-border:hover, {{WRAPPER}} a.wcf-btn-ellipse:hover:before,{{WRAPPER}} a.btn-hover-none:hover',
				'condition' => [
					'layout_style' => '1',
				],
			]
		);

		$this->add_control(
			'category_hover_border',
			[
				'label' => esc_html__( 'Border Color', 'axtra-essential' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wcf--meta-list .wcf--meta-category a:hover, {{WRAPPER}} a:hover, {{WRAPPER}} a:focus, {{WRAPPER}} a:hover.btn-parallal-border:before, {{WRAPPER}} a:hover.btn-parallal-border:after, {{WRAPPER}} a:hover.btn-rollover-cross:before, {{WRAPPER}} a:hover.btn-rollover-cross:after, {{WRAPPER}} a.btn-hover-none:hover' => 'border-color: {{VALUE}}',
				],
				'condition' => [
					'layout_style' => '1',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'category_hover_shadow',
				'selector' => '{{WRAPPER}} .wcf--meta-category a:hover',
				'condition' => [
					'layout_style' => '1',
				],
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();

		// Label
		$this->add_control(
			'category_label_heading',
			[
				'label' => esc_html__( 'Label', 'axtra-essential' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => [
					'layout_style' => '2',
				],
			]
		);

		$this->add_control(
			'category_label_color',
			[
				'label' => esc_html__( 'Color', 'axtra-essential' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wcf--category-title' => 'color: {{VALUE}}',
				],
				'condition' => [
					'layout_style' => '2',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'category_label_typo',
				'selector' => '{{WRAPPER}} .wcf--category-title',
				'condition' => [
					'layout_style' => '2',
				],
			]
		);

		$this->add_responsive_control(
			'category_label_spacing',
			[
				'label' => esc_html__( 'Spacing', 'axtra-essential' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wcf--category-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'layout_style' => '2',
				],
			]
		);

		$this->add_control(
			'category_icon_heading',
			[
				'label' => esc_html__( 'Icon', 'axtra-essential' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'category_icon',
			[
				'label' => esc_html__( 'Size', 'axtra-essential' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wcf--category-wrap i, {{WRAPPER}} li.wcf--category-wrap svg' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .wcf--category-title i, {{WRAPPER}} .wcf--category-title svg' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'category_icon_color',
			[
				'label' => esc_html__( 'Color', 'axtra-essential' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wcf--category-wrap i, {{WRAPPER}} .wcf--category-title i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .wcf--category-wrap svg, {{WRAPPER}} .wcf--category-title svg' => 'fill: {{VALUE}}',

				],
			]
		);

		$this->add_responsive_control(
			'category_icon_space',
			[
				'label' => esc_html__( 'Spacing', 'axtra-essential' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 150,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wcf--category-wrap i, {{WRAPPER}} .wcf--category-wrap svg' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .wcf--category-title i, {{WRAPPER}} .wcf--category-title svg' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();
    }

	// Author Styles Control
	protected function author_styles() {
		$this->start_controls_section(
			'author_styles_section',
			[
				'label' => esc_html__( 'Author', 'axtra-essential' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'author_typo',
				'selector' => '{{WRAPPER}} .wcf--meta-list .wcf--meta-author a',
			]
		);

		$this->add_control(
			'author_transition',
			[
				'label' => esc_html__( 'Transition', 'axtra-essential' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1,
						'step' => .1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wcf--meta-author a' => 'transition: all {{SIZE}}s;',
				],
			]
		);

		$this->start_controls_tabs(
			'author_tabs'
		);

		$this->start_controls_tab(
			'author_normal_tab',
			[
				'label' => esc_html__( 'Normal', 'axtra-essential' ),
			]
		);

		$this->add_control(
			'author_color',
			[
				'label' => esc_html__( 'Color', 'axtra-essential' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wcf--meta-list .wcf--meta-author a, {{WRAPPER}} .wcf--meta-list .wcf--meta-author' => 'color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();


		$this->start_controls_tab(
			'author_hover_tab',
			[
				'label' => esc_html__( 'Hover', 'axtra-essential' ),
			]
		);

		$this->add_control(
			'author_hover_color',
			[
				'label' => esc_html__( 'Color', 'axtra-essential' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wcf--meta-list .wcf--meta-author a:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();

        // Label
		$this->add_control(
			'author_label_heading',
			[
				'label' => esc_html__( 'Label', 'axtra-essential' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => [
					'layout_style' => '2',
				],
			]
		);

		$this->add_control(
			'author_label_color',
			[
				'label' => esc_html__( 'Color', 'axtra-essential' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wcf--author-title' => 'color: {{VALUE}}',
				],
				'condition' => [
					'layout_style' => '2',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'author_label_typo',
				'selector' => '{{WRAPPER}} .wcf--author-title',
				'condition' => [
					'layout_style' => '2',
				],
			]
		);

		$this->add_responsive_control(
			'author_label_spacing',
			[
				'label' => esc_html__( 'Spacing', 'axtra-essential' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wcf--author-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'layout_style' => '2',
				],
			]
		);

		$this->add_control(
			'author_icon_heading',
			[
				'label' => esc_html__( 'Icon', 'axtra-essential' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'author_icon',
			[
				'label' => esc_html__( 'Size', 'axtra-essential' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wcf--meta-author i, {{WRAPPER}} .wcf--meta-author svg' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .wcf-author-img img' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->add_control(
			'author_icon_color',
			[
				'label' => esc_html__( 'Color', 'axtra-essential' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wcf--meta-author i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .wcf--meta-author svg' => 'fill: {{VALUE}}',

				],
				'condition' => [
					'layout_style' => '1',
				],
			]
		);

		$this->add_responsive_control(
			'author_icon_space',
			[
				'label' => esc_html__( 'Spacing', 'axtra-essential' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 150,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wcf--meta-author i, {{WRAPPER}} .wcf--meta-author svg' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .wcf-author-img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'author_img_radius',
			[
				'label' => esc_html__( 'Border Radius', 'axtra-essential' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wcf-author-img img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'layout_style' => '2',
				],
			]
		);

		$this->end_controls_section();
	}

	// Date Styles Control
	protected function date_styles() {
		$this->start_controls_section(
			'date_styles_section',
			[
				'label' => esc_html__( 'Date', 'axtra-essential' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'date_align',
			[
				'label' => esc_html__( 'Alignment', 'axtra-essential' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'start' => [
						'title' => esc_html__( 'Left', 'axtra-essential' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'axtra-essential' ),
						'icon' => 'eicon-text-align-center',
					],
					'end' => [
						'title' => esc_html__( 'Right', 'axtra-essential' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .wcf--date-wrap' => 'align-items: {{VALUE}}; text-align: {{VALUE}};',
				],
				'condition' => [
					'layout_style' => '2',
				],
			]
		);

		$this->add_control(
			'date_color',
			[
				'label' => esc_html__( 'Color', 'axtra-essential' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wcf--meta-list .wcf--meta-date' => 'color: {{VALUE}}',
				],
                'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'date_typo',
				'selector' => '{{WRAPPER}} .wcf--meta-list .wcf--meta-date',
			]
		);

		$this->add_control(
			'date_label_heading',
			[
				'label' => esc_html__( 'Label', 'axtra-essential' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => [
					'layout_style' => '2',
				],
			]
		);

		$this->add_control(
			'date_label_color',
			[
				'label' => esc_html__( 'Color', 'axtra-essential' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wcf--date-title' => 'color: {{VALUE}}',
				],
				'condition' => [
					'layout_style' => '2',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'date_label_typo',
				'selector' => '{{WRAPPER}} .wcf--date-title',
				'condition' => [
					'layout_style' => '2',
				],
			]
		);

		$this->add_responsive_control(
			'date_label_spacing',
			[
				'label' => esc_html__( 'Spacing', 'axtra-essential' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wcf--date-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'layout_style' => '2',
				],
			]
		);

		$this->add_control(
			'date_icon_heading',
			[
				'label' => esc_html__( 'Icon', 'axtra-essential' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'date_icon',
			[
				'label' => esc_html__( 'Size', 'axtra-essential' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wcf--meta-date i, {{WRAPPER}} .wcf--meta-date svg' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .wcf--date-title i, {{WRAPPER}} .wcf--date-title svg' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'date_icon_color',
			[
				'label' => esc_html__( 'Color', 'axtra-essential' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wcf--meta-date i, {{WRAPPER}} .wcf--date-title i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .wcf--meta-date svg, {{WRAPPER}} .wcf--date-title svg' => 'fill: {{VALUE}}',

				],
			]
		);

		$this->add_responsive_control(
			'date_icon_space',
			[
				'label' => esc_html__( 'Spacing', 'axtra-essential' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 150,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wcf--meta-date i, {{WRAPPER}} .wcf--meta-date svg' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .wcf--date-title i, {{WRAPPER}} .wcf--date-title svg' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();
	}

	// View Count Styles Control
	protected function view_count_styles() {
		$this->start_controls_section(
			'view_styles_section',
			[
				'label' => esc_html__( 'View Count', 'axtra-essential' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'view_align',
			[
				'label' => esc_html__( 'Alignment', 'axtra-essential' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'start' => [
						'title' => esc_html__( 'Left', 'axtra-essential' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'axtra-essential' ),
						'icon' => 'eicon-text-align-center',
					],
					'end' => [
						'title' => esc_html__( 'Right', 'axtra-essential' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .wcf--view-wrap' => 'align-items: {{VALUE}}; text-align: {{VALUE}};',
				],
				'condition' => [
					'layout_style' => '2',
				],
			]
		);

		$this->add_responsive_control(
			'view_direction',
			[
				'label' => esc_html__( 'Direction', 'axtra-essential' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'row' => [
						'title' => esc_html__( 'Row', 'axtra-essential' ),
						'icon' => ' eicon-arrow-right',
					],
					'column' => [
						'title' => esc_html__( 'Column', 'axtra-essential' ),
						'icon' => 'eicon-arrow-down',
					],
					'row-reverse' => [
						'title' => esc_html__( 'Row Reverse', 'axtra-essential' ),
						'icon' => ' eicon-arrow-left',
					],
					'column-reverse' => [
						'title' => esc_html__( 'Column Reverse', 'axtra-essential' ),
						'icon' => 'eicon-arrow-up',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .wcf--meta-view' => 'flex-direction: {{VALUE}};',
				],
				'condition' => [
					'layout_style' => '2',
				],
			]
		);

		$this->add_responsive_control(
			'view_gap',
			[
				'label' => esc_html__( 'Gap', 'axtra-essential' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wcf--meta-view' => 'gap: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'layout_style' => '2',
				],
			]
		);

		// Typo
		$this->add_control(
			'view_color',
			[
				'label' => esc_html__( 'Color', 'axtra-essential' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wcf--meta-list .wcf--meta-view' => 'color: {{VALUE}}',
				],
                'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'view_typo',
				'selector' => '{{WRAPPER}} .wcf--meta-list .wcf--meta-view',
			]
		);

		$this->add_control(
			'view_label_heading',
			[
				'label' => esc_html__( 'Label', 'axtra-essential' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
                'condition' => [
                        'layout_style' => '2',
                ],
			]
		);

		$this->add_control(
			'view_label_color',
			[
				'label' => esc_html__( 'Color', 'axtra-essential' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wcf--view-title' => 'color: {{VALUE}}',
				],
				'condition' => [
					'layout_style' => '2',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'view_label_typo',
				'selector' => '{{WRAPPER}} .wcf--view-title',
				'condition' => [
					'layout_style' => '2',
				],
			]
		);

		$this->add_responsive_control(
			'view_label_spacing',
			[
				'label' => esc_html__( 'Spacing', 'axtra-essential' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wcf--view-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'layout_style' => '2',
				],
			]
		);

		$this->add_control(
			'view_icon_heading',
			[
				'label' => esc_html__( 'Icon', 'axtra-essential' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'view_icon',
			[
				'label' => esc_html__( 'Size', 'axtra-essential' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wcf--meta-view i, {{WRAPPER}} .wcf--meta-view svg' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .wcf--view-title i, {{WRAPPER}} .wcf--view-title svg' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'view_icon_color',
			[
				'label' => esc_html__( 'Color', 'axtra-essential' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wcf--meta-view i, {{WRAPPER}} .wcf--view-title i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .wcf--meta-view svg, {{WRAPPER}} .wcf--view-title svg' => 'fill: {{VALUE}}',

				],
			]
		);

		$this->add_responsive_control(
			'view_icon_space',
			[
				'label' => esc_html__( 'Spacing', 'axtra-essential' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 150,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wcf--meta-view i, {{WRAPPER}} .wcf--meta-view svg' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .wcf--view-title i, {{WRAPPER}} .wcf--view-title svg' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();
	}

	// Comment Styles Control
	protected function comment_styles() {
		$this->start_controls_section(
			'comment_styles_section',
			[
				'label' => esc_html__( 'Comment', 'axtra-essential' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'comment_align',
			[
				'label' => esc_html__( 'Alignment', 'axtra-essential' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'start' => [
						'title' => esc_html__( 'Left', 'axtra-essential' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'axtra-essential' ),
						'icon' => 'eicon-text-align-center',
					],
					'end' => [
						'title' => esc_html__( 'Right', 'axtra-essential' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .wcf--comment-wrap' => 'align-items: {{VALUE}}; text-align: {{VALUE}};',
				],
				'condition' => [
					'layout_style' => '2',
				],
			]
		);

		// Typo
		$this->add_control(
			'comment_color',
			[
				'label' => esc_html__( 'Color', 'axtra-essential' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wcf--meta-list .wcf--meta-comment' => 'color: {{VALUE}}',
				],
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'comment_typo',
				'selector' => '{{WRAPPER}} .wcf--meta-list .wcf--meta-comment',
			]
		);

		$this->add_control(
			'comment_label_heading',
			[
				'label' => esc_html__( 'Label', 'axtra-essential' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => [
					'layout_style' => '2',
				],
			]
		);

		$this->add_control(
			'comment_label_color',
			[
				'label' => esc_html__( 'Color', 'axtra-essential' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wcf--comment-title' => 'color: {{VALUE}}',
				],
				'condition' => [
					'layout_style' => '2',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'comment_label_typo',
				'selector' => '{{WRAPPER}} .wcf--comment-title',
				'condition' => [
					'layout_style' => '2',
				],
			]
		);

		$this->add_responsive_control(
			'comment_label_spacing',
			[
				'label' => esc_html__( 'Spacing', 'axtra-essential' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wcf--comment-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'layout_style' => '2',
				],
			]
		);

		$this->add_control(
			'comment_icon_heading',
			[
				'label' => esc_html__( 'Icon', 'axtra-essential' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'comment_icon',
			[
				'label' => esc_html__( 'Size', 'axtra-essential' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wcf--meta-comment i, {{WRAPPER}} .wcf--meta-comment svg' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .wcf--comment-title i, {{WRAPPER}} .wcf--comment-title svg' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'comment_icon_color',
			[
				'label' => esc_html__( 'Color', 'axtra-essential' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wcf--meta-comment i, {{WRAPPER}} .wcf--comment-title i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .wcf--meta-comment svg, {{WRAPPER}} .wcf--comment-title svg' => 'fill: {{VALUE}}',

				],
			]
		);

		$this->add_responsive_control(
			'comment_icon_space',
			[
				'label' => esc_html__( 'Spacing', 'axtra-essential' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 150,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wcf--meta-comment i, {{WRAPPER}} .wcf--meta-comment svg' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .wcf--comment-title i, {{WRAPPER}} .wcf--comment-title svg' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();
	}
	
	protected function render() {
	
        $settings   = $this->get_settings_for_display();        
        $meta_list     = $settings['list'];
		$post_id    = get_the_id();
        $is_editor  = \Elementor\Plugin::$instance->editor->is_edit_mode() || \Elementor\Plugin::$instance->preview->is_preview_mode() || (isset($_GET['preview_id']) && isset($_GET['preview_nonce']));
        
        if($is_editor) {
        
            $recent_posts = wp_get_recent_posts(array(
                'numberposts' => 1, 
                'post_status' => 'publish' 
            ));
            
            if(isset($recent_posts[0])){
                $post_id = $recent_posts[0]['ID'];
                
                global $post; 
                $post = get_post( $post_id, OBJECT );
                setup_postdata( $post );
            } 
            
        }
       ?>

        <ul class="wcf--meta-list style-<?php echo esc_html( $settings['layout_style'] ); ?>">
			<?php foreach ( $meta_list as $meta ) {
				$this->render_date( $meta, $settings );
				$this->render_categories( $meta, $settings );
				$this->render_author( $meta, $settings );
				$this->render_view_count( $meta, $settings );
				$this->render_reading_time( $meta, $settings );
				$this->render_comments( $meta, $settings );
			}
			?>
        </ul>

		<?php
		if($is_editor) {
		    wp_reset_postdata();
        }
	}

	protected function render_date( $meta, $settings ) {
		if($meta['list_type'] == 'date'){ ?>
			<?php if ( '1' == $settings['layout_style'] ): ?>
                <li class="wcf--meta-date wcf-separator" data-separator="<?php echo esc_attr( $meta['meta_separator'] ); ?>">
					<?php Icons_Manager::render_icon( $meta['list_icon'], [ 'aria-hidden' => 'true' ] ); ?>
					<?php echo get_the_date( get_option( 'date_format' ) ); ?>
                </li>
			<?php endif; ?>

			<?php if( '2' == $settings['layout_style'] ): ?>
                <li class="wcf--date-wrap">
                    <div class="wcf--date-title label">
						<?php Icons_Manager::render_icon( $meta['list_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                        <?php echo esc_html($meta['list_title']); ?>
                    </div>
                    <div class="wcf--meta-date">
					    <?php echo get_the_date(get_option( 'date_format' )); ?>
                    </div>
                </li>
			<?php endif; ?>
		<?php }
	}

	protected function render_categories( $meta, $settings ) {
		if ( $meta['list_type'] == 'category' ) {
			$cat = get_the_category();
			shuffle( $cat );
			?>

			<?php if ( '1' == $settings['layout_style'] ): ?>
				<?php if ( 'yes' === $meta['multiple_category'] ): ?>
                    <li class="wcf--category-wrap">
						<?php Icons_Manager::render_icon( $meta['list_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                        <ul class="wcf--category-list">
							<?php foreach ( $cat as $key => $term ) { ?>
                                <li class="wcf--meta-category wcf-separator"
                                    data-separator="<?php echo esc_attr( $meta['meta_separator'] ); ?>">
                                    <a class="wcf-btn-default btn-<?php echo $settings['category_hover_list']; ?>" href="<?php echo esc_url( get_category_link( $term->term_id ) ); ?>">
                                        <?php echo esc_html( get_cat_name( $term->term_id ) ); ?>
                                    </a>
                                </li>
							    <?php
								if( isset($meta['category_limit']) && is_numeric($meta['category_limit'])){
									if($meta['category_limit'] == $key+1 ){
										break;
									}
								}
							}
                            ?>
                        </ul>
                    </li>
				<?php else: ?>
					<?php if ( isset( $cat[0] ) ) { ?>
                        <li class="wcf--meta-category wcf-separator"
                            data-separator="<?php echo esc_attr( $meta['meta_separator'] ); ?>">
                            <?php Icons_Manager::render_icon( $meta['list_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                            <a class="wcf-btn-default btn-<?php echo $settings['category_hover_list']; ?>" href="<?php echo esc_url( get_category_link( $cat[0]->term_id ) ); ?>">
	                            <?php echo esc_html( get_cat_name( $cat[0]->term_id ) ); ?>
                            </a>
                        </li>
					<?php } ?>
				<?php
				endif;
				?>
			<?php endif; ?>

			<?php if ( '2' == $settings['layout_style'] ): ?>
				<?php if ( 'yes' === $meta['multiple_category'] ): ?>
                    <li class="wcf--category-wrap">
                        <div class="wcf--category-title label">
		                    <?php Icons_Manager::render_icon( $meta['list_icon'], [ 'aria-hidden' => 'true' ] ); ?>
		                    <?php echo esc_html($meta['list_title']); ?>
                        </div>
                        <ul class="wcf--category-list">
							<?php foreach ( $cat as $key => $term ) { ?>
                                <li class="wcf--meta-category wcf-separator"
                                    data-separator="<?php echo esc_attr( $meta['meta_separator'] ); ?>">
                                    <a class="wcf-btn-default btn-<?php echo $settings['category_hover_list']; ?>" href="<?php echo esc_url( get_category_link( $term->term_id ) ); ?>">
										<?php echo esc_html( get_cat_name( $term->term_id ) ); ?>
                                    </a>
                                </li>
							    <?php
								if( isset($meta['category_limit']) && is_numeric($meta['category_limit'])){
									if($meta['category_limit'] == $key+1 ){
										break;
									}
								}
							} ?>
                        </ul>
                    </li>
				<?php else: ?>
					<?php if ( isset( $cat[0] ) ) { ?>
                        <li class="wcf--meta-category">
                            <div class="wcf--category-title label">
	                            <?php Icons_Manager::render_icon( $meta['list_icon'], [ 'aria-hidden' => 'true' ] ); ?>
		                        <?php echo esc_html($meta['list_title']); ?>
                            </div>
                            <a class="wcf-btn-default btn-<?php echo $settings['category_hover_list']; ?>" href="<?php echo esc_url( get_category_link( $cat[0]->term_id ) ); ?>">
								<?php echo esc_html( get_cat_name( $cat[0]->term_id ) ); ?>
                            </a>
                        </li>
					<?php } ?>
				<?php
				endif;
				?>
			<?php endif; ?>
		<?php }
	}

	protected function render_author( $meta, $settings ) {
		global $post;
		$author_id = $post->post_author;

		if ( $meta['list_type'] == 'author' ) {
			$get_author = get_the_author_meta( 'display_name', $author_id );
			$avatar     = get_avatar( $author_id, 55 );
			$_posts_url = esc_url( get_author_posts_url( $author_id ) );
			?>
			<?php if ( '1' == $settings['layout_style'] ): ?>
                <li class="wcf--meta-author wcf-separator" data-separator="<?php echo esc_attr( $meta['meta_separator'] ); ?>">
                    <?php Icons_Manager::render_icon( $meta['list_icon'], [ 'aria-hidden' => 'true' ] ); ?>
					<?php echo "<a href='{$_posts_url}'>&nbsp;{$get_author}</a></strong>"; ?>
                </li>
			<?php endif; ?>

			<?php if ( '2' == $settings['layout_style'] ): ?>
                <li class="wcf--author-wrap">
                    <div class="wcf-author-img">
                        <?php echo $avatar; ?>
                    </div>
                    <div class="wcf--author-info">
                        <div class="wcf--author-title label">
		                    <?php echo esc_html($meta['list_title']); ?>
                        </div>
                        <div class="wcf--meta-author">
                            <?php echo "<a href='{$_posts_url}'>&nbsp;{$get_author}</a></strong>"; ?>
                        </div>
                    </div>
                </li>
			<?php endif; ?>
		<?php }
	}

	protected function render_view_count( $meta, $settings ) {
		if($meta['list_type'] == 'view'){ ?>
			<?php if ( '1' == $settings['layout_style'] ): ?>
                <li class="wcf--meta-view wcf-separator" data-separator="<?php echo esc_attr( $meta['meta_separator'] ); ?>">
                    <?php Icons_Manager::render_icon( $meta['list_icon'], [ 'aria-hidden' => 'true' ] ); ?>
					<?php echo get_post_meta(get_the_id(),'axtra_post_views_count',true); ?>&nbsp;<?php echo esc_html__('Views','axtra-essential'); ?>
                </li>
			<?php endif; ?>

			<?php if ( '2' == $settings['layout_style'] ): ?>
                <li class="wcf--view-wrap">
                    <div class="wcf--view-title label">
		                <?php Icons_Manager::render_icon( $meta['list_icon'], [ 'aria-hidden' => 'true' ] ); ?>
		                <?php echo esc_html($meta['list_title']); ?>
                    </div>
                    <div class="wcf--meta-view">
	                    <?php echo get_post_meta(get_the_id(),'axtra_post_views_count',true); ?>&nbsp;<span><?php echo esc_html__('Views','axtra-essential'); ?></span>
                    </div>
                </li>
			<?php endif; ?>
		<?php }
	}
	protected function render_reading_time( $meta, $settings ) {
	    $time = axtra_content_estimated_reading_time();
		if($meta['list_type'] == 'reading_time'){ ?>
			<?php if ( '1' == $settings['layout_style'] ): ?>
                <li class="wcf--meta-view wcf-separator" data-separator="<?php echo esc_attr( $meta['meta_separator'] ); ?>">
                    <?php Icons_Manager::render_icon( $meta['list_icon'], [ 'aria-hidden' => 'true' ] ); ?>
					<?php echo $time; ?><?php echo $time<=1 ? esc_html__('minute read','axtra-essential') : esc_html__('minutes read','axtra-essential'); ?>
                </li>
			<?php endif; ?>
 
			<?php if ( '2' == $settings['layout_style'] ): ?>
                <li class="wcf--view-wrap">
                    <div class="wcf--view-title label">
		                <?php Icons_Manager::render_icon( $meta['list_icon'], [ 'aria-hidden' => 'true' ] ); ?>
		                <?php echo esc_html($meta['list_title']); ?>
                    </div>
                    <div class="wcf--meta-view">
	                    <?php echo $time; ?>&nbsp;<span><?php echo $time<=1 ? esc_html__('minute read','axtra-essential') : esc_html__('minutes read','axtra-essential'); ?></span>
                    </div>
                </li>
			<?php endif; ?>
		<?php }
	}

	protected function render_comments( $meta, $settings ) {
		if($meta['list_type'] == 'comment'){ ?>
			<?php if ( '1' == $settings['layout_style'] ): ?>
                <li class="wcf--meta-comment wcf-separator" data-separator="<?php echo esc_attr( $meta['meta_separator'] ); ?>">
					<?php Icons_Manager::render_icon( $meta['list_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                    <?php comments_number(); ?>
                </li>
			<?php endif; ?>

			<?php if ( '2' == $settings['layout_style'] ): ?>
                <li class="wcf--comment-wrap">
                    <div class="wcf--comment-title label">
						<?php Icons_Manager::render_icon( $meta['list_icon'], [ 'aria-hidden' => 'true' ] ); ?>
						<?php echo esc_html($meta['list_title']); ?>
                    </div>
                    <div class="wcf--meta-comment">
	                    <?php comments_number(); ?>
                    </div>
                </li>
			<?php endif; ?>
		<?php }
	}

}