<?php
namespace AxtraEssentialApp\Widgets;

use Elementor\Controls_Manager;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Widget_Base;

use Elementor\Plugin;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Blog_Post_Feature extends \Elementor\Widget_Base {
		
	public function get_name() {	
		return 'wcf--theme-post-image';
	}

	public function get_title() {
		return wcf_elementor_widget_concat_prefix( 'Post Image' );
	}

    public function get_icon() {
		return 'wcf eicon-featured-image';
	}

	public function get_categories() {
		return [ 'wcf-blog-single' ];
	}

	public function get_keywords() {
		return [ 'feature', 'post image' ,'image'];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Settings', 'axtra-essential' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Image_Size::get_type(),
			[
				'name' => 'thumbnail', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
				'exclude' => [ 'custom' ],
				'include' => [],
				'default' => 'large',
			]
		);
		
		
		$this->add_responsive_control(
			'image_align',
			[
				'label' => esc_html__( 'Alignment', 'axtra-essential' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'axtra-essential' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'axtra-essential' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'axtra-essential' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .wcf-f-image-wrapper' => 'text-align: {{VALUE}};',
				],
			]
		);

		
	
		$this->end_controls_section();
	}

	protected function render() {
	
        $settings   = $this->get_settings_for_display();        
        $post_id    = get_the_id();
        $image_size = isset($settings['thumbnail_size']) ? $settings['thumbnail_size'] : 'full';
        if(\Elementor\Plugin::$instance->editor->is_edit_mode() || \Elementor\Plugin::$instance->preview->is_preview_mode() || (isset($_GET['preview_id']) && isset($_GET['preview_nonce']))) {
        
            $recent_posts = wp_get_recent_posts(array(
                'numberposts' => 1, 
                'post_status' => 'publish' 
            ));
            
            if(isset($recent_posts[0])){
                $post_id = $recent_posts[0]['ID'];
            } 
           
        }
		?>
		<style>
		.elementor-editor-preview .elementor-widget-wcf--theme-post-image.elementor-widget-empty{
		 display: block;
		}
		</style>
		<div class="wcf-f-image-wrapper">
            <?php echo get_the_post_thumbnail( $post_id , $image_size , array(  ) ); ?>        
        </div>
        <?php
	}

}
