<?php
namespace AxtraEssentialApp\Widgets;

use Elementor\Controls_Manager;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Widget_Base;
use Elementor\Plugin;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Blog_Post_Content extends \Elementor\Widget_Base {
	
	
	public function get_name() {	
		return 'wcf--theme-post-content';
	}

	public function get_title() {
		return wcf_elementor_widget_concat_prefix( 'Post Content' );
	}

	public function get_icon() {
		return 'wcf eicon-post-content';
	}

	public function get_categories() {
		return [ 'wcf-blog-single' ];
	}

	public function get_keywords() {
		return [ 'content', 'post' ];
	}

	/**
	 * Render post content.
	 *
	 * @param boolean     $with_wrapper - Whether to wrap the content with a div.
	 * @param boolean     $with_css - Decides whether to print inline CSS before the post content.
	 *
	 * @return void
	 */
	public function render_post_content( $with_wrapper = false, $with_css = true ) {
		static $did_posts = [];
		static $level = 0;
		$settings = $this->get_settings_for_display();
		$post = get_post();
    
		if ( post_password_required( $post->ID ) ) {
			// PHPCS - `get_the_password_form`. is safe.
			echo get_the_password_form( $post->ID ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			return;
		}

		// Avoid recursion
		if ( isset( $did_posts[ $post->ID ] ) ) {
			return;
		}

		$level++;
		$did_posts[ $post->ID ] = true;
		// End avoid recursion

		$editor = \Elementor\Plugin::$instance->editor;
		$is_edit_mode = $editor->is_edit_mode();
		
		$recent_posts = wp_get_recent_posts(array(
			'numberposts' => 1, 
			'post_status' => 'publish' 
		));
		$post_id = $post->ID;
		
		if(isset($recent_posts[0])){
			$post_id = $recent_posts[0]['ID'];
			$post = get_post( $post_id, OBJECT );
        	setup_postdata( $post );
		} 
		
		// Set edit mode as false, so don't render settings and etc. use the $is_edit_mode to indicate if we need the CSS inline
		$editor->set_edit_mode( false );
		$elementor_page = get_post_meta( $post_id , '_elementor_edit_mode', true );
		
		// Print manually (and don't use `the_content()`) because it's within another `the_content` filter, and the Elementor filter has been removed to avoid recursion.
		$content = $elementor_page ? \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $post_id, $with_css ) : get_the_content($post_id);
		
		if(isset($settings['enable_inline_style']) && $settings['enable_inline_style'] =='' && $elementor_page){
			//$content = preg_replace("/<((?:style)).*>.*<\/style>/si", ' ',$content);
		}
	
			// Restore edit mode state
		\Elementor\Plugin::$instance->editor->set_edit_mode( $is_edit_mode );
		
		echo $content; 		

		$level--;

		if ( 0 === $level ) {
			$did_posts = [];
		}
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'elementor-pro' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		

		$this->add_control(
			'text_color',
			[
				'label' => esc_html__( 'Text Color', 'elementor-pro' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}}' => 'color: {{VALUE}};',
				],
				'global' => [
					'default' => Global_Colors::COLOR_TEXT,
				],
				'condition' => [
					'enable_inline_style' => ['yes']
				]
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'typography',
				'global' => [
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				],
				'condition' => [
					'enable_inline_style' => ['yes']
				]
			]
		);
	
		$this->end_controls_section();
	}

	protected function render() {
		$elementor_page = get_post_meta( get_the_ID(), '_elementor_edit_mode', true );
	
	    ?>	   
	    
	    <?php
		// Post CSS should not be printed here because it overrides the already existing post CSS.
		if(\Elementor\Plugin::$instance->editor->is_edit_mode() || \Elementor\Plugin::$instance->preview->is_preview_mode() || (isset($_GET['preview_id']) && isset($_GET['preview_nonce']))) {
			$this->render_post_content( false, true );	
		}else{
		   // check post id is_elementor_editor Otherwise it will show p content
		   if ( $elementor_page ) {	
		         if( get_post_type() == 'post'){		           
					echo \Elementor\Plugin::instance()->frontend->get_builder_content( get_the_id() , true );
		         }   
				
		   }else{			       
				echo get_the_content( get_the_id() );				
		   }
		
		}
		?>
		
		<?php
	}

	public function render_plain_content() {}
}
