<?php

namespace AxtraEssentialApp\Widgets;

use Elementor\Controls_Manager;
use Elementor\Control_Media;
use Elementor\Utils;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Text_Stroke;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Group_Control_Image_Size;
use Elementor\Repeater;
use Elementor\Group_Control_Css_Filter;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;
use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) {
	exit;   // Exit if accessed directly.
}

class Blog_Post_Comment extends \Elementor\Widget_Base {

	public function get_name() {
		return 'wcf--blog--post--comment';
	}

	public function get_title() {
		return wcf_elementor_widget_concat_prefix( 'Post Comment' );
	}

	public function get_icon() {
		return 'wcf eicon-comments';
	}

	public function get_categories() {
		return [ 'wcf-blog-single' ];
	}

	public function get_keywords() {
		return [ 'comment', 'post comment' ];
	}

	public function get_style_depends() {
		return [ 'wcf--button' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'Content', 'axtra-essential' ),
			]
		);


		$this->end_controls_section();

		$this->start_controls_section(
			'element_ready_form_con_section',
			[
				'label' => esc_html__( 'Container', 'axtra-essential' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'comment__padding',
			[
				'label'      => esc_html__( 'Padding', 'axtra-essential' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .joya--blog-post-comment' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'  => 'before',
			]
		);
		$this->add_responsive_control(
			'comment_margin',
			[
				'label'      => esc_html__( 'Margin', 'axtra-essential' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .joya--blog-post-comment' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'  => 'before',
			]
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'element_ready_form_heading_section',
			[
				'label' => esc_html__( 'Common Text Color', 'axtra-essential' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'comment_ct_color',
			[
				'label'     => esc_html__( 'Comment Count', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .joya--comment .comment-num' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography:: get_type(),
			[
				'name'     => 'comment_count_typography',
				'selector' => '{{WRAPPER}} .joya--comment .comment-num',
			]
		);

		// Author Name
		$this->add_control(
			'author_ct_color',
			[
				'label'     => esc_html__( 'Author Count', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .default-details-comment-name' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography:: get_type(),
			[
				'name'     => 'cathor_count_typography',
				'selector' => '{{WRAPPER}} .default-details-comment-name',
			]
		);

		// Date Name
		$this->add_control(
			'meta_ct_color',
			[
				'label'     => esc_html__( 'Date Color', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .default-details-comment-date'      => 'color: {{VALUE}};',
					'{{WRAPPER}} .default-details-comment-date span' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography:: get_type(),
			[
				'name'     => 'cmeta_count_typography',
				'selector' => '{{WRAPPER}} .default-details-comment-date',
				'label'    => esc_html__( 'Date', 'axtra-essential' ),
			]
		);
		// Comment TExt
		$this->add_control(
			'c_text_color',
			[
				'label'     => esc_html__( 'Body Text', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .axtra-comment-text p' => 'color: {{VALUE}};',
					'{{WRAPPER}} .logged-in-as'        => 'color: {{VALUE}};',
					'{{WRAPPER}} .comment-reply-link'  => 'color: {{VALUE}};',
					'{{WRAPPER}} .comment-notes'       => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography:: get_type(),
			[
				'name'     => 'cmeta_ytext_typography',
				'label'    => esc_html__( 'Body Text', 'axtra-essential' ),
				'selector' => '{{WRAPPER}} .axtra-comment-text p,{{WRAPPER}} .logged-in-as',
			]
		);

		// link

		$this->add_control(
			'c_linkt_color',
			[
				'label'     => esc_html__( 'Link', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography:: get_type(),
			[
				'name'     => 'cmeta_linkt_typography',
				'label'    => esc_html__( 'Link Text', 'axtra-essential' ),
				'selector' => '{{WRAPPER}} a',
			]
		);

		$this->add_control(
			'c_repluiuy_color',
			[
				'label'     => esc_html__( 'Reply Heading', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .joya--comment #reply-title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'cmetaiui_reply_typography',
				'label'    => esc_html__( 'Reply Heading', 'axtra-essential' ),
				'selector' => '{{WRAPPER}} .joya--comment #reply-title',
			]
		);

		$this->add_control(
			'c_replbtn_color',
			[
				'label'     => esc_html__( 'Reply Icon Color', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .comment-reply-link' => 'fill: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

		/*----------------------------
		LABEL STYLE
	------------------------------*/
		$this->start_controls_section(
			'element_ready_form_label_style_section',
			[
				'label' => esc_html__( 'Label', 'axtra-essential' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'label_show',
			[
				'label' => esc_html__( 'Show/Hide', 'axtra-essential' ),
				'type' => Controls_Manager::SELECT,
				'default' => '',
				'options' => [
					'' => esc_html__( 'Default', 'axtra-essential' ),
					'none' => esc_html__( 'None', 'axtra-essential' ),
				],
				'selectors' => [
					'{{WRAPPER}} .comment-form label' => 'display: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography:: get_type(),
			[
				'name'     => 'label_typography',
				'selector' => '{{WRAPPER}} .joya--blog-post-comment label',
			]
		);
		$this->add_control(
			'label_text_color',
			[
				'label'     => esc_html__( 'Text Color', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .joya--blog-post-comment label' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background:: get_type(),
			[
				'name'     => 'label_background',
				'label'    => esc_html__( 'Background', 'axtra-essential' ),
				'types'    => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .joya--blog-post-comment label',
			]
		);
		$this->add_responsive_control(
			'label_width',
			[
				'label'      => esc_html__( 'Width', 'axtra-essential' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 1000,
						'step' => 1,
					],
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default'    => [
					'unit' => '%',
					'size' => 100
				],
				'selectors'  => [
					'{{WRAPPER}} .joya--blog-post-comment label' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Border:: get_type(),
			[
				'name'     => 'label_border',
				'label'    => esc_html__( 'Border', 'axtra-essential' ),
				'selector' => '{{WRAPPER}} .joya--blog-post-comment label',
			]
		);
		$this->add_responsive_control(
			'label_border_radius',
			[
				'label'     => esc_html__( 'Border Radius', 'axtra-essential' ),
				'type'      => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .joya--blog-post-comment label' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
				],
				'separator' => 'before',
			]
		);
		$this->add_responsive_control(
			'label_padding',
			[
				'label'      => esc_html__( 'Padding', 'axtra-essential' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .joya--blog-post-comment label' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'  => 'before',
			]
		);
		$this->add_responsive_control(
			'label_margin',
			[
				'label'      => esc_html__( 'Margin', 'axtra-essential' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .joya--blog-post-comment label' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'  => 'before',
			]
		);
		$this->end_controls_section();
		/*---------------------------
			LABEL STYLE END
		-----------------------------*/

		/*---------------------------
			INPUT STYLE START
		----------------------------*/
		$this->start_controls_section(
			'element_ready_form_input_style_section',
			[
				'label' => esc_html__( 'Input', 'axtra-essential' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs( 'input_box_tabs' );
		$this->start_controls_tab(
			'input_box_normal_tab',
			[
				'label' => esc_html__( 'Normal', 'axtra-essential' ),
			]
		);
		$this->add_group_control(
			Group_Control_Typography:: get_type(),
			[
				'name'     => 'input_box_typography',
				'selector' => '
                                {{WRAPPER}} .joya--blog-post-comment input[type*="text"],
                                {{WRAPPER}} .joya--blog-post-comment input[type*="email"],
                                {{WRAPPER}} .joya--blog-post-comment input[type*="url"],
                                {{WRAPPER}} .joya--blog-post-comment input[type*="number"],
                                {{WRAPPER}} .joya--blog-post-comment input[type*="tel"],
                                {{WRAPPER}} .joya--blog-post-comment input[type*="date"],
                                {{WRAPPER}} .joya--blog-post-comment input[type*="file"]
                            ',
			]
		);
		$this->add_control(
			'input_box_text_color',
			[
				'label'     => esc_html__( 'Text Color', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .joya--blog-post-comment input[type*="text"]'   => 'color:{{VALUE}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="email"]'  => 'color:{{VALUE}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="url"]'    => 'color:{{VALUE}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="number"]' => 'color:{{VALUE}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="tel"]'    => 'color:{{VALUE}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="date"]'   => 'color:{{VALUE}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="file"]'   => 'color:{{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background:: get_type(),
			[
				'name'     => 'input_box_background',
				'label'    => esc_html__( 'Background', 'axtra-essential' ),
				'types'    => [ 'classic', 'gradient' ],
				'selector' => '
                                {{WRAPPER}} .joya--blog-post-comment input[type*="text"],
                                {{WRAPPER}} .joya--blog-post-comment input[type*="email"],
                                {{WRAPPER}} .joya--blog-post-comment input[type*="url"],
                                {{WRAPPER}} .joya--blog-post-comment input[type*="number"],
                                {{WRAPPER}} .joya--blog-post-comment input[type*="tel"],
                                {{WRAPPER}} .joya--blog-post-comment input[type*="date"],
                                {{WRAPPER}} .joya--blog-post-comment input[type*="file"]
                            ',
			]
		);
		$this->add_control(
			'input_box_placeholder_color',
			[
				'label'     => esc_html__( 'Placeholder Color', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .joya--blog-post-comment input[type*="text"]::-webkit-input-placeholder'   => 'color: {{VALUE}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="text"]::-moz-placeholder'            => 'color: {{VALUE}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="text"]:-ms-input-placeholder'        => 'color: {{VALUE}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="email"]::-webkit-input-placeholder'  => 'color: {{VALUE}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="email"]::-moz-placeholder'           => 'color: {{VALUE}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="email"]:-ms-input-placeholder'       => 'color: {{VALUE}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="url"]::-webkit-input-placeholder'    => 'color: {{VALUE}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="url"]::-moz-placeholder'             => 'color: {{VALUE}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="url"]:-ms-input-placeholder'         => 'color: {{VALUE}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="number"]::-webkit-input-placeholder' => 'color: {{VALUE}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="number"]::-moz-placeholder'          => 'color: {{VALUE}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="number"]:-ms-input-placeholder'      => 'color: {{VALUE}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="tel"]::-webkit-input-placeholder'    => 'color: {{VALUE}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="tel"]::-moz-placeholder'             => 'color: {{VALUE}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="tel"]:-ms-input-placeholder'         => 'color: {{VALUE}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="date"]::-webkit-input-placeholder'   => 'color: {{VALUE}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="date"]::-moz-placeholder'            => 'color: {{VALUE}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="date"]:-ms-input-placeholder'        => 'color: {{VALUE}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="file"]'                              => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'input_box_height',
			[
				'label'      => esc_html__( 'Height', 'axtra-essential' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range'      => [
					'px' => [
						'max' => 150,
					],
				],
				'default'    => [
					'size' => 55,
				],
				'selectors'  => [
					'{{WRAPPER}} .joya--blog-post-comment input[type*="text"]'   => 'height:{{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="email"]'  => 'height:{{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="url"]'    => 'height:{{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="number"]' => 'height:{{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="tel"]'    => 'height:{{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="date"]'   => 'height:{{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="file"]'   => 'height:{{SIZE}}{{UNIT}};',
				],
				'separator'  => 'before',
			]
		);
		$this->add_responsive_control(
			'input_box_width',
			[
				'label'      => esc_html__( 'Width', 'axtra-essential' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 1000,
						'step' => 1,
					],
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default'    => [
					'unit' => '%',
					'size' => 100,
				],
				'selectors'  => [
					'{{WRAPPER}} .joya--blog-post-comment input[type*="text"]'   => 'width:{{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="email"]'  => 'width:{{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="url"]'    => 'width:{{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="number"]' => 'width:{{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="tel"]'    => 'width:{{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="date"]'   => 'width:{{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="file"]'   => 'width:{{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Border:: get_type(),
			[
				'name'      => 'input_box_border',
				'label'     => esc_html__( 'Border', 'axtra-essential' ),
				'selector'  => '
                                {{WRAPPER}} .joya--blog-post-comment input[type*="text"],
                                {{WRAPPER}} .joya--blog-post-comment input[type*="email"],
                                {{WRAPPER}} .joya--blog-post-comment input[type*="url"],
                                {{WRAPPER}} .joya--blog-post-comment input[type*="number"],
                                {{WRAPPER}} .joya--blog-post-comment input[type*="tel"],
                                {{WRAPPER}} .joya--blog-post-comment input[type*="date"],
                                {{WRAPPER}} .joya--blog-post-comment input[type*="file"]
                            ',
				'separator' => 'before',
			]
		);
		$this->add_responsive_control(
			'input_box_border_radius',
			[
				'label'     => esc_html__( 'Border Radius', 'axtra-essential' ),
				'type'      => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .joya--blog-post-comment input[type*="text"]'   => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="email"]'  => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="url"]'    => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="number"]' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="tel"]'    => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="date"]'   => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="file"]'   => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
				],
				'separator' => 'before',
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow:: get_type(),
			[
				'name'     => 'input_box_shadow',
				'selector' => '
                                {{WRAPPER}} .joya--blog-post-comment input[type*="text"],
                                {{WRAPPER}} .joya--blog-post-comment input[type*="email"],
                                {{WRAPPER}} .joya--blog-post-comment input[type*="url"],
                                {{WRAPPER}} .joya--blog-post-comment input[type*="number"],
                                {{WRAPPER}} .joya--blog-post-comment input[type*="tel"],
                                {{WRAPPER}} .joya--blog-post-comment input[type*="date"],
                                {{WRAPPER}} .joya--blog-post-comment input[type*="file"]
                            ',
			]
		);
		$this->add_responsive_control(
			'input_box_padding',
			[
				'label'      => esc_html__( 'Padding', 'axtra-essential' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .joya--blog-post-comment input[type*="text"]'   => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="email"]'  => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="url"]'    => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="number"]' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="tel"]'    => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="date"]'   => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="file"]'   => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'  => 'before',
			]
		);
		$this->add_responsive_control(
			'input_box_margin',
			[
				'label'      => esc_html__( 'Margin', 'axtra-essential' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .joya--blog-post-comment input[type*="text"]'   => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="email"]'  => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="url"]'    => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="number"]' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="tel"]'    => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="date"]'   => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="file"]'   => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'  => 'before',
			]
		);
		$this->add_control(
			'input_box_transition',
			[
				'label'      => esc_html__( 'Transition', 'axtra-essential' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0.1,
						'max'  => 3,
						'step' => 0.1,
					],
				],
				'default'    => [
					'unit' => 'px',
					'size' => 0.3,
				],
				'selectors'  => [
					'{{WRAPPER}} .joya--blog-post-comment input[type*="text"]'   => 'transition: {{SIZE}}s;',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="email"]'  => 'transition: {{SIZE}}s;',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="url"]'    => 'transition: {{SIZE}}s;',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="number"]' => 'transition: {{SIZE}}s;',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="tel"]'    => 'transition: {{SIZE}}s;',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="date"]'   => 'transition: {{SIZE}}s;',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="file"]'   => 'transition: {{SIZE}}s;',
				],
			]
		);
		$this->end_controls_tab();
		$this->start_controls_tab(
			'input_box_hover_tabs',
			[
				'label' => esc_html__( 'Focus', 'axtra-essential' ),
			]
		);
		$this->add_control(
			'input_box_hover_color',
			[
				'label'     => esc_html__( 'Text Color', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .joya--blog-post-comment input[type*="text"]:focus'   => 'color:{{VALUE}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="email"]:focus'  => 'color:{{VALUE}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="url"]:focus'    => 'color:{{VALUE}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="number"]:focus' => 'color:{{VALUE}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="tel"]:focus'    => 'color:{{VALUE}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="date"]:focus'   => 'color:{{VALUE}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="file"]:focus'   => 'color:{{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background:: get_type(),
			[
				'name'     => 'input_box_hover_backkground',
				'label'    => esc_html__( 'Focus Background', 'axtra-essential' ),
				'types'    => [ 'classic', 'gradient' ],
				'selector' => '
                            {{WRAPPER}} .joya--blog-post-comment input[type*="text"]  : focus,
                            {{WRAPPER}} .joya--blog-post-comment input[type*="email"] : focus,
                            {{WRAPPER}} .joya--blog-post-comment input[type*="url"]   : focus,
                            {{WRAPPER}} .joya--blog-post-comment input[type*="number"]: focus,
                            {{WRAPPER}} .joya--blog-post-comment input[type*="tel"]   : focus,
                            {{WRAPPER}} .joya--blog-post-comment input[type*="date"]  : focus,
                            {{WRAPPER}} .joya--blog-post-comment input[type*="file"]  : focus
                        ',
			]
		);
		$this->add_control(
			'input_box_hover_border_color',
			[
				'label'     => esc_html__( 'Border Color', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .joya--blog-post-comment input[type*="text"]:focus'   => 'border-color:{{VALUE}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="email"]:focus'  => 'border-color:{{VALUE}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="url"]:focus'    => 'border-color:{{VALUE}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="number"]:focus' => 'border-color:{{VALUE}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="tel"]:focus'    => 'border-color:{{VALUE}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="date"]:focus'   => 'border-color:{{VALUE}};',
					'{{WRAPPER}} .joya--blog-post-comment input[type*="file"]:focus'   => 'border-color:{{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow:: get_type(),
			[
				'name'     => 'input_box_hover_shadow',
				'selector' => '
                            {{WRAPPER}} .joya--blog-post-comment input[type*="text"]  : focus,
                            {{WRAPPER}} .joya--blog-post-comment input[type*="email"] : focus,
                            {{WRAPPER}} .joya--blog-post-comment input[type*="url"]   : focus,
                            {{WRAPPER}} .joya--blog-post-comment input[type*="number"]: focus,
                            {{WRAPPER}} .joya--blog-post-comment input[type*="tel"]   : focus,
                            {{WRAPPER}} .joya--blog-post-comment input[type*="date"]  : focus,
                            {{WRAPPER}} .joya--blog-post-comment input[type*="file"]  : focus
                        ',
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
		/*-----------------------------
			INPUT STYLE END
		-------------------------------*/

		/*---------------------------
			INPUT CHECKBOX / RADIO STYLE
		----------------------------*/
		$this->start_controls_section(
			'element_ready_form_input_readio_style_section',
			[
				'label' => esc_html__( 'Input Radio / Checkbox', 'axtra-essential' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs( 'input_radio_checkbox_tabs' );
		$this->start_controls_tab(
			'input_radio_checkbox_normal_tab',
			[
				'label' => esc_html__( 'Normal', 'axtra-essential' ),
			]
		);

		$this->add_responsive_control(
			'input_radio_checkbox__display',
			[
				'label'   => esc_html__( 'Display', 'axtra-essential' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'inline-block',

				'options'   => [
					'initial'      => esc_html__( 'Initial', 'axtra-essential' ),
					'block'        => esc_html__( 'Block', 'axtra-essential' ),
					'inline-block' => esc_html__( 'Inline Block', 'axtra-essential' ),
					'flex'         => esc_html__( 'Flex', 'axtra-essential' ),
					'inline-flex'  => esc_html__( 'Inline Flex', 'axtra-essential' ),
					'none'         => esc_html__( 'none', 'axtra-essential' ),
				],
				'selectors' => [
					'{{WRAPPER}} .joya--blog-post-comment span.wpcf7-list-item' => 'display: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography:: get_type(),
			[
				'name'     => 'input_radio_checkbox_typography',
				'selector' => '
                                {{WRAPPER}} .joya--blog-post-comment span.wpcf7-list-item,
                                {{WRAPPER}} .joya--blog-post-comment span.wpcf7-list-item label
                            ',
			]
		);
		$this->add_control(
			'input_radio_checkbox_text_color',
			[
				'label'     => esc_html__( 'Text Color', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .joya--blog-post-comment span.wpcf7-list-item' => 'color:{{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background:: get_type(),
			[
				'name'     => 'input_radio_checkbox_background',
				'label'    => esc_html__( 'Background', 'axtra-essential' ),
				'types'    => [ 'classic', 'gradient' ],
				'selector' => '
                                {{WRAPPER}} .joya--blog-post-comment span.wpcf7-list-item
                            ',
			]
		);
		$this->add_responsive_control(
			'input_radio_checkbox_height',
			[
				'label'      => esc_html__( 'Height', 'axtra-essential' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range'      => [
					'px' => [
						'max' => 150,
					],
				],
				'default'    => [
				],
				'selectors'  => [
					'{{WRAPPER}} .joya--blog-post-comment span.wpcf7-list-item' => 'height:{{SIZE}}{{UNIT}};',
				],
				'separator'  => 'before',
			]
		);
		$this->add_responsive_control(
			'input_radio_checkbox_width',
			[
				'label'      => esc_html__( 'Width', 'axtra-essential' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 1000,
						'step' => 1,
					],
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default'    => [
					'unit' => '%',
				],
				'selectors'  => [
					'{{WRAPPER}} .joya--blog-post-comment span.wpcf7-list-item' => 'width:{{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Border:: get_type(),
			[
				'name'      => 'input_radio_checkbox_border',
				'label'     => esc_html__( 'Border', 'axtra-essential' ),
				'selector'  => '
                                {{WRAPPER}} .joya--blog-post-comment span.wpcf7-list-item
                            ',
				'separator' => 'before',
			]
		);
		$this->add_responsive_control(
			'input_radio_checkbox_border_radius',
			[
				'label'     => esc_html__( 'Border Radius', 'axtra-essential' ),
				'type'      => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .joya--blog-post-comment span.wpcf7-list-item' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
				],
				'separator' => 'before',
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow:: get_type(),
			[
				'name'     => 'input_radio_checkbox_shadow',
				'selector' => '
                                {{WRAPPER}} .joya--blog-post-comment span.wpcf7-list-item
                            ',
			]
		);
		$this->add_responsive_control(
			'input_radio_checkbox_padding',
			[
				'label'      => esc_html__( 'Padding', 'axtra-essential' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .joya--blog-post-comment span.wpcf7-list-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'  => 'before',
			]
		);
		$this->add_responsive_control(
			'input_radio_checkbox_margin',
			[
				'label'      => esc_html__( 'Margin', 'axtra-essential' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .joya--blog-post-comment span.wpcf7-list-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'  => 'before',
			]
		);
		$this->add_control(
			'input_radio_checkbox_transition',
			[
				'label'      => esc_html__( 'Transition', 'axtra-essential' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0.1,
						'max'  => 3,
						'step' => 0.1,
					],
				],
				'default'    => [
					'unit' => 'px',
					'size' => 0.3,
				],
				'selectors'  => [
					'{{WRAPPER}} .joya--blog-post-comment span.wpcf7-list-item' => 'transition: {{SIZE}}s;',
				],
			]
		);
		$this->end_controls_tab();
		$this->start_controls_tab(
			'input_radio_checkbox_hover_tabs',
			[
				'label' => esc_html__( 'Focus', 'axtra-essential' ),
			]
		);
		$this->add_control(
			'input_radio_checkbox_hover_color',
			[
				'label'     => esc_html__( 'Text Color', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .joya--blog-post-comment span.wpcf7-list-item:focus' => 'color:{{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background:: get_type(),
			[
				'name'     => 'input_radio_checkbox_hover_backkground',
				'label'    => esc_html__( 'Focus Background', 'axtra-essential' ),
				'types'    => [ 'classic', 'gradient' ],
				'selector' => '
                            {{WRAPPER}} .joya--blog-post-comment span.wpcf7-list-item: focus
                        ',
			]
		);
		$this->add_control(
			'input_radio_checkbox_hover_border_color',
			[
				'label'     => esc_html__( 'Border Color', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .joya--blog-post-comment span.wpcf7-list-item:focus' => 'border-color:{{VALUE}};'
				],
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow:: get_type(),
			[
				'name'     => 'input_radio_checkbox_hover_shadow',
				'selector' => '
                            {{WRAPPER}} .joya--blog-post-comment span.wpcf7-list-item: focus
                        ',
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
		/*-----------------------------
			INPUT CHECKBOX / RADIO STYLE  END
		-------------------------------*/

		/*---------------------------
			SELECT BOX STYLE START
		----------------------------*/
		$this->start_controls_section(
			'element_ready_form_select_style_section',
			[
				'label' => esc_html__( 'Select', 'axtra-essential' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs( 'select_box_tabs' );
		$this->start_controls_tab(
			'select_box_normal_tab',
			[
				'label' => esc_html__( 'Normal', 'axtra-essential' ),
			]
		);
		$this->add_group_control(
			Group_Control_Typography:: get_type(),
			[
				'name'     => 'select_box_typography',
				'selector' => '
                                {{WRAPPER}} .joya--blog-post-comment select
                            ',
			]
		);
		$this->add_control(
			'select_box_text_color',
			[
				'label'     => esc_html__( 'Text Color', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .joya--blog-post-comment select' => 'color:{{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background:: get_type(),
			[
				'name'     => 'select_box_background',
				'label'    => esc_html__( 'Background', 'axtra-essential' ),
				'types'    => [ 'classic', 'gradient' ],
				'selector' => '
                                {{WRAPPER}} .joya--blog-post-comment select
                            ',
			]
		);
		$this->add_control(
			'select_box_placeholder_color',
			[
				'label'     => esc_html__( 'Placeholder Color', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .joya--blog-post-comment select' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'select_box_height',
			[
				'label'      => esc_html__( 'Height', 'axtra-essential' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range'      => [
					'px' => [
						'max' => 150,
					],
				],
				'default'    => [
					'size' => 55,
				],
				'selectors'  => [
					'{{WRAPPER}} .joya--blog-post-comment select' => 'height:{{SIZE}}{{UNIT}};',
				],
				'separator'  => 'before',
			]
		);
		$this->add_responsive_control(
			'select_box_width',
			[
				'label'      => esc_html__( 'Width', 'axtra-essential' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 1000,
						'step' => 1,
					],
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default'    => [
					'unit' => '%',
					'size' => 100,
				],
				'selectors'  => [
					'{{WRAPPER}} .joya--blog-post-comment select' => 'width:{{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Border:: get_type(),
			[
				'name'      => 'select_box_border',
				'label'     => esc_html__( 'Border', 'axtra-essential' ),
				'selector'  => '
                                {{WRAPPER}} .joya--blog-post-comment select
                            ',
				'separator' => 'before',
			]
		);
		$this->add_responsive_control(
			'select_box_border_radius',
			[
				'label'     => esc_html__( 'Border Radius', 'axtra-essential' ),
				'type'      => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .joya--blog-post-comment select' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
				],
				'separator' => 'before',
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow:: get_type(),
			[
				'name'     => 'select_box_shadow',
				'selector' => '
                                {{WRAPPER}} .joya--blog-post-comment select
                            ',
			]
		);
		$this->add_responsive_control(
			'select_box_padding',
			[
				'label'      => esc_html__( 'Padding', 'axtra-essential' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .joya--blog-post-comment select' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'  => 'before',
			]
		);
		$this->add_responsive_control(
			'select_box_margin',
			[
				'label'      => esc_html__( 'Margin', 'axtra-essential' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .joya--blog-post-comment select' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'  => 'before',
			]
		);
		$this->add_control(
			'select_box_transition',
			[
				'label'      => esc_html__( 'Transition', 'axtra-essential' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0.1,
						'max'  => 3,
						'step' => 0.1,
					],
				],
				'default'    => [
					'unit' => 'px',
					'size' => 0.3,
				],
				'selectors'  => [
					'{{WRAPPER}} .joya--blog-post-comment select' => 'transition: {{SIZE}}s;',
				],
			]
		);
		$this->end_controls_tab();
		$this->start_controls_tab(
			'select_box_hover_tabs',
			[
				'label' => esc_html__( 'Focus', 'axtra-essential' ),
			]
		);
		$this->add_control(
			'select_box_hover_color',
			[
				'label'     => esc_html__( 'Text Color', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .joya--blog-post-comment select:focus' => 'color:{{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background:: get_type(),
			[
				'name'     => 'select_box_hover_backkground',
				'label'    => esc_html__( 'Focus Background', 'axtra-essential' ),
				'types'    => [ 'classic', 'gradient' ],
				'selector' => '
                            {{WRAPPER}} .joya--blog-post-comment select: focus
                        ',
			]
		);
		$this->add_control(
			'select_box_hover_border_color',
			[
				'label'     => esc_html__( 'Border Color', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .joya--blog-post-comment select:focus' => 'border-color:{{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow:: get_type(),
			[
				'name'     => 'select_box_hover_shadow',
				'selector' => '
                            {{WRAPPER}} .joya--blog-post-comment select: focus
                        ',
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
		/*-----------------------------
			SELECT BOX STYLE END
		-------------------------------*/

		/*-----------------------------
			TEXTAREA STYLE
		-----------------------------*/
		$this->start_controls_section(
			'element_ready_form_textarea_style_section',
			[
				'label' => esc_html__( 'Textarea', 'axtra-essential' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs( 'textarea_box_tabs' );
		$this->start_controls_tab(
			'textarea_box_normal_tab',
			[
				'label' => esc_html__( 'Normal', 'axtra-essential' ),
			]
		);
		$this->add_responsive_control(
			'textarea_box_height',
			[
				'label'      => esc_html__( 'Height', 'axtra-essential' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'max' => 500,
					],
				],
				'default'    => [
					'size' => 150,
				],

				'selectors' => [
					'{{WRAPPER}} .joya--blog-post-comment textarea' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'textarea_expand_height',
			[
				'label'      => esc_html__( 'Expanded Height', 'axtra-essential' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'max' => 500,
					],
				],
				'default'    => [
					'size' => 150,
				],
				'selectors' => [
					'{{WRAPPER}} .joya--blog-post-comment textarea:focus' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'textarea_box_width',
			[
				'label'      => esc_html__( 'Width', 'axtra-essential' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range'      => [
					'px' => [
						'max' => 500,
					],
					'%'  => [
						'max' => 100,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .joya--blog-post-comment textarea' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography:: get_type(),
			[
				'name'     => 'textarea_box_typography',
				'selector' => '{{WRAPPER}} .joya--blog-post-comment textarea',
			]
		);
		$this->add_control(
			'textarea_box_text_color',
			[
				'label'     => esc_html__( 'Text Color', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .joya--blog-post-comment textarea' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'textarea_box_placeholder_color',
			[
				'label'     => esc_html__( 'Placeholder Color', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .joya--blog-post-comment textarea::-webkit-input-placeholder' => 'color: {{VALUE}};',
					'{{WRAPPER}} .joya--blog-post-comment textarea::-moz-placeholder'          => 'color: {{VALUE}};',
					'{{WRAPPER}} .joya--blog-post-comment textarea:-ms-input-placeholder'      => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background:: get_type(),
			[
				'name'     => 'textarea_box_background',
				'label'    => esc_html__( 'Background', 'axtra-essential' ),
				'types'    => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .joya--blog-post-comment textarea',
			]
		);
		$this->add_group_control(
			Group_Control_Border:: get_type(),
			[
				'name'     => 'textarea_box_border',
				'label'    => esc_html__( 'Border', 'axtra-essential' ),
				'selector' => '{{WRAPPER}} .joya--blog-post-comment textarea',
			]
		);
		$this->add_responsive_control(
			'textarea_box_border_radius',
			[
				'label'     => esc_html__( 'Border Radius', 'axtra-essential' ),
				'type'      => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .joya--blog-post-comment textarea' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
				],
				'separator' => 'before',
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow:: get_type(),
			[
				'name'     => 'textarea_box_shadow',
				'selector' => '{{WRAPPER}} .joya--blog-post-comment textarea',
			]
		);
		$this->add_responsive_control(
			'textarea_box_padding',
			[
				'label'      => esc_html__( 'Padding', 'axtra-essential' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .joya--blog-post-comment textarea' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'  => 'before',
			]
		);
		$this->add_responsive_control(
			'textarea_box_margin',
			[
				'label'      => esc_html__( 'Margin', 'axtra-essential' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .joya--blog-post-comment textarea' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'  => 'before',
			]
		);
		$this->add_control(
			'textarea_box_transition',
			[
				'label'      => esc_html__( 'Transition', 'axtra-essential' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0.1,
						'max'  => 3,
						'step' => 0.1,
					],
				],
				'default'    => [
					'unit' => 'px',
					'size' => 0.3,
				],
				'selectors'  => [
					'{{WRAPPER}} .joya--blog-post-comment textarea' => 'transition: {{SIZE}}s;',
				],
			]
		);
		$this->end_controls_tab();
		$this->start_controls_tab(
			'textarea_box_hover_tabs',
			[
				'label' => esc_html__( 'Focus', 'axtra-essential' ),
			]
		);
		$this->add_control(
			'textarea_box_hover_color',
			[
				'label'     => esc_html__( 'Text Color', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .joya--blog-post-comment textarea:focus' => 'color:{{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background:: get_type(),
			[
				'name'     => 'textarea_box_hover_backkground',
				'label'    => esc_html__( 'Focus Background', 'axtra-essential' ),
				'types'    => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .joya--blog-post-comment textarea:focus',
			]
		);
		$this->add_control(
			'textarea_box_hover_border_color',
			[
				'label'     => esc_html__( 'Border Color', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .joya--blog-post-comment textarea:focus' => 'border-color:{{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow:: get_type(),
			[
				'name'     => 'textarea_box_hover_shadow',
				'selector' => '{{WRAPPER}} .joya--blog-post-comment textarea:focus',
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
		/*----------------------------
			TEXTAREA STYLE END
		-----------------------------*/

		/*----------------------------
			BUTTONS TYLE
		------------------------------*/
		$this->start_controls_section(
			'element_ready_input_submit_style_section',
			[
				'label' => esc_html__( 'Button', 'axtra-essential' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs( 'submit_style_tabs' );
		$this->start_controls_tab(
			'submit_style_normal_tab',
			[
				'label' => esc_html__( 'Normal', 'axtra-essential' ),
			]
		);

		$this->add_group_control(
			Group_Control_Typography:: get_type(),
			[
				'name'     => 'input_submit_typography',
				'selector' => '{{WRAPPER}} .joya--blog-post-comment input[type*="submit"],{{WRAPPER}} .joya--blog-post-comment button[type="submit"]',
			]
		);

		$this->add_control(
			'input_submit_text_color',
			[
				'label'     => esc_html__( 'Text Color', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .joya--blog-post-comment input[type*="submit"],{{WRAPPER}} .joya--blog-post-comment button[type="submit"]' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background:: get_type(),
			[
				'name'     => 'input_submit_background_color',
				'label'    => esc_html__( 'Background', 'axtra-essential' ),
				'types'    => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .joya--blog-post-comment input[type*="submit"],{{WRAPPER}} .joya--blog-post-comment button[type="submit"]',
			]
		);

		$this->add_responsive_control(
			'input_submit_width',
			[
				'label'      => esc_html__( 'Width', 'axtra-essential' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 1000,
						'step' => 1,
					],
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default'    => [
					'unit' => 'px',
					'size' => 200,
				],
				'selectors'  => [
					'{{WRAPPER}} .joya--blog-post-comment input[type*="submit"],{{WRAPPER}} .joya--blog-post-comment button[type="submit"]' => 'width:{{SIZE}}{{UNIT}};',
				],
				'separator'  => 'before',
			]
		);
		$this->add_responsive_control(
			'input_submit_height',
			[
				'label'      => esc_html__( 'Height', 'axtra-essential' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'max' => 150,
					],
				],
				'default'    => [
					'size' => 55,
				],
				'selectors'  => [
					'{{WRAPPER}} .joya--blog-post-comment input[type*="submit"],{{WRAPPER}} .joya--blog-post-comment button[type="submit"]' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Border:: get_type(),
			[
				'name'      => 'input_submit_border',
				'label'     => esc_html__( 'Border', 'axtra-essential' ),
				'selector'  => '{{WRAPPER}} .joya--blog-post-comment input[type*="submit"],{{WRAPPER}} .joya--blog-post-comment button[type="submit"]',
				'separator' => 'before',
			]
		);
		$this->add_responsive_control(
			'input_submit_border_radius',
			[
				'label'     => esc_html__( 'Border Radius', 'axtra-essential' ),
				'type'      => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} button[type="submit"]' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',
				],
				'separator' => 'before',
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow:: get_type(),
			[
				'name'     => 'input_submit_box_shadow',
				'label'    => esc_html__( 'Box Shadow', 'axtra-essential' ),
				'selector' => '{{WRAPPER}} button[type="submit"]',
			]
		);
		$this->add_responsive_control(
			'input_submit_padding',
			[
				'label'      => esc_html__( 'Padding', 'axtra-essential' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} button[type="submit"]' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'  => 'before',
			]
		);
		$this->add_responsive_control(
			'input_submit_margin',
			[
				'label'      => esc_html__( 'Margin', 'axtra-essential' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} button[type="submit"]' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .default-details__cmtbtn' => 'margin: 0;',
				],
				'separator'  => 'before',
			]
		);
		$this->add_control(
			'input_submit_transition',
			[
				'label'      => esc_html__( 'Transition', 'axtra-essential' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min'  => 0.1,
						'max'  => 3,
						'step' => 0.1,
					],
				],
				'default'    => [
					'unit' => 'px',
					'size' => 0.3,
				],
				'selectors'  => [
					'{{WRAPPER}} button[type="submit"]' => 'transition: {{SIZE}}s;',
				],
			]
		);
		$this->add_responsive_control(
			'input_submit_floting',
			[
				'label'     => esc_html__( 'Button Floating', 'axtra-essential' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => [
					'float:left'                                       => [
						'title' => esc_html__( 'Left', 'axtra-essential' ),
						'icon'  => 'eicon-h-align-left',
					],
					'display:block;margin-left:auto;margin-right:auto' => [
						'title' => esc_html__( 'None', 'axtra-essential' ),
						'icon'  => 'eicon-v-align-top',
					],
					'float:right'                                      => [
						'title' => esc_html__( 'Right', 'axtra-essential' ),
						'icon'  => 'eicon-h-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}} button[type="submit"]' => '{{VALUE}};',
				],
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'input_submit_text_align',
			[
				'label'     => esc_html__( 'Text Align', 'axtra-essential' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => [
					'left'   => [
						'title' => esc_html__( 'Left', 'axtra-essential' ),
						'icon'  => 'eicon-flex eicon-align-start-h',
					],
					'center' => [
						'title' => esc_html__( 'None', 'axtra-essential' ),
						'icon'  => 'eicon-flex eicon-align-center-h',
					],
					'right'  => [
						'title' => esc_html__( 'Right', 'axtra-essential' ),
						'icon'  => 'eicon-flex eicon-align-end-h',
					],
				],
				'selectors' => [
					'{{WRAPPER}} .default-details__cmtbtn' => 'text-align: {{VALUE}};',
				],
				'separator' => 'before',
			]
		);

		$this->end_controls_tab();
		$this->start_controls_tab(
			'submit_style_hover_tab',
			[
				'label' => esc_html__( 'Hover', 'axtra-essential' ),
			]
		);
		$this->add_control(
			'input_submithover_text_color',
			[
				'label'     => esc_html__( 'Text Color', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} button[type="submit"]:hover' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background:: get_type(),
			[
				'name'     => 'input_submithover_background_color',
				'label'    => esc_html__( 'Background', 'axtra-essential' ),
				'types'    => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} button[type="submit"]:hover',
			]
		);
		$this->add_group_control(
			Group_Control_Border:: get_type(),
			[
				'name'     => 'input_submithover_border',
				'label'    => esc_html__( 'Border', 'axtra-essential' ),
				'selector' => '{{WRAPPER}} button[type="submit"]:hover',
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow:: get_type(),
			[
				'name'     => 'input_submithover_shadow',
				'label'    => esc_html__( 'Box Shadow', 'axtra-essential' ),
				'selector' => '{{WRAPPER}} button[type="submit"]:hover',
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
		/*----------------------------
			BUTTONS TYLE END
		------------------------------*/
	}

	protected function render() {

		$settings  = $this->get_settings_for_display();
		$post_id   = get_the_id();
		$is_editor = \Elementor\Plugin::$instance->editor->is_edit_mode() || \Elementor\Plugin::$instance->preview->is_preview_mode() || ( isset( $_GET['preview_id'] ) && isset( $_GET['preview_nonce'] ) );
		if ( $is_editor ) {

			$recent_posts = wp_get_recent_posts( array(
				'numberposts' => 1,
				'post_status' => 'publish'
			) );

			if ( isset( $recent_posts[0] ) ) {
				$post_id = $recent_posts[0]['ID'];

				global $post;
				$post = get_post( $post_id, OBJECT );
				setup_postdata( $post );
			}

		}

		comments_template();
		if ( $is_editor ) {
			wp_reset_postdata();
		}
		?>

		<?php
	}
}