<?php if ( ! defined( 'ABSPATH' ) ) {
	die( 'Forbidden' );
}

require dirname( __FILE__ ) . '/wordpress-importer/wordpress-importer.php';
require dirname( __FILE__ ) . '/wp-import.class.php';

// OneClick Demo Importer

add_filter( 'wcfio/import_files', 'axtra_import_files' );
function axtra_import_files() {
	return array(

		array(
			'import_file_name'         => esc_html__( 'Digital Market', 'axtra-essential' ),
			'import_file_url'          => 'https://themecrowdy.com/demo-content/axtra/digital-market/contents.xml',
			'import_widget_file_url'   => 'https://themecrowdy.com/demo-content/axtra/digital-market/widgets.wie',
			'import_preview_image_url' => 'https://themecrowdy.com/demo-content/axtra/digital-market/sc.jpg',
			'import_notice'            => 'Digital Market',
			'preview_url'              => 'https://crowdytheme.com/wp/axtra',
			'import_theme_settings'    => [
				[
					'option_content' => '',
					'file_url'       => 'https://themecrowdy.com/demo-content/axtra/digital-market/axtra_settings.xml',
					'option_name'    => 'axtra_settings',
				],
				[
					'option_content' => '',
					'file_url'       => 'https://themecrowdy.com/demo-content/axtra/digital-market/wcf_save_widgets.xml',
					'option_name'    => 'wcf_save_widgets',
				],
				[
					'option_content' => '',
					'file_url'       => 'https://themecrowdy.com/demo-content/axtra/digital-market/wcf_save_extensions.xml',
					'option_name'    => 'wcf_save_extensions',
				],
				[
					'option_content'  => '',
					'option_kit_name' => 'elementor_active_kit',
					'file_url'        => 'https://themecrowdy.com/demo-content/axtra/digital-market/site-settings.json',
					'option_name'     => '_elementor_page_settings',
				],
			],
		),

		array(
			'import_file_name'         => esc_html__( 'Design Studio', 'axtra-essential' ),
			'import_file_url'          => 'https://themecrowdy.com/demo-content/axtra/design-studio/contents.xml',
			'import_widget_file_url'   => 'https://themecrowdy.com/demo-content/axtra/design-studio/widgets.wie',
			'import_preview_image_url' => 'https://themecrowdy.com/demo-content/axtra/design-studio/sc.jpg',
			'import_notice'            => 'Design Studio',
			'preview_url'              => 'https://crowdytheme.com/wp/axtra/design-studio',
			'import_theme_settings'    => [
				[
					'option_content' => '',
					'file_url'       => 'https://themecrowdy.com/demo-content/axtra/design-studio/axtra_settings.xml',
					'option_name'    => 'axtra_settings',
				],
				[
					'option_content' => '',
					'file_url'       => 'https://themecrowdy.com/demo-content/axtra/design-studio/wcf_save_widgets.xml',
					'option_name'    => 'wcf_save_widgets',
				],
				[
					'option_content' => '',
					'file_url'       => 'https://themecrowdy.com/demo-content/axtra/design-studio/wcf_save_extensions.xml',
					'option_name'    => 'wcf_save_extensions',
				],
				[
					'option_content'  => '',
					'option_kit_name' => 'elementor_active_kit',
					'file_url'        => 'https://themecrowdy.com/demo-content/axtra/design-studio/site-settings.json',
					'option_name'     => '_elementor_page_settings',
				],
			],
		),

		array(
			'import_file_name'         => esc_html__( 'Digital Agency', 'axtra-essential' ),
			'import_file_url'          => 'https://themecrowdy.com/demo-content/axtra/digital-agency/contents.xml',
			'import_widget_file_url'   => 'https://themecrowdy.com/demo-content/axtra/digital-agency/widgets.wie',
			'import_preview_image_url' => 'https://themecrowdy.com/demo-content/axtra/digital-agency/sc.jpg',
			'import_notice'            => 'Digital Agency',
			'preview_url'              => 'https://crowdytheme.com/wp/axtra/digital-agency/',
			'import_theme_settings'    => [
				[
					'option_content' => '',
					'file_url'       => 'https://themecrowdy.com/demo-content/axtra/digital-agency/axtra_settings.xml',
					'option_name'    => 'axtra_settings',
				],
				[
					'option_content' => '',
					'file_url'       => 'https://themecrowdy.com/demo-content/axtra/digital-agency/wcf_save_widgets.xml',
					'option_name'    => 'wcf_save_widgets',
				],
				[
					'option_content' => '',
					'file_url'       => 'https://themecrowdy.com/demo-content/axtra/digital-agency/wcf_save_extensions.xml',
					'option_name'    => 'wcf_save_extensions',
				],
				[
					'option_content'  => '',
					'option_kit_name' => 'elementor_active_kit',
					'file_url'        => 'https://themecrowdy.com/demo-content/axtra/digital-agency/site-settings.json',
					'option_name'     => '_elementor_page_settings',
				],
			],
		),

		array(
			'import_file_name'         => esc_html__( 'Creative Agency', 'axtra-essential' ),
			'import_file_url'          => 'https://themecrowdy.com/demo-content/axtra/creative-agency/contents.xml',
			'import_widget_file_url'   => 'https://themecrowdy.com/demo-content/axtra/creative-agency/widgets.wie',
			'import_preview_image_url' => 'https://themecrowdy.com/demo-content/axtra/creative-agency/sc.jpg',
			'import_notice'            => 'Creative Agency',
			'preview_url'              => 'https://crowdytheme.com/wp/axtra/creative-agency/',
			'import_theme_settings'    => [
				[
					'option_content' => '',
					'file_url'       => 'https://themecrowdy.com/demo-content/axtra/creative-agency/axtra_settings.xml',
					'option_name'    => 'axtra_settings',
				],
				[
					'option_content' => '',
					'file_url'       => 'https://themecrowdy.com/demo-content/axtra/creative-agency/wcf_save_widgets.xml',
					'option_name'    => 'wcf_save_widgets',
				],
				[
					'option_content' => '',
					'file_url'       => 'https://themecrowdy.com/demo-content/axtra/creative-agency/wcf_save_extensions.xml',
					'option_name'    => 'wcf_save_extensions',
				],
				[
					'option_content'  => '',
					'option_kit_name' => 'elementor_active_kit',
					'file_url'        => 'https://themecrowdy.com/demo-content/axtra/creative-agency/site-settings.json',
					'option_name'     => '_elementor_page_settings',
				],
			],
		),

		array(
			'import_file_name'         => esc_html__( 'Modern Agency', 'axtra-essential' ),
			'import_file_url'          => 'https://themecrowdy.com/demo-content/axtra/modern-agency/contents.xml',
			'import_widget_file_url'   => 'https://themecrowdy.com/demo-content/axtra/modern-agency/widgets.wie',
			'import_preview_image_url' => 'https://themecrowdy.com/demo-content/axtra/modern-agency/sc.jpg',
			'import_notice'            => 'Modern Agency',
			'preview_url'              => 'https://crowdytheme.com/wp/axtra/modern-agency/',
			'import_theme_settings'    => [
				[
					'option_content' => '',
					'file_url'       => 'https://themecrowdy.com/demo-content/axtra/modern-agency/axtra_settings.xml',
					'option_name'    => 'axtra_settings',
				],
				[
					'option_content' => '',
					'file_url'       => 'https://themecrowdy.com/demo-content/axtra/modern-agency/wcf_save_widgets.xml',
					'option_name'    => 'wcf_save_widgets',
				],
				[
					'option_content' => '',
					'file_url'       => 'https://themecrowdy.com/demo-content/axtra/modern-agency/wcf_save_extensions.xml',
					'option_name'    => 'wcf_save_extensions',
				],
				[
					'option_content'  => '',
					'option_kit_name' => 'elementor_active_kit',
					'file_url'        => 'https://themecrowdy.com/demo-content/axtra/modern-agency/site-settings.json',
					'option_name'     => '_elementor_page_settings',
				],
			],
		),

		array(
			'import_file_name'         => esc_html__( 'Startup Agency', 'axtra-essential' ),
			'import_file_url'          => 'https://themecrowdy.com/demo-content/axtra/startup-agency/contents.xml',
			'import_widget_file_url'   => 'https://themecrowdy.com/demo-content/axtra/startup-agency/widgets.wie',
			'import_preview_image_url' => 'https://themecrowdy.com/demo-content/axtra/startup-agency/sc.jpg',
			'import_notice'            => 'Startup Agency',
			'preview_url'              => 'https://crowdytheme.com/wp/axtra/startup-agency/',
			'import_theme_settings'    => [
				[
					'option_content' => '',
					'file_url'       => 'https://themecrowdy.com/demo-content/axtra/startup-agency/axtra_settings.xml',
					'option_name'    => 'axtra_settings',
				],
				[
					'option_content' => '',
					'file_url'       => 'https://themecrowdy.com/demo-content/axtra/startup-agency/wcf_save_widgets.xml',
					'option_name'    => 'wcf_save_widgets',
				],
				[
					'option_content' => '',
					'file_url'       => 'https://themecrowdy.com/demo-content/axtra/startup-agency/wcf_save_extensions.xml',
					'option_name'    => 'wcf_save_extensions',
				],
				[
					'option_content'  => '',
					'option_kit_name' => 'elementor_active_kit',
					'file_url'        => 'https://themecrowdy.com/demo-content/axtra/startup-agency/site-settings.json',
					'option_name'     => '_elementor_page_settings',
				],
			],
		),

		array(
			'import_file_name'         => esc_html__( 'Personal Portfolio', 'axtra-essential' ),
			'import_file_url'          => 'https://themecrowdy.com/demo-content/axtra/personal-portfolio/contents.xml',
			'import_widget_file_url'   => 'https://themecrowdy.com/demo-content/axtra/personal-portfolio/widgets.wie',
			'import_preview_image_url' => 'https://themecrowdy.com/demo-content/axtra/personal-portfolio/sc.jpg',
			'import_notice'            => 'Personal Portfolio',
			'preview_url'              => 'https://crowdytheme.com/wp/axtra/personal-portfolio/',
			'import_theme_settings'    => [
				[
					'option_content' => '',
					'file_url'       => 'https://themecrowdy.com/demo-content/axtra/personal-portfolio/axtra_settings.xml',
					'option_name'    => 'axtra_settings',
				],
				[
					'option_content' => '',
					'file_url'       => 'https://themecrowdy.com/demo-content/axtra/personal-portfolio/wcf_save_widgets.xml',
					'option_name'    => 'wcf_save_widgets',
				],
				[
					'option_content' => '',
					'file_url'       => 'https://themecrowdy.com/demo-content/axtra/personal-portfolio/wcf_save_extensions.xml',
					'option_name'    => 'wcf_save_extensions',
				],
				[
					'option_content'  => '',
					'option_kit_name' => 'elementor_active_kit',
					'file_url'        => 'https://themecrowdy.com/demo-content/axtra/personal-portfolio/site-settings.json',
					'option_name'     => '_elementor_page_settings',
				],
			],
		),

		array(
			'import_file_name'         => esc_html__( 'Creative portfolio', 'axtra-essential' ),
			'import_file_url'          => 'https://themecrowdy.com/demo-content/axtra/creative-portfolio/contents.xml',
			'import_widget_file_url'   => 'https://themecrowdy.com/demo-content/axtra/creative-portfolio/widgets.wie',
			'import_preview_image_url' => 'https://themecrowdy.com/demo-content/axtra/creative-portfolio/sc.jpg',
			'import_notice'            => 'Creative portfolio',
			'preview_url'              => 'https://crowdytheme.com/wp/axtra/creative-portfolio/',
			'import_theme_settings'    => [
				[
					'option_content' => '',
					'file_url'       => 'https://themecrowdy.com/demo-content/axtra/creative-portfolio/axtra_settings.xml',
					'option_name'    => 'axtra_settings',
				],
				[
					'option_content' => '',
					'file_url'       => 'https://themecrowdy.com/demo-content/axtra/creative-portfolio/wcf_save_widgets.xml',
					'option_name'    => 'wcf_save_widgets',
				],
				[
					'option_content' => '',
					'file_url'       => 'https://themecrowdy.com/demo-content/axtra/creative-portfolio/wcf_save_extensions.xml',
					'option_name'    => 'wcf_save_extensions',
				],
				[
					'option_content'  => '',
					'option_kit_name' => 'elementor_active_kit',
					'file_url'        => 'https://themecrowdy.com/demo-content/axtra/creative-portfolio/site-settings.json',
					'option_name'     => '_elementor_page_settings',
				],
			],
		),
	);
}

function builder_after_import_setup( $selected_import ) {

	$main_menu = get_term_by( 'name', 'Main', 'nav_menu' );
	if ( isset( $main_menu->term_id ) ) {
		set_theme_mod( 'nav_menu_locations', [
				'main-menu' => $main_menu->term_id,
				// replace 'main-menu' here with the menu location identifier from register_nav_menu() function in your theme.
			]
		);
	}


	// Get the front page.
	$front_page = get_posts(
		[
			'post_type'              => 'page',
			's'                      => 'Home',
			'post_status'            => 'all',
			'numberposts'            => 1,
			'update_post_term_cache' => false,
			'update_post_meta_cache' => false,
		]
	);

	if ( ! empty( $front_page ) ) {
		update_option( 'page_on_front', $front_page[0]->ID );
	}

	// Get the blog page.
	$blog_page = get_posts(
		[
			'post_type'   => 'page',
			's'           => 'Blog Page',
			'post_status' => 'all',
			'numberposts' => 1,
		]
	);

	if ( ! empty( $blog_page ) ) {
		update_option( 'page_for_posts', $blog_page[0]->ID );
	}

	if ( ! empty( $blog_page ) || ! empty( $front_page ) ) {
		update_option( 'show_on_front', 'page' );
	}

	// Disable Elementor's Default Colors and Default Fonts
	update_option( 'elementor_disable_color_schemes', 'yes' );
	update_option( 'elementor_disable_typography_schemes', 'yes' );
	update_option( 'elementor_global_image_lightbox', 'yes' );
	if ( defined( 'ELEMENTOR_VERSION' ) && class_exists( 'Elementor\Plugin' ) ) {
		//\Elementor\Plugin::$instance->files_manager->clear_cache();
	}


}

add_action( 'wcfio/after_import', 'builder_after_import_setup' );

function ocdi_before_content_import( $selected_import ) {

	if ( isset( $selected_import['import_theme_settings'] ) && is_array( $selected_import['import_theme_settings'] ) ) {
		$settings = $selected_import['import_theme_settings'];
		foreach ( $settings as $item ) {
			wcf_option_update( $item['option_content'], $item['option_name'] );
		}
	}
}


function wcf_option_update( $value, $option_name ) {
	if ( $value ) {
		global $wpdb;
		$new_value = $value;

		$result = $wpdb->update(
			$wpdb->options,
			array( 'option_value' => $new_value ),
			array( 'option_name' => $option_name ),
			array( '%s' ),
			array( '%s' )
		);
	}
}


function builder_ocdi_before_content_import( $selected_import ) {

	if ( isset( $selected_import['import_theme_settings'] ) && is_array( $selected_import['import_theme_settings'] ) ) {
		$settings = $selected_import['import_theme_settings'];
		foreach ( $settings as $item ) {
			$response = wp_remote_get( $item['file_url'] );
			if ( isset( $item['option_kit_name'] ) ) {

				if ( is_array( $response ) && ! is_wp_error( $response ) ) {
					$json_data = wp_remote_retrieve_body( $response );
					wcf_update_elementor_global_settings( $json_data );
				}

			} else {
				if ( is_array( $response ) && ! is_wp_error( $response ) ) {
					$headers  = $response['headers']; // array of http header lines
					$xml_data = wp_remote_retrieve_body( $response );
					$xml      = simplexml_load_string( $xml_data );
					// Extract the serialized value
					$serialized_data = (string) $xml->value;
					if ( is_string( $serialized_data ) ) {
						$arr = unserialize( $serialized_data );
						if ( is_array( $arr ) ) {
							update_option( $item['option_name'], $arr );
						}
					}
				}
			}

		}
	}
	if ( isset( $_GET['page'] ) && $_GET['page'] === 'wcf-theme-demo-import' && isset( $_GET['import'] ) ) {

	}

}

add_action( 'wcfio/before_content_import', 'builder_ocdi_before_content_import' );

function wcf_update_elementor_global_settings( $elementor ) {

	$activeKitId = get_option( 'elementor_active_kit' );
	$kit_data    = json_decode( $elementor, true );
	if ( $activeKitId ) {
		$postMeta = get_post_meta( $activeKitId, '_elementor_page_settings', true );
		// Ensure $postMeta is an array
		$newPostMeta = is_array( $postMeta ) ? $postMeta : [];
		// Add or override custom colors
		if ( $kit_data && isset( $kit_data['settings'] ) ) {
			$newPostMeta = $kit_data['settings'];
			update_post_meta( $activeKitId, '_elementor_page_settings', $newPostMeta );
		}
	}
}