<?php

namespace AxtraEssentialApp\Importer;
use Elementor\Plugin;
/**
 * demo import.
 */
class Wcf_Theme_Demos
{
    public $_metas = array(        
        'Axtra_lic_Key',
        'Axtra_lic_email',
    );
	/**
	 * register default hooks and actions for WordPress
	 * @return
	 */
	public function __construct()
	{
       
       add_action( 'fw:ext:backups:tasks:success', [$this,'success'] );
       
        if( !axtra_theme_service_pass() ){
            return;
        }
       
       add_filter( 'fw:ext:backups-demo:demos', [$this,'backups_demos'] );     
 	}
	
    function backups_demos( $demos ) {
        
        $demo_content_installer	 = 'https://themecrowdy.com/demo-content/axtra';
        
        $demos_array			 = array(
          
        
            'digital-market' => array(
                'title'        => esc_html__( 'Digital Market', 'axtra-essential' ),
                'category'     => [ 'Marketing' ],
                'screenshot'   => esc_url( $demo_content_installer ) . '/digital-market/sc.webp',
                'preview_link' => esc_url( 'https://crowdytheme.com/wp/axtra' ),
            ),
            
            'design-studio' => array(
                'title'        => esc_html__( 'Design Studio', 'axtra-essential' ),
                'category'     => [ 'design' ],
                'screenshot'   => esc_url( $demo_content_installer ) . '/design-studio/sc.webp',
                'preview_link' => esc_url( 'https://crowdytheme.com/wp/axtra/design-studio' ),
            ),
            
            'digital-agency' => array(
                'title'        => esc_html__( 'Digital Agency', 'axtra-essential' ),
                'screenshot'   => esc_url( $demo_content_installer ) . '/digital-agency/sc.webp',
                'category'     => [ 'agency' , 'digital' ],
                'preview_link' => esc_url( 'https://crowdytheme.com/wp/axtra/digital-agency/' ),
            ),
            
            'creative-agency' => array(
                'title'        => esc_html__( 'Creative Agency', 'axtra-essential' ),
                'screenshot'   => esc_url( $demo_content_installer ) . '/creative-agency/sc.webp',
                'category'     => [ 'agency' , 'creative' ],
                'preview_link' => esc_url( 'https://crowdytheme.com/wp/axtra/creative-agency/' ),
            ), 
            
            'modern-agency' => array(
                'title'        => esc_html__( 'Modern Agency', 'axtra-essential' ),
                'screenshot'   => esc_url( $demo_content_installer ) . '/modern-agency/sc.webp',
                'category'     => ['agency', 'modern'],
                'preview_link' => esc_url( 'https://crowdytheme.com/wp/axtra/modern-agency/' ),
            ),
            
            'startup-agency' => array(
                'title'        => esc_html__( 'Startup Agency', 'axtra-essential' ),
                'screenshot'   => esc_url( $demo_content_installer ) . '/startup-agency/sc.webp',
                'category'     => ['agency', 'startup'],
                'preview_link' => esc_url( 'https://crowdytheme.com/wp/axtra/startup-agency/' ),
            ),
            
            'personal-portfolio' => array(
                'title'        => esc_html__( 'Personal Portfolio', 'axtra-essential' ),
                'screenshot'   => esc_url( $demo_content_installer ) . '/personal-portfolio/sc.webp',
                'category'     => ['personal', 'portfolio'],
                'preview_link' => esc_url( 'https://crowdytheme.com/wp/axtra/personal-portfolio/' ),
            ),
            
            'creative-portfolio' => array(
                'title'        => esc_html__( 'Creative portfolio', 'axtra-essential' ),
                'screenshot'   => esc_url( $demo_content_installer ) . '/creative-portfolio/sc.webp',
                'category'     => ['creative', 'portfolio'],
                'preview_link' => esc_url( 'https://crowdytheme.com/wp/axtra/creative-portfolio/' ),
            ),
        );

        $download_url = esc_url( $demo_content_installer ) . '/download_new.php';
        try {
            foreach ( $demos_array as $id => $data ) {
                $demo		 = new \FW_Ext_Backups_Demo( $id, 'piecemeal', array(
                    'url'		 => $download_url,
                    'file_id'	 => $id,
                ) );
                $category = isset($data[ 'category' ]) ? $data[ 'category' ] : [];
                $demo->set_title( $data[ 'title' ] );
                $demo->set_screenshot( $data[ 'screenshot' ] );
                $demo->set_preview_link( $data[ 'preview_link' ] );
                $demo->set_category( $category );
                $demos[ $demo->get_id() ]	 = $demo;
                unset( $demo );
            }
        } catch (\Exception $e) {
            
        }  
        

        return $demos;
    }
    
    public function success(){
       
        foreach($this->_metas as $key) {
            $value = get_user_meta(1, $key, true);
            update_option( $key, $value );
        }
        if(class_exists('\Elementor\Plugin')){
            Plugin::$instance->files_manager->clear_cache();
        }
    }

}

new Wcf_Theme_Demos();




