<?php 

/*
* get default header footer id
* @return bool
*/
function wcf_hf_get_default_template_id( $type= 'header' ){
    return false;
}

/*
* get default header footer id
* @return bool
*/
if( !function_exists( 'wcf_hf_header_footer_templates') ){
   
    function wcf_hf_header_footer_templates( $type= 'header' ){

        $list = [];
        $args = array(
            'post_type'           => 'wcf-hf-tpl',
            'orderby'             => 'id',
            'order'               => 'DESC',
            'numberposts'         => -1,
            'ignore_sticky_posts' => 1,
            'meta_query'          => array(
                array(
                    'key'     => 'wcf_hf_template_type',
                    'compare' => 'LIKE',
                    'value'   => sanitize_text_field($type),
                ),
               
            ),
        );
     
        $data = get_posts($args);

        $list['--'] = esc_html__( 'None', 'axtra-essential' );
        
        foreach($data as $item){
           $list[ $item->ID ] = esc_html( $item->post_title );
        }
        
        return $list;
     }

}


if( !function_exists( 'wcf_hf_get_header_template_id') ){
   
    function wcf_hf_get_header_template_id($page_id = '' , $type= 'not-found' ){
    
    	if( is_404() ){
			$type = '404';			
		}
		
		if(is_archive() ){
			$type = 'archive';
		}
		
		if( is_category() ){
			$type = 'category';
		}
		
		if( is_tag() ){
			$type = 'tag';
		}
		
		if(is_author() ){
			$type = 'author';
		}
		
		if(is_search() ){
			$type = 'search';
		}
				
		if( is_singular('post') ){
			$type = 'post';
		}
		
		if(is_single()){
            $type = get_post_type(); 		 
		}
       
        $list = [];
        $args = array(
            'post_type'           => 'wcf-hf-tpl',
            'orderby'             => 'id',
            'order'               => 'DESC',
            'posts_per_page'      => 1,
            'ignore_sticky_posts' => 1,
            'meta_query'          => array(
            
                array(
                    'key'     => 'wcf_advanced_settings_enable',
                    'compare' => '==',
                    'value'   => 1,
                ),
                
                array(
                    'key'     => 'wcf_hf_template_type',
                    'compare' => '==',
                    'value'   => 'header',
                ),
                
                array(
                    'key'     => 'wcf_hf_custom_header_pages',
                    'compare' => 'like',
                    'value'   => $type,
                )
               
            ),
        );
     
        $data = get_posts($args);
        
        if($data && isset($data[0])){
            return $data[0]->ID;
        }
        
        return $page_id;
     }

}

if( !function_exists( 'wcf_hf_get_header_exclude_template_id') ){
   
    function wcf_hf_get_header_exclude_template_id($page_id = '' , $type= 'not-found' ){
    
    	if( is_404() ){
			$type = '404';			
		}
		
		if(is_archive() ){
			$type = 'archive';
		}
		
		if( is_category() ){
			$type = 'category';
		}
		
		if( is_tag() ){
			$type = 'tag';
		}
		
		if(is_author() ){
			$type = 'author';
		}
		
		if(is_search() ){
			$type = 'search';
		}
				
		if( is_singular('post') ){
			$type = 'post';
		}
		
		if(is_single()){
            $type = get_post_type(); 		 
		}
       
        $list = [];
        $args = array(
            'post_type'           => 'wcf-hf-tpl',
            'orderby'             => 'id',
            'order'               => 'DESC',
            'posts_per_page'      => 1,
            'ignore_sticky_posts' => 1,
            'meta_query'          => array(
            
                array(
                    'key'     => 'wcf_advanced_settings_enable',
                    'compare' => '==',
                    'value'   => 1,
                ),
                
                array(
                    'key'     => 'wcf_hf_template_type',
                    'compare' => '==',
                    'value'   => 'header',
                ),
                
                array(
                    'key'     => 'wcf_hf_custom_header_exclude_pages',
                    'compare' => 'like',
                    'value'   => $type,
                )
               
            ),
        );
     
        $data = get_posts($args);
        
        if($data && isset($data[0])){
            return -404;
        }
        
        return $page_id;
     }

}

if( !function_exists( 'wcf_hf_get_footer_template_id') ){
   
    function wcf_hf_get_footer_template_id($page_id = '', $type= 'not-found' ){
    
    	if( is_404() ){
			$type = '404';			
		}
		
		if(is_archive() ){
			$type = 'archive';
		}
		
		if( is_category() ){
			$type = 'category';
		}
		
		if( is_tag() ){
			$type = 'tag';
		}
		
		if(is_author() ){
			$type = 'author';
		}
		
		if(is_search() ){
			$type = 'search';
		}
				
		if( is_singular('post') ){
			$type = 'post';
		}
		
		if(is_single()){
            $type = get_post_type(); 		 
		}
       
        $list = [];
        $args = array(
            'post_type'           => 'wcf-hf-tpl',
            'orderby'             => 'id',
            'order'               => 'DESC',
            'numberposts'      => 1,
            'ignore_sticky_posts' => 1,
            'meta_query'          => array(
            
                array(
                    'key'     => 'wcf_advanced_settings_enable',
                    'compare' => '==',
                    'value'   => 1,
                ),
                
                array(
                    'key'     => 'wcf_hf_template_type',
                    'compare' => '==',
                    'value'   => 'footer',
                ),
                
                array(
                    'key'     => 'wcf_hf_custom_footer_pages',
                    'compare' => 'like',
                    'value'   => $type,
                )
               
            ),
        );
     
        $data = get_posts($args);
        if($data && isset($data[0])){
            return $data[0]->ID;
        }
        return $page_id;
     }

}
if( !function_exists( 'wcf_hf_get_footer_exclude_template_id') ){
   
    function wcf_hf_get_footer_exclude_template_id($page_id = '', $type= 'not-found' ){
    
    	if( is_404() ){
			$type = '404';			
		}
		
		if(is_archive() ){
			$type = 'archive';
		}
		
		if( is_category() ){
			$type = 'category';
		}
		
		if( is_tag() ){
			$type = 'tag';
		}
		
		if(is_author() ){
			$type = 'author';
		}
		
		if(is_search() ){
			$type = 'search';
		}
				
		if( is_singular('post') ){
			$type = 'post';
		}
		
		if(is_single()){
            $type = get_post_type(); 		 
		}
       
        $list = [];
        $args = array(
            'post_type'           => 'wcf-hf-tpl',
            'orderby'             => 'id',
            'order'               => 'DESC',
            'numberposts'      => 1,
            'ignore_sticky_posts' => 1,
            'meta_query'          => array(
            
                array(
                    'key'     => 'wcf_advanced_settings_enable',
                    'compare' => '==',
                    'value'   => 1,
                ),
                
                array(
                    'key'     => 'wcf_hf_template_type',
                    'compare' => '==',
                    'value'   => 'footer',
                ),
                
                array(
                    'key'     => 'wcf_hf_custom_footer_exclude_pages',
                    'compare' => 'like',
                    'value'   => $type,
                )
               
            ),
        );
     
        $data = get_posts($args);
        if($data && isset($data[0])){
            return -404;
        }
        return $page_id;
     }

}

if( !function_exists( 'wcf_hf_get_header_footer_options_area') ){
   
    function wcf_hf_get_header_footer_options_area(){
        $post_types = axtra_get_cache_post_types();
        $post_types['post'] = 'Post';
        $post_types['page'] = 'Page';
        $post_types['404'] = '404';
        $post_types['archive'] = 'Archive';
        $post_types['category'] = 'Category';
        $post_types['tag'] = 'Tag';
        $post_types['author'] = 'Author Page';
        $post_types['search'] = 'Search Page';
        
        return $post_types;
    }
}
/* 
* Selected Options
*/
if( !function_exists( 'wcf_hf_get_header_selected_options') ){

    function wcf_hf_get_header_footer_selected_options($type=''){
    
        global $wpdb;
        $return_result = [];
        $id = isset($_GET['post']) ? $_GET['post'] : 0;        
         
        try {
          
            $results = $wpdb->get_results( "SELECT meta_key, meta_value , post_id FROM $wpdb->postmeta WHERE post_id IN (SELECT post_id FROM $wpdb->postmeta JOIN $wpdb->posts ON $wpdb->posts.ID = $wpdb->postmeta.post_id WHERE $wpdb->posts.post_status = 'publish' AND $wpdb->posts.post_type = 'wcf-hf-tpl' AND meta_key = 'wcf_hf_template_type' AND meta_value = '$type' AND $wpdb->postmeta.post_id !='$id')" );
            if($results && is_array($results)){
                $key_chekcer = 'wcf_hf_custom_header_pages';    
                if($type == 'footer'){
                    $key_chekcer = 'wcf_hf_custom_footer_pages';
                }
                foreach($results as $item){                    
                    if( $item->meta_key === $key_chekcer ){
                        $this_item =  maybe_unserialize($item->meta_value);
                        $this_item = is_array($this_item) ? $this_item : [];
                        $return_result = array_merge($return_result, $this_item);
                    }
                }
            }
        } catch (Exception $e) { }
       
       return $return_result;
    }

}

function wcf_hf_check_force_header_footer($type='header'){
    
    $args = array(
        'post_type'           => 'wcf-hf-tpl',
        'orderby'             => 'id',
        'order'               => 'DESC',
        'numberposts'      => 1,
        'ignore_sticky_posts' => 1,
        'meta_query'          => array(
        
            array(
                'key'     => 'wcf_hf_template_type_force_full_site',
                'compare' => '==',
                'value'   => 1,
            ),
            
            array(
                'key'     => 'wcf_hf_template_type',
                'compare' => '==',
                'value'   => $type,
            ),            
         
           
        ),
    );
 
    $data = get_posts($args);
    
    return $data && isset($data[0]) ? $data[0]->ID : null;
}



