<?php

if(is_admin()){

  if( class_exists( 'CSF' ) ) {
  
    $post_types = wcf_hf_get_header_footer_options_area();
    $dbskip     = wcf_hf_get_header_footer_selected_options('header');
    $fdbskip    = wcf_hf_get_header_footer_selected_options('footer');
    $skip = [
          // 'page',
        'wcf-hf-tpl',
        'wcf-single-post',
        'mc4wp-form',
        'wpcf7_contact_form',
        'nav_menu_item',
        'e-landing-page',
        'wcf-custom-font',
        'wcf-blog-tpl',
        'wcf-search-tpl',
        'wcf-error-tpl',
        'wcf-mega-menu-tpl'
    ];
      
    foreach($post_types as $key => $item){   
        if(in_array($key, $skip)){
          unset($post_types[$key]);
        }
    }
      
    $header_options = $footer_options = $post_types;
      
      // Header option sanitize
    foreach($header_options as $key => $item){   
        if(in_array($key, $dbskip)){
          unset($header_options[$key]);
        }
    }
      
      // Footer option sanitize
    foreach($header_options as $key => $item){   
        if(in_array($key, $fdbskip)){
          unset($header_options[$key]);
        }
    }
    $ply = [];
    if(function_exists('pll_languages_list')){
      $lng_trm = pll_languages_list(array('fields' => array()));
      $arr_lng = [];
      
      foreach($lng_trm as $item){
        $arr_lng[$item->slug] = $item->name;
      }      
      
      $ply = array(
        'id'          => 'wcf_hf_custom_footer_lang',
        'type'        => 'select',
        'title'       => esc_html__('Lang','axtra-essential'),
        'chosen'      => true,
        'multiple'    => false,
        'placeholder' => esc_html__('Lang','axtra-essential'),
        'options'     => $arr_lng,
        'default'     => ''     
      );
      
    }
      // Set a unique slug-like ID    
    $post_prefix = 'wcf_hf_options';    
      // Create a metabox for post
    CSF::createMetabox( $post_prefix, array(
        'title'     => 'Settings',
        'post_type' => 'wcf-hf-tpl',
        'data_type' => 'unserialize',       
    ) );
        
      // Header section
    CSF::createSection( $post_prefix, array(
        'title'  =>  esc_html__( 'Header Footer', 'axtra-essential'),      
        'fields' => array( 
        
           array(
            'id'          => 'wcf_hf_template_type',
            'type'        => 'select',
            'title'       => esc_html__('Select Template Type','axtra-essential'),
            'placeholder' => esc_html__('Select an option','axtra-essential'),
            'options'     => array(
              'header'  => esc_html__('Header','axtra-essential'),
              'footer'  => esc_html__('Footer','axtra-essential'),            
            ),
            'default'     => ''
          ), 
          
          array(
            'id'      => 'wcf_hf_template_type_force_full_site',
            'type'    => 'switcher',
            'title'   => esc_html__( 'Force / Override Entire Site', 'axtra-essential' ),
            'default' => false,
            'help' => esc_html__('It will override theme header settings', 'axtra-essential')
          ), 
          
          array(
            'id'      => 'wcf_advanced_settings_enable',
            'type'    => 'switcher',
            'title'   => esc_html__( 'Advanced Settings', 'axtra-essential' ),
            'default' => false
          ),  
          
          array(
            'id'          => 'wcf_hf_custom_header_pages',
            'type'        => 'select',
            'title'       => esc_html__('Custom Header Include Area','axtra-essential'),
            'chosen'      => true,
            'multiple'    => true,
            'placeholder' => esc_html__('Custom Header Area','axtra-essential'),
            'options'     => $header_options,
            'default'     => '',
            'dependency' => array( 'wcf_hf_template_type|wcf_advanced_settings_enable', '==|==', 'header|true' ),
          ),
          
          array(
            'id'          => 'wcf_hf_custom_header_exclude_pages',
            'type'        => 'select',
            'title'       => esc_html__('Custom Header Exclude Area','axtra-essential'),
            'chosen'      => true,
            'multiple'    => true,
            'placeholder' => esc_html__('Custom Header Area','axtra-essential'),
            'options'     => $header_options,
            'default'     => '',
            'dependency' => array( 'wcf_hf_template_type|wcf_advanced_settings_enable', '==|==', 'header|true' ),
          ), 
          
          array(
            'id'          => 'wcf_hf_custom_footer_pages',
            'type'        => 'select',
            'title'       => esc_html__('Custom Footer Include Area','axtra-essential'),
            'chosen'      => true,
            'multiple'    => true,
            'placeholder' => esc_html__('Custom Footer Area','axtra-essential'),
            'options'     => $post_types,
            'default'     => '',
            'dependency' => array( 'wcf_hf_template_type|wcf_advanced_settings_enable', '==|==', 'footer|true' ),
          ), 
          
          array(
            'id'          => 'wcf_hf_custom_footer_exclude_pages',
            'type'        => 'select',
            'title'       => esc_html__('Custom Footer Exclude Area','axtra-essential'),
            'chosen'      => true,
            'multiple'    => true,
            'placeholder' => esc_html__('Custom Footer Area','axtra-essential'),
            'options'     => $post_types,
            'default'     => '',
            'dependency' => array( 'wcf_hf_template_type|wcf_advanced_settings_enable', '==|==', 'footer|true' ),
          ),          
          $ply 
          
        )
      )
    );    
     
  }
  
}
  