<?php

namespace Wcf\Header_Footer\Base;

class Template
{

	public function register()
	{

		if (!file_exists(WP_PLUGIN_DIR . '/elementor/elementor.php')) {
			return;
		}

		add_filter('wcf_hf_header_page_override', array( $this , 'header_page_override' ), 10);
		add_filter('wcf_hf_header_page_override', array( $this , 'header_advanced_setting' ), 12);
		add_filter('wcf_hf_header_page_override', array( $this , 'header_advanced_exclude_setting' ), 14);
		
		add_filter('wcf_hf_footer_page_override', array( $this , 'footer_page_override' ), 10);
		add_filter('wcf_hf_footer_page_override', array( $this , 'footer_advanced_setting' ), 12);
		add_filter('wcf_hf_footer_page_override', array( $this , 'footer_advanced_exclude_setting' ), 14);
	}
	
	public function footer_advanced_exclude_setting($page_id){
		$page_id = wcf_hf_get_footer_exclude_template_id($page_id);
		return $page_id;
	}
	
	public function header_advanced_exclude_setting($page_id){
		$page_id = wcf_hf_get_header_exclude_template_id($page_id);
		return $page_id;
	}
	public function header_advanced_setting($page_id){
	
		// post and custom post override		
		if( axtra_meta_option( get_the_ID() , 'header_style_override' , true ) === 'theme_header' ){
			return false;
		}
	
		$page_id = wcf_hf_get_header_template_id($page_id);
		
		if( axtra_meta_option( get_the_ID() , 'header_style_override' , true ) === 'builder_header' ){
			$page_id = axtra_meta_option( get_the_ID() , 'builder_header' , true );		
		}
		
		return $page_id;
	}
	
	public function footer_advanced_setting($page_id){

		// post and custom post override		
		if(axtra_meta_option(get_the_ID(), 'footer_style_override', true) === 'theme_footer'){
			return false;
		}
		
		$page_id = wcf_hf_get_footer_template_id($page_id);
		
		if( axtra_meta_option( get_the_ID() , 'footer_style_override' , true ) === 'builder_footer' ){
			$page_id = axtra_meta_option( get_the_ID() , 'builder_footer' , true );		
		}
		
		return $page_id;
	}

	public function header_page_override() {
		
		$page_id = wcf_hf_check_force_header_footer('header');	
	    if( axtra_option('elementor_header') == 'yes' ){
		   $page_id = axtra_option( 'builder_header' );
	    }
	    // force check
	
	    if(function_exists('pll_current_language')){
            $current_lng = pll_current_language();		
            $page_id = $this->wcf_hf_polylang_header_footer('header', $page_id);             
        }
		
		if ( is_page() && 'builder_header' == axtra_meta_option( get_the_ID() , 'header_style_override' , '' ) ) {			
			$page_id = axtra_meta_option( get_the_ID() , 'builder_header' , true );			
		}
		
		if ( is_numeric( $page_id ) && $page_id > 0 ) {		
			return $page_id;
		} else {

			$builder_header_layout = axtra_option( 'elementor_header' );
			
			if ( ! $builder_header_layout ) {
				return false;
			}
			
			$id = axtra_option( 'builder_header' );
			
			if ( ! is_numeric( $id ) || $id == -1 ) {
				return false;
			}
		}
		return $id;
	}
	
	
	public function wcf_hf_polylang_header_footer($type='header', $page_id = null ){
	
	    $current_lng = pll_current_language();
	    $args = array(
	        'post_type'           => 'wcf-hf-tpl',
	        'orderby'             => 'id',
	        'order'               => 'DESC',
	        'numberposts'      => 1,
	        'ignore_sticky_posts' => 1,
	        'meta_query'          => array(
	        
	            array(
	                'key'     => 'wcf_hf_custom_footer_lang',
	                'compare' => '==',
	                'value'   => $current_lng,
	            ),
	            
	            array(
	                'key'     => 'wcf_hf_template_type',
	                'compare' => '==',
	                'value'   => $type,
	            ),            
	         
	           
	        ),
	    ); 
	    $data = get_posts($args);   
	
	    return $data && isset($data[0]) ? $data[0]->ID : $page_id;
	}

	public function footer_page_override()
	{
	
		$page_id = wcf_hf_check_force_header_footer('footer');	
	//
	    if( axtra_option('elementor_footer') == 'yes' ){
		   $page_id = axtra_option('builder_footer');
	    }
	    
		if(function_exists('pll_current_language')){
            $current_lng = pll_current_language();
            $page_id = $this->wcf_hf_polylang_header_footer('footer', $page_id);             
        }
		
		// page override
		if ( (is_page() || is_singular('docs')) && 'builder_footer' == axtra_meta_option(get_the_ID(), 'footer_style_override', '')) {
			$page_id = axtra_meta_option( get_the_ID(), 'builder_footer', true );			
		}
		
		if ( is_numeric( $page_id ) ) {
			return $page_id;
		} else {
			$builder_layout = axtra_option('elementor_footer');
			if (!$builder_layout) {
				return false;
			}
			$id = axtra_option('builder_footer');			
			if (!is_numeric($id) || $id == -1) {
				return false;
			}
		}
       
		return $id;
	}

	public function hooks()
	{
		// add_action('get_header', array($this, 'render_header'), 100);
		// add_action('get_footer', array($this, 'render_footer'));		
	}

	public function wp_head()
	{
		wp_reset_postdata();
	}

	public function header_template()
	{
	
		$path   = AXTRA_ESSENTIAL_DIR_PATH . 'inc/packages/header-footer/templates/content/content-header.php';
		$header = $this->display_template();
		$this->render($header, $path);
	}

	public function footer_template()
	{

		$path   = AXTRA_ESSENTIAL_DIR_PATH . 'inc/packages/header-footer/templates/content/content-footer.php';
		$footer = $this->display_template('all', 'footer');
		$this->render($footer, $path);
	}

	public function render($header, $path)
	{

		if ($header->have_posts()) {
			while ($header->have_posts()) {
				$header->the_post();
				load_template($path);
			}
			wp_reset_postdata();
		}
	}

	public function render_header()
	{

		$header_id = $this->template_header_id();
        
		if ($header_id) {
			require AXTRA_ESSENTIAL_DIR_PATH . 'inc/packages/header-footer/templates/default/header.php';
			$templates   = array();
			$templates[] = 'header.php';
			remove_all_actions('wp_head');
			ob_start();
			locate_template($templates, true);
			ob_get_clean();
		}
	}

	public function render_footer()
	{

		$footer_id = $this->template_footer_id();
       
		if ($footer_id) {
			require AXTRA_ESSENTIAL_DIR_PATH . 'inc/packages/header-footer/templates/default/footer.php';
			$templates   = array();
			$templates[] = 'footer.php';
			remove_all_actions('wp_footer');
			ob_start();
			locate_template($templates, true);
			ob_get_clean();
		}
	}

	public function template_header_id()
	{

		$header = $this->display_template();
		if (!$header) {
			return false;
		}
		while ($header->have_posts()) {
			$header->the_post();
			$id = get_the_ID();
		}
		wp_reset_postdata();
		return $id;
	}

	public function template_footer_id()
	{

		$footer = $this->display_template($page_type = 'all', $type = 'footer');
		
		if (!$footer) {
			return false;
		}
		while ($footer->have_posts()) {
			$footer->the_post();
			$id = get_the_ID();
		}
		wp_reset_postdata();
		return $id;
	}
	
	public function display_template( $page_type = 'all', $type = 'header' )
	{

		if (empty($page_type)) {
			return false;
		}

		$args = [
			'post_type' => 'nmo'
		];
        
		$override = false;
		if ($type == 'header') {
			$override = apply_filters("wcf_hf_header_page_override", false);
			if ($override) {
				$args = array(
					'p'         => $override,
					'post_type' => 'wcf-hf-tpl'
				);
			}
		}

		if ($type == 'footer') {
			$override = apply_filters("wcf_hf_footer_page_override", false);
			
			if ($override) {
				$args = array(
					'p'         => $override,
					'post_type' => 'wcf-hf-tpl'
				);
			}
		}
		
		$header = new \WP_Query($args);
		wp_reset_postdata();
		if ($header->have_posts()) {		
			return $header;
		} else {
			return false;
		}
	}
}
