<?php 
 

 // Post Page
CSF::createSection( AXTRA_OPTION_KEY, array(
    'icon'   => 'fa fa-book',
    'title' => esc_html__( 'Post & Page', 'axtra-essential' ),
    'fields' => array(

        array(
          'type'    => 'subheading',
          'content' => esc_html__( 'Post Setting', 'axtra-essential' ),
        ),        
        
        array(
            'id'      => 'single_post_tags',
            'type'    => 'switcher',
            'title'   => esc_html__( 'Enable Post tags', 'axtra-essential' ),
            'desc'    => esc_html__( 'If you want to enable or disable single post tags you can set ( YES / NO )', 'axtra-essential' ),
            'default' => true,
        ),

        array(
            'id'      => 'blog_single_author_box',
            'type'    => 'switcher',
            'title'   => esc_html__( 'Blog Author About', 'axtra-essential' ),
            'default' => false
        ),
        
        array(
            'id'            => 'blog_post_preset_grp',
            'type'          => 'tabbed',
            'title'         => esc_html__('Preset','axtra-essential'),
            'tabs'          => array(
              array(
                'title'     => 'Post Single',
                'icon'      => 'fas fa-warehouse',
                'fields'    => array(
                    // array(
                    //     'id'      => 'preset_active',
                    //     'type'    => 'switcher',
                    //     'title'   => esc_html__( 'Active', 'axtra-essential' ),
                    //     'default' => false,
                        
                    // ), 
                    
                    array(
                        'id'        => 'post_layout',
                        'type'      => 'image_select',
                        'title'     => esc_html__('Layout','axtra-essential'),
                        'options'   => array(
                          'default' => AXTRA_ESSENTIAL_ASSETS_URL . 'images/patterns/default.svg',
                          'health-one' => AXTRA_ESSENTIAL_ASSETS_URL . 'images/patterns/layout-1.svg',
                          'athlete' => AXTRA_ESSENTIAL_ASSETS_URL . 'images/patterns/layout-2.svg',                              
                          'elementor_builder' => AXTRA_ESSENTIAL_ASSETS_URL . 'images/elementor.svg'
                        ),
                        'default'   => 'default',
                        // 'dependency' => array( 'preset_active', '==', true )                       
                    ),
            
                    array(
                        'id'      => 'preset_blog_banner',
                        'type'    => 'switcher',
                        'title'   => esc_html__( 'Banner', 'axtra-essential' ),
                        'default' => false,
                        'dependency' => array( 'post_layout', 'any', 'health-one,athlete' )
                    ), 
                    
                    array(
                        'id'      => 'preset_blog_view',
                        'type'    => 'switcher',
                        'title'   => esc_html__( 'View', 'axtra-essential' ),
                        'default' => false,
                        'dependency' => array( 'post_layout', 'any', 'health-one,athlete' )
                    ),
                    
                    array(
                        'id'      => 'preset_blog_sidebar',
                        'type'    => 'switcher',
                        'title'   => esc_html__( 'Sidebar', 'axtra-essential' ),
                        'default' => false,
                        'dependency' => array( 'post_layout', 'any', 'health-one,athlete' )
                    ),
                    
                    array(
                        'type'     => 'callback',
                        'function' => 'axtra_elementor_post_single_layout_json',
                        'dependency' => array( 'post_layout', '==', 'elementor_builder' )
                    )
                    
                )
              ),           
            )
          ),
          
          


    ),
) );

