<?php 
 

 // Post Page
CSF::createSection( AXTRA_OPTION_KEY, array(
    'icon'   => 'fas fa-holly-berry',
    'id'    => '404_page_section', // Set a unique slug-like ID
    'title' => esc_html__( '404', 'axtra-essential' )
    ) );
    
    CSF::createSection( AXTRA_OPTION_KEY, array(
        'parent' => '404_page_section', // The slug id of the parent section
        'icon'   => 'fa fa-book',
        'title'  => esc_html__( 'Content', 'axtra-essential' ),
        'fields' => array(
            array(
                'type'    => 'subheading',
                'content' => esc_html__( '404 Error Page Setting', 'axtra-essential' ),
              ),
              
              array(
                'id'      => 'error_preset_layout',
                'type'    => 'image_select',
                'title'   => esc_html__('404 Layout','axtra-essential'),
                'options' => array(
                    'default'           => AXTRA_ESSENTIAL_ASSETS_URL . 'images/patterns/default.svg',
                    'elementor_builder' => AXTRA_ESSENTIAL_ASSETS_URL . 'images/elementor.svg'
                ),
                'default' => 'default',
                                  
              ),
              
              array(
                'type'     => 'callback',
                'function' => 'axtra_elementor_error__layout_json',
                'dependency' => array( 'error_preset_layout', '==', 'elementor_builder' )
              ),
            
              array(
                  'id'         => 'error_title',
                  'type'       => 'text',
                  'title'      => esc_html__( 'Error title', 'axtra-essential' ),
                  'desc'       => esc_html__( 'Set your 404 error title.', 'axtra-essential' ),
                  'default'    => esc_html__( '404', 'axtra-essential' ),
                  'dependency' => array( 'error_preset_layout', '==', 'default' )
              ),
              
              array(
                'id'         => 'error_subtitle',
                'type'       => 'text',
                'title'      => esc_html__( 'Error subtitle', 'axtra-essential' ),
                'desc'       => esc_html__( 'Set your 404 error subtitle.', 'axtra-essential' ),
                'default'    => esc_html__( 'Ops! Page not found', 'axtra-essential' ),
                'dependency' => array( 'error_preset_layout', '==', 'default' )
             ),
             
             array(
                'id'         => 'error_content',
                'type'       => 'wp_editor',
                'title'      => esc_html__( 'Error content', 'axtra-essential' ),
                'desc'       => esc_html__( 'Set your 404 error subtitle.', 'axtra-essential' ),
                'default'    => esc_html__( 'The page you are looking for was moved, removed, renamed or never existed.', 'axtra-essential' ),
                'dependency' => array( 'error_preset_layout', '==', 'default' )
             ),
      
             array(
                  'id'      => 'enable_404_search_button',
                  'type'    => 'switcher',
                  'title'   => esc_html__( 'Enable Search Button', 'axtra-essential' ),
                  'desc'    => esc_html__( 'If you want to enable or disable 404 page button you can set ( YES / NO )', 'axtra-essential' ),
                  'default' => true,
                  'dependency' => array( 'error_preset_layout', '==', 'default' )
             ),
              
             array(
                'id'         => 'error_btn_text',
                'type'       => 'text',
                'title'      => esc_html__( 'Button Text', 'axtra-essential' ),
                'desc'       => esc_html__( 'Set your 404 button text.', 'axtra-essential' ),
                'default'    => esc_html__( 'Back to Home', 'axtra-essential' ),
                'dependency' => array( 'enable_404_search_button', '==', 'true' ),
                'dependency' => array( 'error_preset_layout', '==', 'default' )
             ),
              
            //  array(
            //       'id'      => 'enable_404_header',
            //       'type'    => 'switcher',
            //       'title'   => esc_html__( 'Enable 404 header', 'axtra-essential' ),
            //       'desc'    => esc_html__( 'If you want to enable or disable 404 page header you can set ( YES / NO )', 'axtra-essential' ),
            //       'default' => false,
                 
            //  ),
      
            //  array(
            //       'id'      => 'enable_404_footer',
            //       'type'    => 'switcher',
            //       'title'   => esc_html__( 'Enable 404 footer', 'axtra-essential' ),
            //       'desc'    => esc_html__( 'If you want to enable or disable 404 page footer you can set ( YES / NO )', 'axtra-essential' ),
            //       'default' => false,
                 
            //  ),
             
        )
    ) );
    
    CSF::createSection( AXTRA_OPTION_KEY, array(
        'parent' => '404_page_section', // The slug id of the parent section
        'icon'   => 'fa fa-book',
        'title'  => esc_html__( 'Style', 'axtra-essential' ),
        'fields' => array(
            array(
            
                'id'      => 'banner_404_image',
                'type'    => 'background',
                'title'   => esc_html__( 'Upload Background', 'axtra-essential' ),
                'desc'    => esc_html__( 'Upload main Image width 1200px and height 400px.', 'axtra-essential' ),
                'output' => '.error404 .body-wrapper'
            ),
            
            array(
                'id'     => 'banner_404_content_title_color',
                'type'   => 'color',
                'title'  => esc_html__( 'Title Color', 'axtra-essential' ),
                'output' => '.error404 .default-error__title',
                'output_important' => true
            ),
            
            array(
                'id'     => 'banner_404_content_subtitle_color',
                'type'   => 'color',
                'title'  => esc_html__( 'SubTitle Color', 'axtra-essential' ),
                'output' => '.error404 .default-error__sub-title',
                'output_important' => true
            ),
            
            array(
                'id'     => 'banner_404_content_c_color',
                'type'   => 'color',
                'title'  => esc_html__( 'Content Color', 'axtra-essential' ),
                'output' => '.error404 .default-error__content p',
                'output_important' => true
            ),
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Button', 'axtra-essential' ),
              ),
              
            array(
                'id'     => 'banner_404_content_button_color',
                'type'   => 'color',
                'title'  => esc_html__( 'Button Color', 'axtra-essential' ),
                'output' => '.error404 .default-error_go_btn a,.error404 .default-error_go_btn i',
                'output_important' => true
            ),
            array(
                'id'     => 'banner_404_content_button_bg_color',
                'type'   => 'color',
                'title'  => esc_html__( 'Button bgColor', 'axtra-essential' ),
                'output' => '.error404 .default-error_go_btn a',
                'output_important' => true,
                'output_mode' => 'background-color'
            ),
            
            array(
                'id'     => 'banner_404_content_button_border',
                'type'   => 'border',
                'title'  => esc_html__('Button Border','axtra-essential'),
                'output' => '.error404 .default-error_go_btn a'
            ),
            
            array(
                'id'     => 'banner_404_content_button_hcolor',
                'type'   => 'color',
                'title'  => esc_html__( 'Button Hover Color', 'axtra-essential' ),
                'output' => '.error404 .default-error_go_btn:hover a,.error404 .default-error_go_btn:hover i',
                'output_important' => true
            ),
            array(
                'id'     => 'banner_404_content_button_bg_hcolor',
                'type'   => 'color',
                'title'  => esc_html__( 'Button Hover bgColor', 'axtra-essential' ),
                'output' => '.error404 .default-error_go_btn:hover a',
                'output_important' => true,
                'output_mode' => 'background-color'
            ),
            
            array(
                'id'     => 'banner_404_content_button_hborder',
                'type'   => 'border',
                'title'  => esc_html__('Button Hover Border','axtra-essential'),
                'output' => '.error404 .default-error_go_btn a:hover'
            ),
        )
    ) );
    