<?php 

    // Blog a top-tab
    CSF::createSection( AXTRA_OPTION_KEY, array(
        'id'    => 'blog_tab',                     // Set a unique slug-like ID
        'title' => esc_html__( 'Blog', 'axtra-essential' ),
        'icon'  => 'fas fa-archive',
    ) ); 
    // Blog
    CSF::createSection( AXTRA_OPTION_KEY, array(
        'parent' => 'blog_tab',                        // The slug id of the parent section
        'icon'   => 'fas fa-archive',
        'title'  => esc_html__( 'General', 'axtra-essential' ),
        'fields' => array(

            array(
                'id'      => 'blog_preset_layout',
                'type'    => 'image_select',
                'title'   => esc_html__('Blog Layout','axtra-essential'),
                'options' => array(                
                  'default' => AXTRA_ESSENTIAL_ASSETS_URL . 'images/patterns/default.svg',
                  'elementor_builder' => AXTRA_ESSENTIAL_ASSETS_URL . 'images/elementor.svg'
                ),
                'default' => 'default',
                // 'dependency' => array( 'preset_active', '==', true )                       
            ),
            
            array(
                'type'     => 'callback',
                'function' => 'axtra_elementor_blog__layout_json',
                'dependency' => array( 'blog_preset_layout', '==', 'elementor_builder' )
            ),
             
            array(
                'id'          => 'blog_sidebar',
                'type'        => 'select',
                'title'       => esc_html__('Blog Sidebar', 'axtra-essential'),
                'placeholder' => 'Select an option',
                'options'     => array(
                    'blog-lg'       => esc_html__('No sidebar', 'axtra-essential'),
                    'left-sidebar'  => esc_html__('Left Sidebar', 'axtra-essential'),
                    'right-sidebar' => esc_html__('Right Sidebar', 'axtra-essential'),
                ),
                'default'    => '',
                'dependency' => array( 'blog_preset_layout', '==', 'default' )
            ),
            array(
                'id'            => 'blog_content_container_size',
                'type'          => 'dimensions',
                'title'         => esc_html__( 'Content Container size(px)', 'axtra-essential' ),
                'placeholder'   => '860',
                'dependency' => array( 'blog_post_nav|blog_preset_layout', '==|==', 'true|default' ),
                'units'         => array( 'px','em','cm' ),
                'output_prefix' => 'max',
                'height'        => false,
                'output'        => 'html .default-blog__grid.no-sidebar',
            ),
            array(
                'id'          => 'blog_content_padding',
                'type'        => 'spacing',
                'title'       => esc_html__('Blog Content Padding','axtra-essential'),
                'left'        => false,
                'right'       => false,
                'units'       => array( 'px','em','cm' ),
                'output_mode' => 'padding',
                'output'      => 'html .default-blog__area',
                'dependency' => array( 'blog_preset_layout', '==', 'default' )
            ),
            array(
                'id'      => 'blog_meta_above_title',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Blog meta above title', 'axtra-essential' ),
                'default' => false,
                'dependency' => array( 'blog_preset_layout', '==', 'default' )
            ), 
            
            array(
                'id'      => 'blog_author',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Blog Author', 'axtra-essential' ),
                'default' => false,
                'dependency' => array( 'blog_preset_layout', '==', 'default' )
            ), 
            
            array(
                'id'      => 'blog_author_image',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Blog Author image', 'axtra-essential' ),
                'default' => false,
                'dependency' => array( 'blog_preset_layout', '==', 'default' )
            ), 

            array(
                'id'      => 'blog_date',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Blog Date', 'axtra-essential' ),
                'default' => true,
                'dependency' => array( 'blog_preset_layout', '==', 'default' )
            ),
            
            array(
                'id'      => 'blog_comment',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Blog Comment', 'axtra-essential' ),
                'default' => false,
                'dependency' => array( 'blog_preset_layout', '==', 'default' )
            ),
            
            array(
                'id'      => 'blog_category',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Blog Category', 'axtra-essential' ),
                'default' => true,
                'dependency' => array( 'blog_preset_layout', '==', 'default' )
            ),
           
            array(
                'id'      => 'blog_readmore',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Blog Readmore', 'axtra-essential' ),
                'default' => true,
                'dependency' => array( 'blog_preset_layout', '==', 'default' )
            ), 
            array(
                'id'      => 'blog_readmore_text',
                'type'    => 'text',
                'title'   => esc_html__( 'Blog Readmore Text', 'axtra-essential' ),
                'default' => esc_html__( 'Read More', 'axtra-essential' ),
                'dependency' => array( 'blog_preset_layout', '==', 'default' )
            ),
            
            array(
                'id'      => 'blog_readmore__icon',
                'type'    => 'media',
                'title'   => esc_html__('Readmore Icon','axtra-essential'),
                'library' => 'image',
                'dependency' => array( 'blog_preset_layout', '==', 'default' )
            ),
          
            array(
                'id'      => 'blog_post_nav',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Blog Navigation', 'axtra-essential' ),
                'default' => true,
                'dependency' => array( 'blog_preset_layout', '==', 'default' )
            ),
            
            array(
                'id'         => 'blog_next_icon',
                'type'       => 'media',
                'title'      => esc_html__('Next Icon','axtra-essential'),
                'library'    => 'image',           
                'dependency' => array( 'blog_post_nav|blog_preset_layout', '==|==', 'true|default' ),
            ),
            
            array(
                'id'         => 'blog_prev_icon',
                'type'       => 'media',
                'title'      => esc_html__('Prev Icon','axtra-essential'),
                'library'    => 'image',            
                'dependency' => array( 'blog_post_nav|blog_preset_layout', '==|==', 'true|default' ),
            ),

            array(
            'id'          => 'blog_post_nav_alignment',
            'type'        => 'select',
            'title'       => esc_html__( 'Navigation Alignment', 'axtra-essential' ),
            'placeholder' => 'Select an option',
            'options'     => array(
                'justify-content-start'  => esc_html__( 'Left', 'axtra-essential' ),
                'justify-content-center' => esc_html__( 'Center', 'axtra-essential' ),
                'justify-content-end'    => esc_html__( 'Right', 'axtra-essential' ),
            ),          
            'dependency' => array( 'blog_post_nav|blog_preset_layout', '==|==', 'true|default' ),
            'default'    => 'justify-content-start'
            ),
           
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Blog & Page Default Options', 'axtra-essential' ),
                'dependency' => array( 'blog_preset_layout', '==', 'default' ),
            ),
            
            array(
                'id'      => 'blog_excerpt_word',
                'type'    => 'number',
                'title'   => esc_html__( 'Blog Excerpt Word', 'axtra-essential' ),
                'desc'    => esc_html__( 'Set the words that how many words you want to show in every blog post item.', 'axtra-essential' ),
                'default' => '30',
                'dependency' => array( 'blog_preset_layout', '==', 'default' ),
            ),
        

        )
    ) ); 
     // fav icon
    CSF::createSection( AXTRA_OPTION_KEY, array(
        'parent' => 'blog_tab',                           // The slug id of the parent section  
        'title'  => esc_html__('Sidebar Style','axtra-essential'),
        'icon'   => 'fa fa-image',
        'fields' => array(

            array(
                'id'      => 'news__sidebars_bg',
                'type'    => 'background',
                'title'   => esc_html__( 'Sidebar Background', 'axtra-essential' ),
                'desc'    => esc_html__( 'Upload a new background image to set the footer background.', 'axtra-essential' ),
                'default' => array(
                    'image'      => '',
                    'repeat'     => 'no-repeat',
                    'position'   => 'center center',
                    'attachment' => 'scroll',
                    'size'       => 'cover',
                   
                ),
                'output' => '.default-sidebar__widget .widget,.default-sidebar__widget'
            ),
           
            array(
                    'id'    => 'news__sidebars_padding_top',
                    'type'  => 'slider',
                    'title' => esc_html__( 'Sidebar Padding Top', 'axtra-essential' ),
                    'min'   => 0,
                    'max'   => 200,
                    'step'  => 1,
                    'unit'  => 'px',
                    
            ),
            array(
                    'id'    => 'news__sidebars_padding_bottom',
                    'type'  => 'slider',
                    'title' => esc_html__( 'Sidebar Padding Bottom', 'axtra-essential' ),
                    'min'   => 0,
                    'max'   => 200,
                    'step'  => 1,
                    'unit'  => 'px',
                    
            ),
        

         
            array(
              'type'    => 'subheading',
              'content' => esc_html__( 'Text & Link Color', 'axtra-essential' ),
            ),
            array(
                'id'     => 'news__sidebars_widget_title_color',
                'type'   => 'color',
                'title'  => esc_html__( 'Title Color', 'axtra-essential' ),
                'desc'   => esc_html__( 'Set Sideabr widget title color form here.', 'axtra-essential' ),
                'output' => '.default-sidebar__widget .widget .widget-title,.default-sidebar__widget .widget-title'
            ),
            array(
                'id'     => 'news__sidebars_widget_content_color',
                'type'   => 'color',
                'title'  => esc_html__( 'Content Color', 'axtra-essential' ),
                'desc'   => esc_html__( 'Set footer widget content color form here.', 'axtra-essential' ),
                'output' => '
                .default-sidebar__widget select, 
                .default-sidebar__widget .tagcloud a,
                .default-sidebar__widget ul li a,
                .rsswidget,
                .default-sidebar__widget,               
                .default-sidebar__widget .widget,               
                .default-sidebar__wrapper .widget_pages li a,
                .default-sidebar__wrapper .widget_meta li a, 
                .default-sidebar__wrapper .widget_nav_menu li a, 
                .default-sidebar__wrapper .widget_recent_entries li a,s
                .default-sidebar__widget ul li a,
                .default-sidebar__wrapper .widget_rss ul cite,
                .default-sidebar__wrapper .widget_recent_comments li a,
                .default-sidebar__wrapper .widget_rss ul a,
                .default-sidebar__wrapper .widget_rss .rssSummary,
                .default-sidebar__wrapper .widget_rss ul .rss-date,
                .default-sidebar__widget .widget ul li a.url'
            ),
            array(
                'id'     => 'sidebar_border_color',
                'type'   => 'border',
                'title'  => esc_html__( 'Border Color', 'axtra-essential' ),
                'output' => '.default-sidebar__widget'
            ),
            array(
                'id'    => 'sidebar_widget_title_margin_top',
                'type'  => 'slider',
                'title' => esc_html__( 'Title Margin Top', 'axtra-essential' ),
                'min'   => 0,
                'max'   => 200,
                'step'  => 1,
                'unit'  => 'px',
                
          ),
            array(
                'id'    => 'sidebar_widget_title_margin_bottom',
                'type'  => 'slider',
                'title' => esc_html__( 'Title Margin bottom', 'axtra-essential' ),
                'min'   => 0,
                'max'   => 200,
                'step'  => 1,
                'unit'  => 'px',
                
          ),
       
            array(
                'id'     => 'sidebars_link_color',
                'type'   => 'color',
                'title'  => esc_html__( 'Sideber links color', 'axtra-essential' ),
                'desc'   => esc_html__( 'Set the Sidebar area link color', 'axtra-essential' ),
                'output' => '.default-sidebar__widget .single-blog-post a .default-sidebar__widget .tagcloud a, .default-sidebar__widget .widget a, .default-sidebar__widget .widget ul li a.url,.default-sidebar__widget .widget ul li a.rsswidget'
            ),

            array(
                'id'     => 'sidebar_link_hover',
                'type'   => 'color',
                'title'  => esc_html__( 'Sidebar links Hover color', 'axtra-essential' ),
                'desc'   => esc_html__( 'Set the footer area link hover color', 'axtra-essential' ),
                'output' => '.default-sidebar__widget .single-blog-post a:hover, .default-sidebar__widget .tagcloud a:hover,.default-sidebar__widget .widget a:hover, .default-sidebar__widget .widget ul li a.url:hover,.default-sidebar__widget .widget ul li a.rsswidget:hover'
            ),

        )
    ) );