<?php 

// Control core classes for avoid errors
if( class_exists( 'CSF' ) ) {

    // Set a unique slug-like ID
    $post_prefix = 'axtra_post_options';
  
    // Create a metabox for post
    CSF::createMetabox( $post_prefix, array(
      'title'     => 'Settings',
      'post_type' => 'post',
    ) );
  
          // Header section
          CSF::createSection( $post_prefix, array(
            'title'  => 'Header',
            'fields' => array(
    
              array(
                'id'          => 'header_style_override',
                'type'        => 'select',
                'title'       => esc_html__('Override Header','axtra-essential'),            
                'options'     => array(
                  ''  => esc_html__('No option','axtra-essential'),
                  'theme_header'  => esc_html__('Theme Header','axtra-essential'),
                  'builder_header'  => esc_html__('Elementor Header','axtra-essential'),
                ),
                'default'     => ''
              ),
           
              array(
                  'id'      => 'header_style',
                  'type'    => 'image_select',
                  'title'   => esc_html__( 'Header Style', 'axtra-essential' ),
                  'desc'    => esc_html__( 'Select the header style which you want to show on your website.', 'axtra-essential' ),
                  'options' => array(
                    'style1' => AXTRA_ESSENTIAL_ASSETS_URL. '/images/header/header-1.png',
                   ),
                  'default' => '',
                  'dependency' => array( 'header_style_override', '==', 'theme_header' ),
              ),
                
              array(
                'id'      => 'transparent_header',
                'type'    => 'switcher',
                'title'   => esc_html__( 'Transparent Header', 'axtra-essential' ),
                'default' => false,
                'dependency' => array( 'header_style_override', '==', 'theme_header' ),
              ),
    
              array(
                'id'          => 'builder_header',
                'type'        => 'select',
                'title'       => esc_html__('Elementor Header','axtra-essential'),            
                'options'     => axtra_header_footer__custom_ele_type('header'),
                'default'     => '',
                'dependency'  => array( 'header_style_override', '==', 'builder_header' ),
                'after'       => wp_kses_post( $_hf_html ),
              ),
              
              array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Menu Background', 'axtra-essential' ),
                'dependency' => array( 'header_style_override', '==', 'theme_header' ),
            ),
            
            array(
                'id'      => 'menu_bg',
                'type'    => 'background',
                'title'   => esc_html__( 'Menu Background', 'axtra-essential' ),
                'desc'    => esc_html__( 'Set the menu background form here.', 'axtra-essential' ),
                'default' => array(
                    'image'      => '',
                    'repeat'     => 'repeat',
                    'position'   => 'center center',
                    'attachment' => 'scroll',
                    'size'       => '',
                    'color'      => '',
                ),
                'output_important'=> true,
                'output' =>'.single-post .default-blog-header',
                'dependency' => array( 'header_style_override', '==', 'theme_header' ),
            ),
            
            array(
                'id'     => 'header-menu-padding',
                'type'   => 'spacing',
                'title'  => esc_html__('Menu Padding','axtra-essential'),
                'output' => '.single-post .lawyer-header__inner,.single-post .lawyer-header__inner',
                'dependency' => array( 'header_style_override', '==', 'theme_header' ),
              ),
          
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Menu Color', 'axtra-essential' ),
                'dependency' => array( 'header_style_override', '==', 'theme_header' ),
            ),
    
            array(
                'id'      => 'menu_color',
                'type'    => 'color',
                'title'   => esc_html__( 'Menu Color', 'axtra-essential' ),
                'desc'    => esc_html__( 'Set the menu color by color picker', 'axtra-essential' ),
                'default' => '',
                'output'  => '.single-post .default-blog-header .nav-item a,.single-post .logo-title a',
                'dependency' => array( 'header_style_override', '==', 'theme_header' ),
            ),
            array(
                'id'      => 'menu_hover',
                'type'    => 'color',
                'title'   => esc_html__( 'Menu Hover Color', 'axtra-essential' ),
                'desc'    => esc_html__( 'Set the menu hover color by color picker', 'axtra-essential' ),
                'default' => '',
               
                'output'  => '.single-post .default-blog-header .nav-item:hover > a',
                'dependency' => array( 'header_style_override', '==', 'theme_header' ),
            ),
           
            array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Menu Dropdown Color & Hover', 'axtra-essential' ),
                'dependency' => array( 'header_style_override', '==', 'theme_header' ),
            ),
            array(
                'id'      => 'menu_dropdown_color',
                'type'    => 'color',
                'title'   => esc_html__( 'Menu Dropdown Color', 'axtra-essential' ),
                'desc'    => esc_html__( 'Set the menu dropdown color by color picker', 'axtra-essential' ),
                'default' => '',
                'output'  => '.single-post .default-blog-header .nav-item .dp-menu .nav-item a',
                'dependency' => array( 'header_style_override', '==', 'theme_header' ),
            ),
            array(
                'id'      => 'menu_dropdown_hover__text_color',
                'type'    => 'color',
                'title'   => esc_html__( 'Menu Dropdown Hover Color', 'axtra-essential' ),
                'desc'    => esc_html__( 'Set the menu dropdown hover color by color picker', 'axtra-essential' ),
                'default' => '',
                'output'  => '.single-post .default-blog-header .nav-item .dp-menu .nav-item:hover a',
                'dependency' => array( 'header_style_override', '==', 'theme_header' ),
            ),
            array(
                'id'      => 'menu_dropdown_uibg_color',
                'type'    => 'color',
                'title'   => esc_html__( 'Menu Dropdown bgColor', 'axtra-essential' ),
                'desc'    => esc_html__( 'Set the menu dropdown hover color by color picker', 'axtra-essential' ),
                'default' => '',
                'output_mode' => 'background',
                'output'  => '.single-post .main-menu ul.dp-menu,.single-post .main-menu ul.dp-menu ul',
                'dependency' => array( 'header_style_override', '==', 'theme_header' ),
            ),
            
            array(
              'type'    => 'heading',
              'content' => esc_html__('Mobile/ Offcanvas','axtra-essential'),
            ),
          
          array(
          
              'id'      => 'offcanvas_container_image',
              'type'    => 'background',
              'title'   => esc_html__( 'Upload Background', 'axtra-essential' ),
              'desc'    => esc_html__( 'Upload main Image width 400px and height 100%.', 'axtra-essential' ),
              'output' => '.offcanvas__area .offcanvas',
              'dependency' => array( 'header_style_override', '==', 'theme_header' ),
          ),
          array(
              'id'     => 'offcanvas_container_color',
              'type'   => 'color',
              'title'  => esc_html__( 'Color', 'axtra-essential' ),
              'output' => '
              .single-post.light .offcanvas__title,
              .single-post .offcanvas__title,
              .single-post .offcanvas__area .offcanvas ul li a ,
              .single-post .offcanvas__area .offcanvas i,
              .single-post .offcanvas__area .offcanvas p,
              .single-post .offcanvas__area .offcanvas p
              ',
              'output_important' => true,
              'dependency' => array( 'header_style_override', '==', 'theme_header' ),
          ),
          
          array(
              'id'     => 'offcanvas_menu_border_color',
              'type'   => 'color',
              'title'  => esc_html__( 'Menu Border Color', 'axtra-essential' ),
              'output' => '
              .single-post .offcanvas__menu-wrapper.mean-container .mean-nav > ul > li:last-child > a,
              .single-post .offcanvas__menu-wrapper.mean-container .mean-nav > ul > li > a
              ',
              'output_important' => true,
              'output_mode' => 'border-color',
              'dependency' => array( 'header_style_override', '==', 'theme_header' ),
          ),
      
    
            )
    ) );
    CSF::createSection( $post_prefix, array(
      'title'  => esc_html__('Footer','axtra-essential'),
      'fields' => array(
          
          array(
            'id'          => 'footer_style_override',
            'type'        => 'select',
            'title'       => esc_html__('Override Footer','axtra-essential'),            
            'options'     => array(
              ''  => esc_html__('No option','axtra-essential'),
              'theme_footer'  => esc_html__('Theme Footer','axtra-essential'),
              'builder_footer'  => esc_html__('Elementor Footer','axtra-essential'),
            ),
            'default'     => ''
          ),
       
          array(
              'id'      => 'footer_style',
              'type'    => 'image_select',
              'title'   => esc_html__( 'Footer Style', 'axtra-essential' ),
              'desc'    => esc_html__( 'Select the footer style which you want to show on your website.', 'axtra-essential' ),
              'options' => array(
                'style2'       => AXTRA_ESSENTIAL_ASSETS_URL. '/images/footer/footer_2.png',
               ),
              'default' => 'style2',
              'dependency' => array( 'footer_style_override', '==', 'theme_footer' ),
          ),

          array(
            'id'          => 'builder_footer',
            'type'        => 'select',
            'title'       => esc_html__('Elementor Footer','axtra-essential'),            
            'options'     => axtra_header_footer__custom_ele_type('footer'),
            'default'     => '',
            'dependency'  => array( 'footer_style_override', '==', 'builder_footer' ),
            'after'       => wp_kses_post( $_hf_html ),
          ),           
      )
    ) );
    CSF::createSection( $post_prefix, array(
      'title'  =>  esc_html__( 'Layout', 'axtra-essential'),
      'fields' => array(
      
          array(
              'id'      => 'override_post_layout',
              'type'    => 'switcher',
              'title'   => esc_html__( 'Override Layout', 'axtra-essential' ),
              'default' => false,
             
          ), 
      
          array(
            'id'        => 'post_layout',
            'type'      => 'image_select',
            'title'     => esc_html__('Layout','axtra-essential'),
            'options'   => array(
              'default' => AXTRA_ESSENTIAL_ASSETS_URL.'images/default-layout.png',
              'health-one' => 'http://codestarframework.com/assets/images/placeholder/80x80-2c3e50.gif',
              'athlete' => 'http://codestarframework.com/assets/images/placeholder/80x80-2c3e50.gif',                               
              'elementor_builder' => AXTRA_ESSENTIAL_ASSETS_URL . 'images/elementor.svg'
            ),
            'default'   => '',
            'dependency' => array( 'override_post_layout', '==', true )                       
          ),

          array(
              'id'      => 'preset_blog_banner',
              'type'    => 'switcher',
              'title'   => esc_html__( 'Banner', 'axtra-essential' ),
              'default' => false,
              'dependency' => array( 'post_layout', 'any', 'health-one,athlete' )
          ), 
        
          array(
              'id'      => 'preset_blog_view',
              'type'    => 'switcher',
              'title'   => esc_html__( 'View', 'axtra-essential' ),
              'default' => false,
              'dependency' => array( 'post_layout', 'any', 'health-one,athlete' )
          ),
          
          array(
              'id'      => 'preset_blog_sidebar',
              'type'    => 'switcher',
              'title'   => esc_html__( 'Sidebar', 'axtra-essential' ),
              'default' => false,
              'dependency' => array( 'post_layout', 'any', 'health-one,athlete' )
          ),        
        
          array(
            'id'          => 'wcf-elementor-post-layout-id',
            'type'        => 'select',
            'title'       => 'Select with Layout',
            'placeholder' => 'Select Layout',
            'chosen'      => false,
            'ajax'        => true,
            'multiple'    => false,
            'sortable'    => false,
            'options'     => 'posts',
            'query_args'  => array(
              'post_type' => 'wcf-single-post'
            ),
            'dependency' => array( 'post_layout', '==', 'elementor_builder' )
          ),
  
      )
    ) );
    
    CSF::createSection( $post_prefix, array(
      'title'  =>  esc_html__( 'Video', 'axtra-essential'),
      'fields' => array(  
        array(
          'id'    => 'feature_video_id',
          'type'  => 'text',
          'title'  =>  esc_html__( 'Video Url', 'axtra-essential'),
          'desc'  =>  esc_html__( 'Provide Url here From Youtube', 'axtra-essential'),
        ),  
      )
    ) );

    CSF::createSection( $post_prefix, array(
      'title'  =>  esc_html__( 'Audio', 'axtra-essential'),
      'fields' => array(  
            array(
              'id'    => 'feature_audio',
              'type'  => 'text',
              'title'  =>  esc_html__( 'Audio URL', 'axtra-essential'),
              'desc'  =>  esc_html__( 'Provide SoundCloud audio url', 'axtra-essential'),
            ),  
      )
    ) );   
  
  
  }
  