<?php

  $all_registerd_taxonomy = axtra_get_cache_tax_types();     
  $all_registerd_post_types = axtra_get_cache_post_types();    
  
  $skip_posts_types = [
    'nav_menu_item',
    'e-landing-page',
    'product',
    'product_variation',
    'shop_order',
    'shop_order_refund',
    'shop_coupon',
    'shop_order_placehold',
    'wpcf7_contact_form',
    'mc4wp-form',
    'wcf-custom-font',    
    'wcf-single-post',
    'wcf-blog-tpl',
    'wcf-search-tpl',
    'wcf-error-tpl',
    'wcf-hf-tpl',
    'patterns_ai_data',
  ];
  
  if(is_array($all_registerd_post_types)){
    foreach($all_registerd_post_types as $key => $type){
        if(in_array($key,$skip_posts_types)){
           unset($all_registerd_post_types[$key]);
        }
    } 
  }
   // Taxonomy
  $skips_tax = [
        'nav_menu',
        'link_category',
        'wp_theme', 
        'wp_template_part_area', 
        'wp_pattern_category',
        'elementor_library_type', 
        'elementor_library_category', 
        'product_type', 
        'product_visibility' ,    
        'product_shipping_class', 
        'pa_color', 
        'pa_size',
  ];
  
  if( isset( $_GET[ 'post' ] ) && is_numeric( $_GET[ 'post' ] ) ){
    $already_used = axtra_custom_taxonomy_used_by_meta( $_GET[ 'post' ] , 'wcf_blog_archive_type' ); 
    if(is_array($already_used)){
        $skips_tax = array_merge($skips_tax, $already_used);
    }
  }
 
  if(is_array($all_registerd_taxonomy)){
    foreach($all_registerd_taxonomy as $key => $item){
        if(in_array($key,$skips_tax)){
           unset($all_registerd_taxonomy[$key]);
        }
    } 
  }
$all_registerd_taxonomy = array_merge($all_registerd_taxonomy, $all_registerd_post_types);
// Include defaults
$all_registerd_taxonomy['blog'] = esc_html__('Blog (Archive, Category , Tags, Author, Date)', 'axtra-essential');
$all_registerd_taxonomy['author'] = esc_html__('Author Archive', 'axtra-essential');
// Control core classes for avoid errors
if( class_exists( 'CSF' ) ) {
    // Set a unique slug-like ID    
    $post_prefix = 'wcf_blog_archive_options';    
    // Create a metabox for post
    CSF::createMetabox( $post_prefix, array(
      'title'     => 'Settings',
      'post_type' => 'wcf-blog-tpl',
      'data_type' => 'unserialize',
      //'context'   => 'side',
    ) );
      
    // Header section
    CSF::createSection( $post_prefix, array(
      'title'  =>  esc_html__( 'Archive Settings', 'axtra-essential'),      
      'fields' => array( 
      
         array(
          'id'          => 'wcf_blog_archive_type',
          'type'        => 'select',
          'chosen'      => true,
          'settings' => [ 'width' => '380px' ],
          'title'       => esc_html__('Select Taxonomy','axtra-essential'),
          'placeholder' => esc_html__('Select an option','axtra-essential'),
          'options'      => $all_registerd_taxonomy,
          'default'     => ''
        ),  
        
        array(
          'id'      => 'wcf_essential_settings_blog_layoutactivate',
          'type'    => 'switcher',
          'title'   => esc_html__( 'Activate', 'axtra-essential' ),
          'default' => false
        ),  
        
      )
    ) );    
   
}

