import { cn } from "./utils";

export const IconCross = ({ size = "12", className }) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width={size}
    height={size}
    className={cn("fill-text-2 hover:fill-text", className)}
    viewBox="0 0 12 12"
    fill="currentColor"
  >
    <g clipPath="url(#clip0_3993_3560)">
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M10.995 1.00507C11.2684 1.27844 11.2684 1.72166 10.995 1.99502L1.99502 10.995C1.72166 11.2684 1.27844 11.2684 1.00507 10.995C0.731707 10.7217 0.731707 10.2784 1.00507 10.0051L10.0051 1.00507C10.2784 0.731707 10.7217 0.731707 10.995 1.00507Z"
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M1.00507 1.00507C1.27844 0.731707 1.72166 0.731707 1.99502 1.00507L10.995 10.0051C11.2684 10.2784 11.2684 10.7217 10.995 10.995C10.7217 11.2684 10.2784 11.2684 10.0051 10.995L1.00507 1.99502C0.731707 1.72166 0.731707 1.27844 1.00507 1.00507Z"
      />
    </g>
    <defs>
      <clipPath id="clip0_3993_3560">
        <rect width="12" height="12" fill="white" />
      </clipPath>
    </defs>
  </svg>
);

export const IconCopy = ({ size = "12", className }) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width={size}
    height={size}
    className={cn("fill-text-2 hover:fill-text", className)}
    viewBox="0 0 12 12"
    fill="currentColor"
  >
    <g clip-path="url(#clip0_3993_3573)">
      <path
        fill-rule="evenodd"
        clip-rule="evenodd"
        d="M1.375 3.375C1.375 3.09886 1.59886 2.875 1.875 2.875H8.625C8.90114 2.875 9.125 3.09886 9.125 3.375V10.125C9.125 10.4011 8.90114 10.625 8.625 10.625H1.875C1.59886 10.625 1.375 10.4011 1.375 10.125V3.375ZM2.375 3.875V9.625H8.125V3.875H2.375Z"
      />
      <path
        fill-rule="evenodd"
        clip-rule="evenodd"
        d="M2.87476 1.875C2.87476 1.59886 3.09861 1.375 3.37476 1.375H10.1248C10.4009 1.375 10.6248 1.59886 10.6248 1.875V8.625C10.6248 8.90114 10.4009 9.125 10.1248 9.125C9.84861 9.125 9.62476 8.90114 9.62476 8.625V2.375H3.37476C3.09861 2.375 2.87476 2.15114 2.87476 1.875Z"
      />
    </g>
    <defs>
      <clipPath id="clip0_3993_3573">
        <rect width="12" height="12" fill="white" />
      </clipPath>
    </defs>
  </svg>
);

export const IconDelete = ({ size = "12", className }) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width={size}
    height={size}
    className={cn("fill-text-2 hover:fill-text", className)}
    viewBox="0 0 12 12"
    fill="currentColor"
  >
    <g clip-path="url(#clip0_3993_3577)">
      <path
        fill-rule="evenodd"
        clip-rule="evenodd"
        d="M1.25 2.625C1.25 2.27982 1.52982 2 1.875 2H10.125C10.4702 2 10.75 2.27982 10.75 2.625C10.75 2.97018 10.4702 3.25 10.125 3.25H1.875C1.52982 3.25 1.25 2.97018 1.25 2.625Z"
      />
      <path
        fill-rule="evenodd"
        clip-rule="evenodd"
        d="M3.625 1.125C3.625 0.848858 3.84886 0.625 4.125 0.625H7.875C8.15114 0.625 8.375 0.848858 8.375 1.125C8.375 1.40114 8.15114 1.625 7.875 1.625H4.125C3.84886 1.625 3.625 1.40114 3.625 1.125Z"
      />
      <path
        fill-rule="evenodd"
        clip-rule="evenodd"
        d="M2.625 2.125C2.90114 2.125 3.125 2.34886 3.125 2.625V9.625H8.875V2.625C8.875 2.34886 9.09886 2.125 9.375 2.125C9.65114 2.125 9.875 2.34886 9.875 2.625V9.75C9.875 9.98206 9.78281 10.2046 9.61872 10.3687C9.45462 10.5328 9.23206 10.625 9 10.625H3C2.76794 10.625 2.54538 10.5328 2.38128 10.3687C2.21719 10.2046 2.125 9.98206 2.125 9.75V2.625C2.125 2.34886 2.34886 2.125 2.625 2.125Z"
      />
    </g>
    <defs>
      <clipPath id="clip0_3993_3577">
        <rect width="12" height="12" fill="white" />
      </clipPath>
    </defs>
  </svg>
);

export const IconPlus = ({ size = "12", className }) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width={size}
    height={size}
    className={cn("fill-text-2 hover:fill-text", className)}
    viewBox="0 0 12 12"
    fill="currentColor"
  >
    <g clip-path="url(#clip0_4001_2972)">
      <path
        fill-rule="evenodd"
        clip-rule="evenodd"
        d="M6.625 0.75C6.625 0.404822 6.34518 0.125 6 0.125C5.65482 0.125 5.375 0.404822 5.375 0.75V5.375H0.75C0.404822 5.375 0.125 5.65482 0.125 6C0.125 6.34518 0.404822 6.625 0.75 6.625H5.375V11.25C5.375 11.5952 5.65482 11.875 6 11.875C6.34518 11.875 6.625 11.5952 6.625 11.25V6.625H11.25C11.5952 6.625 11.875 6.34518 11.875 6C11.875 5.65482 11.5952 5.375 11.25 5.375H6.625V0.75Z"
      />
    </g>
    <defs>
      <clipPath id="clip0_4001_2972">
        <rect width="12" height="12" fill="white" />
      </clipPath>
    </defs>
  </svg>
);
export const IconPlus2 = ({ size = "16", className }) => (
  <svg
    width={size}
    height={size}
    className={cn("fill-text-2 hover:fill-text", className)}
    viewBox="0 0 16 16"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path
      fill-rule="evenodd"
      clip-rule="evenodd"
      d="M8.75 3C8.75 2.58579 8.41421 2.25 8 2.25C7.58579 2.25 7.25 2.58579 7.25 3V7.25H3C2.58579 7.25 2.25 7.58579 2.25 8C2.25 8.41421 2.58579 8.75 3 8.75H7.25V13C7.25 13.4142 7.58579 13.75 8 13.75C8.41421 13.75 8.75 13.4142 8.75 13V8.75H13C13.4142 8.75 13.75 8.41421 13.75 8C13.75 7.58579 13.4142 7.25 13 7.25H8.75V3Z"
    />
  </svg>
);

export const IconChevronDown = ({ size = "12", className }) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width={size}
    height={size}
    className={cn("fill-text-2 hover:fill-text", className)}
    viewBox="0 0 12 12"
    fill="currentColor"
  >
    <g clip-path="url(#clip0_3993_3566)">
      <path
        fill-rule="evenodd"
        clip-rule="evenodd"
        d="M0.969914 3.78998C1.26281 3.49709 1.73768 3.49709 2.03057 3.78998L6.00024 7.75965L9.96991 3.78998C10.2628 3.49709 10.7377 3.49709 11.0306 3.78998C11.3235 4.08288 11.3235 4.55775 11.0306 4.85064L6.53057 9.35064C6.23768 9.64354 5.76281 9.64354 5.46991 9.35064L0.969914 4.85064C0.677021 4.55775 0.677021 4.08288 0.969914 3.78998Z"
      />
    </g>
    <defs>
      <clipPath id="clip0_3993_3566">
        <rect width="12" height="12" fill="white" />
      </clipPath>
    </defs>
  </svg>
);

export const IconHelp = ({ size = "14", className }) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width={size}
    height={size}
    className={cn("fill-text-2 hover:fill-text", className)}
    viewBox="0 0 14 14"
    fill="currentColor"
  >
    <g clip-path="url(#clip0_3484_5478)">
      <path d="M7 1.80005C5.87512 1.80005 4.7755 2.13361 3.8402 2.75857C2.90489 3.38352 2.17591 4.27178 1.74544 5.31104C1.31496 6.35029 1.20233 7.49386 1.42179 8.59713C1.64124 9.70039 2.18292 10.7138 2.97833 11.5092C3.77374 12.3046 4.78716 12.8463 5.89043 13.0658C6.99369 13.2852 8.13726 13.1726 9.17651 12.7421C10.2158 12.3116 11.104 11.5827 11.729 10.6474C12.3539 9.71205 12.6875 8.61243 12.6875 7.48755C12.6859 5.97962 12.0862 4.53391 11.0199 3.46764C9.95365 2.40137 8.50793 1.80164 7 1.80005ZM6.78125 4.42505C6.91105 4.42505 7.03793 4.46354 7.14585 4.53565C7.25377 4.60776 7.33788 4.71025 7.38755 4.83016C7.43722 4.95008 7.45021 5.08203 7.42489 5.20933C7.39957 5.33663 7.33707 5.45356 7.24529 5.54534C7.15351 5.63712 7.03658 5.69962 6.90928 5.72494C6.78198 5.75026 6.65003 5.73726 6.53012 5.68759C6.4102 5.63792 6.30771 5.55381 6.2356 5.44589C6.16349 5.33797 6.125 5.21109 6.125 5.0813C6.125 4.90725 6.19414 4.74033 6.31721 4.61726C6.44028 4.49419 6.6072 4.42505 6.78125 4.42505ZM7.4375 10.55C7.20544 10.55 6.98288 10.4579 6.81878 10.2938C6.65469 10.1297 6.5625 9.90711 6.5625 9.67505V7.48755C6.44647 7.48755 6.33519 7.44145 6.25314 7.35941C6.1711 7.27736 6.125 7.16608 6.125 7.05005C6.125 6.93402 6.1711 6.82274 6.25314 6.74069C6.33519 6.65864 6.44647 6.61255 6.5625 6.61255C6.79457 6.61255 7.01713 6.70474 7.18122 6.86883C7.34531 7.03292 7.4375 7.25548 7.4375 7.48755V9.67505C7.55353 9.67505 7.66481 9.72114 7.74686 9.80319C7.82891 9.88524 7.875 9.99652 7.875 10.1125C7.875 10.2286 7.82891 10.3399 7.74686 10.4219C7.66481 10.504 7.55353 10.55 7.4375 10.55Z" />
    </g>
    <defs>
      <clipPath id="clip0_3484_5478">
        <rect width="14" height="14" fill="white" />
      </clipPath>
    </defs>
  </svg>
);

export const IconPlaceholderS = ({ size = "10", className }) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width={size}
    height={size}
    className={cn("fill-placeholder", className)}
    viewBox="0 0 10 10"
    fill="currentColor"
  >
    <path d="M6.95801 6.93359C6.95801 6.75098 6.92936 6.58984 6.87207 6.4502C6.81836 6.30697 6.72168 6.17806 6.58203 6.06348C6.44596 5.94889 6.25618 5.83968 6.0127 5.73584C5.77279 5.632 5.46842 5.52637 5.09961 5.41895C4.71289 5.30436 4.36377 5.17725 4.05225 5.0376C3.74072 4.89437 3.47396 4.73145 3.25195 4.54883C3.02995 4.36621 2.85986 4.15674 2.7417 3.92041C2.62354 3.68408 2.56445 3.41374 2.56445 3.10938C2.56445 2.80501 2.62712 2.52393 2.75244 2.26611C2.87777 2.0083 3.0568 1.78451 3.28955 1.59473C3.52588 1.40137 3.80697 1.25098 4.13281 1.14355C4.45866 1.03613 4.8221 0.982422 5.22314 0.982422C5.81038 0.982422 6.30811 1.09521 6.71631 1.3208C7.12809 1.54281 7.44141 1.83464 7.65625 2.19629C7.87109 2.55436 7.97852 2.9375 7.97852 3.3457H6.94727C6.94727 3.05208 6.8846 2.79248 6.75928 2.56689C6.63395 2.33773 6.44417 2.15869 6.18994 2.02979C5.93571 1.8973 5.61344 1.83105 5.22314 1.83105C4.85433 1.83105 4.54997 1.88656 4.31006 1.99756C4.07015 2.10856 3.89111 2.25895 3.77295 2.44873C3.65837 2.63851 3.60107 2.85514 3.60107 3.09863C3.60107 3.26335 3.63509 3.41374 3.70312 3.5498C3.77474 3.68229 3.88395 3.80583 4.03076 3.92041C4.18115 4.03499 4.37093 4.14062 4.6001 4.2373C4.83284 4.33398 5.11035 4.42708 5.43262 4.5166C5.87663 4.64193 6.25977 4.78158 6.58203 4.93555C6.9043 5.08952 7.16927 5.26318 7.37695 5.45654C7.58822 5.64632 7.74398 5.86296 7.84424 6.10645C7.94808 6.34635 8 6.61849 8 6.92285C8 7.24154 7.93555 7.52979 7.80664 7.7876C7.67773 8.04541 7.49333 8.26562 7.25342 8.44824C7.01351 8.63086 6.72526 8.7723 6.38867 8.87256C6.05566 8.96924 5.68327 9.01758 5.27148 9.01758C4.90983 9.01758 4.55355 8.96745 4.20264 8.86719C3.85531 8.76693 3.53841 8.61654 3.25195 8.41602C2.96908 8.21549 2.7417 7.96842 2.56982 7.6748C2.40153 7.3776 2.31738 7.03385 2.31738 6.64355H3.34863C3.34863 6.91211 3.40055 7.14307 3.50439 7.33643C3.60824 7.5262 3.74967 7.68376 3.92871 7.80908C4.11133 7.93441 4.31722 8.02751 4.54639 8.08838C4.77913 8.14567 5.02083 8.17432 5.27148 8.17432C5.63314 8.17432 5.93929 8.12419 6.18994 8.02393C6.44059 7.92367 6.63037 7.78044 6.75928 7.59424C6.89176 7.40804 6.95801 7.18783 6.95801 6.93359Z" />
  </svg>
);

export const IconCheck = ({ size = "12", className }) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width={size}
    height={size}
    className={cn("fill-text-2 hover:fill-text", className)}
    viewBox="0 0 12 12"
    fill="currentColor"
  >
    <g clip-path="url(#clip0_3484_5490)">
      <path
        fill-rule="evenodd"
        clip-rule="evenodd"
        d="M10.9419 2.93306C11.186 3.17714 11.186 3.57286 10.9419 3.81694L4.94194 9.81694C4.69786 10.061 4.30214 10.061 4.05806 9.81694L1.43306 7.19194C1.18898 6.94786 1.18898 6.55214 1.43306 6.30806C1.67714 6.06398 2.07286 6.06398 2.31694 6.30806L4.5 8.49112L10.0581 2.93306C10.3021 2.68898 10.6979 2.68898 10.9419 2.93306Z"
      />
    </g>
    <defs>
      <clipPath id="clip0_3484_5490">
        <rect width="12" height="12" fill="white" />
      </clipPath>
    </defs>
  </svg>
);

export const IconPlay = ({ size = "16", className }) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width={size}
    height={size}
    className={cn("fill-text-2 hover:fill-text", className)}
    viewBox="0 0 16 16"
    fill="currentColor"
  >
    <g clip-path="url(#clip0_4071_3480)">
      <path
        fill-rule="evenodd"
        clip-rule="evenodd"
        d="M4.4574 1.51622C4.63067 1.42082 4.82604 1.37278 5.0238 1.37696C5.22156 1.38114 5.41472 1.43739 5.58381 1.54003L5.58558 1.54111L14.5881 7.04711C14.5886 7.0474 14.5891 7.04769 14.5895 7.04798C14.7528 7.14713 14.8878 7.28662 14.9816 7.45305C15.0757 7.61997 15.1252 7.80833 15.1252 7.99992C15.1252 8.19152 15.0757 8.37988 14.9816 8.54679C14.8878 8.71322 14.7528 8.85271 14.5895 8.95187C14.5891 8.95216 14.5886 8.95245 14.5881 8.95273L5.58558 14.4587L5.58381 14.4598C5.41472 14.5625 5.22156 14.6187 5.0238 14.6229C4.82604 14.6271 4.63067 14.579 4.4574 14.4836C4.28412 14.3882 4.13906 14.2488 4.03685 14.0795C3.93464 13.9101 3.87889 13.7168 3.87522 13.519L3.875 13.5074L3.87511 2.48081C3.87878 2.28304 3.93464 2.08974 4.03685 1.92039C4.13907 1.75104 4.28412 1.61163 4.4574 1.51622ZM5.12511 2.72474L13.7503 7.99992L5.12511 13.2751V2.72474Z"
      />
    </g>
    <defs>
      <clipPath id="clip0_4071_3480">
        <rect width="16" height="16" fill="white" />
      </clipPath>
    </defs>
  </svg>
);

export const IconAlert = ({ size = "24", className }) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width={size}
    height={size}
    className={cn("fill-text-3", className)}
    viewBox="0 0 24 24"
    fill="currentColor"
  >
    <g clip-path="url(#clip0_4071_3550)">
      <path d="M22.2005 17.6291L14.0021 3.39129C13.7972 3.04247 13.5047 2.75325 13.1536 2.55229C12.8026 2.35133 12.4051 2.24561 12.0005 2.24561C11.596 2.24561 11.1985 2.35133 10.8474 2.55229C10.4963 2.75325 10.2038 3.04247 9.99895 3.39129L1.80052 17.6291C1.60339 17.9665 1.49951 18.3502 1.49951 18.741C1.49951 19.1317 1.60339 19.5155 1.80052 19.8529C2.00276 20.2038 2.29474 20.4946 2.64648 20.6954C2.99822 20.8962 3.39706 20.9999 3.80208 20.9957H20.199C20.6037 20.9995 21.0021 20.8958 21.3535 20.6949C21.7049 20.4941 21.9966 20.2035 22.1986 19.8529C22.396 19.5156 22.5003 19.132 22.5006 18.7412C22.5009 18.3505 22.3974 17.9667 22.2005 17.6291ZM11.2505 9.74567C11.2505 9.54675 11.3295 9.35599 11.4702 9.21534C11.6108 9.07468 11.8016 8.99567 12.0005 8.99567C12.1994 8.99567 12.3902 9.07468 12.5308 9.21534C12.6715 9.35599 12.7505 9.54675 12.7505 9.74567V13.4957C12.7505 13.6946 12.6715 13.8853 12.5308 14.026C12.3902 14.1666 12.1994 14.2457 12.0005 14.2457C11.8016 14.2457 11.6108 14.1666 11.4702 14.026C11.3295 13.8853 11.2505 13.6946 11.2505 13.4957V9.74567ZM12.0005 17.9957C11.778 17.9957 11.5605 17.9297 11.3755 17.8061C11.1905 17.6825 11.0463 17.5068 10.9612 17.3012C10.876 17.0956 10.8537 16.8694 10.8971 16.6512C10.9405 16.433 11.0477 16.2325 11.205 16.0752C11.3624 15.9178 11.5628 15.8107 11.781 15.7673C11.9993 15.7239 12.2255 15.7462 12.431 15.8313C12.6366 15.9165 12.8123 16.0606 12.9359 16.2457C13.0595 16.4307 13.1255 16.6482 13.1255 16.8707C13.1255 17.169 13.007 17.4552 12.796 17.6662C12.585 17.8771 12.2989 17.9957 12.0005 17.9957Z" />
    </g>
    <defs>
      <clipPath id="clip0_4071_3550">
        <rect width="24" height="24" fill="white" />
      </clipPath>
    </defs>
  </svg>
);
