function _createForOfIteratorHelper(r, e) {
	var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"];
	if (!t) {
		if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) {
			t && (r = t);
			var _n = 0,
				F = function F() {};
			return {
				s: F,
				n: function n() {
					return _n >= r.length ? {
						done: !0
					} : {
						done: !1,
						value: r[_n++]
					};
				},
				e: function e(r) {
					throw r;
				},
				f: F
			};
		}
		throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
	}
	var o, a = !0,
		u = !1;
	return {
		s: function s() {
			t = t.call(r);
		},
		n: function n() {
			var r = t.next();
			return a = r.done, r;
		},
		e: function e(r) {
			u = !0, o = r;
		},
		f: function f() {
			try {
				a || null == t["return"] || t["return"]();
			} finally {
				if (u) throw o;
			}
		}
	};
}

function _unsupportedIterableToArray(r, a) {
	if (r) {
		if ("string" == typeof r) return _arrayLikeToArray(r, a);
		var t = {}.toString.call(r).slice(8, -1);
		return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0;
	}
}

function _arrayLikeToArray(r, a) {
	(null == a || a > r.length) && (a = r.length);
	for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e];
	return n;
}
(function($) {
	/**
	 * @param $scope The Widget wrapper element as a jQuery element
	 * @param $ The jQuery alias
	 */

	var Wcf_Lottie = function Wcf_Lottie($scope, $) {
		var $container = $scope.find('.elementor-widget-container');
		var settings = JSON.parse($scope.find('.wcf-lottie-wrp').attr('data-settings'));
		var s_id = '#wcf-lottie-player-' + $scope.attr('data-id');
		var player_element = document.querySelector(s_id);
		var observer = new IntersectionObserver(function(entries, observer) {
			var _iterator = _createForOfIteratorHelper(entries),
				_step;
			try {
				for (_iterator.s(); !(_step = _iterator.n()).done;) {
					var entry = _step.value;
					if (entry.isIntersecting && ('viewport' == settings.event || settings.play == 'inview')) {
						player_element.play();
					}
				}
			} catch (err) {
				_iterator.e(err);
			} finally {
				_iterator.f();
			}
		});
		player_element.addEventListener("click", function() {
			if (settings.event === 'click') {
				player_element.play();
			}
			if (settings.pause === 'onclick') {
				player_element.pause();
			}
		});
		player_element.addEventListener("mouseout", function() {
			if (settings.pause === 'onmouseleave') {
				player_element.pause();
			}
		});
		player_element.addEventListener("mouseover", function() {
			if (settings.play === 'onhover') {
				player_element.play();
			}
		});
		observer.observe(player_element);
		var $start_point = settings.start_point == '' ? 0 : parseInt(settings.start_point);
		var $end_point = settings.end_point == '' ? 280 : parseInt(settings.end_point);
		if ("cursor_move" == settings.event) {
			var $cursor_move = {
				position: {
					x: [0, 1],
					y: [0, 1]
				},
				type: "seek",
				frames: [$start_point, $end_point]
			};
			LottieInteractivity.create({
				player: s_id,
				mode: "cursor",
				actions: [$cursor_move]
			});
		}
		if (settings.event === 'scroll') {
			var $scroll_move = {
				visibility: [0, 1],
				type: "seek",
				frames: [$start_point, $end_point]
			};
			LottieInteractivity.create({
				player: s_id,
				mode: 'scroll',
				actions: [{
					visibility: [0, 1],
					type: 'seek',
					frames: $scroll_move
				}]
			});
		}
		if (settings.event === 'hover') {
			LottieInteractivity.create({
				player: s_id,
				mode: "cursor",
				actions: [{
					type: "hover",
					forceFlag: true
				}]
			});
		}
	};

	// Make sure you run this code under Elementor.
	$(window).on('elementor/frontend/init', function() {
		elementorFrontend.hooks.addAction('frontend/element_ready/wcf--lottie-animation.default', Wcf_Lottie);
	});
})(jQuery);
//# sourceMappingURL=lottie.js.map
