(function() {
	var WgsapDrawSvg = function WgsapDrawSvg($scope) {
		// Get the data attributes for animation control using native JavaScript
		var gsapElement = $scope[0].querySelector('.gsap-draw-svg');
		var scroll_trigger = Boolean(gsapElement.getAttribute('data-scroll_trigger') || false);
		var method = gsapElement.getAttribute('data-method') || 'fromTo';
		var draw_percent = gsapElement.getAttribute('data-draw_percent') || '0%';
		var from = gsapElement.getAttribute('data-from') || '0%';
		var to = gsapElement.getAttribute('data-to') || '100%';
		var duration = parseFloat(gsapElement.getAttribute('data-duration')) || 1;
		var delay = parseFloat(gsapElement.getAttribute('data-delay')) || 0;
		var repeat = parseFloat(gsapElement.getAttribute('data-repeat')) || 0;
		var ease = gsapElement.getAttribute('data-ease') || 'power2.inOut';
		var timeline_yoyo = Boolean(gsapElement.getAttribute('data-timeline_yoyo') || false);
		var scrub = Boolean(gsapElement.getAttribute('data-scrub') || false);
		var scrollTriggerStart = gsapElement.getAttribute('data-scrolltrigger-start') || 'top bottom';
		var scrollTriggerEnd = gsapElement.getAttribute('data-scrolltrigger-end') || 'bottom top';
		var cls = ".elementor-element-".concat($scope[0].getAttribute('data-id'), " svg path");
		// Ensure paths are available and correctly selected
		var paths = Array.from(document.querySelectorAll(cls));
		if (paths.length === 0) {
			console.log("No paths found for animation!");
			return;
		}
		if (!scroll_trigger) {
			var tl = gsap.timeline({
				duration: duration,
				delay: delay,
				repeat: repeat,
				yoyo: timeline_yoyo
			});
			paths.forEach(function(path, i) {
				if (method === 'fromTo') {
					tl.fromTo(path, {
						drawSVG: from
					}, {
						drawSVG: to,
						duration: duration,
						delay: i * delay,
						ease: ease
					});
				} else {
					tl[method](path, {
						drawSVG: draw_percent,
						duration: duration,
						delay: i * delay,
						ease: ease
					});
				}
			});
		} else {
			// Register GSAP plugin if not already registered
			if (!gsap.plugins.ScrollTrigger && ScrollTrigger) {
				gsap.registerPlugin(ScrollTrigger);
			}
			// Apply GSAP animation with ScrollTrigger
			paths.forEach(function(path, i) {
				if (method === 'fromTo') {
					gsap.fromTo(path, {
						drawSVG: from
					}, {
						drawSVG: draw_percent,
						duration: duration,
						delay: delay + i * 0.5,
						// stagger delay
						ease: ease,
						ScrollTrigger: {
							trigger: $scope,
							start: scrollTriggerStart,
							end: scrollTriggerEnd,
							scrub: scrub
						},
						repeat: repeat,
						// Repeat the animation
						yoyo: timeline_yoyo // No yoyo effect (reverse)
					});
				} else if (method === 'from') {
					gsap.from(path, {
						drawSVG: draw_percent,
						duration: duration,
						delay: delay + i * 0.5,
						// stagger delay
						ease: ease,
						ScrollTrigger: {
							trigger: $scope,
							start: scrollTriggerStart,
							end: scrollTriggerEnd,
							scrub: scrub
						},
						repeat: repeat,
						// Repeat the animation
						yoyo: timeline_yoyo // No yoyo effect (reverse)
					});
				}
			});
		}
	};

	// Wait for Elementor frontend to initialize
	window.addEventListener('elementor/frontend/init', function() {
		// Register the action for element ready hook
		elementorFrontend.hooks.addAction('frontend/element_ready/wcf-gsap-drawsvg.default', WgsapDrawSvg);
	});
})();
//# sourceMappingURL=gsap-draw.js.map
