/* global WCF_ADDONS_JS */
(function($) {
	/**
	 * @param $scope The Widget wrapper element as a jQuery element
	 * @param $ The jQuery alias
	 */
	var AdvanceSlider = function AdvanceSlider($scope, $) {
		var slider = $($('.wcf__slider', $scope)[0]);
		var sliderSettings = $($('.slider-wrapper', $scope)[0]).data('settings') || {};
		var slides = $('.swiper-slide', $scope).clone();
		var Wrapper = $('.swiper-wrapper', $scope);
		sliderSettings.handleElementorBreakpoints = true;
		if (sliderSettings.hasOwnProperty('pagination')) {
			sliderSettings.pagination.renderCustom = function(swiper, current, total) {
				var width = 100 / total * current;
				return "0" + current + ' <span class="paginate-fill" style="' + '--width:' + width + '%"></span> ' + 0 + total;
			};
		}
		var filters = $('.slide-filter li', $scope);
		new elementorFrontend.utils.swiper(slider, sliderSettings).then(function(newSwiperInstance) {
			return newSwiperInstance;
		}).then(function(newSwiperInstance) {
			filters.first().addClass('active');
			filters.on('click', function() {
				if ($(this).hasClass('active')) {
					return;
				}
				var filter = $(this).data('filter');
				filters.removeClass('active');
				$(this).addClass('active');
				if ('all' === filter) {
					Wrapper.html(slides);
					newSwiperInstance.update();
					newSwiperInstance.updateSlides();
				} else {
					Wrapper.html(slides.filter(filter));
					newSwiperInstance.update();
					newSwiperInstance.updateSlides();
				}
			});
		});
	};

	// Make sure you run this code under Elementor.
	$(window).on('elementor/frontend/init', function() {
		elementorFrontend.hooks.addAction('frontend/element_ready/wcf--filterable-slider.default', AdvanceSlider);
	});
})(jQuery);
//# sourceMappingURL=filterable-slider.js.map
