function _typeof(o) {
	"@babel/helpers - typeof";
	return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(o) {
		return typeof o;
	} : function(o) {
		return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o;
	}, _typeof(o);
}

function ownKeys(e, r) {
	var t = Object.keys(e);
	if (Object.getOwnPropertySymbols) {
		var o = Object.getOwnPropertySymbols(e);
		r && (o = o.filter(function(r) {
			return Object.getOwnPropertyDescriptor(e, r).enumerable;
		})), t.push.apply(t, o);
	}
	return t;
}

function _objectSpread(e) {
	for (var r = 1; r < arguments.length; r++) {
		var t = null != arguments[r] ? arguments[r] : {};
		r % 2 ? ownKeys(Object(t), !0).forEach(function(r) {
			_defineProperty(e, r, t[r]);
		}) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function(r) {
			Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r));
		});
	}
	return e;
}

function _defineProperty(e, r, t) {
	return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, {
		value: t,
		enumerable: !0,
		configurable: !0,
		writable: !0
	}) : e[r] = t, e;
}

function _toPropertyKey(t) {
	var i = _toPrimitive(t, "string");
	return "symbol" == _typeof(i) ? i : i + "";
}

function _toPrimitive(t, r) {
	if ("object" != _typeof(t) || !t) return t;
	var e = t[Symbol.toPrimitive];
	if (void 0 !== e) {
		var i = e.call(t, r || "default");
		if ("object" != _typeof(i)) return i;
		throw new TypeError("@@toPrimitive must return a primitive value.");
	}
	return ("string" === r ? String : Number)(t);
}
(function(wcfWindow) {
	"use strict";

	var wcfAnimBPreview = function() {
		var config = {};
		var scrollTriggerInstance = [];
		var hoverEnabled = false;

		function getFullSelector(element) {
			var path = [];
			var depth = 0; // Track depth
			var idCount = 0; // Track the number of IDs in the selector

			while (element && element.tagName.toLowerCase() !== "html" && depth < 3) {
				var selector = getUniqueSelector(element);

				// Check if the current element has an ID
				if (element.id) {
					idCount++;
					// Stop adding IDs if the limit is reached
					if (idCount > 2) {
						break;
					}
				}
				path.unshift(selector);
				element = element.parentElement;
				depth++; // Increment depth
			}
			return path.join(" > ");
		}

		function getUniqueSelector(element) {
			var tag = element.tagName.toLowerCase();

			// Add ID if available
			if (element.id) {
				return "".concat(tag, "#").concat(element.id); // Only tag and ID, skip classes
			}

			// Add class names, excluding the hover-highlight class
			var classList = Array.from(element.classList).filter(function(cls) {
				return cls !== "wcf-animb--hover-highlight";
			});
			if (classList.length > 0) {
				return "".concat(tag, ".").concat(classList.join(".")); // Concatenated classes if no ID
			}
			return tag; // Return only tag if no ID or classes
		}

		function extractLastSelector(selector) {
			if (selector === undefined) {
				return {
					full: "",
					tag: "",
					classes: false,
					id: ""
				};
			}
			// Regular expression to match selectors based on common delimiters
			var lastPart = selector.trim().split(/[\s>+~]+/) // Split by spaces, >, +, or ~
			.pop() // Get the last element in the array
			.trim();

			// Extract the tag (if any) and classes (if any)
			var tag = lastPart.split(".")[0].split("#")[0]; // Takes the first part before classes or IDs
			var classes = lastPart.split(".").slice(1) // Remove the tag name
			.join("."); // Join classes back
			var id = lastPart.split("#")[1]; // Extract the ID if present

			return {
				full: lastPart,
				tag: tag,
				classes: classes,
				id: id
			};
		}

		function resetAnimations(config) {
			gsap.globalTimeline.clear(); // Clears all animations

			config.animation.forEach(function(section) {
				section.animations.forEach(function(animation) {
					var selector = extractLastSelector(animation.applyAnimation.className);
					if (selector !== null && selector !== void 0 && selector.full && selector.full != "") {
						gsap.set(selector.full, {
							clearProps: "all"
						});
					}
				});
			});
			ScrollTrigger.getAll().forEach(function(st) {
				return st.kill();
			});
			ScrollTrigger.killAll();
			gsap.globalTimeline.clear();
		}

		function generateAnimations(config) {
			hidePopup();
			resetAnimations(config);
			config.animation.forEach(function(section) {
				var timelines = {};
				var scrollConfig = section.ScrollTrigger;
				section.timelines.forEach(function(timeline) {
					var config = timeline.properties.reduce(function(acc, prop) {
						if (!prop.isError) {
							acc[prop.name] = prop.unit ? "".concat(prop.value).concat(prop.unit) : prop.value;
						}
						return acc;
					}, {});
					timelines[timeline.title] = gsap.timeline(config);
				});
				section.animations.forEach(function(animation) {
					var timeline = timelines[animation.timeline];
					if (animation.applyAnimation.className && animation.applyAnimation.className !== "") {
						if (document.querySelector(animation.applyAnimation.className)) {
							var properties = animation.properties.reduce(function(acc, prop) {
								if (prop.type === 'custom') {
									var ccustomArr = prop.value.split(',');
									if (ccustomArr.length) {
										ccustomArr.forEach(function(cItem) {
											if (cItem != '') {
												var SplcItem = cItem.split(':');
												if (SplcItem.length > 1) {
													acc[SplcItem[0].trim()] = SplcItem[1].trim();
												}
											}
										});
									}
								} else {
									if (!prop.isError) {
										acc[prop.name] = prop.unit ? "".concat(prop.value).concat(prop.unit) : prop.value;
									}
								}
								return acc;
							}, {});
							var method = animation.method || "to";
							if (method && animation.method == "fromTo") {
								timeline[method](animation.applyAnimation.className, {
									x: -100
								}, properties); // need from propeties , change in ui
							} else {
								if (animation.absoluteTime != '') {
									timeline[method](animation.applyAnimation.className, properties, animation.absoluteTime);
								} else {
									timeline[method](animation.applyAnimation.className, properties);
								}
							}
						} else {
							console.warn("Target not found for animation: ".concat(animation.title));
						}
					}
				});

				// Scroll Trigger
				if (scrollConfig !== null && scrollConfig !== void 0 && scrollConfig.enable && scrollConfig.enable) {
					var scrolTime = timelines[scrollConfig.timeline];
					if (scrolTime && ScrollTrigger) {
						var final_scroll_configs = {
							animation: scrolTime,
							trigger: scrollConfig.trigger,
							endTrigger: scrollConfig.endTrigger,
							start: scrollConfig.start,
							end: scrollConfig.end,
							scrub: scrollConfig.scrub === "true",
							markers: scrollConfig.markers === "true" // Enable markers dynamically
						};
						if (scrollConfig.pin === "true") {
							final_scroll_configs.pin = scrollConfig.pin === "true";
							final_scroll_configs.pinSpacing = scrollConfig.pinSpacing === "true";
							var extraprops = extractNameAndValue(scrollConfig.properties);
							extraprops.forEach(function(pinprop) {
								if (pinprop.name === "markers") {
									final_scroll_configs.markers = pinprop.value;
								}
								if (pinprop.name === "anticipate pin") {
									final_scroll_configs.pinAnticipate = parseInt(pinprop.value, 10) || 0;
								}
								if (pinprop.name === "pinned container") {
									final_scroll_configs.pinContainer = pinprop.value || null;
								}
								if (pinprop.name === "pin type") {
									final_scroll_configs.pinType = pinprop.value || "fixed";
								}
							});
						}
						ScrollTrigger.create(final_scroll_configs);
						ScrollTrigger.refresh(); // Ensure everything recalculates
					}
				}
			});
		}

		function extractNameAndValue(data) {
			return data.map(function(item) {
				return {
					name: item.name,
					value: item.value
				};
			});
		}

		// Show the popup near the clicked element
		function showPopup(selector, x, y) {
			var popup = document.getElementById("wcfanim-selectorPopup");
			var content = document.getElementById("wcfanim-popupContent");

			// Set the content of the popup (for example, display the selector string)
			content.textContent = selector;

			// Get the width and height of the popup and its content
			var popupWidth = popup.offsetWidth;
			var popupHeight = popup.offsetHeight;
			var contentWidth = content.offsetWidth;
			var contentHeight = content.offsetHeight;

			// Get the current viewport size
			var viewportWidth = window.innerWidth;
			var viewportHeight = window.innerHeight;

			// Adjust the x-coordinate if the popup is too wide for the screen
			if (x + popupWidth > viewportWidth) {
				x = viewportWidth - popupWidth - 10; // Keep it 10px away from the right edge
			}

			// Adjust the y-coordinate if the popup is too tall for the screen
			if (y + popupHeight > viewportHeight) {
				y = viewportHeight - popupHeight - 10; // Keep it 10px away from the bottom edge
			}

			// Position the popup
			popup.style.left = "".concat(x, "px");
			popup.style.top = "".concat(y, "px");

			// Show the popup
			popup.style.display = "block";
		}

		// Hide the popup
		function hidePopup() {
			var popup = document.getElementById("wcfanim-selectorPopup");
			popup.style.display = "none";
		}

		function handleMouseOver(event) {
			var target = event.target;
			if (target.classList.contains("wcfanimb-skip-selector")) {
				return;
			}
			target.classList.add("wcf-animb--hover-highlight");
			target.addEventListener("mouseleave", function() {
				target.classList.remove("wcf-animb--hover-highlight");
			}, {
				once: true
			});
		}

		function enableHover() {
			if (!hoverEnabled) {
				document.body.addEventListener("mouseover", handleMouseOver);
				hoverEnabled = true;
			}
		}

		function disableHover() {
			if (hoverEnabled) {
				document.body.removeEventListener("mouseover", handleMouseOver);
				hoverEnabled = false;
			}
		}
		return {
			// Get the current configuration
			getConfig: function getConfig(key) {
				return key ? config[key] : _objectSpread({}, config); // Return specific key or full config
			},
			// Set a single configuration or multiple configurations
			setConfig: function setConfig(key, value) {
				if (_typeof(key) === "object") {
					// Update multiple configurations
					Object.assign(config, key);
				} else {
					// Update a single configuration
					config[key] = value;
				}
			},
			// Show a message using the current configurations
			playAnimation: function playAnimation() {
				generateAnimations(config);
			},
			sendPageConfig: function sendPageConfig() {
				window.addEventListener("message", function(event) {
					if ("wcf-animation-config" in event.data) {
						disableHover();
						wcfAnimBPreview.setConfig("animation", event.data["wcf-animation-config"]); // Update multiple configs
						wcfAnimBPreview.playAnimation();
					}
				}, false);
				setTimeout(function() {
					window.parent.postMessage(wcf_anim_preview_object);
				}, 1000);
			},
			enableHoverSelector: function enableHoverSelector() {
				enableHover();
			},
			disableHoverSelector: function disableHoverSelector() {
				disableHover();
			},
			fallbackCopyTextToClipboard: function fallbackCopyTextToClipboard(text) {
				var textArea = document.createElement("textarea");
				textArea.value = text;

				// Avoid scrolling to bottom
				textArea.style.top = "0";
				textArea.style.left = "0";
				textArea.style.position = "fixed";
				document.body.appendChild(textArea);
				textArea.focus();
				textArea.select();
				try {
					var successful = document.execCommand("copy");
					var msg = successful ? "successful" : "unsuccessful";
					console.log("Fallback: Copying text command was " + msg);
				} catch (err) {
					console.error("Fallback: Oops, unable to copy", err);
				}
				document.body.removeChild(textArea);
			},
			runPopup: function runPopup() {
				var closeBtn = document.querySelector(".wcfanimb-close-btn");
				var selectorContent = document.getElementById("wcfanim-popupContent");
				closeBtn.addEventListener("click", function() {
					hidePopup();
					disableHover();
				});
				document.getElementById("wcfanim-expendSelector").addEventListener("click", function(e) {
					selectorContent.classList.toggle("close");
					if (selectorContent.classList.contains("close")) {
						document.getElementById("wcfanim-expendSelector").textContent = "Expand";
					} else {
						document.getElementById("wcfanim-expendSelector").textContent = "Shrink";
					}
				});
				document.body.addEventListener("click", function(event) {
					event.preventDefault();
					var target = event.target;
					var selector = getFullSelector(target);
					// Show the popup at the click location
					enableHover();
					var isSkip = target.classList.contains("wcfanimb-skip-selector");
					if (!isSkip) {
						showPopup(selector, event.clientX + 10, event.clientY + 10);
					}
				});
				document.getElementById("wcfanim-copySelector").addEventListener("click", function() {
					var textElement = document.getElementById("wcfanim-popupContent");
					var textToCopy = textElement.textContent;

					// Use navigator.clipboard if available
					if (navigator.clipboard && window.isSecureContext) {
						// Modern API for copying
						navigator.clipboard.writeText(textToCopy).then(function() {
							disableHover();
							hidePopup();
						})["catch"](function(err) {
							console.error("Failed to copy text: ", err);
						});
					} else {
						// Fallback to manual method for older browsers
						var tempTextarea = document.createElement("textarea");
						tempTextarea.value = textToCopy;

						// Style the textarea to be offscreen
						tempTextarea.style.position = "fixed";
						tempTextarea.style.top = "-9999px";
						document.body.appendChild(tempTextarea);

						// Select the text inside the textarea
						tempTextarea.focus();
						tempTextarea.select();
						try {
							if (document.execCommand("copy")) {
								disableHover();
								hidePopup();
							}
						} catch (err) {
							console.error("Error copying text: ", err);
						}

						// Clean up by removing the temporary textarea
						document.body.removeChild(tempTextarea);
					}
				});
			}
		};
	}();
	wcfAnimBPreview.enableHoverSelector();
	wcfAnimBPreview.runPopup();
	wcfAnimBPreview.sendPageConfig();
})(window);
//# sourceMappingURL=animation-builder-preview.js.map
