(function(wcfWindow) {
	"use strict";

	var wcfAnimB = function() {
		function generateAnimations(config) {
			config.forEach(function(section) {
				var timelines = {};
				var scrollConfig = section.ScrollTrigger;
				section.timelines.forEach(function(timeline) {
					var config = timeline.properties.reduce(function(acc, prop) {
						if (!prop.isError) {
							acc[prop.name] = prop.unit ? "".concat(prop.value).concat(prop.unit) : prop.value;
						}
						return acc;
					}, {});
					timelines[timeline.title] = gsap.timeline(config);
				});
				section.animations.forEach(function(animation) {
					var timeline = timelines[animation.timeline];
					if (animation.applyAnimation.className && animation.applyAnimation.className !== '') {
						if (document.querySelector(animation.applyAnimation.className)) {
							var properties = animation.properties.reduce(function(acc, prop) {
								if (prop.type === 'custom') {
									var ccustomArr = prop.value.split(',');
									if (ccustomArr.length) {
										ccustomArr.forEach(function(cItem) {
											if (cItem != '') {
												var SplcItem = cItem.split(':');
												if (SplcItem.length > 1) {
													acc[SplcItem[0].trim()] = SplcItem[1].trim();
												}
											}
										});
									}
								} else {
									if (!prop.isError) {
										acc[prop.name] = prop.unit ? "".concat(prop.value).concat(prop.unit) : prop.value;
									}
								}
								return acc;
							}, {});
							var method = animation.method || "to";
							if (method && animation.method == 'fromTo') {
								if (animation.absoluteTime != '') {
									timeline[method](animation.applyAnimation.className, {
										x: -100
									}, properties); // need from propeties , change in ui
								} else {
									timeline[method](animation.applyAnimation.className, {
										x: -100
									}, properties, animation.absoluteTime); // need from propeties , change in ui
								}
							} else {
								if (animation.absoluteTime != '') {
									timeline[method](animation.applyAnimation.className, properties, animation.absoluteTime);
								} else {
									timeline[method](animation.applyAnimation.className, properties);
								}
							}
						} else {
							console.warn("Target not found for animation: ".concat(animation.title));
						}
					}
				});
				// Scroll Trigger    
				if (scrollConfig !== null && scrollConfig !== void 0 && scrollConfig.enable && scrollConfig.enable) {
					var scrolTime = timelines[scrollConfig.timeline];
					if (scrolTime && ScrollTrigger) {
						var final_scroll_configs = {
							animation: scrolTime,
							trigger: scrollConfig.trigger,
							endTrigger: scrollConfig.endTrigger,
							start: scrollConfig.start,
							end: scrollConfig.end,
							scrub: scrollConfig.scrub === "true",
							markers: scrollConfig.markers === "true" // Enable markers dynamically
						};
						if (scrollConfig.pin === "true") {
							final_scroll_configs.pin = scrollConfig.pin === "true";
							final_scroll_configs.pinSpacing = scrollConfig.pinSpacing === "true";
							var extraprops = extractNameAndValue(scrollConfig.properties);
							extraprops.forEach(function(pinprop) {
								if (pinprop.name === 'markers') {
									final_scroll_configs.markers = pinprop.value;
								}
								if (pinprop.name === 'anticipate pin') {
									final_scroll_configs.pinAnticipate = parseInt(pinprop.value, 10) || 0;
								}
								if (pinprop.name === 'pinned container') {
									final_scroll_configs.pinContainer = pinprop.value || null;
								}
								if (pinprop.name === 'pin type') {
									final_scroll_configs.pinType = pinprop.value || "fixed";
								}
							});
						}
						ScrollTrigger.create(final_scroll_configs);
					}
				}
			});
		}

		function extractNameAndValue(data) {
			return data.map(function(item) {
				return {
					name: item.name,
					value: item.value
				};
			});
		}
		return {
			playAnimation: function playAnimation() {
				try {
					var _wcfanimb;
					if (wcfanimb !== undefined && (_wcfanimb = wcfanimb) !== null && _wcfanimb !== void 0 && (_wcfanimb = _wcfanimb.animation_config) !== null && _wcfanimb !== void 0 && _wcfanimb.length && wcfanimb.animation_config.length) {
						generateAnimations(wcfanimb.animation_config);
					}
				} catch (err) {}
			}
		};
	}();
	wcfAnimB.playAnimation();
})(window);
//# sourceMappingURL=animation-builder-frontend.js.map
