/***************************************************
==================== JS INDEX ======================
****************************************************
01. Offcanvas
02. Image PopUp
03. Video PopUp
04. Skip content
05. Mouse Move Animation
06. Sticky Menu

****************************************************/

(function ($) {
  "use strict";

  // Using an object literal for a jQuery Axtra Theme module
  var axtra_theme_module = {
    init: function( settings ) {    
        axtra_theme_module.config = {
            responsive_menu_width: 1199,
            header_menu          : $('.lawyer-header__inner'),
            header               : $( ".default-blog-header" ),
            video_pop            : $( ".video-popup" ),
            image_pop            : $( ".image-popup" ),
        };  
        // Allow overriding the default config
        $.extend( axtra_theme_module.config, settings );  
        axtra_theme_module.setup();     
    },
    setup: function() {
    
      if(!jQuery('.wcf-theme-default-offcanvas').length){
        axtra_theme_module.header_menu();
      }   
      axtra_theme_module.sticky_header();
      axtra_theme_module.video_poup_global();
      axtra_theme_module.image_popup_global();
      axtra_theme_module.preloader();
      axtra_theme_module.scroll_preogress();
    },
    
    scroll_preogress: function(){
    	var progressPath                        = document.querySelector('.progress-wrap path');
    	
    	if( progressPath ){
      		var pathLength                          = progressPath.getTotalLength();
      		    progressPath.style.transition       = progressPath.style.WebkitTransition = 'none';
      		    progressPath.style.strokeDasharray  = pathLength + ' ' + pathLength;
      		    progressPath.style.strokeDashoffset = pathLength;
      		    progressPath.getBoundingClientRect();
      		    progressPath.style.transition = progressPath.style.WebkitTransition = 'stroke-dashoffset 10ms linear';
      		var updateProgress = function () {
      			var scroll                              = $(window).scrollTop();
      			var height                              = $(document).height() - $(window).height();
      			var progress                            = pathLength - (scroll * pathLength / height);
      			    progressPath.style.strokeDashoffset = progress;
      		}
      		updateProgress();
      		$(window).scroll(updateProgress);	
      		var offset   = 50;
      		var duration = 550;
      		jQuery(window).on('scroll', function() {
      			if (jQuery(this).scrollTop() > offset) {
      				jQuery('.progress-wrap').addClass('active-progress');
      			} else {
      				jQuery('.progress-wrap').removeClass('active-progress');
      			}
      		});				
      		jQuery('.progress-wrap').on('click', function(event) {
      			event.preventDefault();
      			jQuery('html, body').animate({scrollTop: 0}, duration);
      			return false;
      		})
      }
    },
    header_menu: function(){
       
       // Mobile menu Start
       let header_wrapper        = axtra_theme_module.config.header_menu;
       if( 'offcanvas_responsive_menu_width' in axtra_obj ){
        axtra_theme_module.config.responsive_menu_width = axtra_obj.offcanvas_responsive_menu_width;
       }
       var $menu_obj = {
         meanScreenWidth  : axtra_theme_module.config.responsive_menu_width,
         meanMenuContainer: '.offcanvas__menu-wrapper',
         meanMenuCloseSize: '36px',
       };
      
       if( 'offcanvas_menu_icon_plus' in axtra_obj ){
         $menu_obj.meanExpand = axtra_obj.offcanvas_menu_icon_plus;
       }
     
       if( 'offcanvas_menu_icon_minus' in axtra_obj ){
         $menu_obj.meanContract = axtra_obj.offcanvas_menu_icon_minus;
       }
        // meanmenu activition 
       $('.main-menu-js').meanmenu($menu_obj);
     
       if ($('.lawyer-header__inner .main-menu-js').css('display') === 'none') {
         header_wrapper.find('.info-default-offcanvas').show();
         header_wrapper.addClass('wcf-mobile-nav-active');
       }else{
         header_wrapper.find('.info-default-offcanvas').hide();
       }  
     
       window.addEventListener("resize", function () {          
             if (header_wrapper.find('.main-menu-js').css('display') == 'block') {      
                 header_wrapper.removeClass('wcf-mobile-nav-active');
             } else {    
                 header_wrapper.addClass('wcf-mobile-nav-active');
             }
           
             if (header_wrapper.find('.main-menu-js').css('display') == 'block') {      
               header_wrapper.find('.info-default-offcanvas').hide();
             } else {
               header_wrapper.find('.info-default-offcanvas').show();
             }          
       });
    },
    
    preloader : function(){
      // Preloader
      $(document).ready(function () {
        setTimeout(function () {
          $('#container').addClass('loaded');
          if ($('#container').hasClass('loaded')) {
            $('#preloader').delay(0).queue(function () {
              $('body').removeClass('axtra-preloader-active');
              $(this).remove();
            });
          }
        }, 0);    
      });
    },
      // Magnific Image popup
    image_popup_global : function(){
      axtra_theme_module.config.image_pop.magnificPopup({
          type: "image",
          gallery: {
            enabled: true,
          },
        });
    },
     /* Magnific Video popup */
    video_poup_global : function(){
      axtra_theme_module.config.video_pop.magnificPopup({
        type: 'iframe',
      });
    },
     /* Header Sticky */
    sticky_header : function(){    
      if( 'sticky_enable' in axtra_obj ){
        const toggleClass = "wcf-is-sticky";
        const sticky_top = axtra_obj.sticky_header_top || 150;    
        $(window).scroll(function() {
            if ($(this).scrollTop() > sticky_top){  
              axtra_theme_module.config.header.addClass(toggleClass);
            }
            else{
              axtra_theme_module.config.header.removeClass(toggleClass);
            }
        });
      }
    }
   
  };    
  $( document ).ready( axtra_theme_module.init );
  // Register GSAP Plugins
  gsap.registerPlugin(ScrollTrigger);   
  
})(jQuery);



