<?php
/**
 * Template Style
 *
 * @package WCFAddons
 */

if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	die();
}

/**
 * @var array $settings
 */
?>
<div <?php $this->print_render_attribute_string( 'wrapper' ); ?>>
    <div class="pt-number">
        <p class="number"><?php echo esc_html( $settings['number'] ); ?></p>
    </div>
    <div class="pt-name">
		<?php $this->render_price_heading(); ?>
		<?php $this->render_ribbon(); ?>
    </div>
    <div class="pt-price-wrap">
        <div class="pt-price">
			<span class="pt-currency">
				<?php $this->render_currency_symbol(); ?>
			</span>
            <span class="pt-sale-price">
				<?php $this->print_unescaped_setting( 'price' ); ?>
			</span>
			<?php $this->render_original_price(); ?>
            <span class="pt-period">
				<?php $this->print_unescaped_setting( 'period' ); ?>
			</span>
        </div>
    </div>
	<?php
	$this->render_feature_list();
	$this->render_button();
	?>
</div>
