<?php
/**
 * Retrieves an array of the elementor save template.
 *
 * For more information on the accepted arguments, see the
 * {@link https://developer.wordpress.org/reference/classes/wp_query/
 * WP_Query} documentation in the Developer Handbook.
 *
 *
 * @since 1.0.0
 *
 * @see WP_Query
 * @see WP_Query::parse_query()
 *
 * @param array $args
 *
 * @return WP_Post[]|int[] Array of post objects or post IDs.
 */
function get_saved_template_list( $args = null ) {
	$post_list = [];

	$defaults = array(
		'post_type'   => 'elementor_library',
		'post_status' => 'publish',
		'numberposts' => - 1,
	);

	$parsed_args              = wp_parse_args( $args, $defaults );
	$parsed_args['post_type'] = 'elementor_library'; //don't overwrite post type
	$posts                    = get_posts( $parsed_args );
	if ( $posts ) {
		foreach ( $posts as $post ) {
			$post_list[ $post->ID ] = esc_html( $post->post_title );
		}
	}

	return $post_list;
}


/**
 * Get database settings of a widget by widget id and element
 *
 * @param array $elements
 * @param string $widget_id
 *
 * @return false|mixed|string
 */
function get_widget_element_settings($elements, $widget_id) {

	if (is_array($elements)) {
		foreach ($elements as $d) {
			if ($d && !empty($d['id']) && $d['id'] == $widget_id) {
				return $d;
			}
			if ($d && !empty($d['elements']) && is_array($d['elements'])) {
				$value = get_widget_element_settings($d['elements'], $widget_id);
				if ($value) {
					return $value;
				}
			}
		}
	}

	return false;
}

/**
 * Get database settings of a widget by widget id and post id
 *
 * @param number $post_id
 * @param string $widget_id
 *
 * @return false|mixed|string
 */
function get_widget_settings($post_id, $widget_id) {

	$elementor_data = @json_decode(get_post_meta($post_id, '_elementor_data', true), true);

	if ($elementor_data) {
		$element = get_widget_element_settings($elementor_data, $widget_id);
		return isset($element['settings']) ? $element['settings'] : '';
	}

	return false;
}
