(function($) {
	/**
	 * @param $scope The Widget wrapper element as a jQuery element
	 * @param $ The jQuery alias
	 */
	var Video = function Video($scope, $) {
		var element = $('.wcf--video', $scope);
		var popup_btn = $('.wcf-popup-btn', $scope);
		var video = element.find('video');
		var settings = element.find('.wcf-video-wrapper').data('settings') || {};
		video.mediaelementplayer({
			features: settings.features,
			videoVolume: settings.videoVolume,
			startVolume: settings.startVolume,
			stretching: "responsive",
			enableAutosize: !0,
			videoWidth: "100%",
			videoHeight: "100%"
		});
		popup_btn.magnificPopup({
			mainClass: 'wcf-video-wrapper',
			removalDelay: 160,
			preloader: !0,
			fixedContentPos: !1,
			items: {
				src: element.find('.wcf-video-wrapper'),
				type: 'inline'
			}
		});
	};

	// Make sure you run this code under Elementor.
	$(window).on('elementor/frontend/init', function() {
		elementorFrontend.hooks.addAction('frontend/element_ready/wcf--video.default', Video);
	});
})(jQuery);
//# sourceMappingURL=video.js.map
