<?php

namespace AxtraEssentialApp\Widgets;

use Elementor\Controls_Manager;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Icons_Manager;
use Elementor\Repeater;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Plugin;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Service extends Widget_Base {

	public function get_name() {
		return 'axtra-service';
	}

	public function get_title() {
		return wcf_elementor_widget_concat_prefix( 'Services' );
	}

	public function get_icon() {
		return 'wcf eicon-post-content';
	}

	public function get_categories() {
		return [ 'weal-coder-addon' ];
	}

	public function get_style_depends() {
		wp_register_style( 'axtra-service', AXTRA_ESSENTIAL_ASSETS_URL . 'css/service.css' );

		return [ 'axtra-service' ];
	}

	public function get_script_depends() {
		wp_register_script( 'axtra--service', AXTRA_ESSENTIAL_ASSETS_URL . '/js/widgets/service.js' );

		return [ 'axtra--service' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_service',
			[
				'label' => esc_html__( 'Service', 'axtra-essential' ),
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'service_image',
			[
				'label'   => esc_html__( 'Service Image', 'axtra-essential' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$repeater->add_control(
			'service_title',
			[
				'label'       => esc_html__( 'Title', 'axtra-essential' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'Interaction Design', 'axtra-essential' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'service_desc',
			[
				'label'   => esc_html__( 'Description', 'axtra-essential' ),
				'type'    => Controls_Manager::TEXTAREA,
				'rows'    => 5,
				'default' => esc_html__( 'We create, products, brands, apps & websites for the companies all around the world class digital products', 'axtra-essential' ),
			]
		);

		$repeater->add_control(
			'service_icon',
			[
				'label'       => esc_html__( 'Icon', 'axtra-essential' ),
				'type'        => Controls_Manager::ICONS,
				'skin'        => 'inline',
				'label_block' => false,
				'default'     => [
					'value'   => 'fas fa-arrow-right',
					'library' => 'fa-solid',
				],
			]
		);

		$repeater->add_control(
			'service_link',
			[
				'label'       => esc_html__( 'Link', 'axtra-essential' ),
				'type'        => Controls_Manager::URL,
				'options'     => [ 'url', 'is_external', 'nofollow' ],
				'default'     => [
					'url'         => '#',
					'is_external' => false,
					'nofollow'    => true,
				],
				'label_block' => false,
			]
		);

		$this->add_control(
			'service_list',
			[
				'label'       => esc_html__( 'Service List', 'axtra-essential' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'default'     => [
					[
						'service_title' => esc_html__( 'Digital Maketing', 'axtra-essential' ),
						'service_desc'  => esc_html__( 'We create, products, brands, apps & websites for the companies all around the world class digital products.' ),
					],
					[
						'service_title' => esc_html__( 'Interaction Design', 'axtra-essential' ),
						'service_desc'  => esc_html__( 'We partnered digital marketing tocreate an interactive video tool will change the way businesses.' ),
					],
					[
						'service_title' => esc_html__( 'Branding and Strategy', 'axtra-essential' ),
						'service_desc'  => esc_html__( 'Funnels that increase response rates is just the first step for them and we can’t wait to see where it takes them!' ),
					],
				],
				'title_field' => '{{{ service_title }}}',
			]
		);

		$this->end_controls_section();

		// Style
		// Thumb
		$this->start_controls_section(
			'section_thumb_style',
			[
				'label' => esc_html__( 'Thumb & Shape', 'axtra-essential' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'thumb_heading',
			[
				'label'     => esc_html__( 'Thumb', 'axtra-essential' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'thumb_width',
			[
				'label'      => esc_html__( 'Width', 'axtra-essential' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range'      => [
					'px' => [
						'min' => 0,
						'max' => 500,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .thumb img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'thumb_height',
			[
				'label'      => esc_html__( 'Height', 'axtra-essential' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range'      => [
					'px' => [
						'min' => 0,
						'max' => 500,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .thumb img' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'thumb_b_radius',
			[
				'label'      => esc_html__( 'Border Radius', 'axtra-essential' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'selectors'  => [
					'{{WRAPPER}} .thumb img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		// Shape
		$this->add_control(
			'shape_heading',
			[
				'label'     => esc_html__( 'Shape', 'axtra-essential' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'shape_color',
			[
				'label'     => esc_html__( 'Color', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .shape' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'shape_b_radius',
			[
				'label'      => esc_html__( 'Border Radius', 'axtra-essential' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'selectors'  => [
					'{{WRAPPER}} .shape' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'shape_popover_toggle',
			[
				'label'        => esc_html__( 'Position', 'axtra-essential' ),
				'type'         => Controls_Manager::POPOVER_TOGGLE,
				'label_off'    => esc_html__( 'Default', 'axtra-essential' ),
				'label_on'     => esc_html__( 'Custom', 'axtra-essential' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->start_popover();

		$this->add_responsive_control(
			'shape_pos_x',
			[
				'label'      => esc_html__( 'X', 'axtra-essential' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range'      => [
					'px' => [
						'min' => - 200,
						'max' => 200,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .shape' => 'left: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'shape_pos_y',
			[
				'label'      => esc_html__( 'Y', 'axtra-essential' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range'      => [
					'px' => [
						'min' => - 300,
						'max' => 300,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .shape' => 'bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_popover();

		$this->end_controls_section();

		// Content
		$this->start_controls_section(
			'section_content_style',
			[
				'label' => esc_html__( 'Content', 'axtra-essential' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'content_gap',
			[
				'label'      => esc_html__( 'Gap', 'axtra-essential' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range'      => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .axtra-service__item a' => 'gap: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'content_padding',
			[
				'label'      => esc_html__( 'Padding', 'axtra-essential' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'selectors'  => [
					'{{WRAPPER}} .axtra-service__item a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'content_b_color',
			[
				'label'     => esc_html__( 'Border Color', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .axtra-service__item a' => 'border-color: {{VALUE}}',
				],
			]
		);

		// Number
		$this->add_control(
			'number_heading',
			[
				'label'     => esc_html__( 'Number', 'axtra-essential' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'number_color',
			[
				'label'     => esc_html__( 'Color', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .number' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'number_typo',
				'selector' => '{{WRAPPER}} .number',
			]
		);

		// Title
		$this->add_control(
			'title_heading',
			[
				'label'     => esc_html__( 'Title', 'axtra-essential' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Color', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typo',
				'selector' => '{{WRAPPER}} .title',
			]
		);

		// Description
		$this->add_control(
			'desc_heading',
			[
				'label'     => esc_html__( 'Description', 'axtra-essential' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'desc_color',
			[
				'label'     => esc_html__( 'Color', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .desc' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'desc_typo',
				'selector' => '{{WRAPPER}} .desc',
			]
		);

		// Icon
		$this->add_control(
			'icon_heading',
			[
				'label'     => esc_html__( 'Icon', 'axtra-essential' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'icon_color',
			[
				'label'     => esc_html__( 'Color', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .icon' => 'color: {{VALUE}}; fill: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'icon_size',
			[
				'label'      => esc_html__( 'Size', 'axtra-essential' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min' => 10,
						'max' => 100,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .icon' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_active_style',
			[
				'label' => esc_html__( 'Active/Hover', 'axtra-essential' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'number_h_color',
			[
				'label'     => esc_html__( 'Number Color', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .active .number' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'title_h_color',
			[
				'label'     => esc_html__( 'Title Color', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .active .title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'icon_h_color',
			[
				'label'     => esc_html__( 'Icon Color', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .active .icon' => 'color: {{VALUE}}; fill: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		?>
        <div class="axtra-service__list">
			<?php
			if ( empty( $settings['service_list'] ) ) {
				return;
			}

			$count = 1;

			foreach ( $settings['service_list'] as $index => $item ) {

				$service_link = 'service_link_' . $index;

				if ( ! empty( $item['service_link']['url'] ) ) {
					$this->add_link_attributes( $service_link, $item['service_link'] );
				}

				?>
                <div class="axtra-service__item">
                    <a <?php $this->print_render_attribute_string( $service_link ); ?>>
                        <div class="number"><?php echo $count; ?></div>
                        <h2 class="title"><?php $this->print_unescaped_setting( 'service_title', 'service_list', $index ); ?></h2>
                        <p class="desc"><?php echo esc_html( $item['service_desc'] ); ?></p>
                        <div class="icon-wrap">
                            <div class="icon">
                                <span class="icon-1"><?php Icons_Manager::render_icon( $item['service_icon'], [ 'aria-hidden' => 'true' ] ); ?></span>
                                <span class="icon-2"><?php Icons_Manager::render_icon( $item['service_icon'], [ 'aria-hidden' => 'true' ] ); ?></span>
                            </div>
                        </div>
                    </a>
                    <div class="thumb">
                        <img src="<?php echo esc_url( $item['service_image']['url'] ); ?>"
                             alt="<?php echo esc_html( $item['service_title'] ); ?>">
                        <span class="shape"></span>
                    </div>
                </div>
				<?php
				$count ++;
			}
			?>
        </div>
		<?php
	}
}
