<?php

namespace AxtraEssentialApp\Importer;
use Elementor\Plugin;

global $pagenow;
if( $pagenow !='import.php' ){

class Wcf_Theme_Demo_Import extends \WCF_Axtra_WP_Import
    {
        public $wp_tags     = array(
            'wp:name',
            'wp:content'      
        );
        public $in_sub_tag;       
        public $wxr_version;       
        public $data;
        public $wp_options;
        public $in_tag;  
        public $cdata;  
        public $in_option;
         public $import_path = 'https://crowdytheme.com/elementor/info-templates/wp-content/plugins/wcf-elementor-templates/inc/demo/page-xml-layout/wcf-page-tpl-%s.xml';
         public $xml_path    = null;
         public $upload_path = null;
         public $option_path = null;
         public $cache_name  = 'crowdyinfo_theme_templates_file';
    	/**
    	 * register default hooks and actions for WordPress
    	 * @return
    	 */
    	public function __construct()
    	{   
            if(!axtra_theme_service_pass()){
                return;
            }
                       
            $this->import_path = plugin_dir_url(__FILE__).'demo-content/wcf-theme-xml-library.json';
            
            add_action( 'admin_menu', [$this, '_admin_action_admin_menu'] ,11);
            add_action( 'admin_enqueue_scripts', [ $this, 'admin_enqueue_scripts' ] );           
            add_action( 'wp_ajax_wcf_theme_demo_xml_file_import', [$this,'wcf_theme_demo_xml_file_import'] );
            
          //  add_action( 'admin_init' , [$this, 'update_elementor_option'] );
            //add_action( 'update_option_elementor_active_kit' , [$this, 'update_elementor_option'] );
     	}
     	public function update_elementor_option(){
     	
          global $wpdb;
          $_elementor_page_assets   = get_option( 'wcf_kit_elementor_page_assets' );
          $_elementor_css           = get_option( 'wcf_kit_elementor_css' );
          $_elementor_page_settings = get_option( 'wcf_kit_elementor_page_settings' );
          $active_kit_id            = get_option( 'elementor_active_kit' );
        
          $meta_results = $wpdb->get_results( 
            $wpdb->prepare( "SELECT * FROM $wpdb->postmeta WHERE post_id=%d", $active_kit_id ),
            'ARRAY_A'
          );
     
          
          foreach($meta_results as $item){
             
            if( $item[ 'meta_key' ] === '_elementor_page_settings' && $_elementor_page_settings !='' ){
              
                $wpdb->replace(
                    $wpdb->postmeta,
                    array(                   
                    'meta_key' => '_elementor_page_settings',
                    'meta_value' => $_elementor_page_settings,
                    )                   
                );  
          
            }
             
            if( $item[ 'meta_key' ] === '_elementor_css' && $_elementor_css !='' ){
                $wpdb->replace(
                    $wpdb->postmeta,
                    array(                   
                    'meta_key' => '_elementor_css',
                    'meta_value' => $_elementor_css,
                    )                   
                );
            }
             
            if( $item[ 'meta_key' ] === '_elementor_page_assets' && $_elementor_page_assets !='' ){
                $wpdb->replace(
                    $wpdb->postmeta,
                    array(                   
                    'meta_key' => '_elementor_page_assets',
                    'meta_value' => $_elementor_page_assets,
                    )                   
                );
            }
            
          }
            
     	}
     	public function custom_settings_update(){
     	  
     	  if(isset( $_REQUEST['page_on_front'] ) && $_REQUEST['page_on_front'] !=''){
     	      update_option('show_on_front', 'page');
     	      update_option('page_on_front', $_REQUEST['page_on_front']);
     	  }
     	  
     	  if(isset( $_REQUEST['page_for_posts'] ) && $_REQUEST['page_for_posts'] !=''){
     	      update_option('page_for_posts', $_REQUEST['page_for_posts'] );
     	  }
     	   
     	  echo '<h2>'.esc_html__('Succesfully updated settings','axtra-essential').'</h2>';
     	}
        public function _admin_action_admin_menu() {
            $active  = function_exists('axtra_option') ? axtra_option('theme_demo_activate_two', true) : false;
            if ( current_user_can( 'administrator' ) && $active ) {            
                add_submenu_page(
                    'wcf-axtra-theme-parent',
                    __('Alternative Demo Importer', 'axtra-essential'),
                    __('Alternative Demo Importer', 'axtra-essential'),
                    'manage_options',
                    'wcf-theme-demo-importer',
                    array($this, '_display_page')
                );
            }
        }
        public function _display_page(){
            ?>
              <style>
                body .wcf-page-modal-content{
                    margin-left:0;
                    background-color: #fefefe;
                    padding: 20px;
                    border: 1px solid #dbdbdb;            
                    width: 96%;
                    height: auto;
                    overflow-y: unset;
                }
                body .wcf-page-modal{
                    background-color: transparent;
                    display: block;
                    position: relative;
                }
                
                body .wcf-row {
                    display: grid;
                    gap: 20px;
                    grid-template-columns: repeat(4, 1fr);
                    margin: 0 30px;
                    padding: 20px;
                    background: #F8F8FA;
                    border-radius: 8px 8px 0 0;
                }
               
              </style>
            <?php
            echo sprintf('
           
            <div style="display:block;" id="wcf-page-importeri" class="wcf-page-modal">                   
              <!-- Modal content -->
              <div class="wcf-page-modal-content">                
                <h3>%s</h3>
                <div class="wcf-page-filter-area">
                     <div class="wcf-page-subtype" id="wcf-page-select-type">
                         
                     </div>    
                     <input type="text" placeholder="Search here" class="wcf-page-search-js" />
                </div>
                <div id="wcf--page-dimporter--content-js">
                     <div class="wcf-dpage-xml-import-container">
                         <div class="wcf-msg"></div> 
                         <div class="wcf-templates-list-renderer"> </div>                                
                     </div>
                </div>
              </div>                   
            </div>',
         esc_html__('Crowdytheme Theme Importer', 'axtra-essential'),        
     );
        }
     	public function wcf_theme_demo_xml_file_import(){
     	    // Ajax
            if ( !wp_verify_nonce( $_REQUEST['nonce'], "wcf_page_import_secure")) {
                exit("No naughty business please");
            }
                       
            $this->upload_path = sprintf( plugin_dir_path(__FILE__).'demo-content/%s/demo.xml' , $_REQUEST['id'] );       
            
            $return_obj = [
                'action' => 'wcf_theme_demo_xml_file_import',
                'nonce'  => $_REQUEST['nonce'],
                'id'     => $_REQUEST['id'],
                'step'   => '',
                'html'   => '',
            ];
            
            $id   = sanitize_text_field( isset($_POST['id']) ? $_POST['id'] : '');         
             // download step
            if( isset( $_REQUEST[ 'step' ] ) && $_REQUEST[ 'step' ] === 'download' ){
                ob_start();
                if( $this->has_file($this->upload_path) ) {
                    $return_obj['step'] = 'options';
                    echo sprintf('<div class="wcf-page-imporing">Demo: %s downloaded. Starting the pages install</div>',$_REQUEST['page_title']);
                    echo '<svg width="200px" height="200px"  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid" style="background: none;">
                    <circle cx="75" cy="50" fill="#363a3c" r="6.39718">
                        <animate attributeName="r" values="4.8;4.8;8;4.8;4.8" times="0;0.1;0.2;0.3;1" dur="1s" repeatCount="indefinite" begin="-0.875s"></animate>
                    </circle>
                    <circle cx="67.678" cy="67.678" fill="#363a3c" r="4.8">
                        <animate attributeName="r" values="4.8;4.8;8;4.8;4.8" times="0;0.1;0.2;0.3;1" dur="1s" repeatCount="indefinite" begin="-0.75s"></animate>
                    </circle>
                    <circle cx="50" cy="75" fill="#363a3c" r="4.8">
                        <animate attributeName="r" values="4.8;4.8;8;4.8;4.8" times="0;0.1;0.2;0.3;1" dur="1s" repeatCount="indefinite" begin="-0.625s"></animate>
                    </circle>
                    <circle cx="32.322" cy="67.678" fill="#363a3c" r="4.8">
                        <animate attributeName="r" values="4.8;4.8;8;4.8;4.8" times="0;0.1;0.2;0.3;1" dur="1s" repeatCount="indefinite" begin="-0.5s"></animate>
                    </circle>
                    <circle cx="25" cy="50" fill="#363a3c" r="4.8">
                        <animate attributeName="r" values="4.8;4.8;8;4.8;4.8" times="0;0.1;0.2;0.3;1" dur="1s" repeatCount="indefinite" begin="-0.375s"></animate>
                    </circle>
                    <circle cx="32.322" cy="32.322" fill="#363a3c" r="4.80282">
                        <animate attributeName="r" values="4.8;4.8;8;4.8;4.8" times="0;0.1;0.2;0.3;1" dur="1s" repeatCount="indefinite" begin="-0.25s"></animate>
                    </circle>
                    <circle cx="50" cy="25" fill="#363a3c" r="6.40282">
                        <animate attributeName="r" values="4.8;4.8;8;4.8;4.8" times="0;0.1;0.2;0.3;1" dur="1s" repeatCount="indefinite" begin="-0.125s"></animate>
                    </circle>
                    <circle cx="67.678" cy="32.322" fill="#363a3c" r="7.99718">
                        <animate attributeName="r" values="4.8;4.8;8;4.8;4.8" times="0;0.1;0.2;0.3;1" dur="1s" repeatCount="indefinite" begin="0s"></animate>
                    </circle>
                </svg>';
                }else{
                    $return_obj['step'] = 'failed';
                    echo sprintf('<div class="wcf-page-imporing">File: %s download failed . <br/> May be file not exist or server busy . </br/>Try few miniute later.</div>',$_REQUEST['page_title']);
                }               
                $return_obj['html'] = ob_get_clean();
                wp_send_json_success($return_obj);
            }elseif( isset( $_REQUEST[ 'step' ] ) && $_REQUEST[ 'step' ] === 'import' ){
                ob_start();
                $return_obj['step'] = 'custom_config';
                echo '<svg width="200px" height="200px"  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid" style="background: none;">
                <circle cx="75" cy="50" fill="#363a3c" r="6.39718">
                    <animate attributeName="r" values="4.8;4.8;8;4.8;4.8" times="0;0.1;0.2;0.3;1" dur="1s" repeatCount="indefinite" begin="-0.875s"></animate>
                </circle>
                <circle cx="67.678" cy="67.678" fill="#363a3c" r="4.8">
                    <animate attributeName="r" values="4.8;4.8;8;4.8;4.8" times="0;0.1;0.2;0.3;1" dur="1s" repeatCount="indefinite" begin="-0.75s"></animate>
                </circle>
                <circle cx="50" cy="75" fill="#363a3c" r="4.8">
                    <animate attributeName="r" values="4.8;4.8;8;4.8;4.8" times="0;0.1;0.2;0.3;1" dur="1s" repeatCount="indefinite" begin="-0.625s"></animate>
                </circle>
                <circle cx="32.322" cy="67.678" fill="#363a3c" r="4.8">
                    <animate attributeName="r" values="4.8;4.8;8;4.8;4.8" times="0;0.1;0.2;0.3;1" dur="1s" repeatCount="indefinite" begin="-0.5s"></animate>
                </circle>
                <circle cx="25" cy="50" fill="#363a3c" r="4.8">
                    <animate attributeName="r" values="4.8;4.8;8;4.8;4.8" times="0;0.1;0.2;0.3;1" dur="1s" repeatCount="indefinite" begin="-0.375s"></animate>
                </circle>
                <circle cx="32.322" cy="32.322" fill="#363a3c" r="4.80282">
                    <animate attributeName="r" values="4.8;4.8;8;4.8;4.8" times="0;0.1;0.2;0.3;1" dur="1s" repeatCount="indefinite" begin="-0.25s"></animate>
                </circle>
                <circle cx="50" cy="25" fill="#363a3c" r="6.40282">
                    <animate attributeName="r" values="4.8;4.8;8;4.8;4.8" times="0;0.1;0.2;0.3;1" dur="1s" repeatCount="indefinite" begin="-0.125s"></animate>
                </circle>
                <circle cx="67.678" cy="32.322" fill="#363a3c" r="7.99718">
                    <animate attributeName="r" values="4.8;4.8;8;4.8;4.8" times="0;0.1;0.2;0.3;1" dur="1s" repeatCount="indefinite" begin="0s"></animate>
                </circle>
            </svg>';
                echo sprintf( '<div class="wcf-page-imporing">%s</div>' , esc_html__('Demo Process going to finish' ,'axtra-essential') );
                echo  '<div hidden>';
                $this->import($this->upload_path);
                $this->update_elementor_option();
                echo '</div>';
                $return_obj['html'] = ob_get_clean();
                if(class_exists('Elementor\Plugin')){
                    Plugin::$instance->files_manager->clear_cache();
                }
                wp_send_json_success($return_obj);
            }elseif( isset( $_REQUEST[ 'step' ] ) && $_REQUEST[ 'step' ] === 'options' ){
                $this->option_path = sprintf( plugin_dir_path(__FILE__).'demo-content/%s/options.xml' , $_REQUEST['id'] );
                ob_start();
                $return_obj['step'] = 'import';
                $return_obj['path'] = $this->option_path;                
                $this->import_options($this->option_path);                 
                $return_obj['html'] = ob_get_clean();
                wp_send_json_success($return_obj);
            }elseif( isset( $_REQUEST[ 'step' ] ) && $_REQUEST[ 'step' ] === 'custom_config' ){
                ob_start();
                $return_obj['step'] = 'done';
                include_once('wordpress-importer/welcome.view.php');  
                
                $return_obj['html'] = ob_get_clean();
                
                wp_send_json_success($return_obj);
            }elseif( isset( $_REQUEST[ 'step' ] ) && $_REQUEST[ 'step' ] === 'custom_settings_update' ){
                ob_start();
                $return_obj['step'] = 'done';
                $this->custom_settings_update();
                include_once('wordpress-importer/frontend-visit.view.php');       
                $return_obj['html'] = ob_get_clean();
                
                wp_send_json_success($return_obj);
            }
            ob_start();
            $return_obj['step'] = 'failed';
            $return_obj['action'] = 'null';
            echo '<p><strong>' . __( 'Sorry, there has been an error.', 'axtra-essential' ) . '</strong><br />';
            $return_obj['html'] = ob_get_clean();
            wp_send_json_error($return_obj);
            wp_die();
     	}
     	/*
     	* Downnload remote file
     	*/
     	public function has_file($path){
     	    
            if(file_exists($path)){
              return true;
            }
            return false;
     	}
     	
         function tag_open( $parse, $tag, $attr ) {
            if ( in_array( $tag, $this->wp_tags, true ) ) {
                $this->in_tag = substr( $tag, 3 );
                return;
            }
    
            switch ( $tag ) {                
                case 'item':
                    $this->in_post = true;
                    break;
                case 'wp:name':
                    $this->in_tag = 'name';
                    break;                
                case 'wp:content':
                    $this->content = 'value';
                    break;
            }
        }
    
        function cdata( $parser, $cdata ) {
            if ( ! trim( $cdata ) ) {
                return;
            }
    
            if ( false !== $this->in_tag || false !== $this->in_sub_tag ) {
                $this->cdata .= $cdata;
            } else {
                $this->cdata .= trim( $cdata );
            }
        }
    
        function tag_close( $parser, $tag ) {
            switch ( $tag ) {
               
                case 'item':
                    $this->wp_options[] = $this->data;
                    $this->data    = false;
                    break;             
                case 'wp:base_site_url':
                    $this->base_url = $this->cdata;
                    if ( ! isset( $this->base_blog_url ) ) {
                        $this->base_blog_url = $this->cdata;
                    }
                    break;
                case 'wp:base_blog_url':
                    $this->base_blog_url = $this->cdata;
                    break;
                case 'wp:wxr_version':
                    $this->wxr_version = $this->cdata;
                    break;
    
                default:
                   if ( $this->in_tag ) {
                        if ( false === $this->data ) {
                            $this->data = array();
                        }
    
                        $this->data[ $this->in_tag ] = ! empty( $this->cdata ) ? $this->cdata : '';
                        $this->in_tag                = false;
                    }
            }
    
            $this->cdata = false;
        }
     	
        public function admin_enqueue_scripts(){  
    
            wp_register_style( 'wcf-theme-importer-admin', plugin_dir_url( __FILE__ ).'wordpress-importer/assets/admin.css', [], time() ); 
            
            wp_register_script(
                'wcf-theme-importer-admin',
                plugin_dir_url( __FILE__ ).'wordpress-importer/assets/theme-demo.js',			
                ['jquery'],			
                time(),
                true
            ); 
            
            $_data =[
                'ajax_url'   => admin_url( 'admin-ajax.php' ),
                'ajax_nonce' => wp_create_nonce('wcf_page_import_secure'),
                'demos'      => $this->get_data()
            ];           
            wp_localize_script( 'wcf-theme-importer-admin', 'wcf_import_obj', $_data);           
            $current_screen = get_current_screen();
            if(isset($current_screen->id) && $current_screen->id === 'axtra-theme_page_wcf-theme-demo-importer'){
                wp_enqueue_style('wcf-theme-importer-admin');
                wp_enqueue_script('wcf-theme-importer-admin');
            }            
        }
     	
        /* 
        * Load Config data
        */
        function get_data() {            
            $_array = require_once("demo-content/demo-config.php");            
            return json_encode($_array);            
        }
        
        public function import_options($file){     
           
            if(file_exists($file)){            
                if(extension_loaded( 'xml' )){
                    try {
                        $xml = xml_parser_create( 'UTF-8' );
                        xml_parser_set_option( $xml, XML_OPTION_SKIP_WHITE, 1 );
                        xml_parser_set_option( $xml, XML_OPTION_CASE_FOLDING, 0 );
                        xml_set_object( $xml, $this );
                        xml_set_character_data_handler( $xml, 'cdata' );
                        xml_set_element_handler( $xml, 'tag_open', 'tag_close' );
                
                        if ( ! xml_parse( $xml, file_get_contents( $file ), true ) ) {
                            $current_line   = xml_get_current_line_number( $xml );
                            $current_column = xml_get_current_column_number( $xml );
                            $error_code     = xml_get_error_code( $xml );
                            $error_string   = xml_error_string( $error_code );                         
                            echo "Theme settings import failed . Invalid File ,error in line ". $current_line;
                            return;
                        }
                        xml_parser_free( $xml );                  
                      
                        if ( ! preg_match( '/^\d+\.\d+$/', $this->wxr_version ) ) {
                            echo new \WP_Error( 'WXR_parse_error', __( 'This does not appear to be a WXR file, missing/invalid WXR version number', 'axtra-essential' ) );
                        }
                        $this->update_option();                       
                    } catch (Exception $e) {
                        echo 'Caught exception: ',  $e->getMessage(), "\n";
                    } 
                }else{
                    echo sprintf('<h2>%s</h2>', esc_html__('Please install XML php extensions','axtra-essential'));
                }               
                 
            }else{
              echo sprintf('<h2>%s</h2>', esc_html__('Options file not found','axtra-essential'));
            } 
            
        }
        
        public function update_option(){
            global $wpdb; 
            $update_args = [];
            if(is_array( $this->wp_options ) && count($this->wp_options) > 1){
            
                foreach($this->wp_options as $item){  
                
                    $table  = $wpdb->prefix.'options';
                    $data   = array( 
                        'option_name'  => $item['name'],
                        'option_value' => $item['content']
                    );   
                                     
                    $wpdb->replace(
                        $table,
                        $data,
                        array(
                        '%s',
                        '%s',                        
                        )
                        );                 
                    
                } 
                echo sprintf('<h2>%s</h2>', esc_html__('Theme settings importing','axtra-essential'));
                echo '<svg width="200px" height="200px"  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid" style="background: none;">
                <circle cx="75" cy="50" fill="#363a3c" r="6.39718">
                    <animate attributeName="r" values="4.8;4.8;8;4.8;4.8" times="0;0.1;0.2;0.3;1" dur="1s" repeatCount="indefinite" begin="-0.875s"></animate>
                </circle>
                <circle cx="67.678" cy="67.678" fill="#363a3c" r="4.8">
                    <animate attributeName="r" values="4.8;4.8;8;4.8;4.8" times="0;0.1;0.2;0.3;1" dur="1s" repeatCount="indefinite" begin="-0.75s"></animate>
                </circle>
                <circle cx="50" cy="75" fill="#363a3c" r="4.8">
                    <animate attributeName="r" values="4.8;4.8;8;4.8;4.8" times="0;0.1;0.2;0.3;1" dur="1s" repeatCount="indefinite" begin="-0.625s"></animate>
                </circle>
                <circle cx="32.322" cy="67.678" fill="#363a3c" r="4.8">
                    <animate attributeName="r" values="4.8;4.8;8;4.8;4.8" times="0;0.1;0.2;0.3;1" dur="1s" repeatCount="indefinite" begin="-0.5s"></animate>
                </circle>
                <circle cx="25" cy="50" fill="#363a3c" r="4.8">
                    <animate attributeName="r" values="4.8;4.8;8;4.8;4.8" times="0;0.1;0.2;0.3;1" dur="1s" repeatCount="indefinite" begin="-0.375s"></animate>
                </circle>
                <circle cx="32.322" cy="32.322" fill="#363a3c" r="4.80282">
                    <animate attributeName="r" values="4.8;4.8;8;4.8;4.8" times="0;0.1;0.2;0.3;1" dur="1s" repeatCount="indefinite" begin="-0.25s"></animate>
                </circle>
                <circle cx="50" cy="25" fill="#363a3c" r="6.40282">
                    <animate attributeName="r" values="4.8;4.8;8;4.8;4.8" times="0;0.1;0.2;0.3;1" dur="1s" repeatCount="indefinite" begin="-0.125s"></animate>
                </circle>
                <circle cx="67.678" cy="32.322" fill="#363a3c" r="7.99718">
                    <animate attributeName="r" values="4.8;4.8;8;4.8;4.8" times="0;0.1;0.2;0.3;1" dur="1s" repeatCount="indefinite" begin="0s"></animate>
                </circle>
            </svg>';
                return;
            }
            echo sprintf('<h2>%s</h2>', esc_html__('No option found','axtra-essential'));
        }
    
    }
    // instance
    new Wcf_Theme_Demo_Import();
}






