<?php

namespace Wcf\Header_Footer\Base\Custom_Post_Type;
use Wcf\Cpt\Custom_Post;

class Header_Footer extends Custom_Post
{

    public $name         = 'Header Footers';
    public $menu         = 'Header Footer';
    public $textdomain   = '';
    public $posts        = array();
    /*
    * plublic_query true for 
    * elementor support 
    */
    public $public_quary = true;
    public $slug         = 'header-footer';
    public $search       = true;

	public function register() {

        $this->textdomain = 'wcf';
        $this->posts      = array();       
        add_action( 'init', array( $this, 'create_post_type' ) , 12 );       
        add_filter( 'save_post_wcf-hf-tpl', array( $this, 'update_template' ), 10,3 );  
        //add_filter( 'save_post_wcf-hf-tpl', array( $this, 'update_meta_settings' ), 11,3 );  
        add_action( 'admin_menu', array(&$this, 'register_sub_menu_post') );
   }
   
    public function get_headers(){
       
        $_header = wcf_hf_header_footer_templates();
        return is_array($_header)?$_header:[];
    }

    public function get_footers(){       
        $_footer = wcf_hf_header_footer_templates('footer');
        return is_array($_footer)?$_footer:[];
    }
    public function register_sub_menu_post() {
        add_submenu_page( 'wcf-axtra-theme-parent', 'Header Footer', 'Header Footer',
        'manage_options', 'edit.php?post_type=wcf-hf-tpl');
      }
    public function create_post_type(){
      
        $this->init( 'wcf-hf-tpl', $this->name, $this->menu, array( 'menu_icon' => 'dashicons-text-page',
            'supports'            => array( 'title'),
            'rewrite'             => array( 'slug' => $this->slug ),
            'exclude_from_search' => $this->search,
            'has_archive'         => false,          
            'publicly_queryable'  => $this->public_quary,
            'hierarchical'        => false,
            'show_in_menu'        => false,
            'show_in_nav_menus'   => false,
        ) 

       );

       $this->register_custom_post();
       $this->add_elementor_editor_support();
    }
     public function add_elementor_editor_support() {
    	add_post_type_support( 'wcf-hf-tpl', 'elementor' );
    }

    public function update_meta_settings( $post_id,$post ,$update ){
           
        if(isset($_POST[ 'wcf_hf_options' ])){
            $options = $_POST[ 'wcf_hf_options' ];
            if( is_array($options) ) {
               foreach($options as $key => $option){
                if($key === 'wcf_hf_custom_header_pages'){
                    if(is_array($option)){
                        update_post_meta( $post_id , $key , $option ); 
                    }                    
                }else{
                    update_post_meta( $post_id , $key , $option ); 
                }                
               }
            }
        }
      
    }
    public function update_template( $post_id,$post ,$update ){
    
        if( get_post_type($post_id) == 'wcf-hf-tpl' ):
            update_post_meta( $post_id, '_wp_page_template', 'elementor_canvas' );
        endif;
       
        if($update):
        
            if(isset($_POST['page_template'])):
                $template = sanitize_text_field($_POST['page_template']);            
                if( get_post_type($post_id) == 'wcf-hf-tpl' ):
                    update_post_meta( $post_id, '_wp_page_template', $template );
                endif;
            endif;     
        
        endif; 
        
       

    }

    public function get_template_display_option(){

        $post_types = get_post_types();

		$post_types_unset = array(
			'attachment'          => 'attachment',
			'revision'            => 'revision',
			'nav_menu_item'       => 'nav_menu_item',
			'custom_css'          => 'custom_css',
			'customize_changeset' => 'customize_changeset',
			'oembed_cache'        => 'oembed_cache',
			'user_request'        => 'user_request',
			'wp_block'            => 'wp_block',
			'elementor_library'   => 'elementor_library',
			'btf_builder'         => 'btf_builder',
			'elementor-hf'        => 'elementor-hf',
			'elementor_font'      => 'elementor_font',
			'elementor_icons'     => 'elementor_icons',
			'wpforms'             => 'wpforms',
			'wpforms_log'         => 'wpforms_log',
			'acf-field-group'     => 'acf-field-group',
			'acf-field'           => 'acf-field',
			'booked_appointments' => 'booked_appointments',
			'wpcf7_contact_form'  => 'wpcf7_contact_form',
			'scheduled-action'    => 'scheduled-action',
			'shop_order'          => 'shop_order',
			'shop_order_refund'   => 'shop_order_refund',
			'shop_coupon'         => 'shop_coupon',
        );
        
        $diff = array_diff( $post_types, $post_types_unset );
        
		$default = array(
			'all'       => esc_html__( 'All', 'axtra-essential'),
			'blog'      => esc_html__( 'Blog Page' , 'axtra-essential'),
			'archive'   => esc_html__( 'Archive Page' , 'axtra-essential'),
			'post'      => esc_html__( 'Post Page' , 'axtra-essential'),
			'page'      => esc_html__( 'Page Page' , 'axtra-essential'),
			'author'    => esc_html__( 'Author Page' , 'axtra-essential'),
			'tags'      => esc_html__( 'Tags Page' , 'axtra-essential'),
			'category'  => esc_html__( 'Category Page' , 'axtra-essential'),
			'search'    => esc_html__( 'Search Page' , 'axtra-essential'),
			'not_found' => esc_html__( '404 Page' , 'axtra-essential'),
        );
        
		$options = array_merge( $default, $diff );

        return $options;
    }
   
}