<?php

namespace AxtraEssentialApp\Blog;

class WCF_Blog_Archive
{
    public $option = null;
    
    function __construct() {
      $this->option = axtra_option('blog_preset_layout');    
      
       add_filter( 'single_template', [ $this , 'load_our_custom_cpt_editor_single_template' ] ); 
      
       add_filter( 'date_template', [ $this,'load_our_custom_blog_template']);
       add_filter( 'author_template', [ $this,'load_our_custom_blog_template']);
       add_filter( 'tag_template', [ $this,'load_our_custom_blog_template']);
       
       add_filter( 'archive_template', [ $this,'load_our_custom_blog_template']);
       add_filter( 'category_template', [ $this,'load_our_custom_blog_template']);
       add_filter( 'home_template', [ $this,'load_our_custom_blog_template']);
       
       add_action( 'admin_menu', array(&$this, 'register_sub_menu_post') );
      // // Elementor Template Import  ajax     
      add_action( 'wp_ajax_wcf_blog_tpl_activate', [ $this , 'wcf_post_tpl_activate' ] );    
      add_action( 'wp_ajax_wcf_blog_tpl_dectivate', [ $this , 'wcf_post_tpl_dectivate' ] );    
      add_action( 'wp_ajax_wcf_blog_tpl_remote_import', [ $this , 'wcf_post_tpl_import' ] );    
      add_action( 'wp_ajax_wcf_blog_tpl_status', [ $this , 'wcf_post_tpl_status' ] );    
      add_action( 'wp_ajax_wcf_data_table_blog_template_activate', [ $this , 'wcf_data_table_template_activate' ] );
      
      //
      
       add_action( 'init', [$this,'custom_post_type']);
       add_filter( 'save_post_wcf-blog-tpl', array( $this, 'update_template' ), 10,3 );
       add_filter( 'wcf_elementor_blog_layout_id', array( $this, 'wcf_elementor_blog_layout' ), 11 );
       add_action( 'manage_posts_extra_tablenav', [$this,'top_form_edit'] );
       
      // Data Table
      add_filter('manage_edit-wcf-blog-tpl_columns', [ $this,'extra_column_add' ]);
      add_action('manage_wcf-blog-tpl_posts_custom_column', [ $this,'active_cpt_column' ], 10, 2);
      add_action('manage_wcf-blog-tpl_posts_custom_column', [ $this,'archive_type_cpt_column' ], 10, 2);
      add_action('manage_wcf-blog-tpl_posts_custom_column', [ $this,'thumbnail_cpt_column' ], 10, 2);
      
      // Elementor preview redirect
      
      add_filter( 'template_redirect', [ $this , 'preview_wp_redirect' ] );
    }
    
    public function preview_wp_redirect(){
      
      if(isset($_GET['wcf-edit']) && isset($_GET['preview_nonce']) && isset($_GET['preview_id'])){
      
        if(get_post_type($_GET['preview_id']) === 'wcf-blog-tpl'){          
          if($this->get_tax_tpl_id( 'blog' )){
            $page_for_posts = get_option( 'page_for_posts' );            
            if(is_numeric($page_for_posts)){
              exit( wp_redirect( get_permalink($page_for_posts) ) );
            }else{
              exit( wp_redirect( home_url('/') ) );
            }            
          }           
        }
       
      }
      
    }
    
    function load_our_custom_cpt_editor_single_template($template){
    
      if ( is_singular('wcf-blog-tpl') ) {
        $preset = $this->option;  
        $is_editor  = false;
        if( defined( 'ELEMENTOR_VERSION' ) ){
          $is_editor  = \Elementor\Plugin::$instance->editor->is_edit_mode() || \Elementor\Plugin::$instance->preview->is_preview_mode() || (isset($_GET['preview_id']) && isset($_GET['preview_nonce']));
          if($is_editor && $preset === 'elementor_builder'){
            $template = AXTRA_ESSENTIAL_DIR_PATH . "templates/header-footer.php";
            return $template;
          }
        }
      }
      
      return $template;
    }
    function extra_column_add( $columns ) {
      unset($columns["date"]);
      $columns["active"]    = esc_html__( 'Active' ,'axtra-essential');
      $columns["thumbnail"] = esc_html__('Thumbnail','axtra-essential');
      $columns["post_type_archive"] = esc_html__('Archive Type','axtra-essential');      
      return $columns;
    }
    
    function archive_type_cpt_column( $colname, $cptid ) {
      $meta_archive_type = get_post_meta($cptid, 'wcf_blog_archive_type' , true);
      if ( $colname == 'post_type_archive'){
        $meta_archive_type = $meta_archive_type == false || $meta_archive_type == '' ? 'blog' : $meta_archive_type;
        echo sprintf('<p class="archive-type" data-type ="%s">%s</p>',$meta_archive_type  , ucfirst( $meta_archive_type ));
      }
      
    }
    function active_cpt_column( $colname, $cptid ) {
    
      if ( $colname == 'active'){
        $meta_archive_type = get_post_meta($cptid, 'wcf_essential_settings_blog_layoutactivate' , true);
      
        if($meta_archive_type){
          echo sprintf('<p class="wcf-blog-type-button active">&check; %s </p>', esc_html__('Active', 'axtra-essential'));
        }else{
          echo sprintf('<p class="wcf-blog-type-button deactive">%s</p>', esc_html__('Inactive', 'axtra-essential'));
        }
        
      }
         
    }
    
    function thumbnail_cpt_column( $colname, $cptid ) {
      if ( $colname == 'thumbnail')
        echo get_the_post_thumbnail( $cptid , 'thumbnail', array( 'class' => 'alignleft' ) );
    }
    
    function top_form_edit( ) {
      static $single_load = null;
      if(isset($_GET['post_type']) && $_GET['post_type'] == 'wcf-blog-tpl' && is_null($single_load)){
        $single_load = 1; 
        ?>
         <script>          
           
            var wcf_button_add = document.querySelector('.page-title-action');
            var wcf_new_button = document.createElement("a");
            wcf_new_button.innerHTML = 'Import Templates';
            wcf_new_button.classList = 'add-new-h2 wcf-post-layout-import-modal';
            wcf_new_button.setAttribute('href', 'javascript:void(0)');
            wcf_new_button.setAttribute('data-id', 'blog_layout');
            wcf_new_button.onclick = function(e){
              jQuery('.wcf-modal-state').prop("checked", true);
            };
            if(wcf_button_add){             
              wcf_button_add.after(wcf_new_button);
            }
            jQuery(document).on('click', ".wcf-modal__close-import" ,function(){
                location.reload();
            });
         </script>         
        <?php 

      }
      
    }
    public function add_elementor_editor_support() {
    	add_post_type_support( 'wcf-blog-tpl', 'elementor' );
    }
    public function update_template( $post_id,$post ,$update ){
      
      if($update){          
            if(isset($_POST['page_template'])):
                $template = sanitize_text_field($_POST['page_template']);
                if(get_post_type($post_id) =='wcf-blog-tpl'):
                    update_post_meta( $post_id, '_wp_page_template', $template );
                endif;
            endif;
            if(isset($_POST['wcf_blog_archive_options'])){
              $archive_type = isset($_POST[ 'wcf_blog_archive_options' ][ 'wcf_blog_archive_type' ]) ? $_POST[ 'wcf_blog_archive_options' ][ 'wcf_blog_archive_type' ] : 'none';
              $active       = isset($_POST[ 'wcf_blog_archive_options' ][ 'wcf_essential_settings_blog_layoutactivate' ]) ? $_POST[ 'wcf_blog_archive_options' ][ 'wcf_essential_settings_blog_layoutactivate' ] : false;
              if( $active ){
                $this->get_tax_tpl_deactivate( $archive_type , $post_id );
              }
            }          
      else{
          update_post_meta( $post_id, '_wp_page_template', 'elementor_canvas' );
      }
    }

  }
    
    function custom_post_type(){
      register_post_type('wcf-blog-tpl',
        array(
          'labels'      => array(
            'name'          => __('Elementor Archive Layouts', 'axtra-essential'),
            'singular_name' => __('Elementor Archive Layout', 'axtra-essential'),
          ),
            'public'              => true,
            'menu_icon'           => 'dashicons-text-page',
            'supports'            => [ 'title' , 'editor' , 'thumbnail' ],            
            'exclude_from_search' => false,
            'has_archive'         => false,  
            'show_in_nav_menus'   => false,
            'publicly_queryable'  => true,     
            'hierarchical'        => false,
            'show_in_menu'        => false,
        )
      );
      $this->add_elementor_editor_support();
    }
    
    public function register_sub_menu_post() {
      $preset = $this->option;
      //if($preset === 'elementor_builder'){
        add_submenu_page( 'wcf-axtra-theme-parent', 'Archive Layout', 'Archive Layout',
        'manage_options', 'edit.php?post_type=wcf-blog-tpl');
      //}
    }
  
    function load_our_custom_blog_template($template) {    
      
        $permitted_pages = [ 'index.php' , 'category.php' , 'archive.php' , 'tag.php' , 'author.php' ];
        if ( in_array( basename( $template ) , $permitted_pages )) {          
          $preset     = $this->option;
          $is_editor  = false;
          
          if( defined( 'ELEMENTOR_VERSION' ) ){
          
            $is_editor  = \Elementor\Plugin::$instance->editor->is_edit_mode() || \Elementor\Plugin::$instance->preview->is_preview_mode() || (isset($_GET['preview_id']) && isset($_GET['preview_nonce']));
            if( $is_editor && $preset === 'elementor_builder' ){
              $template = AXTRA_ESSENTIAL_DIR_PATH . "templates/header-footer.php";
              return $template;
            }
            
          }         
      
          if( !is_post_type_archive() ){
          
            if( $this->get_tax_tpl_id( 'blog' ) ){
              $template = AXTRA_ESSENTIAL_DIR_PATH . "templates/archive/elementor_builder.php";           
            }
            
            if( is_tag() && $this->get_tax_tpl_id( 'post_tag' ) ){
              $template = AXTRA_ESSENTIAL_DIR_PATH . "templates/archive/elementor_builder.php";
            }
            
            if( is_category() && $this->get_tax_tpl_id( 'category' ) ){
              $template = AXTRA_ESSENTIAL_DIR_PATH . "templates/archive/elementor_builder.php";
            }
            
            if( is_author() && $this->get_tax_tpl_id( 'author' ) ){
              $template = AXTRA_ESSENTIAL_DIR_PATH . "templates/archive/elementor_builder.php";
            }
            
          }                     
          
        }
        // Custom Post Type
      
        if(is_post_type_archive()){
          $tax_obj = get_queried_object(); 
          
          if(isset($tax_obj->name)){
            if( $this->get_tax_tpl_id( $tax_obj->name ) ){
              $template = AXTRA_ESSENTIAL_DIR_PATH . "templates/archive/elementor_builder.php";
            }
          }elseif(file_exists(get_template_directory() . "/archive-{$tax_obj->name}.php")){
            $template = get_template_directory() . "/archive-{$tax_obj->name}.php";
          }elseif(file_exists(get_template_directory() . '/archive.php')){
            $template = get_template_directory() . '/archive.php';     
          }else{
            $template = get_template_directory() . '/index.php';     
          }  
        }
        
        if(is_tax() && get_query_var('taxonomy')){
          $tax_type = get_query_var('taxonomy');    
          if($this->get_tax_tpl_id( $tax_type )){
            $template = AXTRA_ESSENTIAL_DIR_PATH . "templates/archive/elementor_builder.php";
          }else{
           
            $taxObject = get_taxonomy($tax_type);
            $postTypes = $taxObject->object_type;
            if(isset($postTypes[0]) && $this->get_tax_tpl_id( $postTypes[0] )){
              $template = AXTRA_ESSENTIAL_DIR_PATH . "templates/archive/elementor_builder.php";
            }elseif(file_exists(get_template_directory() . "/taxonomy-{$tax_type}.php")){
              $template = get_template_directory() .  "/taxonomy-{$tax_type}.php" ;           
            }elseif(file_exists(get_template_directory() . '/archive.php')){
            $template = get_template_directory() . '/archive.php';     
            }else{
              $template = get_template_directory() . '/index.php';     
            }            
           
          }         
        }
   
        return $template;
    }
    
    
    public function wcf_elementor_blog_layout($id){
      
      if( !is_post_type_archive() && $blog_id = $this->get_tax_tpl_id('blog')){
        $id = $blog_id;       
      }          
      
      if(is_post_type_archive()){
        $tax_obj = get_queried_object();            
        if(isset($tax_obj->name)){
          if( $custom_id = $this->get_tax_tpl_id( $tax_obj->name ) ){
            $id = $custom_id;
          }
        }
      }
      
      if(is_category()){
        if( $cat_id = $this->get_tax_tpl_id( 'category' ) ){
          $id = $cat_id;
        }
      }
      
      if(is_tag()){
        if( $tag_id = $this->get_tax_tpl_id( 'post_tag' ) ){
          $id = $tag_id ;
        }
      }
      
      if(is_author()){
        if( $auth_id = $this->get_tax_tpl_id( 'author' ) ){
          $id = $auth_id;
        }
      }
      
      if(is_tax() && get_query_var('taxonomy')){
        $tax_type = get_query_var('taxonomy');
        if($custom_id = $this->get_tax_tpl_id( $tax_type ) ){
          $id = $custom_id;
        }else{
          $taxObject = get_taxonomy($tax_type);
          $postTypes = $taxObject->object_type;
          if(isset($postTypes[0]) && $post_type_id = $this->get_tax_tpl_id( $postTypes[0] )){
            $id = $post_type_id;
          }
        }         
      }
      
      return $id;
    }
    
    public function get_tax_tpl_id($value='blog'){
      $template_id = null;
      $args = array(
        'numberposts' => 1,
        'post_type'   => 'wcf-blog-tpl',        
        'meta_query'  => array(
          array(
            'key'       => 'wcf_blog_archive_type',
            'value'     => $value,
          ),
          array(
            'key'       => 'wcf_essential_settings_blog_layoutactivate',
            'value'   => array('yes', '1', 1) ,
            'compare' => 'IN'
          )
        )
      );
        
      $latest_posts = get_posts( $args );
      
      if($latest_posts && isset($latest_posts[0])){
        $template_id = $latest_posts[0]->ID;
      }
      return $template_id;
    }
    
    public function get_tax_tpl_deactivate($value='blog', $exclude=0){
      
      $args = array(
        'numberposts' => 1,
        'post_type'   => 'wcf-blog-tpl', 
        'post__not_in' => array($exclude),
        'meta_query'  => array(
          array(
            'key'       => 'wcf_blog_archive_type',
            'value'     => $value,
          ),
          array(
            'key'       => 'wcf_essential_settings_blog_layoutactivate',
            'value'   => array('yes', '1', 1) ,
            'compare' => 'IN'
          )
        )
      );
        
      $latest_posts = get_posts( $args );
      foreach($latest_posts as $item){
        update_post_meta($item->ID , 'wcf_essential_settings_blog_layoutactivate' , 0);
      }
    }
    public function wcf_post_tpl_activate(){
      
      $tpl                 = $_REQUEST['tpl_id'];
      $return['message']   = '<b>Activation Done</b> <br/> <p>Please Check Blog Post</p>';
      $return['next_step'] = 'action_deactivate';
      
      update_option( 'wcf-elementor-blog-layout-id', $tpl );     
      update_option( 'wcf-elementor-blog-layout-id-', $tpl );     
      delete_post_meta_by_key('wcf_essential_settings_blog_layoutactivate');
      update_post_meta($tpl, 'wcf_essential_settings_blog_layoutactivate' , 'yes');
      
      if(is_null($this->get_tax_tpl_id('blog'))){
        update_post_meta($tpl, 'wcf_blog_archive_type' , 'blog');
      }
      
      wp_send_json($return);
    }
    public function wcf_post_tpl_dectivate(){
      $tpl                 = $_REQUEST['tpl_id'];
      $return['message']   = '<b>Deactivation Done</b>';
      $return['next_step'] = 'action_activate';
      update_option( 'wcf-elementor-blog-layout-id', '' );
      update_post_meta($tpl, 'wcf_essential_settings_blog_layoutactivate' , 'no');        
      wp_send_json($return);
    }
    
    public function wcf_post_tpl_status(){
      $tpl = $_REQUEST['tpl_id'];     
     
      $return['message']  = '';
      $return['tpl_id']  = $tpl;
      $return['next_step'] = 'action_fetch';
      $is_active = $this->wcf_check_template_available($tpl);
      if($is_active){
        $return['next_step'] = 'action_activate';
        $return['message']  = 'Already Imported';
        $return['current_layout_id'] = $is_active->ID;
        $tpl = $is_active->ID;
      }
      
      $n_status = get_post_meta($tpl, 'wcf_essential_settings_blog_layoutactivate', true);       
      if( $n_status ){
        $return['next_step'] = 'action_deactivate';
      }
      wp_send_json($return);
    }
    
    public function wcf_data_table_template_activate(){
      $tpl = $_REQUEST['tpl_id'];
      $is_active = $_REQUEST['is_active'];
      if($is_active){
        $return['message']  = '<b>Activation Done</b> <br/> <p>Please Check Blog Post</p>';         
        delete_post_meta_by_key('wcf_essential_settings_blog_layoutactivate');
        update_post_meta($tpl, 'wcf_essential_settings_blog_layoutactivate' , 1);  
      }else{
        $return['message']  = '<b>deactivation Done</b> <br/> <p>Please Check Blog Post</p>';        
        delete_post_meta_by_key('wcf_essential_settings_blog_layoutactivate');
        update_post_meta($tpl, 'wcf_essential_settings_blog_layoutactivate' , 0);  
      }
     
      wp_send_json($return);
    }

    public function wcf_check_template_available($tpld_id){

      $args = array(
          'numberposts' => 1,
          'post_type' => 'wcf-blog-tpl',
          'meta_query' => array(
              array(
                  'key'       => 'wcf_spost_file_imported',
                  'value'     => $tpld_id,
                  'compare'   => '='
              )
          )
      );
    
      $posts = get_posts($args);

      if($posts && isset($posts[0])){
        return $posts[0];
      }
      
      return false;
    }
    public function wcf_post_tpl_import(){
      global $wpdb;
      $return = array(
        'message'  => ''
      );
      
      $tpl = $_REQUEST['tpl_id'];
      // Detect duplicate
      $is_active = $this->wcf_check_template_available($tpl);
      if($is_active){
        $return['message'] = '<i>Duplicate</i> <span>File Already Imported</span>';
        $return['next_step'] = 'action_activate';
        $return['current_layout_id'] = $is_active->ID;        
        wp_send_json($return);
      }
      $return['message'] = esc_html__('Successfully Imported the content','axtra-essential');
      $path = AXTRA_ESSENTIAL_DEMO_BASE_PATH.'blog-layouts/'.$tpl;
     
      $fileContent = file_get_contents( $path );
      $fileJson    = json_decode( $fileContent, true );
  
      $result      = \Elementor\Plugin::instance()->templates_manager->import_template( [
              'fileData' => base64_encode( $fileContent ),
              'fileName' => 'test.json',
          ]
      );
  
      if ( empty( $result ) || empty( $result[0] ) ) {
        $return['message'] = '<b>File Not found</b> <br/> <p>Please Contact Theme Author</p>';
        wp_send_json($return);
      }
      $return['imported_id']  = $result[0]['template_id'];
      set_post_type($result[0]['template_id'],'wcf-blog-tpl');
      if(isset($_REQUEST['thumbnail']) && $_REQUEST['thumbnail'] !=''){
        $thumbnail_url = $_REQUEST['thumbnail'];
        $attachment_id = axtra_remote_sideloader($thumbnail_url,$result[0]['template_id'],$_REQUEST['title']);
        set_post_thumbnail( $result[0]['template_id'] , $attachment_id );
      }
      
      // update_option( 'wcf-elementor-post-layout-id', $result[0]['template_id'] );
      update_post_meta( $result[0]['template_id'] , 'wcf_spost_file_imported', $tpl );
      update_post_meta( $result[0]['template_id'] , '_wp_page_template', 'elementor_header_footer' );
      $return['next_step'] = 'action_activate';
      $return['current_layout_id'] = $result[0]['template_id'];    
      wp_send_json($return);
    }
  
      
}

new WCF_Blog_Archive();




