<?php

   $blog_readmore__icon = AXTRA_IMG .'/default-blog/icon-right-arrow.svg';
   $read_more_icon_option = axtra_option('blog_readmore__icon');
   $icon = '<i class="icon-wcf-arrow-right"></i>';
   if(is_array($read_more_icon_option) && isset($read_more_icon_option['url']) && $read_more_icon_option['url'] !=''){
    $blog_readmore__icon = $read_more_icon_option['url'];
    $icon = sprintf('<img src="%s" alt="%s">', esc_url($blog_readmore__icon), esc_attr__('arrow right','axtra'));
   }
 
?>

<article <?php post_class('default-blog__item-single'); ?>>
    <?php if(has_post_thumbnail()): ?> 
      <a href="<?php the_permalink(); ?>"><img src="<?php echo get_the_post_thumbnail_url(); ?>" alt="<?php the_title_attribute(); ?>"></a>
    <?php endif; ?>
    <div class="default-blog__content">
      <?php echo axtra_post_meta(); ?>
        <h2 class="default-blog__item-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
        <div class="cf_text">
         <?php axtra_excerpt( 40, null ); ?>
        </div>
        <?php if(axtra_option('blog_readmore',1)): ?>
          <div class="cf_btn">
            <a href="<?php the_permalink(); ?>" class="wc-btn-underline"><?php echo esc_html(axtra_option('blog_readmore_text','Read more')); ?><?php echo axtra_kses($icon); ?></a>
          </div>
        <?php endif; ?>
    </div>
</article>