<?php

/*----------------------------------------------------
SHORTHAND CONTANTS FOR THEME VERSION
-----------------------------------------------------*/
update_option( 'enable_full_version', '1' );
update_option( 'Axtra_lic_Key', 'activated' );
update_option( 'Axtra_lic_email', 'null@null.market' );

if ( site_url() === 'http://localhost:8080/development' ) {
    define( 'AXTRA_VERSION', time() );
} else {
    define( 'AXTRA_VERSION', 2.0 );
    
}

/*----------------------------------------------------
SHORTHAND CONTANTS FOR THEME ASSETS URL
-----------------------------------------------------*/
define( 'AXTRA_THEME_URI', get_template_directory_uri() );
define( 'AXTRA_ASSETS', AXTRA_THEME_URI . '/assets/' );
define( 'AXTRA_IMG', AXTRA_THEME_URI . '/assets/imgs' );
define( 'AXTRA_CSS', AXTRA_THEME_URI . '/assets/css' );
define( 'AXTRA_JS', AXTRA_THEME_URI . '/assets/js' );

/*----------------------------------------------------
SHORTHAND CONTANTS FOR THEME ASSETS DIRECTORY PATH
-----------------------------------------------------*/
define( 'AXTRA_THEME_DIR', get_template_directory() );
define( 'AXTRA_IMG_DIR', AXTRA_THEME_DIR . '/assets/imgs' );
define( 'AXTRA_CSS_DIR', AXTRA_THEME_DIR . '/assets/css' );
define( 'AXTRA_JS_DIR', AXTRA_THEME_DIR . '/assets/js' );



/*----------------------------------------------------
LOAD Classes
-----------------------------------------------------*/
if ( file_exists( dirname( __FILE__ ) . '/app/loader.php' ) ):
    require_once dirname( __FILE__ ) . '/app/loader.php';    
endif;
/*----------------------------------------------------
SET UP THE CONTENT WIDTH VALUE BASED ON THE THEME'S DESIGN
-----------------------------------------------------*/
if ( !isset( $content_width ) ) {
    $content_width = 800;
}

add_filter( 'use_block_editor_for_post', '__return_false' );

// Disable Gutenberg for widgets.
add_filter( 'use_widgets_block_editor', '__return_false' );


//Woocommerce Supports
function axtra_add_woocommerce_support() {
	add_theme_support( 'woocommerce', array(
		'thumbnail_image_width' => 350,
		'single_image_width'    => 350,
		'product_grid'          => array(
			'default_rows'    => 3,
			'min_rows'        => 2,
			'max_rows'        => 8,
			'default_columns' => 4,
			'min_columns'     => 2,
			'max_columns'     => 5,
		),
	) );

	add_theme_support( 'wc-product-gallery-zoom' );
	add_theme_support( 'wc-product-gallery-lightbox' );
	add_theme_support( 'wc-product-gallery-slider' );


}

add_action( 'after_setup_theme', 'axtra_add_woocommerce_support' );


