<?php
namespace Axtra\Core;

/**
 * Enqueue.
 */
class Enqueue 
{

	/**
	 * register default hooks and actions for WordPress
	 * @return
	 */
	public function register() 
	{
		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ) );		    
	}
       
	public function enqueue_scripts() 
	{
	
    	// stylesheets
    	wp_register_style( 'wcf-custom-icons', AXTRA_CSS . '/custom-icons.min.css', null, AXTRA_VERSION );
    	wp_register_style( 'magnific-popup', AXTRA_CSS . '/magnific-popup.min.css', null, AXTRA_VERSION );
    	wp_register_style( 'vidbacking', AXTRA_CSS . '/jquery.vidbacking.css', null, AXTRA_VERSION );
    	wp_register_style( 'bootstrap', AXTRA_CSS . '/bootstrap.min.css', null, AXTRA_VERSION );
		// ::::::::::::::::::::::::::::::::::::::::::
		if ( !is_admin() ) {			

			// 3rd party css
			wp_enqueue_style( 'axtra-fonts', axtra_google_fonts_url(['Prata:300,400;500,600,700,800,900']), null, AXTRA_VERSION );						
			wp_enqueue_style( 'meanmenu', AXTRA_CSS . '/meanmenu.min.css', null, AXTRA_VERSION );	
			wp_enqueue_style( 'bootstrap' );
			wp_enqueue_style( 'magnific-popup' );
		   
		    // Theme style
			wp_enqueue_style( 'axtra-style', AXTRA_CSS . '/style.css', null, AXTRA_VERSION );

			// WooCommerce
			if ( class_exists( 'WooCommerce' ) ) {
				wp_enqueue_style( 'axtra-woo', AXTRA_CSS . '/woo.css', null, AXTRA_VERSION );
			}

			wp_enqueue_style( 'wcf-custom-icons' );			

		}

		// javascripts
		// :::::::::::::::::::::::::::::::::::::::::::::::
		if ( !is_admin() ) {
			
			// 3rd party scripts
				
			wp_enqueue_script( 'bootstrap', AXTRA_JS . '/bootstrap.bundle.min.js', array( 'jquery' ), AXTRA_VERSION, true );	
			wp_enqueue_script( 'meanmenu', AXTRA_JS . '/jquery.meanmenu.min.js', array( 'jquery' ), AXTRA_VERSION, true );		
			wp_enqueue_script( 'magnific-popup', AXTRA_JS . '/jquery.magnific-popup.min.js', array( 'jquery' ), AXTRA_VERSION, true );			
            if(is_singular('post')){
				wp_enqueue_script( 'goodshare', AXTRA_JS . '/goodshare.min.js', array( 'jquery' ), AXTRA_VERSION, true );
			}
			// theme scripts			
			wp_enqueue_script( 'axtra-script', AXTRA_JS . '/script.js', array( 'jquery','bootstrap'), AXTRA_VERSION, true );
		
			$axtra_data = apply_filters('axtra/script/custom/data',[
				 'ajax_url' => admin_url( 'admin-ajax.php' ),			 
			]);
			
			wp_localize_script( 'axtra-script', 'axtra_obj', $axtra_data);
			// Load WordPress Comment js
			if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		    	wp_enqueue_script( 'comment-reply' );
			}

		}
    }
}
