<?php

namespace King_Addons;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

final class TemplatesMap
{
    public static function getTemplatesMapArray(): array
    {
        return [
            'templates' => [
                't6-digital-marketing-agency' => [
                    'title' => esc_html__('Digital Marketing Agency', 'king-addons'),
                    'plan' => 'free',
                    'collection' => 6,
                    'category' => 'technology',
                    'subcategory' => 'agency',
                    'tags' => ['agency', 'consulting', 'creative agency', 'digital marketing', 'digital marketing agency', 'marketing agency', 'online marketing', 'SEO', 'SEO agency', 'SEO theme', 'SMM', 'SMM agency', 'social media', 'web development', 'website analysis'],
                ],
                't15-web-development-agency' => [
                    'title' => esc_html__('Web Development Agency', 'king-addons'),
                    'plan' => 'free',
                    'collection' => 15,
                    'category' => 'creative',
                    'subcategory' => 'development',
                    'tags' => ['agency', 'business', 'company', 'consulting', 'corporate', 'finance', 'web', 'development', 'marketing', 'modern', 'minimal', 'IT', 'consultant', 'SMM'],
                ],
                't15-agency' => [
                    'title' => esc_html__('Agency', 'king-addons'),
                    'plan' => 'free',
                    'collection' => 15,
                    'category' => 'creative',
                    'subcategory' => 'development',
                    'tags' => ['agency', 'business', 'company', 'consulting', 'corporate', 'finance', 'web', 'development', 'marketing', 'modern', 'minimal', 'IT', 'consultant', 'SMM'],
                ],
                't15-broadband' => [
                    'title' => esc_html__('Broadband', 'king-addons'),
                    'plan' => 'free',
                    'collection' => 15,
                    'category' => 'creative',
                    'subcategory' => 'development',
                    'tags' => ['agency', 'business', 'company', 'consulting', 'corporate', 'finance', 'web', 'development', 'marketing', 'modern', 'minimal', 'IT', 'consultant', 'SMM'],
                ],
                't15-content-writing-agency' => [
                    'title' => esc_html__('Content Writing Agency', 'king-addons'),
                    'plan' => 'free',
                    'collection' => 15,
                    'category' => 'creative',
                    'subcategory' => 'development',
                    'tags' => ['agency', 'business', 'company', 'consulting', 'corporate', 'finance', 'web', 'development', 'marketing', 'modern', 'minimal', 'IT', 'consultant', 'SMM'],
                ],
                't15-ebook-landing' => [
                    'title' => esc_html__('eBook Landing', 'king-addons'),
                    'plan' => 'free',
                    'collection' => 15,
                    'category' => 'creative',
                    'subcategory' => 'development',
                    'tags' => ['agency', 'business', 'company', 'consulting', 'corporate', 'finance', 'web', 'development', 'marketing', 'modern', 'minimal', 'IT', 'consultant', 'SMM'],
                ],
                't15-graphic-design-services' => [
                    'title' => esc_html__('Graphic Design Services', 'king-addons'),
                    'plan' => 'free',
                    'collection' => 15,
                    'category' => 'creative',
                    'subcategory' => 'development',
                    'tags' => ['agency', 'business', 'company', 'consulting', 'corporate', 'finance', 'web', 'development', 'marketing', 'modern', 'minimal', 'IT', 'consultant', 'SMM'],
                ],
                't15-it-hr-services' => [
                    'title' => esc_html__('IT HR Service', 'king-addons'),
                    'plan' => 'free',
                    'collection' => 15,
                    'category' => 'creative',
                    'subcategory' => 'development',
                    'tags' => ['agency', 'business', 'company', 'consulting', 'corporate', 'finance', 'web', 'development', 'marketing', 'modern', 'minimal', 'IT', 'consultant', 'SMM'],
                ],
                't15-language-school' => [
                    'title' => esc_html__('Language School', 'king-addons'),
                    'plan' => 'free',
                    'collection' => 15,
                    'category' => 'creative',
                    'subcategory' => 'development',
                    'tags' => ['agency', 'business', 'company', 'consulting', 'corporate', 'finance', 'web', 'development', 'marketing', 'modern', 'minimal', 'IT', 'consultant', 'SMM'],
                ],
                't15-mobile-app-landing' => [
                    'title' => esc_html__('Mobile App Landing', 'king-addons'),
                    'plan' => 'free',
                    'collection' => 15,
                    'category' => 'creative',
                    'subcategory' => 'development',
                    'tags' => ['agency', 'business', 'company', 'consulting', 'corporate', 'finance', 'web', 'development', 'marketing', 'modern', 'minimal', 'IT', 'consultant', 'SMM'],
                ],
                't15-nft-single-item-landing' => [
                    'title' => esc_html__('NFT Single Item Landing', 'king-addons'),
                    'plan' => 'free',
                    'collection' => 15,
                    'category' => 'creative',
                    'subcategory' => 'development',
                    'tags' => ['agency', 'business', 'company', 'consulting', 'corporate', 'finance', 'web', 'development', 'marketing', 'modern', 'minimal', 'IT', 'consultant', 'SMM'],
                ],
                't15-online-course-landing' => [
                    'title' => esc_html__('Online Course Landing', 'king-addons'),
                    'plan' => 'free',
                    'collection' => 15,
                    'category' => 'creative',
                    'subcategory' => 'development',
                    'tags' => ['agency', 'business', 'company', 'consulting', 'corporate', 'finance', 'web', 'development', 'marketing', 'modern', 'minimal', 'IT', 'consultant', 'SMM'],
                ],
                't15-saas-services' => [
                    'title' => esc_html__('SaaS Services', 'king-addons'),
                    'plan' => 'free',
                    'collection' => 15,
                    'category' => 'creative',
                    'subcategory' => 'development',
                    'tags' => ['agency', 'business', 'company', 'consulting', 'corporate', 'finance', 'web', 'development', 'marketing', 'modern', 'minimal', 'IT', 'consultant', 'SMM'],
                ],
                't15-software-landing' => [
                    'title' => esc_html__('Software Landing', 'king-addons'),
                    'plan' => 'free',
                    'collection' => 15,
                    'category' => 'creative',
                    'subcategory' => 'development',
                    'tags' => ['agency', 'business', 'company', 'consulting', 'corporate', 'finance', 'web', 'development', 'marketing', 'modern', 'minimal', 'IT', 'consultant', 'SMM'],
                ],
                't15-digital-marketing-agency' => [
                    'title' => esc_html__('Digital Marketing Agency', 'king-addons'),
                    'plan' => 'free',
                    'collection' => 15,
                    'category' => 'creative',
                    'subcategory' => 'development',
                    'tags' => ['agency', 'business', 'company', 'consulting', 'corporate', 'finance', 'web', 'development', 'marketing', 'modern', 'minimal', 'IT', 'consultant', 'SMM'],
                ],
                't15-digital-marketing' => [
                    'title' => esc_html__('Digital Marketing', 'king-addons'),
                    'plan' => 'free',
                    'collection' => 15,
                    'category' => 'creative',
                    'subcategory' => 'development',
                    'tags' => ['agency', 'business', 'company', 'consulting', 'corporate', 'finance', 'web', 'development', 'marketing', 'modern', 'minimal', 'IT', 'consultant', 'SMM'],
                ],
                't15-email-marketing-services' => [
                    'title' => esc_html__('Email Marketing Services', 'king-addons'),
                    'plan' => 'free',
                    'collection' => 15,
                    'category' => 'creative',
                    'subcategory' => 'development',
                    'tags' => ['agency', 'business', 'company', 'consulting', 'corporate', 'finance', 'web', 'development', 'marketing', 'modern', 'minimal', 'IT', 'consultant', 'SMM'],
                ],
                't15-seo-agency' => [
                    'title' => esc_html__('SEO Agency', 'king-addons'),
                    'plan' => 'free',
                    'collection' => 15,
                    'category' => 'creative',
                    'subcategory' => 'development',
                    'tags' => ['agency', 'business', 'company', 'consulting', 'corporate', 'finance', 'web', 'development', 'marketing', 'modern', 'minimal', 'IT', 'consultant', 'SMM'],
                ],
                't15-seo-services' => [
                    'title' => esc_html__('SEO Services', 'king-addons'),
                    'plan' => 'free',
                    'collection' => 15,
                    'category' => 'creative',
                    'subcategory' => 'development',
                    'tags' => ['agency', 'business', 'company', 'consulting', 'corporate', 'finance', 'web', 'development', 'marketing', 'modern', 'minimal', 'IT', 'consultant', 'SMM'],
                ],
                't15-smm-instagram' => [
                    'title' => esc_html__('SMM Instagram', 'king-addons'),
                    'plan' => 'free',
                    'collection' => 15,
                    'category' => 'creative',
                    'subcategory' => 'development',
                    'tags' => ['agency', 'business', 'company', 'consulting', 'corporate', 'finance', 'web', 'development', 'marketing', 'modern', 'minimal', 'IT', 'consultant', 'SMM'],
                ],
                't15-smm-services' => [
                    'title' => esc_html__('SMM Services', 'king-addons'),
                    'plan' => 'free',
                    'collection' => 15,
                    'category' => 'creative',
                    'subcategory' => 'development',
                    'tags' => ['agency', 'business', 'company', 'consulting', 'corporate', 'finance', 'web', 'development', 'marketing', 'modern', 'minimal', 'IT', 'consultant', 'SMM'],
                ],
                't15-creative-agency' => [
                    'title' => esc_html__('Creative Agency', 'king-addons'),
                    'plan' => 'free',
                    'collection' => 15,
                    'category' => 'creative',
                    'subcategory' => 'development',
                    'tags' => ['agency', 'business', 'company', 'consulting', 'corporate', 'finance', 'web', 'development', 'marketing', 'modern', 'minimal', 'IT', 'consultant', 'SMM'],
                ],
                't15-financial-consultant' => [
                    'title' => esc_html__('Financial Consultant', 'king-addons'),
                    'plan' => 'free',
                    'collection' => 15,
                    'category' => 'creative',
                    'subcategory' => 'development',
                    'tags' => ['agency', 'business', 'company', 'consulting', 'corporate', 'finance', 'web', 'development', 'marketing', 'modern', 'minimal', 'IT', 'consultant', 'SMM'],
                ],
                't15-it-consultant' => [
                    'title' => esc_html__('IT Consultant', 'king-addons'),
                    'plan' => 'free',
                    'collection' => 15,
                    'category' => 'creative',
                    'subcategory' => 'development',
                    'tags' => ['agency', 'business', 'company', 'consulting', 'corporate', 'finance', 'web', 'development', 'marketing', 'modern', 'minimal', 'IT', 'consultant', 'SMM'],
                ],
                't15-business-consultant' => [
                    'title' => esc_html__('Business Consultant', 'king-addons'),
                    'plan' => 'free',
                    'collection' => 15,
                    'category' => 'creative',
                    'subcategory' => 'business',
                    'tags' => ['agency', 'business', 'company', 'consulting', 'corporate', 'finance', 'web', 'development', 'marketing', 'modern', 'minimal', 'IT', 'consultant', 'SMM'],
                ],
                't15-business-consulting-1' => [
                    'title' => esc_html__('Business Consulting 1', 'king-addons'),
                    'plan' => 'free',
                    'collection' => 15,
                    'category' => 'creative',
                    'subcategory' => 'business',
                    'tags' => ['agency', 'business', 'company', 'consulting', 'corporate', 'finance', 'web', 'development', 'marketing', 'modern', 'minimal', 'IT', 'consultant', 'SMM'],
                ],
                't15-business-consulting-2' => [
                    'title' => esc_html__('Business Consulting 2', 'king-addons'),
                    'plan' => 'free',
                    'collection' => 15,
                    'category' => 'creative',
                    'subcategory' => 'business',
                    'tags' => ['agency', 'business', 'company', 'consulting', 'corporate', 'finance', 'web', 'development', 'marketing', 'modern', 'minimal', 'IT', 'consultant', 'SMM'],
                ],
                't15-business-consulting-3' => [
                    'title' => esc_html__('Business Consulting 3', 'king-addons'),
                    'plan' => 'free',
                    'collection' => 15,
                    'category' => 'creative',
                    'subcategory' => 'business',
                    'tags' => ['agency', 'business', 'company', 'consulting', 'corporate', 'finance', 'web', 'development', 'marketing', 'modern', 'minimal', 'IT', 'consultant', 'SMM'],
                ],
                't15-business-consulting-services' => [
                    'title' => esc_html__('Business Consulting Services', 'king-addons'),
                    'plan' => 'free',
                    'collection' => 15,
                    'category' => 'creative',
                    'subcategory' => 'business',
                    'tags' => ['agency', 'business', 'company', 'consulting', 'corporate', 'finance', 'web', 'development', 'marketing', 'modern', 'minimal', 'IT', 'consultant', 'SMM'],
                ],
                't15-webinar' => [
                    'title' => esc_html__('Webinar', 'king-addons'),
                    'plan' => 'free',
                    'collection' => 15,
                    'category' => 'creative',
                    'subcategory' => 'business',
                    'tags' => ['agency', 'business', 'company', 'consulting', 'corporate', 'finance', 'web', 'development', 'marketing', 'modern', 'minimal', 'IT', 'consultant', 'SMM'],
                ],
                't15-event' => [
                    'title' => esc_html__('Event', 'king-addons'),
                    'plan' => 'free',
                    'collection' => 15,
                    'category' => 'creative',
                    'subcategory' => 'event',
                    'tags' => ['agency', 'business', 'company', 'consulting', 'corporate', 'finance', 'web', 'development', 'marketing', 'modern', 'minimal', 'IT', 'consultant', 'SMM'],
                ],
                't15-event-2' => [
                    'title' => esc_html__('Event 2', 'king-addons'),
                    'plan' => 'free',
                    'collection' => 15,
                    'category' => 'creative',
                    'subcategory' => 'event',
                    'tags' => ['agency', 'business', 'company', 'consulting', 'corporate', 'finance', 'web', 'development', 'marketing', 'modern', 'minimal', 'IT', 'consultant', 'SMM'],
                ],
                't15-event-3' => [
                    'title' => esc_html__('Event 3', 'king-addons'),
                    'plan' => 'free',
                    'collection' => 15,
                    'category' => 'creative',
                    'subcategory' => 'event',
                    'tags' => ['agency', 'business', 'company', 'consulting', 'corporate', 'finance', 'web', 'development', 'marketing', 'modern', 'minimal', 'IT', 'consultant', 'SMM'],
                ],
                't15-law' => [
                    'title' => esc_html__('Law', 'king-addons'),
                    'plan' => 'free',
                    'collection' => 25,
                    'category' => 'legal',
                    'subcategory' => 'event',
                    'tags' => ['agency', 'business', 'company', 'consulting', 'corporate', 'finance', 'web', 'development', 'marketing', 'modern', 'minimal', 'IT', 'consultant', 'SMM'],
                ],
                't15-law-2' => [
                    'title' => esc_html__('Law 2', 'king-addons'),
                    'plan' => 'free',
                    'collection' => 25,
                    'category' => 'legal',
                    'subcategory' => 'event',
                    'tags' => ['agency', 'business', 'company', 'consulting', 'corporate', 'finance', 'web', 'development', 'marketing', 'modern', 'minimal', 'IT', 'consultant', 'SMM'],
                ],
                't3-crypto-cards' => [
                    'title' => esc_html__('Crypto Cards', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 3,
                    'category' => 'technology',
                    'subcategory' => 'crypto',
                    'tags' => ['bitcoin', 'blockchain', 'crypto', 'crypto NFT', 'cryptocurrency', 'DAO', 'DeFi', 'ICO', 'metamask', 'NFT', 'NFT auction', 'NFT marketplace', 'NFT woocommerce', 'opensea', 'web3'],
                ],
                't3-crypto-trading' => [
                    'title' => esc_html__('Crypto Trading', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 3,
                    'category' => 'technology',
                    'subcategory' => 'crypto',
                    'tags' => ['bitcoin', 'blockchain', 'crypto', 'crypto NFT', 'cryptocurrency', 'DAO', 'DeFi', 'ICO', 'metamask', 'NFT', 'NFT auction', 'NFT marketplace', 'NFT woocommerce', 'opensea', 'web3'],
                ],
                't3-crypto-exchange' => [
                    'title' => esc_html__('Crypto Exchange', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 3,
                    'category' => 'technology',
                    'subcategory' => 'crypto',
                    'tags' => ['bitcoin', 'blockchain', 'crypto', 'crypto NFT', 'cryptocurrency', 'DAO', 'DeFi', 'ICO', 'metamask', 'NFT', 'NFT auction', 'NFT marketplace', 'NFT woocommerce', 'opensea', 'web3'],
                ],
                't3-blockchain-services' => [
                    'title' => esc_html__('Blockchain Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 3,
                    'category' => 'technology',
                    'subcategory' => 'crypto',
                    'tags' => ['bitcoin', 'blockchain', 'crypto', 'crypto NFT', 'cryptocurrency', 'DAO', 'DeFi', 'ICO', 'metamask', 'NFT', 'NFT auction', 'NFT marketplace', 'NFT woocommerce', 'opensea', 'web3'],
                ],
                't3-crypto-startup' => [
                    'title' => esc_html__('Crypto Startup', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 3,
                    'category' => 'technology',
                    'subcategory' => 'crypto',
                    'tags' => ['bitcoin', 'blockchain', 'crypto', 'crypto NFT', 'cryptocurrency', 'DAO', 'DeFi', 'ICO', 'metamask', 'NFT', 'NFT auction', 'NFT marketplace', 'NFT woocommerce', 'opensea', 'web3'],
                ],
                't3-payments-with-crypto' => [
                    'title' => esc_html__('Payments with Crypto', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 3,
                    'category' => 'technology',
                    'subcategory' => 'crypto',
                    'tags' => ['bitcoin', 'blockchain', 'crypto', 'crypto NFT', 'cryptocurrency', 'DAO', 'DeFi', 'ICO', 'metamask', 'NFT', 'NFT auction', 'NFT marketplace', 'NFT woocommerce', 'opensea', 'web3'],
                ],
                't3-crypto-trading-app' => [
                    'title' => esc_html__('Crypto Trading App', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 3,
                    'category' => 'technology',
                    'subcategory' => 'crypto',
                    'tags' => ['bitcoin', 'blockchain', 'crypto', 'crypto NFT', 'cryptocurrency', 'DAO', 'DeFi', 'ICO', 'metamask', 'NFT', 'NFT auction', 'NFT marketplace', 'NFT woocommerce', 'opensea', 'web3'],
                ],
                't3-crypto-app' => [
                    'title' => esc_html__('Crypto App', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 3,
                    'category' => 'technology',
                    'subcategory' => 'crypto',
                    'tags' => ['bitcoin', 'blockchain', 'crypto', 'crypto NFT', 'cryptocurrency', 'DAO', 'DeFi', 'ICO', 'metamask', 'NFT', 'NFT auction', 'NFT marketplace', 'NFT woocommerce', 'opensea', 'web3'],
                ],
                't3-defi-project-landing' => [
                    'title' => esc_html__('Defi Project Landing', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 3,
                    'category' => 'technology',
                    'subcategory' => 'crypto',
                    'tags' => ['bitcoin', 'blockchain', 'crypto', 'crypto NFT', 'cryptocurrency', 'DAO', 'DeFi', 'ICO', 'metamask', 'NFT', 'NFT auction', 'NFT marketplace', 'NFT woocommerce', 'opensea', 'web3'],
                ],
                't3-crypto-hardware-wallets' => [
                    'title' => esc_html__('Crypto Hardware Wallets', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 3,
                    'category' => 'technology',
                    'subcategory' => 'crypto',
                    'tags' => ['bitcoin', 'blockchain', 'crypto', 'crypto NFT', 'cryptocurrency', 'DAO', 'DeFi', 'ICO', 'metamask', 'NFT', 'NFT auction', 'NFT marketplace', 'NFT woocommerce', 'opensea', 'web3'],
                ],
                't3-crypto-wallet-app' => [
                    'title' => esc_html__('Crypto Wallet App', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 3,
                    'category' => 'technology',
                    'subcategory' => 'crypto',
                    'tags' => ['bitcoin', 'blockchain', 'crypto', 'crypto NFT', 'cryptocurrency', 'DAO', 'DeFi', 'ICO', 'metamask', 'NFT', 'NFT auction', 'NFT marketplace', 'NFT woocommerce', 'opensea', 'web3'],
                ],
                't3-nft-landing-page' => [
                    'title' => esc_html__('NFT Landing Page', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 3,
                    'category' => 'technology',
                    'subcategory' => 'NFT',
                    'tags' => ['bitcoin', 'blockchain', 'crypto', 'crypto NFT', 'cryptocurrency', 'DAO', 'DeFi', 'ICO', 'metamask', 'NFT', 'NFT auction', 'NFT marketplace', 'NFT woocommerce', 'opensea', 'web3'],
                ],
                't3-nft-collection-landing' => [
                    'title' => esc_html__('NFT Collection Landing', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 3,
                    'category' => 'technology',
                    'subcategory' => 'NFT',
                    'tags' => ['bitcoin', 'blockchain', 'crypto', 'crypto NFT', 'cryptocurrency', 'DAO', 'DeFi', 'ICO', 'metamask', 'NFT', 'NFT auction', 'NFT marketplace', 'NFT woocommerce', 'opensea', 'web3'],
                ],
                't3-nft-platform' => [
                    'title' => esc_html__('NFT Platform', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 3,
                    'category' => 'technology',
                    'subcategory' => 'NFT',
                    'tags' => ['bitcoin', 'blockchain', 'crypto', 'crypto NFT', 'cryptocurrency', 'DAO', 'DeFi', 'ICO', 'metamask', 'NFT', 'NFT auction', 'NFT marketplace', 'NFT woocommerce', 'opensea', 'web3'],
                ],
                't3-nft-marketplace' => [
                    'title' => esc_html__('NFT Marketplace', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 3,
                    'category' => 'technology',
                    'subcategory' => 'NFT',
                    'tags' => ['bitcoin', 'blockchain', 'crypto', 'crypto NFT', 'cryptocurrency', 'DAO', 'DeFi', 'ICO', 'metamask', 'NFT', 'NFT auction', 'NFT marketplace', 'NFT woocommerce', 'opensea', 'web3'],
                ],
                't3-nft-game' => [
                    'title' => esc_html__('NFT Game', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 3,
                    'category' => 'technology',
                    'subcategory' => 'NFT',
                    'tags' => ['bitcoin', 'blockchain', 'crypto', 'crypto NFT', 'cryptocurrency', 'DAO', 'DeFi', 'ICO', 'metamask', 'NFT', 'NFT auction', 'NFT marketplace', 'NFT woocommerce', 'opensea', 'web3'],
                ],
                't3-nft-dao-platform' => [
                    'title' => esc_html__('NFT DAO Platform', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 3,
                    'category' => 'technology',
                    'subcategory' => 'NFT',
                    'tags' => ['bitcoin', 'blockchain', 'crypto', 'crypto NFT', 'cryptocurrency', 'DAO', 'DeFi', 'ICO', 'metamask', 'NFT', 'NFT auction', 'NFT marketplace', 'NFT woocommerce', 'opensea', 'web3'],
                ],
                't3-nft-website' => [
                    'title' => esc_html__('NFT Website', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 3,
                    'category' => 'technology',
                    'subcategory' => 'NFT',
                    'tags' => ['bitcoin', 'blockchain', 'crypto', 'crypto NFT', 'cryptocurrency', 'DAO', 'DeFi', 'ICO', 'metamask', 'NFT', 'NFT auction', 'NFT marketplace', 'NFT woocommerce', 'opensea', 'web3'],
                ],
                't3-metaverse-website' => [
                    'title' => esc_html__('Metaverse Website', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 3,
                    'category' => 'technology',
                    'subcategory' => 'web3',
                    'tags' => ['bitcoin', 'blockchain', 'crypto', 'crypto NFT', 'cryptocurrency', 'DAO', 'DeFi', 'ICO', 'metamask', 'NFT', 'NFT auction', 'NFT marketplace', 'NFT woocommerce', 'opensea', 'web3'],
                ],
                't3-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 3,
                    'category' => 'technology',
                    'subcategory' => 'technology',
                    'tags' => ['bitcoin', 'blockchain', 'crypto', 'crypto NFT', 'cryptocurrency', 'DAO', 'DeFi', 'ICO', 'metamask', 'NFT', 'NFT auction', 'NFT marketplace', 'NFT woocommerce', 'opensea', 'web3'],
                ],
                't3-about-us-dark' => [
                    'title' => esc_html__('About Us Dark', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 3,
                    'category' => 'technology',
                    'subcategory' => 'technology',
                    'tags' => ['bitcoin', 'blockchain', 'crypto', 'crypto NFT', 'cryptocurrency', 'DAO', 'DeFi', 'ICO', 'metamask', 'NFT', 'NFT auction', 'NFT marketplace', 'NFT woocommerce', 'opensea', 'web3'],
                ],
                't3-our-team' => [
                    'title' => esc_html__('Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 3,
                    'category' => 'technology',
                    'subcategory' => 'technology',
                    'tags' => ['bitcoin', 'blockchain', 'crypto', 'crypto NFT', 'cryptocurrency', 'DAO', 'DeFi', 'ICO', 'metamask', 'NFT', 'NFT auction', 'NFT marketplace', 'NFT woocommerce', 'opensea', 'web3'],
                ],
                't3-our-team-dark' => [
                    'title' => esc_html__('Our Team Dark', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 3,
                    'category' => 'technology',
                    'subcategory' => 'technology',
                    'tags' => ['bitcoin', 'blockchain', 'crypto', 'crypto NFT', 'cryptocurrency', 'DAO', 'DeFi', 'ICO', 'metamask', 'NFT', 'NFT auction', 'NFT marketplace', 'NFT woocommerce', 'opensea', 'web3'],
                ],
                't3-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 3,
                    'category' => 'technology',
                    'subcategory' => 'technology',
                    'tags' => ['bitcoin', 'blockchain', 'crypto', 'crypto NFT', 'cryptocurrency', 'DAO', 'DeFi', 'ICO', 'metamask', 'NFT', 'NFT auction', 'NFT marketplace', 'NFT woocommerce', 'opensea', 'web3'],
                ],
                't3-contact-us-dark' => [
                    'title' => esc_html__('Contact Us Dark', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 3,
                    'category' => 'technology',
                    'subcategory' => 'technology',
                    'tags' => ['bitcoin', 'blockchain', 'crypto', 'crypto NFT', 'cryptocurrency', 'DAO', 'DeFi', 'ICO', 'metamask', 'NFT', 'NFT auction', 'NFT marketplace', 'NFT woocommerce', 'opensea', 'web3'],
                ],
                't1-it-services' => [
                    'title' => esc_html__('IT Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 1,
                    'category' => 'business',
                    'subcategory' => 'IT',
                    'tags' => ['services', 'IT', 'business', 'app', 'design agency', 'digital agency', 'fintech', 'hosting', 'IT Services', 'IT Solutions', 'mobile app', 'SaaS', 'saas theme', 'software', 'startup', 'technology', 'web development'],
                ],
                't1-digital-marketing' => [
                    'title' => esc_html__('Digital Marketing', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 1,
                    'category' => 'creative',
                    'subcategory' => 'marketing',
                    'tags' => ['digital', 'marketing', 'agency', 'app', 'design agency', 'digital agency', 'fintech', 'hosting', 'IT Services', 'IT Solutions', 'mobile app', 'SaaS', 'saas theme', 'software', 'startup', 'technology', 'web development'],
                ],
                't1-web-development' => [
                    'title' => esc_html__('Web Development', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 1,
                    'category' => 'technology',
                    'subcategory' => 'IT',
                    'tags' => ['web', 'development', 'technology', 'app', 'design agency', 'digital agency', 'fintech', 'hosting', 'IT Services', 'IT Solutions', 'mobile app', 'SaaS', 'saas theme', 'software', 'startup', 'technology', 'web development'],
                ],
                't1-digital-studio' => [
                    'title' => esc_html__('Digital Studio', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 1,
                    'category' => 'technology',
                    'subcategory' => 'technology',
                    'tags' => ['design', 'digital', 'agency', 'app', 'design agency', 'digital agency', 'fintech', 'hosting', 'IT Services', 'IT Solutions', 'mobile app', 'SaaS', 'saas theme', 'software', 'startup', 'technology', 'web development'],
                ],
                't1-saas-task-management' => [
                    'title' => esc_html__('SaaS Task Management', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 1,
                    'category' => 'technology',
                    'subcategory' => 'management',
                    'tags' => ['management', 'digital', 'SaaS', 'app', 'design agency', 'digital agency', 'fintech', 'hosting', 'IT Services', 'IT Solutions', 'mobile app', 'SaaS', 'saas theme', 'software', 'startup', 'technology', 'web development'],
                ],
                't1-saas-finance' => [
                    'title' => esc_html__('SaaS Finance', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 1,
                    'category' => 'technology',
                    'subcategory' => 'SaaS',
                    'tags' => ['finance', 'digital', 'SaaS', 'app', 'design agency', 'digital agency', 'fintech', 'hosting', 'IT Services', 'IT Solutions', 'mobile app', 'SaaS', 'saas theme', 'software', 'startup', 'technology', 'web development'],
                ],
                't1-hosting' => [
                    'title' => esc_html__('Hosting', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 1,
                    'category' => 'technology',
                    'subcategory' => 'hosting',
                    'tags' => ['hosting', 'IT', 'services', 'app', 'design agency', 'digital agency', 'fintech', 'hosting', 'IT Services', 'IT Solutions', 'mobile app', 'SaaS', 'saas theme', 'software', 'startup', 'technology', 'web development'],
                ],
                't1-design-agency' => [
                    'title' => esc_html__('Design Agency', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 1,
                    'category' => 'technology',
                    'subcategory' => 'agency',
                    'tags' => ['hosting', 'IT', 'services', 'app', 'design agency', 'digital agency', 'fintech', 'hosting', 'IT Services', 'IT Solutions', 'mobile app', 'SaaS', 'saas theme', 'software', 'startup', 'technology', 'web development'],
                ],
                't1-hardware-services' => [
                    'title' => esc_html__('Hardware Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 1,
                    'category' => 'technology',
                    'subcategory' => 'technology',
                    'tags' => ['hosting', 'IT', 'services', 'app', 'design agency', 'digital agency', 'fintech', 'hosting', 'IT Services', 'IT Solutions', 'mobile app', 'SaaS', 'saas theme', 'software', 'startup', 'technology', 'web development'],
                ],
                't1-web-app-showcase' => [
                    'title' => esc_html__('Web App Showcase', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 1,
                    'category' => 'technology',
                    'subcategory' => 'app',
                    'tags' => ['hosting', 'IT', 'services', 'app', 'design agency', 'digital agency', 'fintech', 'hosting', 'IT Services', 'IT Solutions', 'mobile app', 'SaaS', 'saas theme', 'software', 'startup', 'technology', 'web development'],
                ],
                't1-startup' => [
                    'title' => esc_html__('Startup', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 1,
                    'category' => 'technology',
                    'subcategory' => 'startup',
                    'tags' => ['hosting', 'IT', 'services', 'app', 'design agency', 'digital agency', 'fintech', 'hosting', 'IT Services', 'IT Solutions', 'mobile app', 'SaaS', 'saas theme', 'software', 'startup', 'technology', 'web development'],
                ],
                't1-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 1,
                    'category' => 'technology',
                    'subcategory' => 'technology',
                    'tags' => ['hosting', 'IT', 'services', 'app', 'design agency', 'digital agency', 'fintech', 'hosting', 'IT Services', 'IT Solutions', 'mobile app', 'SaaS', 'saas theme', 'software', 'startup', 'technology', 'web development'],
                ],
                't1-about-us-dark' => [
                    'title' => esc_html__('About Us Dark', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 1,
                    'category' => 'technology',
                    'subcategory' => 'technology',
                    'tags' => ['hosting', 'IT', 'services', 'app', 'design agency', 'digital agency', 'fintech', 'hosting', 'IT Services', 'IT Solutions', 'mobile app', 'SaaS', 'saas theme', 'software', 'startup', 'technology', 'web development'],
                ],
                't1-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 1,
                    'category' => 'technology',
                    'subcategory' => 'technology',
                    'tags' => ['hosting', 'IT', 'services', 'app', 'design agency', 'digital agency', 'fintech', 'hosting', 'IT Services', 'IT Solutions', 'mobile app', 'SaaS', 'saas theme', 'software', 'startup', 'technology', 'web development'],
                ],
                't1-our-services-dark' => [
                    'title' => esc_html__('Our Services Dark', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 1,
                    'category' => 'technology',
                    'subcategory' => 'technology',
                    'tags' => ['hosting', 'IT', 'services', 'app', 'design agency', 'digital agency', 'fintech', 'hosting', 'IT Services', 'IT Solutions', 'mobile app', 'SaaS', 'saas theme', 'software', 'startup', 'technology', 'web development'],
                ],
                't1-our-team' => [
                    'title' => esc_html__('Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 1,
                    'category' => 'technology',
                    'subcategory' => 'technology',
                    'tags' => ['hosting', 'IT', 'services', 'app', 'design agency', 'digital agency', 'fintech', 'hosting', 'IT Services', 'IT Solutions', 'mobile app', 'SaaS', 'saas theme', 'software', 'startup', 'technology', 'web development'],
                ],
                't1-our-team-dark' => [
                    'title' => esc_html__('Our Team Dark', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 1,
                    'category' => 'technology',
                    'subcategory' => 'technology',
                    'tags' => ['hosting', 'IT', 'services', 'app', 'design agency', 'digital agency', 'fintech', 'hosting', 'IT Services', 'IT Solutions', 'mobile app', 'SaaS', 'saas theme', 'software', 'startup', 'technology', 'web development'],
                ],
                't1-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 1,
                    'category' => 'technology',
                    'subcategory' => 'technology',
                    'tags' => ['hosting', 'IT', 'services', 'app', 'design agency', 'digital agency', 'fintech', 'hosting', 'IT Services', 'IT Solutions', 'mobile app', 'SaaS', 'saas theme', 'software', 'startup', 'technology', 'web development'],
                ],
                't1-contact-us-dark' => [
                    'title' => esc_html__('Contact Us Dark', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 1,
                    'category' => 'technology',
                    'subcategory' => 'technology',
                    'tags' => ['hosting', 'IT', 'services', 'app', 'design agency', 'digital agency', 'fintech', 'hosting', 'IT Services', 'IT Solutions', 'mobile app', 'SaaS', 'saas theme', 'software', 'startup', 'technology', 'web development'],
                ],
                't2-mobile-payment' => [
                    'title' => esc_html__('Mobile Payment', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 2,
                    'category' => 'technology',
                    'subcategory' => 'app',
                    'tags' => ['app', 'app landing', 'app landing page', 'app showcase', 'app website', 'crypto', 'digital agency', 'landing page', 'mobile', 'mobile app', 'NFT', 'SaaS', 'software', 'startup'],
                ],
                't2-3d-design-app' => [
                    'title' => esc_html__('3D Design App', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 2,
                    'category' => 'technology',
                    'subcategory' => 'app',
                    'tags' => ['app', 'app landing', 'app landing page', 'app showcase', 'app website', 'crypto', 'digital agency', 'landing page', 'mobile', 'mobile app', 'NFT', 'SaaS', 'software', 'startup'],
                ],
                't2-task-management-app' => [
                    'title' => esc_html__('Task Management App', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 2,
                    'category' => 'technology',
                    'subcategory' => 'app',
                    'tags' => ['app', 'app landing', 'app landing page', 'app showcase', 'app website', 'crypto', 'digital agency', 'landing page', 'mobile', 'mobile app', 'NFT', 'SaaS', 'software', 'startup'],
                ],
                't2-finance-app' => [
                    'title' => esc_html__('Finance App', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 2,
                    'category' => 'technology',
                    'subcategory' => 'finance',
                    'tags' => ['app', 'app landing', 'app landing page', 'app showcase', 'app website', 'crypto', 'digital agency', 'landing page', 'mobile', 'mobile app', 'NFT', 'SaaS', 'software', 'startup'],
                ],
                't2-banking-app' => [
                    'title' => esc_html__('Banking App', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 2,
                    'category' => 'technology',
                    'subcategory' => 'finance',
                    'tags' => ['app', 'app landing', 'app landing page', 'app showcase', 'app website', 'crypto', 'digital agency', 'landing page', 'mobile', 'mobile app', 'NFT', 'SaaS', 'software', 'startup'],
                ],
                't2-fitness-app' => [
                    'title' => esc_html__('Fitness App', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 2,
                    'category' => 'technology',
                    'subcategory' => 'app',
                    'tags' => ['app', 'app landing', 'app landing page', 'app showcase', 'app website', 'crypto', 'digital agency', 'landing page', 'mobile', 'mobile app', 'NFT', 'SaaS', 'software', 'startup'],
                ],
                't2-finance-tracking' => [
                    'title' => esc_html__('Finance Tracking', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 2,
                    'category' => 'technology',
                    'subcategory' => 'app',
                    'tags' => ['app', 'app landing', 'app landing page', 'app showcase', 'app website', 'crypto', 'digital agency', 'landing page', 'mobile', 'mobile app', 'NFT', 'SaaS', 'software', 'startup'],
                ],
                't2-currency-exchange-app' => [
                    'title' => esc_html__('Currency Exchange App', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 2,
                    'category' => 'technology',
                    'subcategory' => 'finance',
                    'tags' => ['app', 'app landing', 'app landing page', 'app showcase', 'app website', 'crypto', 'digital agency', 'landing page', 'mobile', 'mobile app', 'NFT', 'SaaS', 'software', 'startup'],
                ],
                't2-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 2,
                    'category' => 'technology',
                    'subcategory' => 'technology',
                    'tags' => ['app', 'app landing', 'app landing page', 'app showcase', 'app website', 'crypto', 'digital agency', 'landing page', 'mobile', 'mobile app', 'NFT', 'SaaS', 'software', 'startup'],
                ],
                't2-our-team' => [
                    'title' => esc_html__('Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 2,
                    'category' => 'technology',
                    'subcategory' => 'technology',
                    'tags' => ['app', 'app landing', 'app landing page', 'app showcase', 'app website', 'crypto', 'digital agency', 'landing page', 'mobile', 'mobile app', 'NFT', 'SaaS', 'software', 'startup'],
                ],
                't2-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 2,
                    'category' => 'technology',
                    'subcategory' => 'technology',
                    'tags' => ['app', 'app landing', 'app landing page', 'app showcase', 'app website', 'crypto', 'digital agency', 'landing page', 'mobile', 'mobile app', 'NFT', 'SaaS', 'software', 'startup'],
                ],
                't4-ai-driven-learning' => [
                    'title' => esc_html__('AI-driven Learning', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 4,
                    'category' => 'technology',
                    'subcategory' => 'AI',
                    'tags' => ['AI', 'AI art', 'artificial intelligence', 'chatbot', 'data science', 'deep learning', 'fitness AI', 'generator', 'GPT model', 'health AI', 'landing', 'machine learning', 'neural network', 'responsive', 'technology'],
                ],
                't4-ai-chatbot-startup' => [
                    'title' => esc_html__('AI Chatbot Startup', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 4,
                    'category' => 'technology',
                    'subcategory' => 'AI',
                    'tags' => ['AI', 'AI art', 'artificial intelligence', 'chatbot', 'data science', 'deep learning', 'fitness AI', 'generator', 'GPT model', 'health AI', 'landing', 'machine learning', 'neural network', 'responsive', 'technology'],
                ],
                't4-health-ai' => [
                    'title' => esc_html__('Health AI', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 4,
                    'category' => 'technology',
                    'subcategory' => 'AI',
                    'tags' => ['AI', 'AI art', 'artificial intelligence', 'chatbot', 'data science', 'deep learning', 'fitness AI', 'generator', 'GPT model', 'health AI', 'landing', 'machine learning', 'neural network', 'responsive', 'technology'],
                ],
                't4-finance-ai' => [
                    'title' => esc_html__('Finance AI', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 4,
                    'category' => 'technology',
                    'subcategory' => 'AI',
                    'tags' => ['AI', 'AI art', 'artificial intelligence', 'chatbot', 'data science', 'deep learning', 'fitness AI', 'generator', 'GPT model', 'health AI', 'landing', 'machine learning', 'neural network', 'responsive', 'technology'],
                ],
                't4-fitness-and-wellness-ai' => [
                    'title' => esc_html__('Fitness and Wellness AI', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 4,
                    'category' => 'technology',
                    'subcategory' => 'AI',
                    'tags' => ['AI', 'AI art', 'artificial intelligence', 'chatbot', 'data science', 'deep learning', 'fitness AI', 'generator', 'GPT model', 'health AI', 'landing', 'machine learning', 'neural network', 'responsive', 'technology'],
                ],
                't4-ai-image-generation-startup' => [
                    'title' => esc_html__('AI Image Generating Startup', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 4,
                    'category' => 'technology',
                    'subcategory' => 'AI',
                    'tags' => ['AI', 'AI art', 'artificial intelligence', 'chatbot', 'data science', 'deep learning', 'fitness AI', 'generator', 'GPT model', 'health AI', 'landing', 'machine learning', 'neural network', 'responsive', 'technology'],
                ],
                't4-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 4,
                    'category' => 'technology',
                    'subcategory' => 'AI',
                    'tags' => ['AI', 'AI art', 'artificial intelligence', 'chatbot', 'data science', 'deep learning', 'fitness AI', 'generator', 'GPT model', 'health AI', 'landing', 'machine learning', 'neural network', 'responsive', 'technology'],
                ],
                't4-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 4,
                    'category' => 'technology',
                    'subcategory' => 'AI',
                    'tags' => ['AI', 'AI art', 'artificial intelligence', 'chatbot', 'data science', 'deep learning', 'fitness AI', 'generator', 'GPT model', 'health AI', 'landing', 'machine learning', 'neural network', 'responsive', 'technology'],
                ],
                't4-our-team' => [
                    'title' => esc_html__('Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 4,
                    'category' => 'technology',
                    'subcategory' => 'AI',
                    'tags' => ['AI', 'AI art', 'artificial intelligence', 'chatbot', 'data science', 'deep learning', 'fitness AI', 'generator', 'GPT model', 'health AI', 'landing', 'machine learning', 'neural network', 'responsive', 'technology'],
                ],
                't4-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 4,
                    'category' => 'technology',
                    'subcategory' => 'AI',
                    'tags' => ['AI', 'AI art', 'artificial intelligence', 'chatbot', 'data science', 'deep learning', 'fitness AI', 'generator', 'GPT model', 'health AI', 'landing', 'machine learning', 'neural network', 'responsive', 'technology'],
                ],
                't5-ultrafast-web-hosting' => [
                    'title' => esc_html__('Ultrafast Web Hosting', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 5,
                    'category' => 'technology',
                    'subcategory' => 'hosting',
                    'tags' => ['agency', 'fintech', 'hosting', 'IT Solutions', 'multipurpose', 'SaaS', 'shared hosting', 'software', 'startup', 'technology', 'VPS', 'wordpress hosting'],
                ],
                't5-best-hosting-platform' => [
                    'title' => esc_html__('Best Hosting Platform', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 5,
                    'category' => 'technology',
                    'subcategory' => 'hosting',
                    'tags' => ['agency', 'fintech', 'hosting', 'IT Solutions', 'multipurpose', 'SaaS', 'shared hosting', 'software', 'startup', 'technology', 'VPS', 'wordpress hosting'],
                ],
                't5-hosting-services' => [
                    'title' => esc_html__('Hosting Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 5,
                    'category' => 'technology',
                    'subcategory' => 'hosting',
                    'tags' => ['agency', 'fintech', 'hosting', 'IT Solutions', 'multipurpose', 'SaaS', 'shared hosting', 'software', 'startup', 'technology', 'VPS', 'wordpress hosting'],
                ],
                't5-unlimited-hosting' => [
                    'title' => esc_html__('Unlimited Hosting', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 5,
                    'category' => 'technology',
                    'subcategory' => 'hosting',
                    'tags' => ['agency', 'fintech', 'hosting', 'IT Solutions', 'multipurpose', 'SaaS', 'shared hosting', 'software', 'startup', 'technology', 'VPS', 'wordpress hosting'],
                ],
                't5-take-your-site-online' => [
                    'title' => esc_html__('Take Your Site Online', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 5,
                    'category' => 'technology',
                    'subcategory' => 'hosting',
                    'tags' => ['agency', 'fintech', 'hosting', 'IT Solutions', 'multipurpose', 'SaaS', 'shared hosting', 'software', 'startup', 'technology', 'VPS', 'wordpress hosting'],
                ],
                't5-website-is-always-up' => [
                    'title' => esc_html__('Website is Always Up', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 5,
                    'category' => 'technology',
                    'subcategory' => 'hosting',
                    'tags' => ['agency', 'fintech', 'hosting', 'IT Solutions', 'multipurpose', 'SaaS', 'shared hosting', 'software', 'startup', 'technology', 'VPS', 'wordpress hosting'],
                ],
                't5-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 5,
                    'category' => 'technology',
                    'subcategory' => 'technology',
                    'tags' => ['agency', 'fintech', 'hosting', 'IT Solutions', 'multipurpose', 'SaaS', 'shared hosting', 'software', 'startup', 'technology', 'VPS', 'wordpress hosting'],
                ],
                't5-our-team' => [
                    'title' => esc_html__('Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 5,
                    'category' => 'technology',
                    'subcategory' => 'technology',
                    'tags' => ['agency', 'fintech', 'hosting', 'IT Solutions', 'multipurpose', 'SaaS', 'shared hosting', 'software', 'startup', 'technology', 'VPS', 'wordpress hosting'],
                ],
                't5-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 5,
                    'category' => 'technology',
                    'subcategory' => 'technology',
                    'tags' => ['agency', 'fintech', 'hosting', 'IT Solutions', 'multipurpose', 'SaaS', 'shared hosting', 'software', 'startup', 'technology', 'VPS', 'wordpress hosting'],
                ],
                't6-seo-campaign' => [
                    'title' => esc_html__('SEO Campaign', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 6,
                    'category' => 'technology',
                    'subcategory' => 'SEO',
                    'tags' => ['agency', 'consulting', 'creative agency', 'digital marketing', 'digital marketing agency', 'marketing agency', 'online marketing', 'SEO', 'SEO agency', 'SEO theme', 'SMM', 'SMM agency', 'social media', 'web development', 'website analysis'],
                ],
                't6-digital-product-marketing' => [
                    'title' => esc_html__('Digital Product Marketing', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 6,
                    'category' => 'technology',
                    'subcategory' => 'marketing',
                    'tags' => ['agency', 'consulting', 'creative agency', 'digital marketing', 'digital marketing agency', 'marketing agency', 'online marketing', 'SEO', 'SEO agency', 'SEO theme', 'SMM', 'SMM agency', 'social media', 'web development', 'website analysis'],
                ],
                't6-seo-agency' => [
                    'title' => esc_html__('SEO Agency', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 6,
                    'category' => 'technology',
                    'subcategory' => 'agency',
                    'tags' => ['agency', 'consulting', 'creative agency', 'digital marketing', 'digital marketing agency', 'marketing agency', 'online marketing', 'SEO', 'SEO agency', 'SEO theme', 'SMM', 'SMM agency', 'social media', 'web development', 'website analysis'],
                ],
                't6-general-services' => [
                    'title' => esc_html__('General Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 6,
                    'category' => 'technology',
                    'subcategory' => 'technology',
                    'tags' => ['agency', 'consulting', 'creative agency', 'digital marketing', 'digital marketing agency', 'marketing agency', 'online marketing', 'SEO', 'SEO agency', 'SEO theme', 'SMM', 'SMM agency', 'social media', 'web development', 'website analysis'],
                ],
                't6-digital-marketing-services' => [
                    'title' => esc_html__('Digital Marketing Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 6,
                    'category' => 'technology',
                    'subcategory' => 'technology',
                    'tags' => ['agency', 'consulting', 'creative agency', 'digital marketing', 'digital marketing agency', 'marketing agency', 'online marketing', 'SEO', 'SEO agency', 'SEO theme', 'SMM', 'SMM agency', 'social media', 'web development', 'website analysis'],
                ],
                't6-seo-services' => [
                    'title' => esc_html__('SEO Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 6,
                    'category' => 'technology',
                    'subcategory' => 'SEO',
                    'tags' => ['agency', 'consulting', 'creative agency', 'digital marketing', 'digital marketing agency', 'marketing agency', 'online marketing', 'SEO', 'SEO agency', 'SEO theme', 'SMM', 'SMM agency', 'social media', 'web development', 'website analysis'],
                ],
                't6-pricing' => [
                    'title' => esc_html__('Pricing', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 6,
                    'category' => 'technology',
                    'subcategory' => 'technology',
                    'tags' => ['agency', 'consulting', 'creative agency', 'digital marketing', 'digital marketing agency', 'marketing agency', 'online marketing', 'SEO', 'SEO agency', 'SEO theme', 'SMM', 'SMM agency', 'social media', 'web development', 'website analysis'],
                ],
                't6-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 6,
                    'category' => 'technology',
                    'subcategory' => 'technology',
                    'tags' => ['agency', 'consulting', 'creative agency', 'digital marketing', 'digital marketing agency', 'marketing agency', 'online marketing', 'SEO', 'SEO agency', 'SEO theme', 'SMM', 'SMM agency', 'social media', 'web development', 'website analysis'],
                ],
                't6-our-team' => [
                    'title' => esc_html__('Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 6,
                    'category' => 'technology',
                    'subcategory' => 'technology',
                    'tags' => ['agency', 'consulting', 'creative agency', 'digital marketing', 'digital marketing agency', 'marketing agency', 'online marketing', 'SEO', 'SEO agency', 'SEO theme', 'SMM', 'SMM agency', 'social media', 'web development', 'website analysis'],
                ],
                't6-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 6,
                    'category' => 'technology',
                    'subcategory' => 'technology',
                    'tags' => ['agency', 'consulting', 'creative agency', 'digital marketing', 'digital marketing agency', 'marketing agency', 'online marketing', 'SEO', 'SEO agency', 'SEO theme', 'SMM', 'SMM agency', 'social media', 'web development', 'website analysis'],
                ],
                't7-adaptive-business-consulting' => [
                    'title' => esc_html__('Adaptive Business Consulting', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 7,
                    'category' => 'business',
                    'subcategory' => 'consulting',
                    'tags' => ['accountant', 'advisor', 'business', 'business advisor', 'business consulting', 'business corporate', 'clean', 'consultant', 'consulting', 'consulting firm', 'consulting services', 'finance', 'marketing agency', 'SMM'],
                ],
                't7-empowering-businesses' => [
                    'title' => esc_html__('Empowering Businesses', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 7,
                    'category' => 'business',
                    'subcategory' => 'consulting',
                    'tags' => ['accountant', 'advisor', 'business', 'business advisor', 'business consulting', 'business corporate', 'clean', 'consultant', 'consulting', 'consulting firm', 'consulting services', 'finance', 'marketing agency', 'SMM'],
                ],
                't7-reshaping-industries' => [
                    'title' => esc_html__('Reshaping Industries', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 7,
                    'category' => 'business',
                    'subcategory' => 'consulting',
                    'tags' => ['accountant', 'advisor', 'business', 'business advisor', 'business consulting', 'business corporate', 'clean', 'consultant', 'consulting', 'consulting firm', 'consulting services', 'finance', 'marketing agency', 'SMM'],
                ],
                't7-maximizing-profitability' => [
                    'title' => esc_html__('Maximizing Profitability', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 7,
                    'category' => 'business',
                    'subcategory' => 'consulting',
                    'tags' => ['accountant', 'advisor', 'business', 'business advisor', 'business consulting', 'business corporate', 'clean', 'consultant', 'consulting', 'consulting firm', 'consulting services', 'finance', 'marketing agency', 'SMM'],
                ],
                't7-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 7,
                    'category' => 'business',
                    'subcategory' => 'consulting',
                    'tags' => ['accountant', 'advisor', 'business', 'business advisor', 'business consulting', 'business corporate', 'clean', 'consultant', 'consulting', 'consulting firm', 'consulting services', 'finance', 'marketing agency', 'SMM'],
                ],
                't7-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 7,
                    'category' => 'business',
                    'subcategory' => 'business',
                    'tags' => ['accountant', 'advisor', 'business', 'business advisor', 'business consulting', 'business corporate', 'clean', 'consultant', 'consulting', 'consulting firm', 'consulting services', 'finance', 'marketing agency', 'SMM'],
                ],
                't7-our-team' => [
                    'title' => esc_html__('Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 7,
                    'category' => 'business',
                    'subcategory' => 'business',
                    'tags' => ['accountant', 'advisor', 'business', 'business advisor', 'business consulting', 'business corporate', 'clean', 'consultant', 'consulting', 'consulting firm', 'consulting services', 'finance', 'marketing agency', 'SMM'],
                ],
                't7-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 7,
                    'category' => 'business',
                    'subcategory' => 'business',
                    'tags' => ['accountant', 'advisor', 'business', 'business advisor', 'business consulting', 'business corporate', 'clean', 'consultant', 'consulting', 'consulting firm', 'consulting services', 'finance', 'marketing agency', 'SMM'],
                ],
                't8-clicks-into-customers' => [
                    'title' => esc_html__('Clicks into Customers ', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 8,
                    'category' => 'technology',
                    'subcategory' => 'marketing',
                    'tags' => ['agency', 'consulting', 'creative agency', 'digital marketing', 'digital marketing agency', 'marketing agency', 'online marketing', 'SEO', 'SEO agency', 'SEO theme', 'SMM', 'SMM agency', 'social media', 'web development', 'website analysis'],
                ],
                't8-boost-your-brand' => [
                    'title' => esc_html__('Boost Your Brand ', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 8,
                    'category' => 'technology',
                    'subcategory' => 'marketing',
                    'tags' => ['agency', 'consulting', 'creative agency', 'digital marketing', 'digital marketing agency', 'marketing agency', 'online marketing', 'SEO', 'SEO agency', 'SEO theme', 'SMM', 'SMM agency', 'social media', 'web development', 'website analysis'],
                ],
                't8-digital-marketing-excellence' => [
                    'title' => esc_html__('Digital Marketing Excellence ', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 8,
                    'category' => 'technology',
                    'subcategory' => 'marketing',
                    'tags' => ['agency', 'consulting', 'creative agency', 'digital marketing', 'digital marketing agency', 'marketing agency', 'online marketing', 'SEO', 'SEO agency', 'SEO theme', 'SMM', 'SMM agency', 'social media', 'web development', 'website analysis'],
                ],
                't8-online-success' => [
                    'title' => esc_html__('Online Success ', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 8,
                    'category' => 'technology',
                    'subcategory' => 'marketing',
                    'tags' => ['agency', 'consulting', 'creative agency', 'digital marketing', 'digital marketing agency', 'marketing agency', 'online marketing', 'SEO', 'SEO agency', 'SEO theme', 'SMM', 'SMM agency', 'social media', 'web development', 'website analysis'],
                ],
                't8-about-us' => [
                    'title' => esc_html__('About Us ', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 8,
                    'category' => 'technology',
                    'subcategory' => 'technology',
                    'tags' => ['agency', 'consulting', 'creative agency', 'digital marketing', 'digital marketing agency', 'marketing agency', 'online marketing', 'SEO', 'SEO agency', 'SEO theme', 'SMM', 'SMM agency', 'social media', 'web development', 'website analysis'],
                ],
                't8-our-services' => [
                    'title' => esc_html__('Our Services ', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 8,
                    'category' => 'technology',
                    'subcategory' => 'technology',
                    'tags' => ['agency', 'consulting', 'creative agency', 'digital marketing', 'digital marketing agency', 'marketing agency', 'online marketing', 'SEO', 'SEO agency', 'SEO theme', 'SMM', 'SMM agency', 'social media', 'web development', 'website analysis'],
                ],
                't8-our-team' => [
                    'title' => esc_html__('Our Team ', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 8,
                    'category' => 'technology',
                    'subcategory' => 'technology',
                    'tags' => ['agency', 'consulting', 'creative agency', 'digital marketing', 'digital marketing agency', 'marketing agency', 'online marketing', 'SEO', 'SEO agency', 'SEO theme', 'SMM', 'SMM agency', 'social media', 'web development', 'website analysis'],
                ],
                't8-contact-us' => [
                    'title' => esc_html__('Contact Us ', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 8,
                    'category' => 'technology',
                    'subcategory' => 'technology',
                    'tags' => ['agency', 'consulting', 'creative agency', 'digital marketing', 'digital marketing agency', 'marketing agency', 'online marketing', 'SEO', 'SEO agency', 'SEO theme', 'SMM', 'SMM agency', 'social media', 'web development', 'website analysis'],
                ],
                't9-trusted-healthcare' => [
                    'title' => esc_html__('Trusted Healthcare ', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 9,
                    'category' => 'health & beauty',
                    'subcategory' => 'medical',
                    'tags' => ['clinic', 'dental', 'doctor', 'gynecology', 'health', 'healthtech', 'heathcare', 'hospital', 'medical', 'medical center', 'medicine', 'nutrition', 'pediatric', 'therapy', 'doctor'],
                ],
                't9-stay-healthy' => [
                    'title' => esc_html__('Stay Healthy ', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 9,
                    'category' => 'health & beauty',
                    'subcategory' => 'medical',
                    'tags' => ['clinic', 'dental', 'doctor', 'gynecology', 'health', 'healthtech', 'heathcare', 'hospital', 'medical', 'medical center', 'medicine', 'nutrition', 'pediatric', 'therapy', 'doctor'],
                ],
                't9-innovative-healthcare' => [
                    'title' => esc_html__('Innovative Healthcare ', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 9,
                    'category' => 'health & beauty',
                    'subcategory' => 'medical',
                    'tags' => ['clinic', 'dental', 'doctor', 'gynecology', 'health', 'healthtech', 'heathcare', 'hospital', 'medical', 'medical center', 'medicine', 'nutrition', 'pediatric', 'therapy', 'doctor'],
                ],
                't9-find-a-doctor-online' => [
                    'title' => esc_html__('Find a Doctor Online ', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 9,
                    'category' => 'health & beauty',
                    'subcategory' => 'medical',
                    'tags' => ['clinic', 'dental', 'doctor', 'gynecology', 'health', 'healthtech', 'heathcare', 'hospital', 'medical', 'medical center', 'medicine', 'nutrition', 'pediatric', 'therapy', 'doctor'],
                ],
                't9-about-us' => [
                    'title' => esc_html__('About Us ', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 9,
                    'category' => 'health & beauty',
                    'subcategory' => 'health & beauty',
                    'tags' => ['clinic', 'dental', 'doctor', 'gynecology', 'health', 'healthtech', 'heathcare', 'hospital', 'medical', 'medical center', 'medicine', 'nutrition', 'pediatric', 'therapy', 'doctor'],
                ],
                't9-our-team' => [
                    'title' => esc_html__('Our Team ', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 9,
                    'category' => 'health & beauty',
                    'subcategory' => 'health & beauty',
                    'tags' => ['clinic', 'dental', 'doctor', 'gynecology', 'health', 'healthtech', 'heathcare', 'hospital', 'medical', 'medical center', 'medicine', 'nutrition', 'pediatric', 'therapy', 'doctor'],
                ],
                't9-our-services' => [
                    'title' => esc_html__('Our Services ', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 9,
                    'category' => 'health & beauty',
                    'subcategory' => 'health & beauty',
                    'tags' => ['clinic', 'dental', 'doctor', 'gynecology', 'health', 'healthtech', 'heathcare', 'hospital', 'medical', 'medical center', 'medicine', 'nutrition', 'pediatric', 'therapy', 'doctor'],
                ],
                't9-contact-us' => [
                    'title' => esc_html__('Contact Us ', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 9,
                    'category' => 'health & beauty',
                    'subcategory' => 'health & beauty',
                    'tags' => ['clinic', 'dental', 'doctor', 'gynecology', 'health', 'healthtech', 'heathcare', 'hospital', 'medical', 'medical center', 'medicine', 'nutrition', 'pediatric', 'therapy', 'doctor'],
                ],
                't10-served-with-love' => [
                    'title' => esc_html__('Served with Love', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 10,
                    'category' => 'food',
                    'subcategory' => 'restaurant',
                    'tags' => ['bar', 'bistro', 'cafe', 'cafeteria', 'chef', 'cooking business', 'fast food', 'food', 'italian restaurant', 'menu', 'modern restaurant', 'organic', 'pizza', 'restaurant'],
                ],
                't10-a-taste-of-italy' => [
                    'title' => esc_html__('A Taste of Italy', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 10,
                    'category' => 'food',
                    'subcategory' => 'restaurant',
                    'tags' => ['bar', 'bistro', 'cafe', 'cafeteria', 'chef', 'cooking business', 'fast food', 'food', 'italian restaurant', 'menu', 'modern restaurant', 'organic', 'pizza', 'restaurant'],
                ],
                't10-savor-the-moment' => [
                    'title' => esc_html__('Savor the Moment', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 10,
                    'category' => 'food',
                    'subcategory' => 'restaurant',
                    'tags' => ['bar', 'bistro', 'cafe', 'cafeteria', 'chef', 'cooking business', 'fast food', 'food', 'italian restaurant', 'menu', 'modern restaurant', 'organic', 'pizza', 'restaurant'],
                ],
                't10-the-heart-of-italy' => [
                    'title' => esc_html__('The Heart of Italy', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 10,
                    'category' => 'food',
                    'subcategory' => 'restaurant',
                    'tags' => ['bar', 'bistro', 'cafe', 'cafeteria', 'chef', 'cooking business', 'fast food', 'food', 'italian restaurant', 'menu', 'modern restaurant', 'organic', 'pizza', 'restaurant'],
                ],
                't10-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 10,
                    'category' => 'food',
                    'subcategory' => 'food',
                    'tags' => ['bar', 'bistro', 'cafe', 'cafeteria', 'chef', 'cooking business', 'fast food', 'food', 'italian restaurant', 'menu', 'modern restaurant', 'organic', 'pizza', 'restaurant'],
                ],
                't10-our-team' => [
                    'title' => esc_html__('Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 10,
                    'category' => 'food',
                    'subcategory' => 'food',
                    'tags' => ['bar', 'bistro', 'cafe', 'cafeteria', 'chef', 'cooking business', 'fast food', 'food', 'italian restaurant', 'menu', 'modern restaurant', 'organic', 'pizza', 'restaurant'],
                ],
                't10-menu' => [
                    'title' => esc_html__('Menu', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 10,
                    'category' => 'food',
                    'subcategory' => 'food',
                    'tags' => ['bar', 'bistro', 'cafe', 'cafeteria', 'chef', 'cooking business', 'fast food', 'food', 'italian restaurant', 'menu', 'modern restaurant', 'organic', 'pizza', 'restaurant'],
                ],
                't10-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 10,
                    'category' => 'food',
                    'subcategory' => 'food',
                    'tags' => ['bar', 'bistro', 'cafe', 'cafeteria', 'chef', 'cooking business', 'fast food', 'food', 'italian restaurant', 'menu', 'modern restaurant', 'organic', 'pizza', 'restaurant'],
                ],
                't11-revolutionizing-logistics' => [
                    'title' => esc_html__('Revolutionizing Logistics', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 11,
                    'category' => 'business',
                    'subcategory' => 'logistics',
                    'tags' => ['cargo', 'delivery service', 'freight', 'logistic', 'logistics services', 'logistics', 'logistics company', 'moving company', 'shipping', 'transport company', 'transport ', 'transportation', 'trucking', 'warehouse'],
                ],
                't11-your-cargo-our-care' => [
                    'title' => esc_html__('Your Cargo, Our Care', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 11,
                    'category' => 'business',
                    'subcategory' => 'logistics',
                    'tags' => ['cargo', 'delivery service', 'freight', 'logistic', 'logistics services', 'logistics', 'logistics company', 'moving company', 'shipping', 'transport company', 'transport', 'transportation', 'trucking', 'warehouse'],
                ],
                't11-effortless-shipping-solutions' => [
                    'title' => esc_html__('Effortless Shipping Solutions', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 11,
                    'category' => 'business',
                    'subcategory' => 'logistics',
                    'tags' => ['cargo', 'delivery service', 'freight', 'logistic', 'logistics services', 'logistics', 'logistics company', 'moving company', 'shipping', 'transport company', 'transport', 'transportation', 'trucking', 'warehouse'],
                ],
                't11-efficient-logistics' => [
                    'title' => esc_html__('Efficient Logistics', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 11,
                    'category' => 'business',
                    'subcategory' => 'logistics',
                    'tags' => ['cargo', 'delivery service', 'freight', 'logistic', 'logistics services', 'logistics', 'logistics company', 'moving company', 'shipping', 'transport company', 'transport', 'transportation', 'trucking', 'warehouse'],
                ],
                't11-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 11,
                    'category' => 'business',
                    'subcategory' => 'business',
                    'tags' => ['cargo', 'delivery service', 'freight', 'logistic', 'logistics services', 'logistics', 'logistics company', 'moving company', 'shipping', 'transport company', 'transport', 'transportation', 'trucking', 'warehouse'],
                ],
                't11-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 11,
                    'category' => 'business',
                    'subcategory' => 'business',
                    'tags' => ['cargo', 'delivery service', 'freight', 'logistic', 'logistics services', 'logistics', 'logistics company', 'moving company', 'shipping', 'transport company', 'transport', 'transportation', 'trucking', 'warehouse'],
                ],
                't11-our-team' => [
                    'title' => esc_html__('Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 11,
                    'category' => 'business',
                    'subcategory' => 'business',
                    'tags' => ['cargo', 'delivery service', 'freight', 'logistic', 'logistics services', 'logistics', 'logistics company', 'moving company', 'shipping', 'transport company', 'transport', 'transportation', 'trucking', 'warehouse'],
                ],
                't11-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 11,
                    'category' => 'business',
                    'subcategory' => 'business',
                    'tags' => ['cargo', 'delivery service', 'freight', 'logistic', 'logistics services', 'logistics', 'logistics company', 'moving company', 'shipping', 'transport company', 'transport', 'transportation', 'trucking', 'warehouse'],
                ],
                't12-mobile-app' => [
                    'title' => esc_html__('Mobile App', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 12,
                    'category' => 'technology',
                    'subcategory' => 'app',
                    'tags' => ['app', 'app landing', 'app landing page', 'app showcase', 'app website', 'crypto', 'digital agency', 'landing page', 'mobile', 'mobile app', 'NFT', 'SaaS', 'software', 'startup'],
                ],
                't12-saas-startup' => [
                    'title' => esc_html__('SaaS Startup', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 12,
                    'category' => 'technology',
                    'subcategory' => 'SaaS',
                    'tags' => ['app', 'app landing', 'app landing page', 'app showcase', 'app website', 'crypto', 'digital agency', 'landing page', 'mobile', 'mobile app', 'NFT', 'SaaS', 'software', 'startup'],
                ],
                't12-web-app' => [
                    'title' => esc_html__('Web App', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 12,
                    'category' => 'technology',
                    'subcategory' => 'app',
                    'tags' => ['app', 'app landing', 'app landing page', 'app showcase', 'app website', 'crypto', 'digital agency', 'landing page', 'mobile', 'mobile app', 'NFT', 'SaaS', 'software', 'startup'],
                ],
                't12-ai-startup' => [
                    'title' => esc_html__('AI Startup', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 12,
                    'category' => 'technology',
                    'subcategory' => 'AI',
                    'tags' => ['app', 'app landing', 'app landing page', 'app showcase', 'app website', 'crypto', 'digital agency', 'landing page', 'mobile', 'mobile app', 'NFT', 'SaaS', 'software', 'startup'],
                ],
                't12-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 12,
                    'category' => 'technology',
                    'subcategory' => 'technology',
                    'tags' => ['app', 'app landing', 'app landing page', 'app showcase', 'app website', 'crypto', 'digital agency', 'landing page', 'mobile', 'mobile app', 'NFT', 'SaaS', 'software', 'startup'],
                ],
                't12-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 12,
                    'category' => 'technology',
                    'subcategory' => 'technology',
                    'tags' => ['app', 'app landing', 'app landing page', 'app showcase', 'app website', 'crypto', 'digital agency', 'landing page', 'mobile', 'mobile app', 'NFT', 'SaaS', 'software', 'startup'],
                ],
                't12-our-team' => [
                    'title' => esc_html__('Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 12,
                    'category' => 'technology',
                    'subcategory' => 'technology',
                    'tags' => ['app', 'app landing', 'app landing page', 'app showcase', 'app website', 'crypto', 'digital agency', 'landing page', 'mobile', 'mobile app', 'NFT', 'SaaS', 'software', 'startup'],
                ],
                't12-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 12,
                    'category' => 'technology',
                    'subcategory' => 'technology',
                    'tags' => ['app', 'app landing', 'app landing page', 'app showcase', 'app website', 'crypto', 'digital agency', 'landing page', 'mobile', 'mobile app', 'NFT', 'SaaS', 'software', 'startup'],
                ],
                't13-smile-transformation' => [
                    'title' => esc_html__('Smile Transformation', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 13,
                    'category' => 'health & beauty',
                    'subcategory' => 'dental',
                    'tags' => ['clinic', 'dental', 'aligners', 'orthodontic', 'health', 'healthtech', 'teeth', 'hospital', 'medical', 'medical center', 'doctor', 'braces', 'pediatric', 'therapy', 'dentist'],
                ],
                't13-perfect-smiles' => [
                    'title' => esc_html__('Perfect Smiles', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 13,
                    'category' => 'health & beauty',
                    'subcategory' => 'dental',
                    'tags' => ['clinic', 'dental', 'aligners', 'orthodontic', 'health', 'healthtech', 'teeth', 'hospital', 'medical', 'medical center', 'doctor', 'braces', 'pediatric', 'therapy', 'dentist'],
                ],
                't13-orthodontic-care' => [
                    'title' => esc_html__('Orthodontic Care', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 13,
                    'category' => 'health & beauty',
                    'subcategory' => 'dental',
                    'tags' => ['clinic', 'dental', 'aligners', 'orthodontic', 'health', 'healthtech', 'teeth', 'hospital', 'medical', 'medical center', 'doctor', 'braces', 'pediatric', 'therapy', 'dentist'],
                ],
                't13-smile-brighter' => [
                    'title' => esc_html__('Smile Brighter', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 13,
                    'category' => 'health & beauty',
                    'subcategory' => 'dental',
                    'tags' => ['clinic', 'dental', 'aligners', 'orthodontic', 'health', 'healthtech', 'teeth', 'hospital', 'medical', 'medical center', 'doctor', 'braces', 'pediatric', 'therapy', 'dentist'],
                ],
                't13-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 13,
                    'category' => 'health & beauty',
                    'subcategory' => 'health & beauty',
                    'tags' => ['clinic', 'dental', 'aligners', 'orthodontic', 'health', 'healthtech', 'teeth', 'hospital', 'medical', 'medical center', 'doctor', 'braces', 'pediatric', 'therapy', 'dentist'],
                ],
                't13-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 13,
                    'category' => 'health & beauty',
                    'subcategory' => 'health & beauty',
                    'tags' => ['clinic', 'dental', 'aligners', 'orthodontic', 'health', 'healthtech', 'teeth', 'hospital', 'medical', 'medical center', 'doctor', 'braces', 'pediatric', 'therapy', 'dentist'],
                ],
                't13-our-team' => [
                    'title' => esc_html__('Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 13,
                    'category' => 'health & beauty',
                    'subcategory' => 'health & beauty',
                    'tags' => ['clinic', 'dental', 'aligners', 'orthodontic', 'health', 'healthtech', 'teeth', 'hospital', 'medical', 'medical center', 'doctor', 'braces', 'pediatric', 'therapy', 'dentist'],
                ],
                't13-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 13,
                    'category' => 'health & beauty',
                    'subcategory' => 'health & beauty',
                    'tags' => ['clinic', 'dental', 'aligners', 'orthodontic', 'health', 'healthtech', 'teeth', 'hospital', 'medical', 'medical center', 'doctor', 'braces', 'pediatric', 'therapy', 'dentist'],
                ],
                't14-brighter-tomorrow' => [
                    'title' => esc_html__('Brighter Tomorrow', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 14,
                    'category' => 'business',
                    'subcategory' => 'corporate',
                    'tags' => ['architecture', 'building', 'building company', 'building materials', 'construction', 'construction company', 'construction supplies', 'contractor', 'corporate', 'engineering', 'exterior design', 'industrial', 'remodeling', 'renovation'],
                ],
                't14-blueprints-into-reality' => [
                    'title' => esc_html__('Blueprints into Reality', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 14,
                    'category' => 'business',
                    'subcategory' => 'corporate',
                    'tags' => ['architecture', 'building', 'building company', 'building materials', 'construction', 'construction company', 'construction supplies', 'contractor', 'corporate', 'engineering', 'exterior design', 'industrial', 'remodeling', 'renovation'],
                ],
                't14-building-dreams' => [
                    'title' => esc_html__('Building Dreams', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 14,
                    'category' => 'business',
                    'subcategory' => 'corporate',
                    'tags' => ['architecture', 'building', 'building company', 'building materials', 'construction', 'construction company', 'construction supplies', 'contractor', 'corporate', 'engineering', 'exterior design', 'industrial', 'remodeling', 'renovation'],
                ],
                't14-transforming-spaces' => [
                    'title' => esc_html__('Transforming Spaces', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 14,
                    'category' => 'business',
                    'subcategory' => 'corporate',
                    'tags' => ['architecture', 'building', 'building company', 'building materials', 'construction', 'construction company', 'construction supplies', 'contractor', 'corporate', 'engineering', 'exterior design', 'industrial', 'remodeling', 'renovation'],
                ],
                't14-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 14,
                    'category' => 'business',
                    'subcategory' => 'business',
                    'tags' => ['architecture', 'building', 'building company', 'building materials', 'construction', 'construction company', 'construction supplies', 'contractor', 'corporate', 'engineering', 'exterior design', 'industrial', 'remodeling', 'renovation'],
                ],
                't14-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 14,
                    'category' => 'business',
                    'subcategory' => 'business',
                    'tags' => ['architecture', 'building', 'building company', 'building materials', 'construction', 'construction company', 'construction supplies', 'contractor', 'corporate', 'engineering', 'exterior design', 'industrial', 'remodeling', 'renovation'],
                ],
                't14-our-gallery' => [
                    'title' => esc_html__('Our Gallery', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 14,
                    'category' => 'business',
                    'subcategory' => 'business',
                    'tags' => ['architecture', 'building', 'building company', 'building materials', 'construction', 'construction company', 'construction supplies', 'contractor', 'corporate', 'engineering', 'exterior design', 'industrial', 'remodeling', 'renovation'],
                ],
                't14-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 14,
                    'category' => 'business',
                    'subcategory' => 'business',
                    'tags' => ['architecture', 'building', 'building company', 'building materials', 'construction', 'construction company', 'construction supplies', 'contractor', 'corporate', 'engineering', 'exterior design', 'industrial', 'remodeling', 'renovation'],
                ],
                't16-rescue-rehabilitate-rehome' => [
                    'title' => esc_html__('Rescue, Rehabilitate, Rehome', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 16,
                    'category' => 'nonprofit',
                    'subcategory' => 'shelter',
                    'tags' => ['adoption', 'animal', 'animal shelter', 'cats', 'charity', 'dogs', 'donation', 'homeless', 'non-profit', 'sanctuary', 'shelter', 'sponsor', 'sponsorship', 'volunteer', 'welfare'],
                ],
                't16-hope-for-paws' => [
                    'title' => esc_html__('Hope for Paws', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 16,
                    'category' => 'nonprofit',
                    'subcategory' => 'shelter',
                    'tags' => ['adoption', 'animal', 'animal shelter', 'cats', 'charity', 'dogs', 'donation', 'homeless', 'non-profit', 'sanctuary', 'shelter', 'sponsor', 'sponsorship', 'volunteer', 'welfare'],
                ],
                't16-tails-of-hope' => [
                    'title' => esc_html__('Tails of Hope', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 16,
                    'category' => 'nonprofit',
                    'subcategory' => 'shelter',
                    'tags' => ['adoption', 'animal', 'animal shelter', 'cats', 'charity', 'dogs', 'donation', 'homeless', 'non-profit', 'sanctuary', 'shelter', 'sponsor', 'sponsorship', 'volunteer', 'welfare'],
                ],
                't16-wagging-tails-happy-hearts' => [
                    'title' => esc_html__('Wagging Tails Happy Hearts', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 16,
                    'category' => 'nonprofit',
                    'subcategory' => 'shelter',
                    'tags' => ['adoption', 'animal', 'animal shelter', 'cats', 'charity', 'dogs', 'donation', 'homeless', 'non-profit', 'sanctuary', 'shelter', 'sponsor', 'sponsorship', 'volunteer', 'welfare'],
                ],
                't16-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 16,
                    'category' => 'nonprofit',
                    'subcategory' => 'shelter',
                    'tags' => ['adoption', 'animal', 'animal shelter', 'cats', 'charity', 'dogs', 'donation', 'homeless', 'non-profit', 'sanctuary', 'shelter', 'sponsor', 'sponsorship', 'volunteer', 'welfare'],
                ],
                't16-our-gallery' => [
                    'title' => esc_html__('Our Gallery', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 16,
                    'category' => 'nonprofit',
                    'subcategory' => 'shelter',
                    'tags' => ['adoption', 'animal', 'animal shelter', 'cats', 'charity', 'dogs', 'donation', 'homeless', 'non-profit', 'sanctuary', 'shelter', 'sponsor', 'sponsorship', 'volunteer', 'welfare'],
                ],
                't16-our-team' => [
                    'title' => esc_html__('Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 16,
                    'category' => 'nonprofit',
                    'subcategory' => 'shelter',
                    'tags' => ['adoption', 'animal', 'animal shelter', 'cats', 'charity', 'dogs', 'donation', 'homeless', 'non-profit', 'sanctuary', 'shelter', 'sponsor', 'sponsorship', 'volunteer', 'welfare'],
                ],
                't16-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 16,
                    'category' => 'nonprofit',
                    'subcategory' => 'shelter',
                    'tags' => ['adoption', 'animal', 'animal shelter', 'cats', 'charity', 'dogs', 'donation', 'homeless', 'non-profit', 'sanctuary', 'shelter', 'sponsor', 'sponsorship', 'volunteer', 'welfare'],
                ],
                't17-enjoy-the-freshness' => [
                    'title' => esc_html__('Enjoy the Freshness', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 17,
                    'category' => 'food',
                    'subcategory' => 'farm',
                    'tags' => ['agriculture', 'dairy', 'dairy farm', 'eco', 'eco-farm', 'eco-store', 'farm', 'farmer', 'farming', 'health', 'organic', 'organic food', 'organic products', 'retail', 'vegetables'],
                ],
                't17-farm-fresh-delights' => [
                    'title' => esc_html__('Farm-Fresh Delights', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 17,
                    'category' => 'food',
                    'subcategory' => 'farm',
                    'tags' => ['agriculture', 'dairy', 'dairy farm', 'eco', 'eco-farm', 'eco-store', 'farm', 'farmer', 'farming', 'health', 'organic', 'organic food', 'organic products', 'retail', 'vegetables'],
                ],
                't17-the-taste-of-tradition' => [
                    'title' => esc_html__('The Taste of Tradition', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 17,
                    'category' => 'food',
                    'subcategory' => 'farm',
                    'tags' => ['agriculture', 'dairy', 'dairy farm', 'eco', 'eco-farm', 'eco-store', 'farm', 'farmer', 'farming', 'health', 'organic', 'organic food', 'organic products', 'retail', 'vegetables'],
                ],
                't17-innovations-in-agriculture' => [
                    'title' => esc_html__('Innovations in Agriculture', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 17,
                    'category' => 'food',
                    'subcategory' => 'farm',
                    'tags' => ['agriculture', 'dairy', 'dairy farm', 'eco', 'eco-farm', 'eco-store', 'farm', 'farmer', 'farming', 'health', 'organic', 'organic food', 'organic products', 'retail', 'vegetables'],
                ],
                't17-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 17,
                    'category' => 'food',
                    'subcategory' => 'farm',
                    'tags' => ['agriculture', 'dairy', 'dairy farm', 'eco', 'eco-farm', 'eco-store', 'farm', 'farmer', 'farming', 'health', 'organic', 'organic food', 'organic products', 'retail', 'vegetables'],
                ],
                't17-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 17,
                    'category' => 'food',
                    'subcategory' => 'farm',
                    'tags' => ['agriculture', 'dairy', 'dairy farm', 'eco', 'eco-farm', 'eco-store', 'farm', 'farmer', 'farming', 'health', 'organic', 'organic food', 'organic products', 'retail', 'vegetables'],
                ],
                't17-our-gallery' => [
                    'title' => esc_html__('Our Gallery', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 17,
                    'category' => 'food',
                    'subcategory' => 'farm',
                    'tags' => ['agriculture', 'dairy', 'dairy farm', 'eco', 'eco-farm', 'eco-store', 'farm', 'farmer', 'farming', 'health', 'organic', 'organic food', 'organic products', 'retail', 'vegetables'],
                ],
                't17-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 17,
                    'category' => 'food',
                    'subcategory' => 'farm',
                    'tags' => ['agriculture', 'dairy', 'dairy farm', 'eco', 'eco-farm', 'eco-store', 'farm', 'farmer', 'farming', 'health', 'organic', 'organic food', 'organic products', 'retail', 'vegetables'],
                ],
                't18-masters-of-textile' => [
                    'title' => esc_html__('Masters of Textile', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 18,
                    'category' => 'manufacturing',
                    'subcategory' => 'textile',
                    'tags' => ['bedding', 'clothing', 'curtains', 'designer', 'fabric', 'factory', 'fashion', 'garment', 'handmade', 'industry', 'manufacturing', 'shoes', 'shop', 'tailor', 'textile'],
                ],
                't18-textile-tailoring' => [
                    'title' => esc_html__('Textile Tailoring', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 18,
                    'category' => 'manufacturing',
                    'subcategory' => 'textile',
                    'tags' => ['bedding', 'clothing', 'curtains', 'designer', 'fabric', 'factory', 'fashion', 'garment', 'handmade', 'industry', 'manufacturing', 'shoes', 'shop', 'tailor', 'textile'],
                ],
                't18-the-fabric-of-fashion' => [
                    'title' => esc_html__('The Fabric of Fashion', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 18,
                    'category' => 'manufacturing',
                    'subcategory' => 'textile',
                    'tags' => ['bedding', 'clothing', 'curtains', 'designer', 'fabric', 'factory', 'fashion', 'garment', 'handmade', 'industry', 'manufacturing', 'shoes', 'shop', 'tailor', 'textile'],
                ],
                't18-your-fashion-source' => [
                    'title' => esc_html__('Your Fashion Source', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 18,
                    'category' => 'manufacturing',
                    'subcategory' => 'textile',
                    'tags' => ['bedding', 'clothing', 'curtains', 'designer', 'fabric', 'factory', 'fashion', 'garment', 'handmade', 'industry', 'manufacturing', 'shoes', 'shop', 'tailor', 'textile'],
                ],
                't18-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 18,
                    'category' => 'manufacturing',
                    'subcategory' => 'textile',
                    'tags' => ['bedding', 'clothing', 'curtains', 'designer', 'fabric', 'factory', 'fashion', 'garment', 'handmade', 'industry', 'manufacturing', 'shoes', 'shop', 'tailor', 'textile'],
                ],
                't18-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 18,
                    'category' => 'manufacturing',
                    'subcategory' => 'textile',
                    'tags' => ['bedding', 'clothing', 'curtains', 'designer', 'fabric', 'factory', 'fashion', 'garment', 'handmade', 'industry', 'manufacturing', 'shoes', 'shop', 'tailor', 'textile'],
                ],
                't18-our-gallery' => [
                    'title' => esc_html__('Our Gallery', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 18,
                    'category' => 'manufacturing',
                    'subcategory' => 'textile',
                    'tags' => ['bedding', 'clothing', 'curtains', 'designer', 'fabric', 'factory', 'fashion', 'garment', 'handmade', 'industry', 'manufacturing', 'shoes', 'shop', 'tailor', 'textile'],
                ],
                't18-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 18,
                    'category' => 'manufacturing',
                    'subcategory' => 'textile',
                    'tags' => ['bedding', 'clothing', 'curtains', 'designer', 'fabric', 'factory', 'fashion', 'garment', 'handmade', 'industry', 'manufacturing', 'shoes', 'shop', 'tailor', 'textile'],
                ],
                't19-transforming-lives' => [
                    'title' => esc_html__('Transforming Lives', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 19,
                    'category' => 'nonprofit',
                    'subcategory' => 'church',
                    'tags' => ['cathedral', 'catholic', 'charity', 'charity foundation', 'church', 'church theme', 'donate', 'donation', 'fundraising', 'NGO', 'nonprofit', 'orthodox', 'religion', 'spiritual'],
                ],
                't19-sunday-worship' => [
                    'title' => esc_html__('Sunday Worship', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 19,
                    'category' => 'nonprofit',
                    'subcategory' => 'church',
                    'tags' => ['cathedral', 'catholic', 'charity', 'charity foundation', 'church', 'church theme', 'donate', 'donation', 'fundraising', 'NGO', 'nonprofit', 'orthodox', 'religion', 'spiritual'],
                ],
                't19-serving-with-love' => [
                    'title' => esc_html__('Serving with Love', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 19,
                    'category' => 'nonprofit',
                    'subcategory' => 'church',
                    'tags' => ['cathedral', 'catholic', 'charity', 'charity foundation', 'church', 'church theme', 'donate', 'donation', 'fundraising', 'NGO', 'nonprofit', 'orthodox', 'religion', 'spiritual'],
                ],
                't19-inspiring-hope' => [
                    'title' => esc_html__('Inspiring Hope', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 19,
                    'category' => 'nonprofit',
                    'subcategory' => 'church',
                    'tags' => ['cathedral', 'catholic', 'charity', 'charity foundation', 'church', 'church theme', 'donate', 'donation', 'fundraising', 'NGO', 'nonprofit', 'orthodox', 'religion', 'spiritual'],
                ],
                't19-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 19,
                    'category' => 'nonprofit',
                    'subcategory' => 'church',
                    'tags' => ['cathedral', 'catholic', 'charity', 'charity foundation', 'church', 'church theme', 'donate', 'donation', 'fundraising', 'NGO', 'nonprofit', 'orthodox', 'religion', 'spiritual'],
                ],
                't19-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 19,
                    'category' => 'nonprofit',
                    'subcategory' => 'church',
                    'tags' => ['cathedral', 'catholic', 'charity', 'charity foundation', 'church', 'church theme', 'donate', 'donation', 'fundraising', 'NGO', 'nonprofit', 'orthodox', 'religion', 'spiritual'],
                ],
                't19-our-team' => [
                    'title' => esc_html__('Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 19,
                    'category' => 'nonprofit',
                    'subcategory' => 'church',
                    'tags' => ['cathedral', 'catholic', 'charity', 'charity foundation', 'church', 'church theme', 'donate', 'donation', 'fundraising', 'NGO', 'nonprofit', 'orthodox', 'religion', 'spiritual'],
                ],
                't19-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 19,
                    'category' => 'nonprofit',
                    'subcategory' => 'church',
                    'tags' => ['cathedral', 'catholic', 'charity', 'charity foundation', 'church', 'church theme', 'donate', 'donation', 'fundraising', 'NGO', 'nonprofit', 'orthodox', 'religion', 'spiritual'],
                ],
                't20-your-trusted-breeder' => [
                    'title' => esc_html__('Your Trusted Breeder', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 20,
                    'category' => 'business',
                    'subcategory' => 'miscellaneous',
                    'tags' => ['adoption', 'animals', 'breed', 'breeder', 'breeding', 'cat', 'dog', 'kennel', 'litter', 'pet', 'pet adoption', 'puppy', 'shelter', 'vet', 'veterinarian'],
                ],
                't20-loving-homes-happy-dogs' => [
                    'title' => esc_html__('Loving Homes, Happy Dogs', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 20,
                    'category' => 'business',
                    'subcategory' => 'miscellaneous',
                    'tags' => ['adoption', 'animals', 'breed', 'breeder', 'breeding', 'cat', 'dog', 'kennel', 'litter', 'pet', 'pet adoption', 'puppy', 'shelter', 'vet', 'veterinarian'],
                ],
                't20-your-furry-friend' => [
                    'title' => esc_html__('Your Furry Friend', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 20,
                    'category' => 'business',
                    'subcategory' => 'miscellaneous',
                    'tags' => ['adoption', 'animals', 'breed', 'breeder', 'breeding', 'cat', 'dog', 'kennel', 'litter', 'pet', 'pet adoption', 'puppy', 'shelter', 'vet', 'veterinarian'],
                ],
                't20-your-dog-your-story' => [
                    'title' => esc_html__('Your Dog, Your Story', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 20,
                    'category' => 'business',
                    'subcategory' => 'miscellaneous',
                    'tags' => ['adoption', 'animals', 'breed', 'breeder', 'breeding', 'cat', 'dog', 'kennel', 'litter', 'pet', 'pet adoption', 'puppy', 'shelter', 'vet', 'veterinarian'],
                ],
                't20-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 20,
                    'category' => 'business',
                    'subcategory' => 'miscellaneous',
                    'tags' => ['adoption', 'animals', 'breed', 'breeder', 'breeding', 'cat', 'dog', 'kennel', 'litter', 'pet', 'pet adoption', 'puppy', 'shelter', 'vet', 'veterinarian'],
                ],
                't20-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 20,
                    'category' => 'business',
                    'subcategory' => 'miscellaneous',
                    'tags' => ['adoption', 'animals', 'breed', 'breeder', 'breeding', 'cat', 'dog', 'kennel', 'litter', 'pet', 'pet adoption', 'puppy', 'shelter', 'vet', 'veterinarian'],
                ],
                't20-our-gallery' => [
                    'title' => esc_html__('Our Gallery', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 20,
                    'category' => 'business',
                    'subcategory' => 'miscellaneous',
                    'tags' => ['adoption', 'animals', 'breed', 'breeder', 'breeding', 'cat', 'dog', 'kennel', 'litter', 'pet', 'pet adoption', 'puppy', 'shelter', 'vet', 'veterinarian'],
                ],
                't20-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 20,
                    'category' => 'business',
                    'subcategory' => 'miscellaneous',
                    'tags' => ['adoption', 'animals', 'breed', 'breeder', 'breeding', 'cat', 'dog', 'kennel', 'litter', 'pet', 'pet adoption', 'puppy', 'shelter', 'vet', 'veterinarian'],
                ],
                't21-yoga-classes' => [
                    'title' => esc_html__('Yoga Classes', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 21,
                    'category' => 'business',
                    'subcategory' => 'wellness',
                    'tags' => ['asana', 'fitness', 'gym', 'health', 'meditation', 'pilates', 'spa', 'spiritual', 'trainer', 'wellness', 'yoga', 'yoga class', 'yoga instructor', 'yoga retreats'],
                ],
                't21-yoga-studio' => [
                    'title' => esc_html__('Yoga Studio', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 21,
                    'category' => 'business',
                    'subcategory' => 'wellness',
                    'tags' => ['asana', 'fitness', 'gym', 'health', 'meditation', 'pilates', 'spa', 'spiritual', 'trainer', 'wellness', 'yoga', 'yoga class', 'yoga instructor', 'yoga retreats'],
                ],
                't21-yoga-practice' => [
                    'title' => esc_html__('Yoga Practice', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 21,
                    'category' => 'business',
                    'subcategory' => 'wellness',
                    'tags' => ['asana', 'fitness', 'gym', 'health', 'meditation', 'pilates', 'spa', 'spiritual', 'trainer', 'wellness', 'yoga', 'yoga class', 'yoga instructor', 'yoga retreats'],
                ],
                't21-the-power-of-yoga' => [
                    'title' => esc_html__('The Power of Yoga', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 21,
                    'category' => 'business',
                    'subcategory' => 'wellness',
                    'tags' => ['asana', 'fitness', 'gym', 'health', 'meditation', 'pilates', 'spa', 'spiritual', 'trainer', 'wellness', 'yoga', 'yoga class', 'yoga instructor', 'yoga retreats'],
                ],
                't21-about-our-studio' => [
                    'title' => esc_html__('About Our Studio', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 21,
                    'category' => 'business',
                    'subcategory' => 'wellness',
                    'tags' => ['asana', 'fitness', 'gym', 'health', 'meditation', 'pilates', 'spa', 'spiritual', 'trainer', 'wellness', 'yoga', 'yoga class', 'yoga instructor', 'yoga retreats'],
                ],
                't21-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 21,
                    'category' => 'business',
                    'subcategory' => 'wellness',
                    'tags' => ['asana', 'fitness', 'gym', 'health', 'meditation', 'pilates', 'spa', 'spiritual', 'trainer', 'wellness', 'yoga', 'yoga class', 'yoga instructor', 'yoga retreats'],
                ],
                't21-our-teachers' => [
                    'title' => esc_html__('Our Teachers', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 21,
                    'category' => 'business',
                    'subcategory' => 'wellness',
                    'tags' => ['asana', 'fitness', 'gym', 'health', 'meditation', 'pilates', 'spa', 'spiritual', 'trainer', 'wellness', 'yoga', 'yoga class', 'yoga instructor', 'yoga retreats'],
                ],
                't21-prices' => [
                    'title' => esc_html__('Prices', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 21,
                    'category' => 'business',
                    'subcategory' => 'wellness',
                    'tags' => ['asana', 'fitness', 'gym', 'health', 'meditation', 'pilates', 'spa', 'spiritual', 'trainer', 'wellness', 'yoga', 'yoga class', 'yoga instructor', 'yoga retreats'],
                ],
                't21-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 21,
                    'category' => 'business',
                    'subcategory' => 'wellness',
                    'tags' => ['asana', 'fitness', 'gym', 'health', 'meditation', 'pilates', 'spa', 'spiritual', 'trainer', 'wellness', 'yoga', 'yoga class', 'yoga instructor', 'yoga retreats'],
                ],
                't22-top-tier-auto-service' => [
                    'title' => esc_html__('Top-Tier Auto Service', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 22,
                    'category' => 'business',
                    'subcategory' => 'auto',
                    'tags' => ['auto', 'auto parts', 'car', 'car repair', 'car service', 'car shop', 'dealership', 'emergency repair', 'mechanic', 'repair', 'services', 'tires', 'tuning', 'vehicle'],
                ],
                't22-revitalize-your-vehicle' => [
                    'title' => esc_html__('Revitalize Your Vehicle', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 22,
                    'category' => 'business',
                    'subcategory' => 'auto',
                    'tags' => ['auto', 'auto parts', 'car', 'car repair', 'car service', 'car shop', 'dealership', 'emergency repair', 'mechanic', 'repair', 'services', 'tires', 'tuning', 'vehicle'],
                ],
                't22-unmatched-auto-service' => [
                    'title' => esc_html__('Unmatched Auto Service', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 22,
                    'category' => 'business',
                    'subcategory' => 'auto',
                    'tags' => ['auto', 'auto parts', 'car', 'car repair', 'car service', 'car shop', 'dealership', 'emergency repair', 'mechanic', 'repair', 'services', 'tires', 'tuning', 'vehicle'],
                ],
                't22-expert-auto-service' => [
                    'title' => esc_html__('Expert Auto Service', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 22,
                    'category' => 'business',
                    'subcategory' => 'auto',
                    'tags' => ['auto', 'auto parts', 'car', 'car repair', 'car service', 'car shop', 'dealership', 'emergency repair', 'mechanic', 'repair', 'services', 'tires', 'tuning', 'vehicle'],
                ],
                't22-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 22,
                    'category' => 'business',
                    'subcategory' => 'auto',
                    'tags' => ['auto', 'auto parts', 'car', 'car repair', 'car service', 'car shop', 'dealership', 'emergency repair', 'mechanic', 'repair', 'services', 'tires', 'tuning', 'vehicle'],
                ],
                't22-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 22,
                    'category' => 'business',
                    'subcategory' => 'auto',
                    'tags' => ['auto', 'auto parts', 'car', 'car repair', 'car service', 'car shop', 'dealership', 'emergency repair', 'mechanic', 'repair', 'services', 'tires', 'tuning', 'vehicle'],
                ],
                't22-look-at-our-work' => [
                    'title' => esc_html__('Look at Our Work', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 22,
                    'category' => 'business',
                    'subcategory' => 'auto',
                    'tags' => ['auto', 'auto parts', 'car', 'car repair', 'car service', 'car shop', 'dealership', 'emergency repair', 'mechanic', 'repair', 'services', 'tires', 'tuning', 'vehicle'],
                ],
                't22-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 22,
                    'category' => 'business',
                    'subcategory' => 'auto',
                    'tags' => ['auto', 'auto parts', 'car', 'car repair', 'car service', 'car shop', 'dealership', 'emergency repair', 'mechanic', 'repair', 'services', 'tires', 'tuning', 'vehicle'],
                ],
                't23-horse-riding-club' => [
                    'title' => esc_html__('Horse Riding Club', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 23,
                    'category' => 'business',
                    'subcategory' => 'miscellaneous',
                    'tags' => ['equestrian club', 'horse', 'horse care', 'horse club', 'horse racing', 'horse stables', 'jockey', 'ranch', 'rider', 'riding club', 'riding equipment', 'riding school', 'sports', 'stables'],
                ],
                't23-equestrian-enthusiasts' => [
                    'title' => esc_html__('Equestrian Enthusiasts', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 23,
                    'category' => 'business',
                    'subcategory' => 'miscellaneous',
                    'tags' => ['equestrian club', 'horse', 'horse care', 'horse club', 'horse racing', 'horse stables', 'jockey', 'ranch', 'rider', 'riding club', 'riding equipment', 'riding school', 'sports', 'stables'],
                ],
                't23-the-thrill-of-horse-riding' => [
                    'title' => esc_html__('The Thrill of Horse Riding', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 23,
                    'category' => 'business',
                    'subcategory' => 'miscellaneous',
                    'tags' => ['equestrian club', 'horse', 'horse care', 'horse club', 'horse racing', 'horse stables', 'jockey', 'ranch', 'rider', 'riding club', 'riding equipment', 'riding school', 'sports', 'stables'],
                ],
                't23-unleash-your-inner-rider' => [
                    'title' => esc_html__('Unleash Your Inner Rider', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 23,
                    'category' => 'business',
                    'subcategory' => 'miscellaneous',
                    'tags' => ['equestrian club', 'horse', 'horse care', 'horse club', 'horse racing', 'horse stables', 'jockey', 'ranch', 'rider', 'riding club', 'riding equipment', 'riding school', 'sports', 'stables'],
                ],
                't23-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 23,
                    'category' => 'business',
                    'subcategory' => 'miscellaneous',
                    'tags' => ['equestrian club', 'horse', 'horse care', 'horse club', 'horse racing', 'horse stables', 'jockey', 'ranch', 'rider', 'riding club', 'riding equipment', 'riding school', 'sports', 'stables'],
                ],
                't23-our-gallery' => [
                    'title' => esc_html__('Our Gallery', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 23,
                    'category' => 'business',
                    'subcategory' => 'miscellaneous',
                    'tags' => ['equestrian club', 'horse', 'horse care', 'horse club', 'horse racing', 'horse stables', 'jockey', 'ranch', 'rider', 'riding club', 'riding equipment', 'riding school', 'sports', 'stables'],
                ],
                't23-our-team' => [
                    'title' => esc_html__('Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 23,
                    'category' => 'business',
                    'subcategory' => 'miscellaneous',
                    'tags' => ['equestrian club', 'horse', 'horse care', 'horse club', 'horse racing', 'horse stables', 'jockey', 'ranch', 'rider', 'riding club', 'riding equipment', 'riding school', 'sports', 'stables'],
                ],
                't23-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 23,
                    'category' => 'business',
                    'subcategory' => 'miscellaneous',
                    'tags' => ['equestrian club', 'horse', 'horse care', 'horse club', 'horse racing', 'horse stables', 'jockey', 'ranch', 'rider', 'riding club', 'riding equipment', 'riding school', 'sports', 'stables'],
                ],
                't24-electrical-emergencies' => [
                    'title' => esc_html__('Electrical Emergencies', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 24,
                    'category' => 'business',
                    'subcategory' => 'engineering',
                    'tags' => ['cable repair', 'electric', 'electrical company', 'electrical repairer', 'electrician', 'electricity mechanic', 'electricity services', 'energy', 'engineering', 'handyman', 'lighting shop', 'maintenance', 'renovation', 'smart home'],
                ],
                't24-electrician-repair-solutions' => [
                    'title' => esc_html__('Electrician Repair Solutions', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 24,
                    'category' => 'business',
                    'subcategory' => 'engineering',
                    'tags' => ['cable repair', 'electric', 'electrical company', 'electrical repairer', 'electrician', 'electricity mechanic', 'electricity services', 'energy', 'engineering', 'handyman', 'lighting shop', 'maintenance', 'renovation', 'smart home'],
                ],
                't24-trusted-electrician-repair' => [
                    'title' => esc_html__('Trusted Electrician Repair', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 24,
                    'category' => 'business',
                    'subcategory' => 'engineering',
                    'tags' => ['cable repair', 'electric', 'electrical company', 'electrical repairer', 'electrician', 'electricity mechanic', 'electricity services', 'energy', 'engineering', 'handyman', 'lighting shop', 'maintenance', 'renovation', 'smart home'],
                ],
                't24-skilled-electricians' => [
                    'title' => esc_html__('Skilled Electricians', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 24,
                    'category' => 'business',
                    'subcategory' => 'engineering',
                    'tags' => ['cable repair', 'electric', 'electrical company', 'electrical repairer', 'electrician', 'electricity mechanic', 'electricity services', 'energy', 'engineering', 'handyman', 'lighting shop', 'maintenance', 'renovation', 'smart home'],
                ],
                't24-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 24,
                    'category' => 'business',
                    'subcategory' => 'engineering',
                    'tags' => ['cable repair', 'electric', 'electrical company', 'electrical repairer', 'electrician', 'electricity mechanic', 'electricity services', 'energy', 'engineering', 'handyman', 'lighting shop', 'maintenance', 'renovation', 'smart home'],
                ],
                't24-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 24,
                    'category' => 'business',
                    'subcategory' => 'engineering',
                    'tags' => ['cable repair', 'electric', 'electrical company', 'electrical repairer', 'electrician', 'electricity mechanic', 'electricity services', 'energy', 'engineering', 'handyman', 'lighting shop', 'maintenance', 'renovation', 'smart home'],
                ],
                't24-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 24,
                    'category' => 'business',
                    'subcategory' => 'engineering',
                    'tags' => ['cable repair', 'electric', 'electrical company', 'electrical repairer', 'electrician', 'electricity mechanic', 'electricity services', 'energy', 'engineering', 'handyman', 'lighting shop', 'maintenance', 'renovation', 'smart home'],
                ],
                't25-justice-prevails' => [
                    'title' => esc_html__('Justice Prevails', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 25,
                    'category' => 'legal',
                    'subcategory' => 'legal',
                    'tags' => ['advocate', 'attorney', 'business', 'court', 'law', 'law firm', 'law firm theme', 'law website', 'lawyer', 'lawyers', 'legal', 'legal consultant', 'legal services', 'solicitor'],
                ],
                't25-trusted-attorneys' => [
                    'title' => esc_html__('Trusted Attorneys', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 25,
                    'category' => 'legal',
                    'subcategory' => 'legal',
                    'tags' => ['advocate', 'attorney', 'business', 'court', 'law', 'law firm', 'law firm theme', 'law website', 'lawyer', 'lawyers', 'legal', 'legal consultant', 'legal services', 'solicitor'],
                ],
                't25-your-legal-solution' => [
                    'title' => esc_html__('Your Legal Solution', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 25,
                    'category' => 'legal',
                    'subcategory' => 'legal',
                    'tags' => ['advocate', 'attorney', 'business', 'court', 'law', 'law firm', 'law firm theme', 'law website', 'lawyer', 'lawyers', 'legal', 'legal consultant', 'legal services', 'solicitor'],
                ],
                't25-your-legal-allies' => [
                    'title' => esc_html__('Your Legal Allies', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 25,
                    'category' => 'legal',
                    'subcategory' => 'legal',
                    'tags' => ['advocate', 'attorney', 'business', 'court', 'law', 'law firm', 'law firm theme', 'law website', 'lawyer', 'lawyers', 'legal', 'legal consultant', 'legal services', 'solicitor'],
                ],
                't25-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 25,
                    'category' => 'legal',
                    'subcategory' => 'legal',
                    'tags' => ['advocate', 'attorney', 'business', 'court', 'law', 'law firm', 'law firm theme', 'law website', 'lawyer', 'lawyers', 'legal', 'legal consultant', 'legal services', 'solicitor'],
                ],
                't25-our-pricing' => [
                    'title' => esc_html__('Our Pricing', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 25,
                    'category' => 'legal',
                    'subcategory' => 'legal',
                    'tags' => ['advocate', 'attorney', 'business', 'court', 'law', 'law firm', 'law firm theme', 'law website', 'lawyer', 'lawyers', 'legal', 'legal consultant', 'legal services', 'solicitor'],
                ],
                't25-our-team' => [
                    'title' => esc_html__('Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 25,
                    'category' => 'legal',
                    'subcategory' => 'legal',
                    'tags' => ['advocate', 'attorney', 'business', 'court', 'law', 'law firm', 'law firm theme', 'law website', 'lawyer', 'lawyers', 'legal', 'legal consultant', 'legal services', 'solicitor'],
                ],
                't25-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 25,
                    'category' => 'legal',
                    'subcategory' => 'legal',
                    'tags' => ['advocate', 'attorney', 'business', 'court', 'law', 'law firm', 'law firm theme', 'law website', 'lawyer', 'lawyers', 'legal', 'legal consultant', 'legal services', 'solicitor'],
                ],
                't26-step-into-possibility' => [
                    'title' => esc_html__('Step into Possibility', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 26,
                    'category' => 'health & beauty',
                    'subcategory' => 'health',
                    'tags' => ['artificial limb', 'biotechnology', 'disability', 'doctor', 'hand prosthesis', 'health care', 'hospital', 'leg prosthesis', 'medical center', 'medical recovery', 'medicine', 'orthopedic clinic', 'orthopedist', 'prosthesis'],
                ],
                't26-prosthetic-care' => [
                    'title' => esc_html__('Prosthetic Care', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 26,
                    'category' => 'health & beauty',
                    'subcategory' => 'health',
                    'tags' => ['artificial limb', 'biotechnology', 'disability', 'doctor', 'hand prosthesis', 'health care', 'hospital', 'leg prosthesis', 'medical center', 'medical recovery', 'medicine', 'orthopedic clinic', 'orthopedist', 'prosthesis'],
                ],
                't26-your-mobility-our-mission' => [
                    'title' => esc_html__('Your Mobility, Our Mission', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 26,
                    'category' => 'health & beauty',
                    'subcategory' => 'health',
                    'tags' => ['artificial limb', 'biotechnology', 'disability', 'doctor', 'hand prosthesis', 'health care', 'hospital', 'leg prosthesis', 'medical center', 'medical recovery', 'medicine', 'orthopedic clinic', 'orthopedist', 'prosthesis'],
                ],
                't26-confident-living' => [
                    'title' => esc_html__('Confident Living', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 26,
                    'category' => 'health & beauty',
                    'subcategory' => 'health',
                    'tags' => ['artificial limb', 'biotechnology', 'disability', 'doctor', 'hand prosthesis', 'health care', 'hospital', 'leg prosthesis', 'medical center', 'medical recovery', 'medicine', 'orthopedic clinic', 'orthopedist', 'prosthesis'],
                ],
                't26-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 26,
                    'category' => 'health & beauty',
                    'subcategory' => 'health',
                    'tags' => ['artificial limb', 'biotechnology', 'disability', 'doctor', 'hand prosthesis', 'health care', 'hospital', 'leg prosthesis', 'medical center', 'medical recovery', 'medicine', 'orthopedic clinic', 'orthopedist', 'prosthesis'],
                ],
                't26-gallery' => [
                    'title' => esc_html__('Gallery', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 26,
                    'category' => 'health & beauty',
                    'subcategory' => 'health',
                    'tags' => ['artificial limb', 'biotechnology', 'disability', 'doctor', 'hand prosthesis', 'health care', 'hospital', 'leg prosthesis', 'medical center', 'medical recovery', 'medicine', 'orthopedic clinic', 'orthopedist', 'prosthesis'],
                ],
                't26-our-team' => [
                    'title' => esc_html__('Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 26,
                    'category' => 'health & beauty',
                    'subcategory' => 'health',
                    'tags' => ['artificial limb', 'biotechnology', 'disability', 'doctor', 'hand prosthesis', 'health care', 'hospital', 'leg prosthesis', 'medical center', 'medical recovery', 'medicine', 'orthopedic clinic', 'orthopedist', 'prosthesis'],
                ],
                't26-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 26,
                    'category' => 'health & beauty',
                    'subcategory' => 'health',
                    'tags' => ['artificial limb', 'biotechnology', 'disability', 'doctor', 'hand prosthesis', 'health care', 'hospital', 'leg prosthesis', 'medical center', 'medical recovery', 'medicine', 'orthopedic clinic', 'orthopedist', 'prosthesis'],
                ],
                't27-kindergarten-magic' => [
                    'title' => esc_html__('Kindergarten Magic', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 27,
                    'category' => 'children',
                    'subcategory' => 'health',
                    'tags' => ['baby', 'babysitting', 'child', 'children', 'children care', 'day care', 'education', 'infant', 'kids', 'kindergarten', 'nanny', 'preschool', 'school', 'teacher'],
                ],
                't27-preschool-adventures' => [
                    'title' => esc_html__('Preschool Adventures', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 27,
                    'category' => 'children',
                    'subcategory' => 'health',
                    'tags' => ['baby', 'babysitting', 'child', 'children', 'children care', 'day care', 'education', 'infant', 'kids', 'kindergarten', 'nanny', 'preschool', 'school', 'teacher'],
                ],
                't27-where-little-minds-blossom' => [
                    'title' => esc_html__('Where Little Minds Blossom', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 27,
                    'category' => 'children',
                    'subcategory' => 'health',
                    'tags' => ['baby', 'babysitting', 'child', 'children', 'children care', 'day care', 'education', 'infant', 'kids', 'kindergarten', 'nanny', 'preschool', 'school', 'teacher'],
                ],
                't27-exceptional-nannies' => [
                    'title' => esc_html__('Exceptional Nannies', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 27,
                    'category' => 'children',
                    'subcategory' => 'health',
                    'tags' => ['baby', 'babysitting', 'child', 'children', 'children care', 'day care', 'education', 'infant', 'kids', 'kindergarten', 'nanny', 'preschool', 'school', 'teacher'],
                ],
                't27-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 27,
                    'category' => 'children',
                    'subcategory' => 'health',
                    'tags' => ['baby', 'babysitting', 'child', 'children', 'children care', 'day care', 'education', 'infant', 'kids', 'kindergarten', 'nanny', 'preschool', 'school', 'teacher'],
                ],
                't27-our-team' => [
                    'title' => esc_html__('Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 27,
                    'category' => 'children',
                    'subcategory' => 'health',
                    'tags' => ['baby', 'babysitting', 'child', 'children', 'children care', 'day care', 'education', 'infant', 'kids', 'kindergarten', 'nanny', 'preschool', 'school', 'teacher'],
                ],
                't27-our-menu' => [
                    'title' => esc_html__('Our Menu', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 27,
                    'category' => 'children',
                    'subcategory' => 'health',
                    'tags' => ['baby', 'babysitting', 'child', 'children', 'children care', 'day care', 'education', 'infant', 'kids', 'kindergarten', 'nanny', 'preschool', 'school', 'teacher'],
                ],
                't27-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 27,
                    'category' => 'children',
                    'subcategory' => 'health',
                    'tags' => ['baby', 'babysitting', 'child', 'children', 'children care', 'day care', 'education', 'infant', 'kids', 'kindergarten', 'nanny', 'preschool', 'school', 'teacher'],
                ],
                't28-metal-solutions' => [
                    'title' => esc_html__('Metal Solutions', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 28,
                    'category' => 'manufacturing',
                    'subcategory' => 'industrial',
                    'tags' => ['construction', 'engineering', 'factory', 'industrial', 'industrial machinery', 'industrial products', 'industry', 'manufacture', 'metal forming', 'metallurgy', 'modern', 'robotics technology', 'steel', 'steel production'],
                ],
                't28-excellence-in-metal' => [
                    'title' => esc_html__('Excellence in Metal', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 28,
                    'category' => 'manufacturing',
                    'subcategory' => 'industrial',
                    'tags' => ['construction', 'engineering', 'factory', 'industrial', 'industrial machinery', 'industrial products', 'industry', 'manufacture', 'metal forming', 'metallurgy', 'modern', 'robotics technology', 'steel', 'steel production'],
                ],
                't28-crafting-metals' => [
                    'title' => esc_html__('Crafting Metals', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 28,
                    'category' => 'manufacturing',
                    'subcategory' => 'industrial',
                    'tags' => ['construction', 'engineering', 'factory', 'industrial', 'industrial machinery', 'industrial products', 'industry', 'manufacture', 'metal forming', 'metallurgy', 'modern', 'robotics technology', 'steel', 'steel production'],
                ],
                't28-future-in-metals' => [
                    'title' => esc_html__('Future in Metals', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 28,
                    'category' => 'manufacturing',
                    'subcategory' => 'industrial',
                    'tags' => ['construction', 'engineering', 'factory', 'industrial', 'industrial machinery', 'industrial products', 'industry', 'manufacture', 'metal forming', 'metallurgy', 'modern', 'robotics technology', 'steel', 'steel production'],
                ],
                't28-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 28,
                    'category' => 'manufacturing',
                    'subcategory' => 'industrial',
                    'tags' => ['construction', 'engineering', 'factory', 'industrial', 'industrial machinery', 'industrial products', 'industry', 'manufacture', 'metal forming', 'metallurgy', 'modern', 'robotics technology', 'steel', 'steel production'],
                ],
                't28-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 28,
                    'category' => 'manufacturing',
                    'subcategory' => 'industrial',
                    'tags' => ['construction', 'engineering', 'factory', 'industrial', 'industrial machinery', 'industrial products', 'industry', 'manufacture', 'metal forming', 'metallurgy', 'modern', 'robotics technology', 'steel', 'steel production'],
                ],
                't28-certificates' => [
                    'title' => esc_html__('Certificates', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 28,
                    'category' => 'manufacturing',
                    'subcategory' => 'industrial',
                    'tags' => ['construction', 'engineering', 'factory', 'industrial', 'industrial machinery', 'industrial products', 'industry', 'manufacture', 'metal forming', 'metallurgy', 'modern', 'robotics technology', 'steel', 'steel production'],
                ],
                't28-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 28,
                    'category' => 'manufacturing',
                    'subcategory' => 'industrial',
                    'tags' => ['construction', 'engineering', 'factory', 'industrial', 'industrial machinery', 'industrial products', 'industry', 'manufacture', 'metal forming', 'metallurgy', 'modern', 'robotics technology', 'steel', 'steel production'],
                ],
                't29-sweetness-in-a-jar' => [
                    'title' => esc_html__('Sweetness in a Jar', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 29,
                    'category' => 'business',
                    'subcategory' => 'food',
                    'tags' => ['bee', 'beekeeper', 'beekeeping', 'food', 'healthy food', 'hive', 'honey', 'honey production', 'honey shop', 'organic', 'organic food', 'organic shop', 'organic theme', 'shop'],
                ],
                't29-natures-sweetness' => [
                    'title' => esc_html__('Natures Sweetness', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 29,
                    'category' => 'business',
                    'subcategory' => 'food',
                    'tags' => ['bee', 'beekeeper', 'beekeeping', 'food', 'healthy food', 'hive', 'honey', 'honey production', 'honey shop', 'organic', 'organic food', 'organic shop', 'organic theme', 'shop'],
                ],
                't29-from-hive-to-table' => [
                    'title' => esc_html__('From Hive to Table', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 29,
                    'category' => 'business',
                    'subcategory' => 'food',
                    'tags' => ['bee', 'beekeeper', 'beekeeping', 'food', 'healthy food', 'hive', 'honey', 'honey production', 'honey shop', 'organic', 'organic food', 'organic shop', 'organic theme', 'shop'],
                ],
                't29-sweet-dreams' => [
                    'title' => esc_html__('Sweet Dreams', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 29,
                    'category' => 'business',
                    'subcategory' => 'food',
                    'tags' => ['bee', 'beekeeper', 'beekeeping', 'food', 'healthy food', 'hive', 'honey', 'honey production', 'honey shop', 'organic', 'organic food', 'organic shop', 'organic theme', 'shop'],
                ],
                't29-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 29,
                    'category' => 'business',
                    'subcategory' => 'food',
                    'tags' => ['bee', 'beekeeper', 'beekeeping', 'food', 'healthy food', 'hive', 'honey', 'honey production', 'honey shop', 'organic', 'organic food', 'organic shop', 'organic theme', 'shop'],
                ],
                't29-beekeeping-gallery' => [
                    'title' => esc_html__('Beekeeping Gallery', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 29,
                    'category' => 'business',
                    'subcategory' => 'food',
                    'tags' => ['bee', 'beekeeper', 'beekeeping', 'food', 'healthy food', 'hive', 'honey', 'honey production', 'honey shop', 'organic', 'organic food', 'organic shop', 'organic theme', 'shop'],
                ],
                't29-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 29,
                    'category' => 'business',
                    'subcategory' => 'food',
                    'tags' => ['bee', 'beekeeper', 'beekeeping', 'food', 'healthy food', 'hive', 'honey', 'honey production', 'honey shop', 'organic', 'organic food', 'organic shop', 'organic theme', 'shop'],
                ],
                't30-golden-years-shine-brightest' => [
                    'title' => esc_html__('Golden Years Shine Brightest', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 30,
                    'category' => 'health & beauty',
                    'subcategory' => 'healthcare',
                    'tags' => ['aged care', 'assisted living', 'care', 'elder', 'elderly', 'health', 'health care', 'healthcare', 'medical', 'nursing', 'nursing home', 'old', 'retirement', 'senior', 'senior care'],
                ],
                't30-aging-with-dignity' => [
                    'title' => esc_html__('Aging with Dignity', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 30,
                    'category' => 'health & beauty',
                    'subcategory' => 'healthcare',
                    'tags' => ['aged care', 'assisted living', 'care', 'elder', 'elderly', 'health', 'health care', 'healthcare', 'medical', 'nursing', 'nursing home', 'old', 'retirement', 'senior', 'senior care'],
                ],
                't30-one-smile-at-a-time' => [
                    'title' => esc_html__('One Smile at a Time', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 30,
                    'category' => 'health & beauty',
                    'subcategory' => 'healthcare',
                    'tags' => ['aged care', 'assisted living', 'care', 'elder', 'elderly', 'health', 'health care', 'healthcare', 'medical', 'nursing', 'nursing home', 'old', 'retirement', 'senior', 'senior care'],
                ],
                't30-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 30,
                    'category' => 'health & beauty',
                    'subcategory' => 'healthcare',
                    'tags' => ['aged care', 'assisted living', 'care', 'elder', 'elderly', 'health', 'health care', 'healthcare', 'medical', 'nursing', 'nursing home', 'old', 'retirement', 'senior', 'senior care'],
                ],
                't30-our-team' => [
                    'title' => esc_html__('Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 30,
                    'category' => 'health & beauty',
                    'subcategory' => 'healthcare',
                    'tags' => ['aged care', 'assisted living', 'care', 'elder', 'elderly', 'health', 'health care', 'healthcare', 'medical', 'nursing', 'nursing home', 'old', 'retirement', 'senior', 'senior care'],
                ],
                't30-moments-of-care' => [
                    'title' => esc_html__('Moments of Care', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 30,
                    'category' => 'health & beauty',
                    'subcategory' => 'healthcare',
                    'tags' => ['aged care', 'assisted living', 'care', 'elder', 'elderly', 'health', 'health care', 'healthcare', 'medical', 'nursing', 'nursing home', 'old', 'retirement', 'senior', 'senior care'],
                ],
                't30-exceptional-care' => [
                    'title' => esc_html__('Exceptional Care', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 30,
                    'category' => 'health & beauty',
                    'subcategory' => 'healthcare',
                    'tags' => ['aged care', 'assisted living', 'care', 'elder', 'elderly', 'health', 'health care', 'healthcare', 'medical', 'nursing', 'nursing home', 'old', 'retirement', 'senior', 'senior care'],
                ],
                't30-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 30,
                    'category' => 'health & beauty',
                    'subcategory' => 'healthcare',
                    'tags' => ['aged care', 'assisted living', 'care', 'elder', 'elderly', 'health', 'health care', 'healthcare', 'medical', 'nursing', 'nursing home', 'old', 'retirement', 'senior', 'senior care'],
                ],
                't31-lash-elegance' => [
                    'title' => esc_html__('Lash Elegance', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 31,
                    'category' => 'health & beauty',
                    'subcategory' => 'beauty',
                    'tags' => ['beauty salon', 'beauty services', 'beauty shop', 'brow bar', 'cat eye lashes', 'eyebrows', 'eyelash extension', 'eyelash studio', 'lash lift', 'lash removal', 'lashes', 'perming', 'tinting', 'volume lashes'],
                ],
                't31-lash-love' => [
                    'title' => esc_html__('Lash Love', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 31,
                    'category' => 'health & beauty',
                    'subcategory' => 'beauty',
                    'tags' => ['beauty salon', 'beauty services', 'beauty shop', 'brow bar', 'cat eye lashes', 'eyebrows', 'eyelash extension', 'eyelash studio', 'lash lift', 'lash removal', 'lashes', 'perming', 'tinting', 'volume lashes'],
                ],
                't31-lash-dreams' => [
                    'title' => esc_html__('Lash Dreams', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 31,
                    'category' => 'health & beauty',
                    'subcategory' => 'beauty',
                    'tags' => ['beauty salon', 'beauty services', 'beauty shop', 'brow bar', 'cat eye lashes', 'eyebrows', 'eyelash extension', 'eyelash studio', 'lash lift', 'lash removal', 'lashes', 'perming', 'tinting', 'volume lashes'],
                ],
                't31-lash-magic' => [
                    'title' => esc_html__('Lash Magic', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 31,
                    'category' => 'health & beauty',
                    'subcategory' => 'beauty',
                    'tags' => ['beauty salon', 'beauty services', 'beauty shop', 'brow bar', 'cat eye lashes', 'eyebrows', 'eyelash extension', 'eyelash studio', 'lash lift', 'lash removal', 'lashes', 'perming', 'tinting', 'volume lashes'],
                ],
                't31-prices' => [
                    'title' => esc_html__('Prices', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 31,
                    'category' => 'health & beauty',
                    'subcategory' => 'beauty',
                    'tags' => ['beauty salon', 'beauty services', 'beauty shop', 'brow bar', 'cat eye lashes', 'eyebrows', 'eyelash extension', 'eyelash studio', 'lash lift', 'lash removal', 'lashes', 'perming', 'tinting', 'volume lashes'],
                ],
                't31-gallery' => [
                    'title' => esc_html__('Gallery', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 31,
                    'category' => 'health & beauty',
                    'subcategory' => 'beauty',
                    'tags' => ['beauty salon', 'beauty services', 'beauty shop', 'brow bar', 'cat eye lashes', 'eyebrows', 'eyelash extension', 'eyelash studio', 'lash lift', 'lash removal', 'lashes', 'perming', 'tinting', 'volume lashes'],
                ],
                't31-policies' => [
                    'title' => esc_html__('Policies', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 31,
                    'category' => 'health & beauty',
                    'subcategory' => 'beauty',
                    'tags' => ['beauty salon', 'beauty services', 'beauty shop', 'brow bar', 'cat eye lashes', 'eyebrows', 'eyelash extension', 'eyelash studio', 'lash lift', 'lash removal', 'lashes', 'perming', 'tinting', 'volume lashes'],
                ],
                't31-locations' => [
                    'title' => esc_html__('Locations', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 31,
                    'category' => 'health & beauty',
                    'subcategory' => 'beauty',
                    'tags' => ['beauty salon', 'beauty services', 'beauty shop', 'brow bar', 'cat eye lashes', 'eyebrows', 'eyelash extension', 'eyelash studio', 'lash lift', 'lash removal', 'lashes', 'perming', 'tinting', 'volume lashes'],
                ],
                't31-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 31,
                    'category' => 'health & beauty',
                    'subcategory' => 'beauty',
                    'tags' => ['beauty salon', 'beauty services', 'beauty shop', 'brow bar', 'cat eye lashes', 'eyebrows', 'eyelash extension', 'eyelash studio', 'lash lift', 'lash removal', 'lashes', 'perming', 'tinting', 'volume lashes'],
                ],
                't32-flying-academy' => [
                    'title' => esc_html__('Flying Academy', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 32,
                    'category' => 'business',
                    'subcategory' => 'aircraft',
                    'tags' => ['air charter', 'aircraft', 'aircraft services', 'airline', 'airplane', 'aviation', 'flight', 'flight academy', 'flight school', 'flying', 'maintenance', 'pilot', 'pilot training', 'plane', 'private jet charter'],
                ],
                't32-aviators-of-tomorrow' => [
                    'title' => esc_html__('Aviators of Tomorrow', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 32,
                    'category' => 'business',
                    'subcategory' => 'aircraft',
                    'tags' => ['air charter', 'aircraft', 'aircraft services', 'airline', 'airplane', 'aviation', 'flight', 'flight academy', 'flight school', 'flying', 'maintenance', 'pilot', 'pilot training', 'plane', 'private jet charter'],
                ],
                't32-your-dream-of-flying' => [
                    'title' => esc_html__('Your Dream of Flying', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 32,
                    'category' => 'business',
                    'subcategory' => 'aircraft',
                    'tags' => ['air charter', 'aircraft', 'aircraft services', 'airline', 'airplane', 'aviation', 'flight', 'flight academy', 'flight school', 'flying', 'maintenance', 'pilot', 'pilot training', 'plane', 'private jet charter'],
                ],
                't32-reach-new-heights' => [
                    'title' => esc_html__('Reach New Heights', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 32,
                    'category' => 'business',
                    'subcategory' => 'aircraft',
                    'tags' => ['air charter', 'aircraft', 'aircraft services', 'airline', 'airplane', 'aviation', 'flight', 'flight academy', 'flight school', 'flying', 'maintenance', 'pilot', 'pilot training', 'plane', 'private jet charter'],
                ],
                't32-training-gallery' => [
                    'title' => esc_html__('Training Gallery', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 32,
                    'category' => 'business',
                    'subcategory' => 'aircraft',
                    'tags' => ['air charter', 'aircraft', 'aircraft services', 'airline', 'airplane', 'aviation', 'flight', 'flight academy', 'flight school', 'flying', 'maintenance', 'pilot', 'pilot training', 'plane', 'private jet charter'],
                ],
                't32-our-team' => [
                    'title' => esc_html__('Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 32,
                    'category' => 'business',
                    'subcategory' => 'aircraft',
                    'tags' => ['air charter', 'aircraft', 'aircraft services', 'airline', 'airplane', 'aviation', 'flight', 'flight academy', 'flight school', 'flying', 'maintenance', 'pilot', 'pilot training', 'plane', 'private jet charter'],
                ],
                't32-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 32,
                    'category' => 'business',
                    'subcategory' => 'aircraft',
                    'tags' => ['air charter', 'aircraft', 'aircraft services', 'airline', 'airplane', 'aviation', 'flight', 'flight academy', 'flight school', 'flying', 'maintenance', 'pilot', 'pilot training', 'plane', 'private jet charter'],
                ],
                't33-eye-care-center' => [
                    'title' => esc_html__('Eye Care Center', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 33,
                    'category' => 'health & beauty',
                    'subcategory' => 'health',
                    'tags' => ['eye care', 'eye glasses', 'eye surgery', 'glasses', 'glasses shop', 'ophthalmic', 'ophthalmology', 'optical', 'optician', 'optician shop', 'optics store', 'optometric', 'optometry', 'spectacles', 'vision care'],
                ],
                't33-eye-wear' => [
                    'title' => esc_html__('Eye Wear', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 33,
                    'category' => 'health & beauty',
                    'subcategory' => 'health',
                    'tags' => ['eye care', 'eye glasses', 'eye surgery', 'glasses', 'glasses shop', 'ophthalmic', 'ophthalmology', 'optical', 'optician', 'optician shop', 'optics store', 'optometric', 'optometry', 'spectacles', 'vision care'],
                ],
                't33-eye-care-clinic' => [
                    'title' => esc_html__('Eye Care Clinic', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 33,
                    'category' => 'health & beauty',
                    'subcategory' => 'health',
                    'tags' => ['eye care', 'eye glasses', 'eye surgery', 'glasses', 'glasses shop', 'ophthalmic', 'ophthalmology', 'optical', 'optician', 'optician shop', 'optics store', 'optometric', 'optometry', 'spectacles', 'vision care'],
                ],
                't33-eye-surgery' => [
                    'title' => esc_html__('Eye Surgery', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 33,
                    'category' => 'health & beauty',
                    'subcategory' => 'health',
                    'tags' => ['eye care', 'eye glasses', 'eye surgery', 'glasses', 'glasses shop', 'ophthalmic', 'ophthalmology', 'optical', 'optician', 'optician shop', 'optics store', 'optometric', 'optometry', 'spectacles', 'vision care'],
                ],
                't33-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 33,
                    'category' => 'health & beauty',
                    'subcategory' => 'health',
                    'tags' => ['eye care', 'eye glasses', 'eye surgery', 'glasses', 'glasses shop', 'ophthalmic', 'ophthalmology', 'optical', 'optician', 'optician shop', 'optics store', 'optometric', 'optometry', 'spectacles', 'vision care'],
                ],
                't33-prices' => [
                    'title' => esc_html__('Prices', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 33,
                    'category' => 'health & beauty',
                    'subcategory' => 'health',
                    'tags' => ['eye care', 'eye glasses', 'eye surgery', 'glasses', 'glasses shop', 'ophthalmic', 'ophthalmology', 'optical', 'optician', 'optician shop', 'optics store', 'optometric', 'optometry', 'spectacles', 'vision care'],
                ],
                't33-treatments' => [
                    'title' => esc_html__('Treatments', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 33,
                    'category' => 'health & beauty',
                    'subcategory' => 'health',
                    'tags' => ['eye care', 'eye glasses', 'eye surgery', 'glasses', 'glasses shop', 'ophthalmic', 'ophthalmology', 'optical', 'optician', 'optician shop', 'optics store', 'optometric', 'optometry', 'spectacles', 'vision care'],
                ],
                't33-our-team' => [
                    'title' => esc_html__('Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 33,
                    'category' => 'health & beauty',
                    'subcategory' => 'health',
                    'tags' => ['eye care', 'eye glasses', 'eye surgery', 'glasses', 'glasses shop', 'ophthalmic', 'ophthalmology', 'optical', 'optician', 'optician shop', 'optics store', 'optometric', 'optometry', 'spectacles', 'vision care'],
                ],
                't33-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 33,
                    'category' => 'health & beauty',
                    'subcategory' => 'health',
                    'tags' => ['eye care', 'eye glasses', 'eye surgery', 'glasses', 'glasses shop', 'ophthalmic', 'ophthalmology', 'optical', 'optician', 'optician shop', 'optics store', 'optometric', 'optometry', 'spectacles', 'vision care'],
                ],
                't34-fueling-your-future' => [
                    'title' => esc_html__('Fueling Your Future', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 34,
                    'category' => 'manufacturing',
                    'subcategory' => 'factory',
                    'tags' => ['chemical', 'coal', 'distribution', 'engineering', 'factories', 'gas station', 'machinery', 'oil and gas', 'organic', 'petrochemicals', 'petrol', 'petroleum', 'plastics materials', 'refineries', 'refining'],
                ],
                't34-oil-industry-company' => [
                    'title' => esc_html__('Oil Industry Company', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 34,
                    'category' => 'manufacturing',
                    'subcategory' => 'factory',
                    'tags' => ['chemical', 'coal', 'distribution', 'engineering', 'factories', 'gas station', 'machinery', 'oil and gas', 'organic', 'petrochemicals', 'petrol', 'petroleum', 'plastics materials', 'refineries', 'refining'],
                ],
                't34-oil-gas-company' => [
                    'title' => esc_html__('Oil & Gas Company', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 34,
                    'category' => 'manufacturing',
                    'subcategory' => 'factory',
                    'tags' => ['chemical', 'coal', 'distribution', 'engineering', 'factories', 'gas station', 'machinery', 'oil and gas', 'organic', 'petrochemicals', 'petrol', 'petroleum', 'plastics materials', 'refineries', 'refining'],
                ],
                't34-oil-gas-industry' => [
                    'title' => esc_html__('Oil & Gas Industry', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 34,
                    'category' => 'manufacturing',
                    'subcategory' => 'factory',
                    'tags' => ['chemical', 'coal', 'distribution', 'engineering', 'factories', 'gas station', 'machinery', 'oil and gas', 'organic', 'petrochemicals', 'petrol', 'petroleum', 'plastics materials', 'refineries', 'refining'],
                ],
                't34-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 34,
                    'category' => 'manufacturing',
                    'subcategory' => 'factory',
                    'tags' => ['chemical', 'coal', 'distribution', 'engineering', 'factories', 'gas station', 'machinery', 'oil and gas', 'organic', 'petrochemicals', 'petrol', 'petroleum', 'plastics materials', 'refineries', 'refining'],
                ],
                't34-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 34,
                    'category' => 'manufacturing',
                    'subcategory' => 'factory',
                    'tags' => ['chemical', 'coal', 'distribution', 'engineering', 'factories', 'gas station', 'machinery', 'oil and gas', 'organic', 'petrochemicals', 'petrol', 'petroleum', 'plastics materials', 'refineries', 'refining'],
                ],
                't34-look-at-our-production' => [
                    'title' => esc_html__('Look at Our Production', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 34,
                    'category' => 'manufacturing',
                    'subcategory' => 'factory',
                    'tags' => ['chemical', 'coal', 'distribution', 'engineering', 'factories', 'gas station', 'machinery', 'oil and gas', 'organic', 'petrochemicals', 'petrol', 'petroleum', 'plastics materials', 'refineries', 'refining'],
                ],
                't34-certificates' => [
                    'title' => esc_html__('Certificates', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 34,
                    'category' => 'manufacturing',
                    'subcategory' => 'factory',
                    'tags' => ['chemical', 'coal', 'distribution', 'engineering', 'factories', 'gas station', 'machinery', 'oil and gas', 'organic', 'petrochemicals', 'petrol', 'petroleum', 'plastics materials', 'refineries', 'refining'],
                ],
                't34-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 34,
                    'category' => 'manufacturing',
                    'subcategory' => 'factory',
                    'tags' => ['chemical', 'coal', 'distribution', 'engineering', 'factories', 'gas station', 'machinery', 'oil and gas', 'organic', 'petrochemicals', 'petrol', 'petroleum', 'plastics materials', 'refineries', 'refining'],
                ],
                't35-your-dream-destination' => [
                    'title' => esc_html__('Your Dream Destination', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 35,
                    'category' => 'legal',
                    'subcategory' => 'consulting',
                    'tags' => ['coaching', 'consulting', 'courses', 'green card', 'immigration', 'lawyer', 'overseas jobs', 'student visa', 'tourism', 'tourist visa', 'travel', 'travelling', 'visa', 'visa agent', 'visa service'],
                ],
                't35-simplify-your-journey' => [
                    'title' => esc_html__('Simplify Your Journey', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 35,
                    'category' => 'legal',
                    'subcategory' => 'consulting',
                    'tags' => ['coaching', 'consulting', 'courses', 'green card', 'immigration', 'lawyer', 'overseas jobs', 'student visa', 'tourism', 'tourist visa', 'travel', 'travelling', 'visa', 'visa agent', 'visa service'],
                ],
                't35-empowering-global-aspiration' => [
                    'title' => esc_html__('Empowering Global Aspiration', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 35,
                    'category' => 'legal',
                    'subcategory' => 'consulting',
                    'tags' => ['coaching', 'consulting', 'courses', 'green card', 'immigration', 'lawyer', 'overseas jobs', 'student visa', 'tourism', 'tourist visa', 'travel', 'travelling', 'visa', 'visa agent', 'visa service'],
                ],
                't35-breaking-barriers' => [
                    'title' => esc_html__('Breaking Barriers', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 35,
                    'category' => 'legal',
                    'subcategory' => 'consulting',
                    'tags' => ['coaching', 'consulting', 'courses', 'green card', 'immigration', 'lawyer', 'overseas jobs', 'student visa', 'tourism', 'tourist visa', 'travel', 'travelling', 'visa', 'visa agent', 'visa service'],
                ],
                't35-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 35,
                    'category' => 'legal',
                    'subcategory' => 'consulting',
                    'tags' => ['coaching', 'consulting', 'courses', 'green card', 'immigration', 'lawyer', 'overseas jobs', 'student visa', 'tourism', 'tourist visa', 'travel', 'travelling', 'visa', 'visa agent', 'visa service'],
                ],
                't35-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 35,
                    'category' => 'legal',
                    'subcategory' => 'consulting',
                    'tags' => ['coaching', 'consulting', 'courses', 'green card', 'immigration', 'lawyer', 'overseas jobs', 'student visa', 'tourism', 'tourist visa', 'travel', 'travelling', 'visa', 'visa agent', 'visa service'],
                ],
                't35-our-team' => [
                    'title' => esc_html__('Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 35,
                    'category' => 'legal',
                    'subcategory' => 'consulting',
                    'tags' => ['coaching', 'consulting', 'courses', 'green card', 'immigration', 'lawyer', 'overseas jobs', 'student visa', 'tourism', 'tourist visa', 'travel', 'travelling', 'visa', 'visa agent', 'visa service'],
                ],
                't35-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 35,
                    'category' => 'legal',
                    'subcategory' => 'consulting',
                    'tags' => ['coaching', 'consulting', 'courses', 'green card', 'immigration', 'lawyer', 'overseas jobs', 'student visa', 'tourism', 'tourist visa', 'travel', 'travelling', 'visa', 'visa agent', 'visa service'],
                ],
                't36-dermatology-and-cosmetology' => [
                    'title' => esc_html__('Dermatology and Cosmetology', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 36,
                    'category' => 'health & beauty',
                    'subcategory' => 'cosmetology',
                    'tags' => ['acne', 'botox', 'cosmetology', 'dermabrasion', 'dermal fillers', 'face lift', 'lip augmentation', 'non-surgery procedures', 'plastic surgeon', 'plastic surgery', 'scar removing', 'skin care services', 'skin tightening'],
                ],
                't36-cosmetology-clinic' => [
                    'title' => esc_html__('Cosmetology Clinic', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 36,
                    'category' => 'health & beauty',
                    'subcategory' => 'cosmetology',
                    'tags' => ['acne', 'botox', 'cosmetology', 'dermabrasion', 'dermal fillers', 'face lift', 'lip augmentation', 'non-surgery procedures', 'plastic surgeon', 'plastic surgery', 'scar removing', 'skin care services', 'skin tightening'],
                ],
                't36-cosmeceuticals-and-dermatology' => [
                    'title' => esc_html__('Cosmeceuticals and Dermatology', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 36,
                    'category' => 'health & beauty',
                    'subcategory' => 'cosmetology',
                    'tags' => ['acne', 'botox', 'cosmetology', 'dermabrasion', 'dermal fillers', 'face lift', 'lip augmentation', 'non-surgery procedures', 'plastic surgeon', 'plastic surgery', 'scar removing', 'skin care services', 'skin tightening'],
                ],
                't36-botox-and-skincare' => [
                    'title' => esc_html__('Botox and Skincare', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 36,
                    'category' => 'health & beauty',
                    'subcategory' => 'cosmetology',
                    'tags' => ['acne', 'botox', 'cosmetology', 'dermabrasion', 'dermal fillers', 'face lift', 'lip augmentation', 'non-surgery procedures', 'plastic surgeon', 'plastic surgery', 'scar removing', 'skin care services', 'skin tightening'],
                ],
                't36-about-our-clinic' => [
                    'title' => esc_html__('About Our Clinic', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 36,
                    'category' => 'health & beauty',
                    'subcategory' => 'cosmetology',
                    'tags' => ['acne', 'botox', 'cosmetology', 'dermabrasion', 'dermal fillers', 'face lift', 'lip augmentation', 'non-surgery procedures', 'plastic surgeon', 'plastic surgery', 'scar removing', 'skin care services', 'skin tightening'],
                ],
                't36-treatments' => [
                    'title' => esc_html__('Treatments', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 36,
                    'category' => 'health & beauty',
                    'subcategory' => 'cosmetology',
                    'tags' => ['acne', 'botox', 'cosmetology', 'dermabrasion', 'dermal fillers', 'face lift', 'lip augmentation', 'non-surgery procedures', 'plastic surgeon', 'plastic surgery', 'scar removing', 'skin care services', 'skin tightening'],
                ],
                't36-prices' => [
                    'title' => esc_html__('Prices', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 36,
                    'category' => 'health & beauty',
                    'subcategory' => 'cosmetology',
                    'tags' => ['acne', 'botox', 'cosmetology', 'dermabrasion', 'dermal fillers', 'face lift', 'lip augmentation', 'non-surgery procedures', 'plastic surgeon', 'plastic surgery', 'scar removing', 'skin care services', 'skin tightening'],
                ],
                't36-gallery' => [
                    'title' => esc_html__('Gallery', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 36,
                    'category' => 'health & beauty',
                    'subcategory' => 'cosmetology',
                    'tags' => ['acne', 'botox', 'cosmetology', 'dermabrasion', 'dermal fillers', 'face lift', 'lip augmentation', 'non-surgery procedures', 'plastic surgeon', 'plastic surgery', 'scar removing', 'skin care services', 'skin tightening'],
                ],
                't36-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 36,
                    'category' => 'health & beauty',
                    'subcategory' => 'cosmetology',
                    'tags' => ['acne', 'botox', 'cosmetology', 'dermabrasion', 'dermal fillers', 'face lift', 'lip augmentation', 'non-surgery procedures', 'plastic surgeon', 'plastic surgery', 'scar removing', 'skin care services', 'skin tightening'],
                ],
                't37-meat-the-difference' => [
                    'title' => esc_html__('Meat the Difference', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 37,
                    'category' => 'food',
                    'subcategory' => 'restaurant',
                    'tags' => ['beef', 'butcher', 'butcher shop', 'butchery', 'food delivery', 'food store', 'meat', 'meat food', 'meat market', 'meat restaurant', 'meat shop', 'steak', 'steak house', 'steak restaurant', 'steakhouse'],
                ],
                't37-meat-for-every-appetite' => [
                    'title' => esc_html__('Meat for Every Appetite', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 37,
                    'category' => 'food',
                    'subcategory' => 'restaurant',
                    'tags' => ['beef', 'butcher', 'butcher shop', 'butchery', 'food delivery', 'food store', 'meat', 'meat food', 'meat market', 'meat restaurant', 'meat shop', 'steak', 'steak house', 'steak restaurant', 'steakhouse'],
                ],
                't37-butchered-with-care' => [
                    'title' => esc_html__('Butchered with Care', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 37,
                    'category' => 'food',
                    'subcategory' => 'restaurant',
                    'tags' => ['beef', 'butcher', 'butcher shop', 'butchery', 'food delivery', 'food store', 'meat', 'meat food', 'meat market', 'meat restaurant', 'meat shop', 'steak', 'steak house', 'steak restaurant', 'steakhouse'],
                ],
                't37-meat-is-our-passion' => [
                    'title' => esc_html__('Meat is Our Passion', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 37,
                    'category' => 'food',
                    'subcategory' => 'restaurant',
                    'tags' => ['beef', 'butcher', 'butcher shop', 'butchery', 'food delivery', 'food store', 'meat', 'meat food', 'meat market', 'meat restaurant', 'meat shop', 'steak', 'steak house', 'steak restaurant', 'steakhouse'],
                ],
                't37-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 37,
                    'category' => 'food',
                    'subcategory' => 'restaurant',
                    'tags' => ['beef', 'butcher', 'butcher shop', 'butchery', 'food delivery', 'food store', 'meat', 'meat food', 'meat market', 'meat restaurant', 'meat shop', 'steak', 'steak house', 'steak restaurant', 'steakhouse'],
                ],
                't37-our-cuts' => [
                    'title' => esc_html__('Our Cuts', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 37,
                    'category' => 'food',
                    'subcategory' => 'restaurant',
                    'tags' => ['beef', 'butcher', 'butcher shop', 'butchery', 'food delivery', 'food store', 'meat', 'meat food', 'meat market', 'meat restaurant', 'meat shop', 'steak', 'steak house', 'steak restaurant', 'steakhouse'],
                ],
                't37-butchery-services' => [
                    'title' => esc_html__('Butchery Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 37,
                    'category' => 'food',
                    'subcategory' => 'restaurant',
                    'tags' => ['beef', 'butcher', 'butcher shop', 'butchery', 'food delivery', 'food store', 'meat', 'meat food', 'meat market', 'meat restaurant', 'meat shop', 'steak', 'steak house', 'steak restaurant', 'steakhouse'],
                ],
                't37-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 37,
                    'category' => 'food',
                    'subcategory' => 'restaurant',
                    'tags' => ['beef', 'butcher', 'butcher shop', 'butchery', 'food delivery', 'food store', 'meat', 'meat food', 'meat market', 'meat restaurant', 'meat shop', 'steak', 'steak house', 'steak restaurant', 'steakhouse'],
                ],
                't38-your-favourite-flooring' => [
                    'title' => esc_html__('Your Favourite Flooring', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 38,
                    'category' => 'business',
                    'subcategory' => 'decoration',
                    'tags' => ['carpets', 'doors', 'floor', 'flooring', 'interior and exterior', 'laminate', 'painting & decoration', 'parquet', 'paving', 'renovation solutions', 'solid oak', 'supply', 'tiling services', 'wood', 'wood working'],
                ],
                't38-trusted-flooring-company' => [
                    'title' => esc_html__('Trusted Flooring Company', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 38,
                    'category' => 'business',
                    'subcategory' => 'decoration',
                    'tags' => ['carpets', 'doors', 'floor', 'flooring', 'interior and exterior', 'laminate', 'painting & decoration', 'parquet', 'paving', 'renovation solutions', 'solid oak', 'supply', 'tiling services', 'wood', 'wood working'],
                ],
                't38-reliable-flooring-services' => [
                    'title' => esc_html__('Reliable Flooring Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 38,
                    'category' => 'business',
                    'subcategory' => 'decoration',
                    'tags' => ['carpets', 'doors', 'floor', 'flooring', 'interior and exterior', 'laminate', 'painting & decoration', 'parquet', 'paving', 'renovation solutions', 'solid oak', 'supply', 'tiling services', 'wood', 'wood working'],
                ],
                't38-high-quality-flooring' => [
                    'title' => esc_html__('High Quality Flooring', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 38,
                    'category' => 'business',
                    'subcategory' => 'decoration',
                    'tags' => ['carpets', 'doors', 'floor', 'flooring', 'interior and exterior', 'laminate', 'painting & decoration', 'parquet', 'paving', 'renovation solutions', 'solid oak', 'supply', 'tiling services', 'wood', 'wood working'],
                ],
                't38-services' => [
                    'title' => esc_html__('Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 38,
                    'category' => 'business',
                    'subcategory' => 'decoration',
                    'tags' => ['carpets', 'doors', 'floor', 'flooring', 'interior and exterior', 'laminate', 'painting & decoration', 'parquet', 'paving', 'renovation solutions', 'solid oak', 'supply', 'tiling services', 'wood', 'wood working'],
                ],
                't38-gallery' => [
                    'title' => esc_html__('Gallery', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 38,
                    'category' => 'business',
                    'subcategory' => 'decoration',
                    'tags' => ['carpets', 'doors', 'floor', 'flooring', 'interior and exterior', 'laminate', 'painting & decoration', 'parquet', 'paving', 'renovation solutions', 'solid oak', 'supply', 'tiling services', 'wood', 'wood working'],
                ],
                't38-testimonials' => [
                    'title' => esc_html__('Testimonials', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 38,
                    'category' => 'business',
                    'subcategory' => 'decoration',
                    'tags' => ['carpets', 'doors', 'floor', 'flooring', 'interior and exterior', 'laminate', 'painting & decoration', 'parquet', 'paving', 'renovation solutions', 'solid oak', 'supply', 'tiling services', 'wood', 'wood working'],
                ],
                't38-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 38,
                    'category' => 'business',
                    'subcategory' => 'decoration',
                    'tags' => ['carpets', 'doors', 'floor', 'flooring', 'interior and exterior', 'laminate', 'painting & decoration', 'parquet', 'paving', 'renovation solutions', 'solid oak', 'supply', 'tiling services', 'wood', 'wood working'],
                ],
                't39-medical-diagnostic-center' => [
                    'title' => esc_html__('Medical Diagnostic Center', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 39,
                    'category' => 'health & beauty',
                    'subcategory' => 'health',
                    'tags' => ['clinic', 'diagnostic center', 'diagnostics', 'doctor', 'health center', 'healthcare', 'hospital', 'massage', 'medical blog', 'medical theme', 'medicine', 'pharmacy', 'plastic surgery', 'surgeon', 'surgery'],
                ],
                't39-plastic-surgery-clinic' => [
                    'title' => esc_html__('Plastic Surgery Clinic', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 39,
                    'category' => 'health & beauty',
                    'subcategory' => 'health',
                    'tags' => ['clinic', 'diagnostic center', 'diagnostics', 'doctor', 'health center', 'healthcare', 'hospital', 'massage', 'medical blog', 'medical theme', 'medicine', 'pharmacy', 'plastic surgery', 'surgeon', 'surgery'],
                ],
                't39-expert-diagnostic-services' => [
                    'title' => esc_html__('Expert Diagnostic Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 39,
                    'category' => 'health & beauty',
                    'subcategory' => 'health',
                    'tags' => ['clinic', 'diagnostic center', 'diagnostics', 'doctor', 'health center', 'healthcare', 'hospital', 'massage', 'medical blog', 'medical theme', 'medicine', 'pharmacy', 'plastic surgery', 'surgeon', 'surgery'],
                ],
                't39-transform-your-appearance' => [
                    'title' => esc_html__('Transform Your Appearance', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 39,
                    'category' => 'health & beauty',
                    'subcategory' => 'health',
                    'tags' => ['clinic', 'diagnostic center', 'diagnostics', 'doctor', 'health center', 'healthcare', 'hospital', 'massage', 'medical blog', 'medical theme', 'medicine', 'pharmacy', 'plastic surgery', 'surgeon', 'surgery'],
                ],
                't39-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 39,
                    'category' => 'health & beauty',
                    'subcategory' => 'health',
                    'tags' => ['clinic', 'diagnostic center', 'diagnostics', 'doctor', 'health center', 'healthcare', 'hospital', 'massage', 'medical blog', 'medical theme', 'medicine', 'pharmacy', 'plastic surgery', 'surgeon', 'surgery'],
                ],
                't39-treatments' => [
                    'title' => esc_html__('Treatments', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 39,
                    'category' => 'health & beauty',
                    'subcategory' => 'health',
                    'tags' => ['clinic', 'diagnostic center', 'diagnostics', 'doctor', 'health center', 'healthcare', 'hospital', 'massage', 'medical blog', 'medical theme', 'medicine', 'pharmacy', 'plastic surgery', 'surgeon', 'surgery'],
                ],
                't39-our-gallery' => [
                    'title' => esc_html__('Before and After', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 39,
                    'category' => 'health & beauty',
                    'subcategory' => 'health',
                    'tags' => ['clinic', 'diagnostic center', 'diagnostics', 'doctor', 'health center', 'healthcare', 'hospital', 'massage', 'medical blog', 'medical theme', 'medicine', 'pharmacy', 'plastic surgery', 'surgeon', 'surgery'],
                ],
                't39-our-team' => [
                    'title' => esc_html__('Our Doctors', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 39,
                    'category' => 'health & beauty',
                    'subcategory' => 'health',
                    'tags' => ['clinic', 'diagnostic center', 'diagnostics', 'doctor', 'health center', 'healthcare', 'hospital', 'massage', 'medical blog', 'medical theme', 'medicine', 'pharmacy', 'plastic surgery', 'surgeon', 'surgery'],
                ],
                't39-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 39,
                    'category' => 'health & beauty',
                    'subcategory' => 'health',
                    'tags' => ['clinic', 'diagnostic center', 'diagnostics', 'doctor', 'health center', 'healthcare', 'hospital', 'massage', 'medical blog', 'medical theme', 'medicine', 'pharmacy', 'plastic surgery', 'surgeon', 'surgery'],
                ],
                't40-freedom-of-the-seas' => [
                    'title' => esc_html__('Freedom of the Seas', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 40,
                    'category' => 'travel',
                    'subcategory' => 'luxury',
                    'tags' => ['boat', 'boat hire', 'boating', 'charter', 'cruise travel', 'marine', 'rental', 'sailing', 'sailor', 'yacht', 'yacht charter', 'yacht club', 'yachting', 'yachting sports'],
                ],
                't40-where-luxury-meets-adventure' => [
                    'title' => esc_html__('Where Luxury Meets Adventure', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 40,
                    'category' => 'travel',
                    'subcategory' => 'luxury',
                    'tags' => ['boat', 'boat hire', 'boating', 'charter', 'cruise travel', 'marine', 'rental', 'sailing', 'sailor', 'yacht', 'yacht charter', 'yacht club', 'yachting', 'yachting sports'],
                ],
                't40-your-voyage' => [
                    'title' => esc_html__('Your Voyage', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 40,
                    'category' => 'travel',
                    'subcategory' => 'luxury',
                    'tags' => ['boat', 'boat hire', 'boating', 'charter', 'cruise travel', 'marine', 'rental', 'sailing', 'sailor', 'yacht', 'yacht charter', 'yacht club', 'yachting', 'yachting sports'],
                ],

                't40-cruise-in-comfort' => [
                    'title' => esc_html__('Cruise in Comfort', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 40,
                    'category' => 'travel',
                    'subcategory' => 'luxury',
                    'tags' => ['boat', 'boat hire', 'boating', 'charter', 'cruise travel', 'marine', 'rental', 'sailing', 'sailor', 'yacht', 'yacht charter', 'yacht club', 'yachting', 'yachting sports'],
                ],
                't40-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 40,
                    'category' => 'travel',
                    'subcategory' => 'luxury',
                    'tags' => ['boat', 'boat hire', 'boating', 'charter', 'cruise travel', 'marine', 'rental', 'sailing', 'sailor', 'yacht', 'yacht charter', 'yacht club', 'yachting', 'yachting sports'],
                ],
                't40-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 40,
                    'category' => 'travel',
                    'subcategory' => 'luxury',
                    'tags' => ['boat', 'boat hire', 'boating', 'charter', 'cruise travel', 'marine', 'rental', 'sailing', 'sailor', 'yacht', 'yacht charter', 'yacht club', 'yachting', 'yachting sports'],
                ],
                't40-our-team' => [
                    'title' => esc_html__('Our Crew', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 40,
                    'category' => 'travel',
                    'subcategory' => 'luxury',
                    'tags' => ['boat', 'boat hire', 'boating', 'charter', 'cruise travel', 'marine', 'rental', 'sailing', 'sailor', 'yacht', 'yacht charter', 'yacht club', 'yachting', 'yachting sports'],
                ],
                't40-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 40,
                    'category' => 'travel',
                    'subcategory' => 'luxury',
                    'tags' => ['boat', 'boat hire', 'boating', 'charter', 'cruise travel', 'marine', 'rental', 'sailing', 'sailor', 'yacht', 'yacht charter', 'yacht club', 'yachting', 'yachting sports'],
                ],
                't41-crafted-with-love' => [
                    'title' => esc_html__('Crafted with Love', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 41,
                    'category' => 'retail',
                    'subcategory' => 'handmade',
                    'tags' => ['bath bomb', 'candle', 'candle shop', 'candle store', 'candle theme', 'ecommerce', 'handicraft', 'handmade', 'organic cosmetics', 'organic store', 'perfume', 'retail', 'soap'],
                ],
                't41-pure-bliss' => [
                    'title' => esc_html__('Pure Bliss', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 41,
                    'category' => 'retail',
                    'subcategory' => 'handmade',
                    'tags' => ['bath bomb', 'candle', 'candle shop', 'candle store', 'candle theme', 'ecommerce', 'handicraft', 'handmade', 'organic cosmetics', 'organic store', 'perfume', 'retail', 'soap'],
                ],
                't41-moments-of-serenity' => [
                    'title' => esc_html__('Moments of Serenity', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 41,
                    'category' => 'retail',
                    'subcategory' => 'handmade',
                    'tags' => ['bath bomb', 'candle', 'candle shop', 'candle store', 'candle theme', 'ecommerce', 'handicraft', 'handmade', 'organic cosmetics', 'organic store', 'perfume', 'retail', 'soap'],
                ],
                't41-handmade-with-passion' => [
                    'title' => esc_html__('Handmade with Passion', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 41,
                    'category' => 'retail',
                    'subcategory' => 'handmade',
                    'tags' => ['bath bomb', 'candle', 'candle shop', 'candle store', 'candle theme', 'ecommerce', 'handicraft', 'handmade', 'organic cosmetics', 'organic store', 'perfume', 'retail', 'soap'],
                ],
                't41-about-our-store' => [
                    'title' => esc_html__('About Our Store', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 41,
                    'category' => 'retail',
                    'subcategory' => 'handmade',
                    'tags' => ['bath bomb', 'candle', 'candle shop', 'candle store', 'candle theme', 'ecommerce', 'handicraft', 'handmade', 'organic cosmetics', 'organic store', 'perfume', 'retail', 'soap'],
                ],
                't41-gallery' => [
                    'title' => esc_html__('Gallery', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 41,
                    'category' => 'retail',
                    'subcategory' => 'handmade',
                    'tags' => ['bath bomb', 'candle', 'candle shop', 'candle store', 'candle theme', 'ecommerce', 'handicraft', 'handmade', 'organic cosmetics', 'organic store', 'perfume', 'retail', 'soap'],
                ],
                't41-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 41,
                    'category' => 'retail',
                    'subcategory' => 'handmade',
                    'tags' => ['bath bomb', 'candle', 'candle shop', 'candle store', 'candle theme', 'ecommerce', 'handicraft', 'handmade', 'organic cosmetics', 'organic store', 'perfume', 'retail', 'soap'],
                ],
                't42-hvac-installations' => [
                    'title' => esc_html__('HVAC Installations', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 42,
                    'category' => 'business',
                    'subcategory' => 'service',
                    'tags' => ['AC Service', 'air conditioner', 'air conditioning', 'air cooling', 'conditioner repair', 'cooling', 'electric boiler', 'fireplace', 'heat pump', 'heating', 'heating company', 'HVAC', 'smart home', 'underfloor heating', 'ventilation'],
                ],
                't42-reliable-climate-control' => [
                    'title' => esc_html__('Reliable Climate Control', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 42,
                    'category' => 'business',
                    'subcategory' => 'service',
                    'tags' => ['AC Service', 'air conditioner', 'air conditioning', 'air cooling', 'conditioner repair', 'cooling', 'electric boiler', 'fireplace', 'heat pump', 'heating', 'heating company', 'HVAC', 'smart home', 'underfloor heating', 'ventilation'],
                ],
                't42-comfort-every-season' => [
                    'title' => esc_html__('Comfort Every Season', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 42,
                    'category' => 'business',
                    'subcategory' => 'service',
                    'tags' => ['AC Service', 'air conditioner', 'air conditioning', 'air cooling', 'conditioner repair', 'cooling', 'electric boiler', 'fireplace', 'heat pump', 'heating', 'heating company', 'HVAC', 'smart home', 'underfloor heating', 'ventilation'],
                ],
                't42-the-perfect-climate' => [
                    'title' => esc_html__('The Perfect Climate', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 42,
                    'category' => 'business',
                    'subcategory' => 'service',
                    'tags' => ['AC Service', 'air conditioner', 'air conditioning', 'air cooling', 'conditioner repair', 'cooling', 'electric boiler', 'fireplace', 'heat pump', 'heating', 'heating company', 'HVAC', 'smart home', 'underfloor heating', 'ventilation'],
                ],
                't42-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 42,
                    'category' => 'business',
                    'subcategory' => 'service',
                    'tags' => ['AC Service', 'air conditioner', 'air conditioning', 'air cooling', 'conditioner repair', 'cooling', 'electric boiler', 'fireplace', 'heat pump', 'heating', 'heating company', 'HVAC', 'smart home', 'underfloor heating', 'ventilation'],
                ],
                't42-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 42,
                    'category' => 'business',
                    'subcategory' => 'service',
                    'tags' => ['AC Service', 'air conditioner', 'air conditioning', 'air cooling', 'conditioner repair', 'cooling', 'electric boiler', 'fireplace', 'heat pump', 'heating', 'heating company', 'HVAC', 'smart home', 'underfloor heating', 'ventilation'],
                ],
                't42-look-at-our-work' => [
                    'title' => esc_html__('Look at Our Work', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 42,
                    'category' => 'business',
                    'subcategory' => 'service',
                    'tags' => ['AC Service', 'air conditioner', 'air conditioning', 'air cooling', 'conditioner repair', 'cooling', 'electric boiler', 'fireplace', 'heat pump', 'heating', 'heating company', 'HVAC', 'smart home', 'underfloor heating', 'ventilation'],
                ],
                't42-certificates' => [
                    'title' => esc_html__('Certificates', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 42,
                    'category' => 'business',
                    'subcategory' => 'service',
                    'tags' => ['AC Service', 'air conditioner', 'air conditioning', 'air cooling', 'conditioner repair', 'cooling', 'electric boiler', 'fireplace', 'heat pump', 'heating', 'heating company', 'HVAC', 'smart home', 'underfloor heating', 'ventilation'],
                ],
                't42-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 42,
                    'category' => 'business',
                    'subcategory' => 'service',
                    'tags' => ['AC Service', 'air conditioner', 'air conditioning', 'air cooling', 'conditioner repair', 'cooling', 'electric boiler', 'fireplace', 'heat pump', 'heating', 'heating company', 'HVAC', 'smart home', 'underfloor heating', 'ventilation'],
                ],
                't43-high-quality-dentistry' => [
                    'title' => esc_html__('High Quality Dentistry', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 43,
                    'category' => 'health & beauty',
                    'subcategory' => 'dental',
                    'tags' => ['cosmetic dentistry', 'dental', 'dental clinic', 'dental practice', 'dental tourism', 'dentist', 'dentistry', 'doctor', 'doctor appointment', 'health', 'healthcare', 'medical', 'medical tourism', 'orthodontics', 'stomatology'],
                ],
                't43-trusted-dental-clinic' => [
                    'title' => esc_html__('Trusted Dental Clinic', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 43,
                    'category' => 'health & beauty',
                    'subcategory' => 'dental',
                    'tags' => ['cosmetic dentistry', 'dental', 'dental clinic', 'dental practice', 'dental tourism', 'dentist', 'dentistry', 'doctor', 'doctor appointment', 'health', 'healthcare', 'medical', 'medical tourism', 'orthodontics', 'stomatology'],
                ],
                't43-your-perfect-smile' => [
                    'title' => esc_html__('Your Perfect Smile', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 43,
                    'category' => 'health & beauty',
                    'subcategory' => 'dental',
                    'tags' => ['cosmetic dentistry', 'dental', 'dental clinic', 'dental practice', 'dental tourism', 'dentist', 'dentistry', 'doctor', 'doctor appointment', 'health', 'healthcare', 'medical', 'medical tourism', 'orthodontics', 'stomatology'],
                ],
                't43-dental-care' => [
                    'title' => esc_html__('Dental Care', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 43,
                    'category' => 'health & beauty',
                    'subcategory' => 'dental',
                    'tags' => ['cosmetic dentistry', 'dental', 'dental clinic', 'dental practice', 'dental tourism', 'dentist', 'dentistry', 'doctor', 'doctor appointment', 'health', 'healthcare', 'medical', 'medical tourism', 'orthodontics', 'stomatology'],
                ],
                't43-about-us' => [
                    'title' => esc_html__('About Dental Center', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 43,
                    'category' => 'health & beauty',
                    'subcategory' => 'dental',
                    'tags' => ['cosmetic dentistry', 'dental', 'dental clinic', 'dental practice', 'dental tourism', 'dentist', 'dentistry', 'doctor', 'doctor appointment', 'health', 'healthcare', 'medical', 'medical tourism', 'orthodontics', 'stomatology'],
                ],
                't43-treatments' => [
                    'title' => esc_html__('Treatments', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 43,
                    'category' => 'health & beauty',
                    'subcategory' => 'dental',
                    'tags' => ['cosmetic dentistry', 'dental', 'dental clinic', 'dental practice', 'dental tourism', 'dentist', 'dentistry', 'doctor', 'doctor appointment', 'health', 'healthcare', 'medical', 'medical tourism', 'orthodontics', 'stomatology'],
                ],
                't43-fees' => [
                    'title' => esc_html__('Fees', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 43,
                    'category' => 'health & beauty',
                    'subcategory' => 'dental',
                    'tags' => ['cosmetic dentistry', 'dental', 'dental clinic', 'dental practice', 'dental tourism', 'dentist', 'dentistry', 'doctor', 'doctor appointment', 'health', 'healthcare', 'medical', 'medical tourism', 'orthodontics', 'stomatology'],
                ],
                't43-our-team' => [
                    'title' => esc_html__('Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 43,
                    'category' => 'health & beauty',
                    'subcategory' => 'dental',
                    'tags' => ['cosmetic dentistry', 'dental', 'dental clinic', 'dental practice', 'dental tourism', 'dentist', 'dentistry', 'doctor', 'doctor appointment', 'health', 'healthcare', 'medical', 'medical tourism', 'orthodontics', 'stomatology'],
                ],
                't43-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 43,
                    'category' => 'health & beauty',
                    'subcategory' => 'dental',
                    'tags' => ['cosmetic dentistry', 'dental', 'dental clinic', 'dental practice', 'dental tourism', 'dentist', 'dentistry', 'doctor', 'doctor appointment', 'health', 'healthcare', 'medical', 'medical tourism', 'orthodontics', 'stomatology'],
                ],
                't44-passenger-transfer-service' => [
                    'title' => esc_html__('Passenger Transfer Service', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 44,
                    'category' => 'travel',
                    'subcategory' => 'luxury',
                    'tags' => ['airport transfer', 'business transfer', 'car dealer', 'car hire', 'car rental', 'chauffeur', 'driver', 'events', 'limo driver', 'limousine', 'limousine booking', 'luxury car', 'party', 'taxi', 'wedding limousine'],
                ],
                't44-chauffeur-service' => [
                    'title' => esc_html__('Chauffeur Service', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 44,
                    'category' => 'travel',
                    'subcategory' => 'luxury',
                    'tags' => ['airport transfer', 'business transfer', 'car dealer', 'car hire', 'car rental', 'chauffeur', 'driver', 'events', 'limo driver', 'limousine', 'limousine booking', 'luxury car', 'party', 'taxi', 'wedding limousine'],
                ],
                't44-car-rental' => [
                    'title' => esc_html__('Car Rental', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 44,
                    'category' => 'travel',
                    'subcategory' => 'luxury',
                    'tags' => ['airport transfer', 'business transfer', 'car dealer', 'car hire', 'car rental', 'chauffeur', 'driver', 'events', 'limo driver', 'limousine', 'limousine booking', 'luxury car', 'party', 'taxi', 'wedding limousine'],
                ],
                't44-limousine-rental' => [
                    'title' => esc_html__('Limousine Rental', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 44,
                    'category' => 'travel',
                    'subcategory' => 'luxury',
                    'tags' => ['airport transfer', 'business transfer', 'car dealer', 'car hire', 'car rental', 'chauffeur', 'driver', 'events', 'limo driver', 'limousine', 'limousine booking', 'luxury car', 'party', 'taxi', 'wedding limousine'],
                ],
                't44-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 44,
                    'category' => 'travel',
                    'subcategory' => 'luxury',
                    'tags' => ['airport transfer', 'business transfer', 'car dealer', 'car hire', 'car rental', 'chauffeur', 'driver', 'events', 'limo driver', 'limousine', 'limousine booking', 'luxury car', 'party', 'taxi', 'wedding limousine'],
                ],
                't44-our-team' => [
                    'title' => esc_html__('Chauffeurs', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 44,
                    'category' => 'travel',
                    'subcategory' => 'luxury',
                    'tags' => ['airport transfer', 'business transfer', 'car dealer', 'car hire', 'car rental', 'chauffeur', 'driver', 'events', 'limo driver', 'limousine', 'limousine booking', 'luxury car', 'party', 'taxi', 'wedding limousine'],
                ],
                't44-services' => [
                    'title' => esc_html__('Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 44,
                    'category' => 'travel',
                    'subcategory' => 'luxury',
                    'tags' => ['airport transfer', 'business transfer', 'car dealer', 'car hire', 'car rental', 'chauffeur', 'driver', 'events', 'limo driver', 'limousine', 'limousine booking', 'luxury car', 'party', 'taxi', 'wedding limousine'],
                ],
                't44-careers' => [
                    'title' => esc_html__('Careers', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 44,
                    'category' => 'travel',
                    'subcategory' => 'luxury',
                    'tags' => ['airport transfer', 'business transfer', 'car dealer', 'car hire', 'car rental', 'chauffeur', 'driver', 'events', 'limo driver', 'limousine', 'limousine booking', 'luxury car', 'party', 'taxi', 'wedding limousine'],
                ],
                't44-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 44,
                    'category' => 'travel',
                    'subcategory' => 'luxury',
                    'tags' => ['airport transfer', 'business transfer', 'car dealer', 'car hire', 'car rental', 'chauffeur', 'driver', 'events', 'limo driver', 'limousine', 'limousine booking', 'luxury car', 'party', 'taxi', 'wedding limousine'],
                ],
                't45-towing-services' => [
                    'title' => esc_html__('Towing Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 45,
                    'category' => 'business',
                    'subcategory' => 'services',
                    'tags' => ['breakage', 'car assistance', 'car repair', 'car service', 'car towing', 'emergency service', 'mechanics', 'repair', 'road assistance', 'roadside assistance', 'routine maintenance', 'tire change', 'towing', 'towing service', 'truck towing'],
                ],
                't45-car-towing-and-recovery' => [
                    'title' => esc_html__('Car Towing and Recovery', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 45,
                    'category' => 'business',
                    'subcategory' => 'services',
                    'tags' => ['breakage', 'car assistance', 'car repair', 'car service', 'car towing', 'emergency service', 'mechanics', 'repair', 'road assistance', 'roadside assistance', 'routine maintenance', 'tire change', 'towing', 'towing service', 'truck towing'],
                ],
                't45-emergency-road-service' => [
                    'title' => esc_html__('Emergency Road Service', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 45,
                    'category' => 'business',
                    'subcategory' => 'services',
                    'tags' => ['breakage', 'car assistance', 'car repair', 'car service', 'car towing', 'emergency service', 'mechanics', 'repair', 'road assistance', 'roadside assistance', 'routine maintenance', 'tire change', 'towing', 'towing service', 'truck towing'],
                ],
                't45-roadside-assistance' => [
                    'title' => esc_html__('Roadside Assistance', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 45,
                    'category' => 'business',
                    'subcategory' => 'services',
                    'tags' => ['breakage', 'car assistance', 'car repair', 'car service', 'car towing', 'emergency service', 'mechanics', 'repair', 'road assistance', 'roadside assistance', 'routine maintenance', 'tire change', 'towing', 'towing service', 'truck towing'],
                ],
                't45-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 45,
                    'category' => 'business',
                    'subcategory' => 'services',
                    'tags' => ['breakage', 'car assistance', 'car repair', 'car service', 'car towing', 'emergency service', 'mechanics', 'repair', 'road assistance', 'roadside assistance', 'routine maintenance', 'tire change', 'towing', 'towing service', 'truck towing'],
                ],
                't45-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 45,
                    'category' => 'business',
                    'subcategory' => 'services',
                    'tags' => ['breakage', 'car assistance', 'car repair', 'car service', 'car towing', 'emergency service', 'mechanics', 'repair', 'road assistance', 'roadside assistance', 'routine maintenance', 'tire change', 'towing', 'towing service', 'truck towing'],
                ],
                't45-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 45,
                    'category' => 'business',
                    'subcategory' => 'services',
                    'tags' => ['breakage', 'car assistance', 'car repair', 'car service', 'car towing', 'emergency service', 'mechanics', 'repair', 'road assistance', 'roadside assistance', 'routine maintenance', 'tire change', 'towing', 'towing service', 'truck towing'],
                ],
                't46-premium-nail-salon' => [
                    'title' => esc_html__('Premium Nail Salon', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 46,
                    'category' => 'health & beauty',
                    'subcategory' => 'beauty',
                    'tags' => ['beauty', 'beauty blog', 'beauty salon', 'beauty store', 'cosmetics', 'manicure', 'nail art', 'nail bar', 'nail design', 'nail polish shop', 'nail salon', 'nail shop', 'pedicure', 'wellness'],
                ],
                't46-coolest-nail-bar' => [
                    'title' => esc_html__('Coolest Nail Bar', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 46,
                    'category' => 'health & beauty',
                    'subcategory' => 'beauty',
                    'tags' => ['beauty', 'beauty blog', 'beauty salon', 'beauty store', 'cosmetics', 'manicure', 'nail art', 'nail bar', 'nail design', 'nail polish shop', 'nail salon', 'nail shop', 'pedicure', 'wellness'],
                ],
                't46-perfect-nails' => [
                    'title' => esc_html__('Perfect Nails', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 46,
                    'category' => 'health & beauty',
                    'subcategory' => 'beauty',
                    'tags' => ['beauty', 'beauty blog', 'beauty salon', 'beauty store', 'cosmetics', 'manicure', 'nail art', 'nail bar', 'nail design', 'nail polish shop', 'nail salon', 'nail shop', 'pedicure', 'wellness'],
                ],
                't46-professional-nail-care' => [
                    'title' => esc_html__('Professional Nail Care', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 46,
                    'category' => 'health & beauty',
                    'subcategory' => 'beauty',
                    'tags' => ['beauty', 'beauty blog', 'beauty salon', 'beauty store', 'cosmetics', 'manicure', 'nail art', 'nail bar', 'nail design', 'nail polish shop', 'nail salon', 'nail shop', 'pedicure', 'wellness'],
                ],
                't46-about-salon' => [
                    'title' => esc_html__('About Salon', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 46,
                    'category' => 'health & beauty',
                    'subcategory' => 'beauty',
                    'tags' => ['beauty', 'beauty blog', 'beauty salon', 'beauty store', 'cosmetics', 'manicure', 'nail art', 'nail bar', 'nail design', 'nail polish shop', 'nail salon', 'nail shop', 'pedicure', 'wellness'],
                ],
                't46-gallery' => [
                    'title' => esc_html__('Gallery', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 46,
                    'category' => 'health & beauty',
                    'subcategory' => 'beauty',
                    'tags' => ['beauty', 'beauty blog', 'beauty salon', 'beauty store', 'cosmetics', 'manicure', 'nail art', 'nail bar', 'nail design', 'nail polish shop', 'nail salon', 'nail shop', 'pedicure', 'wellness'],
                ],
                't46-treatments' => [
                    'title' => esc_html__('Treatments', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 46,
                    'category' => 'health & beauty',
                    'subcategory' => 'beauty',
                    'tags' => ['beauty', 'beauty blog', 'beauty salon', 'beauty store', 'cosmetics', 'manicure', 'nail art', 'nail bar', 'nail design', 'nail polish shop', 'nail salon', 'nail shop', 'pedicure', 'wellness'],
                ],
                't46-prices' => [
                    'title' => esc_html__('Prices', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 46,
                    'category' => 'health & beauty',
                    'subcategory' => 'beauty',
                    'tags' => ['beauty', 'beauty blog', 'beauty salon', 'beauty store', 'cosmetics', 'manicure', 'nail art', 'nail bar', 'nail design', 'nail polish shop', 'nail salon', 'nail shop', 'pedicure', 'wellness'],
                ],
                't46-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 46,
                    'category' => 'health & beauty',
                    'subcategory' => 'beauty',
                    'tags' => ['beauty', 'beauty blog', 'beauty salon', 'beauty store', 'cosmetics', 'manicure', 'nail art', 'nail bar', 'nail design', 'nail polish shop', 'nail salon', 'nail shop', 'pedicure', 'wellness'],
                ],
                't47-double-glazed-windows' => [
                    'title' => esc_html__('Double Glazed Windows', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 47,
                    'category' => 'retail',
                    'subcategory' => 'retail',
                    'tags' => ['construction', 'doors', 'double glazed', 'furniture', 'glass', 'interior design', 'interior doors', 'plastic windows', 'service', 'slide doors', 'upvc', 'window glass', 'window systems', 'windows', 'wooden profiles'],
                ],
                't47-windows-doors' => [
                    'title' => esc_html__('Windows & Doors', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 47,
                    'category' => 'retail',
                    'subcategory' => 'retail',
                    'tags' => ['construction', 'doors', 'double glazed', 'furniture', 'glass', 'interior design', 'interior doors', 'plastic windows', 'service', 'slide doors', 'upvc', 'window glass', 'window systems', 'windows', 'wooden profiles'],
                ],
                't47-doors-installation' => [
                    'title' => esc_html__('Doors Installation', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 47,
                    'category' => 'retail',
                    'subcategory' => 'retail',
                    'tags' => ['construction', 'doors', 'double glazed', 'furniture', 'glass', 'interior design', 'interior doors', 'plastic windows', 'service', 'slide doors', 'upvc', 'window glass', 'window systems', 'windows', 'wooden profiles'],
                ],
                't47-windows-installation' => [
                    'title' => esc_html__('Windows Installation', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 47,
                    'category' => 'retail',
                    'subcategory' => 'retail',
                    'tags' => ['construction', 'doors', 'double glazed', 'furniture', 'glass', 'interior design', 'interior doors', 'plastic windows', 'service', 'slide doors', 'upvc', 'window glass', 'window systems', 'windows', 'wooden profiles'],
                ],
                't47-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 47,
                    'category' => 'retail',
                    'subcategory' => 'retail',
                    'tags' => ['construction', 'doors', 'double glazed', 'furniture', 'glass', 'interior design', 'interior doors', 'plastic windows', 'service', 'slide doors', 'upvc', 'window glass', 'window systems', 'windows', 'wooden profiles'],
                ],
                't47-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 47,
                    'category' => 'retail',
                    'subcategory' => 'retail',
                    'tags' => ['construction', 'doors', 'double glazed', 'furniture', 'glass', 'interior design', 'interior doors', 'plastic windows', 'service', 'slide doors', 'upvc', 'window glass', 'window systems', 'windows', 'wooden profiles'],
                ],
                't47-design-inspiration' => [
                    'title' => esc_html__('Design Inspiration', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 47,
                    'category' => 'retail',
                    'subcategory' => 'retail',
                    'tags' => ['construction', 'doors', 'double glazed', 'furniture', 'glass', 'interior design', 'interior doors', 'plastic windows', 'service', 'slide doors', 'upvc', 'window glass', 'window systems', 'windows', 'wooden profiles'],
                ],
                't47-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 47,
                    'category' => 'retail',
                    'subcategory' => 'retail',
                    'tags' => ['construction', 'doors', 'double glazed', 'furniture', 'glass', 'interior design', 'interior doors', 'plastic windows', 'service', 'slide doors', 'upvc', 'window glass', 'window systems', 'windows', 'wooden profiles'],
                ],
                't48-renewable-energy-company' => [
                    'title' => esc_html__('Renewable Energy Company', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 48,
                    'category' => 'business',
                    'subcategory' => 'energy',
                    'tags' => ['alternative energy', 'battery', 'ecology', 'energy service', 'green energy', 'green heating', 'green power', 'heating', 'renewable', 'renewable energy', 'solar energy', 'solar panels', 'wind energy', 'wind power'],
                ],
                't48-solar-solutions' => [
                    'title' => esc_html__('Solar Solutions', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 48,
                    'category' => 'business',
                    'subcategory' => 'energy',
                    'tags' => ['alternative energy', 'battery', 'ecology', 'energy service', 'green energy', 'green heating', 'green power', 'heating', 'renewable', 'renewable energy', 'solar energy', 'solar panels', 'wind energy', 'wind power'],
                ],
                't48-clean-energy' => [
                    'title' => esc_html__('Clean Energy', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 48,
                    'category' => 'business',
                    'subcategory' => 'energy',
                    'tags' => ['alternative energy', 'battery', 'ecology', 'energy service', 'green energy', 'green heating', 'green power', 'heating', 'renewable', 'renewable energy', 'solar energy', 'solar panels', 'wind energy', 'wind power'],
                ],
                't48-the-green-energy' => [
                    'title' => esc_html__('The Green Energy', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 48,
                    'category' => 'business',
                    'subcategory' => 'energy',
                    'tags' => ['alternative energy', 'battery', 'ecology', 'energy service', 'green energy', 'green heating', 'green power', 'heating', 'renewable', 'renewable energy', 'solar energy', 'solar panels', 'wind energy', 'wind power'],
                ],
                't48-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 48,
                    'category' => 'business',
                    'subcategory' => 'energy',
                    'tags' => ['alternative energy', 'battery', 'ecology', 'energy service', 'green energy', 'green heating', 'green power', 'heating', 'renewable', 'renewable energy', 'solar energy', 'solar panels', 'wind energy', 'wind power'],
                ],
                't48-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 48,
                    'category' => 'business',
                    'subcategory' => 'energy',
                    'tags' => ['alternative energy', 'battery', 'ecology', 'energy service', 'green energy', 'green heating', 'green power', 'heating', 'renewable', 'renewable energy', 'solar energy', 'solar panels', 'wind energy', 'wind power'],
                ],
                't48-look-at-our-projects' => [
                    'title' => esc_html__('Look at Our Projects', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 48,
                    'category' => 'business',
                    'subcategory' => 'energy',
                    'tags' => ['alternative energy', 'battery', 'ecology', 'energy service', 'green energy', 'green heating', 'green power', 'heating', 'renewable', 'renewable energy', 'solar energy', 'solar panels', 'wind energy', 'wind power'],
                ],
                't48-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 48,
                    'category' => 'business',
                    'subcategory' => 'energy',
                    'tags' => ['alternative energy', 'battery', 'ecology', 'energy service', 'green energy', 'green heating', 'green power', 'heating', 'renewable', 'renewable energy', 'solar energy', 'solar panels', 'wind energy', 'wind power'],
                ],
                't49-wooden-cottages' => [
                    'title' => esc_html__('Wooden Cottages', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 49,
                    'category' => 'business',
                    'subcategory' => 'construction',
                    'tags' => ['carpenter', 'construction company', 'furniture', 'log house', 'real estate', 'timber', 'timbering', 'wood', 'wood crafter', 'wood products', 'woodcraft store', 'wooden bar house', 'wooden cottage', 'woodwork'],
                ],
                't49-cozy-wooden-house' => [
                    'title' => esc_html__('Cozy Wooden House', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 49,
                    'category' => 'business',
                    'subcategory' => 'construction',
                    'tags' => ['carpenter', 'construction company', 'furniture', 'log house', 'real estate', 'timber', 'timbering', 'wood', 'wood crafter', 'wood products', 'woodcraft store', 'wooden bar house', 'wooden cottage', 'woodwork'],
                ],
                't49-your-perfect-house' => [
                    'title' => esc_html__('Your Perfect House', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 49,
                    'category' => 'business',
                    'subcategory' => 'construction',
                    'tags' => ['carpenter', 'construction company', 'furniture', 'log house', 'real estate', 'timber', 'timbering', 'wood', 'wood crafter', 'wood products', 'woodcraft store', 'wooden bar house', 'wooden cottage', 'woodwork'],
                ],
                't49-craft-wooden-houses' => [
                    'title' => esc_html__('Craft Wooden Houses', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 49,
                    'category' => 'business',
                    'subcategory' => 'construction',
                    'tags' => ['carpenter', 'construction company', 'furniture', 'log house', 'real estate', 'timber', 'timbering', 'wood', 'wood crafter', 'wood products', 'woodcraft store', 'wooden bar house', 'wooden cottage', 'woodwork'],
                ],
                't49-gallery' => [
                    'title' => esc_html__('Gallery', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 49,
                    'category' => 'business',
                    'subcategory' => 'construction',
                    'tags' => ['carpenter', 'construction company', 'furniture', 'log house', 'real estate', 'timber', 'timbering', 'wood', 'wood crafter', 'wood products', 'woodcraft store', 'wooden bar house', 'wooden cottage', 'woodwork'],
                ],
                't49-testimonials' => [
                    'title' => esc_html__('Testimonials', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 49,
                    'category' => 'business',
                    'subcategory' => 'construction',
                    'tags' => ['carpenter', 'construction company', 'furniture', 'log house', 'real estate', 'timber', 'timbering', 'wood', 'wood crafter', 'wood products', 'woodcraft store', 'wooden bar house', 'wooden cottage', 'woodwork'],
                ],
                't49-technologies' => [
                    'title' => esc_html__('Technologies', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 49,
                    'category' => 'business',
                    'subcategory' => 'construction',
                    'tags' => ['carpenter', 'construction company', 'furniture', 'log house', 'real estate', 'timber', 'timbering', 'wood', 'wood crafter', 'wood products', 'woodcraft store', 'wooden bar house', 'wooden cottage', 'woodwork'],
                ],
                't49-contact-us' => [
                    'title' => esc_html__('Contact Us ', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 49,
                    'category' => 'business',
                    'subcategory' => 'construction',
                    'tags' => ['carpenter', 'construction company', 'furniture', 'log house', 'real estate', 'timber', 'timbering', 'wood', 'wood crafter', 'wood products', 'woodcraft store', 'wooden bar house', 'wooden cottage', 'woodwork'],
                ],
                't50-dry-cleaning-laundry-experts' => [
                    'title' => esc_html__('Dry Cleaning & Laundry Experts', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 50,
                    'category' => 'business',
                    'subcategory' => 'cleaning',
                    'tags' => ['clean', 'cleaner', 'cleaning', 'cleaning business', 'cleaning service', 'clothing repair', 'dry cleaning', 'ironing', 'laundry', 'laundry business', 'laundry service', 'tailor', 'wash', 'wash business', 'washing'],
                ],
                't50-dry-cleaning-with-delivery' => [
                    'title' => esc_html__('Dry Cleaning with Delivery', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 50,
                    'category' => 'business',
                    'subcategory' => 'cleaning',
                    'tags' => ['clean', 'cleaner', 'cleaning', 'cleaning business', 'cleaning service', 'clothing repair', 'dry cleaning', 'ironing', 'laundry', 'laundry business', 'laundry service', 'tailor', 'wash', 'wash business', 'washing'],
                ],
                't50-wonderful-laundry' => [
                    'title' => esc_html__('Wonderful Laundry', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 50,
                    'category' => 'business',
                    'subcategory' => 'cleaning',
                    'tags' => ['clean', 'cleaner', 'cleaning', 'cleaning business', 'cleaning service', 'clothing repair', 'dry cleaning', 'ironing', 'laundry', 'laundry business', 'laundry service', 'tailor', 'wash', 'wash business', 'washing'],
                ],
                't50-express-dry-cleaning' => [
                    'title' => esc_html__('Express Dry Cleaning', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 50,
                    'category' => 'business',
                    'subcategory' => 'cleaning',
                    'tags' => ['clean', 'cleaner', 'cleaning', 'cleaning business', 'cleaning service', 'clothing repair', 'dry cleaning', 'ironing', 'laundry', 'laundry business', 'laundry service', 'tailor', 'wash', 'wash business', 'washing'],
                ],
                't50-services' => [
                    'title' => esc_html__('Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 50,
                    'category' => 'business',
                    'subcategory' => 'cleaning',
                    'tags' => ['clean', 'cleaner', 'cleaning', 'cleaning business', 'cleaning service', 'clothing repair', 'dry cleaning', 'ironing', 'laundry', 'laundry business', 'laundry service', 'tailor', 'wash', 'wash business', 'washing'],
                ],
                't50-pricing' => [
                    'title' => esc_html__('Pricing', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 50,
                    'category' => 'business',
                    'subcategory' => 'cleaning',
                    'tags' => ['clean', 'cleaner', 'cleaning', 'cleaning business', 'cleaning service', 'clothing repair', 'dry cleaning', 'ironing', 'laundry', 'laundry business', 'laundry service', 'tailor', 'wash', 'wash business', 'washing'],
                ],
                't50-policies' => [
                    'title' => esc_html__('Policies', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 50,
                    'category' => 'business',
                    'subcategory' => 'cleaning',
                    'tags' => ['clean', 'cleaner', 'cleaning', 'cleaning business', 'cleaning service', 'clothing repair', 'dry cleaning', 'ironing', 'laundry', 'laundry business', 'laundry service', 'tailor', 'wash', 'wash business', 'washing'],
                ],
                't50-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 50,
                    'category' => 'business',
                    'subcategory' => 'cleaning',
                    'tags' => ['clean', 'cleaner', 'cleaning', 'cleaning business', 'cleaning service', 'clothing repair', 'dry cleaning', 'ironing', 'laundry', 'laundry business', 'laundry service', 'tailor', 'wash', 'wash business', 'washing'],
                ],
                't51-satellite-tv' => [
                    'title' => esc_html__('Satellite TV', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 51,
                    'category' => 'technology',
                    'subcategory' => 'service',
                    'tags' => ['broadband', 'broadband service', 'broadband TV', 'cable television', 'cinema', 'internet company', 'internet provider', 'online TV', 'satellite', 'startup', 'streaming', 'telecom', 'TV box', 'TV channel', 'video'],
                ],
                't51-internet-provider' => [
                    'title' => esc_html__('Internet Provider', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 51,
                    'category' => 'technology',
                    'subcategory' => 'service',
                    'tags' => ['broadband', 'broadband service', 'broadband TV', 'cable television', 'cinema', 'internet company', 'internet provider', 'online TV', 'satellite', 'startup', 'streaming', 'telecom', 'TV box', 'TV channel', 'video'],
                ],
                't51-broadband' => [
                    'title' => esc_html__('Broadband', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 51,
                    'category' => 'technology',
                    'subcategory' => 'service',
                    'tags' => ['broadband', 'broadband service', 'broadband TV', 'cable television', 'cinema', 'internet company', 'internet provider', 'online TV', 'satellite', 'startup', 'streaming', 'telecom', 'TV box', 'TV channel', 'video'],
                ],
                't51-live-streaming' => [
                    'title' => esc_html__('Live Streaming', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 51,
                    'category' => 'technology',
                    'subcategory' => 'service',
                    'tags' => ['broadband', 'broadband service', 'broadband TV', 'cable television', 'cinema', 'internet company', 'internet provider', 'online TV', 'satellite', 'startup', 'streaming', 'telecom', 'TV box', 'TV channel', 'video'],
                ],
                't51-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 51,
                    'category' => 'technology',
                    'subcategory' => 'service',
                    'tags' => ['broadband', 'broadband service', 'broadband TV', 'cable television', 'cinema', 'internet company', 'internet provider', 'online TV', 'satellite', 'startup', 'streaming', 'telecom', 'TV box', 'TV channel', 'video'],
                ],
                't51-our-team' => [
                    'title' => esc_html__('Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 51,
                    'category' => 'technology',
                    'subcategory' => 'service',
                    'tags' => ['broadband', 'broadband service', 'broadband TV', 'cable television', 'cinema', 'internet company', 'internet provider', 'online TV', 'satellite', 'startup', 'streaming', 'telecom', 'TV box', 'TV channel', 'video'],
                ],
                't51-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 51,
                    'category' => 'technology',
                    'subcategory' => 'service',
                    'tags' => ['broadband', 'broadband service', 'broadband TV', 'cable television', 'cinema', 'internet company', 'internet provider', 'online TV', 'satellite', 'startup', 'streaming', 'telecom', 'TV box', 'TV channel', 'video'],
                ],
                't52-home-astrology' => [
                    'title' => esc_html__('Home Astrology', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 52,
                    'category' => 'business',
                    'subcategory' => 'service',
                    'tags' => ['astrologer', 'astrology', 'astrology blog', 'astrology conference', 'astrology event', 'horoscope', 'horoscope forecast', 'horoscope reading', 'horoscope report shop', 'zodiac', 'zodiac forecast', 'zodiac report'],
                ],
                't52-home-astrology-dark' => [
                    'title' => esc_html__('Home Astrology Dark', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 52,
                    'category' => 'business',
                    'subcategory' => 'service',
                    'tags' => ['astrologer', 'astrology', 'astrology blog', 'astrology conference', 'astrology event', 'horoscope', 'horoscope forecast', 'horoscope reading', 'horoscope report shop', 'zodiac', 'zodiac forecast', 'zodiac report'],
                ],
                't52-home-tarot' => [
                    'title' => esc_html__('Home Tarot', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 52,
                    'category' => 'business',
                    'subcategory' => 'service',
                    'tags' => ['astrologer', 'astrology', 'astrology blog', 'astrology conference', 'astrology event', 'horoscope', 'horoscope forecast', 'horoscope reading', 'horoscope report shop', 'zodiac', 'zodiac forecast', 'zodiac report'],
                ],
                't52-home-tarot-dark' => [
                    'title' => esc_html__('Home Tarot Dark', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 52,
                    'category' => 'business',
                    'subcategory' => 'service',
                    'tags' => ['astrologer', 'astrology', 'astrology blog', 'astrology conference', 'astrology event', 'horoscope', 'horoscope forecast', 'horoscope reading', 'horoscope report shop', 'zodiac', 'zodiac forecast', 'zodiac report'],
                ],
                't52-home-numerology' => [
                    'title' => esc_html__('Home Numerology', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 52,
                    'category' => 'business',
                    'subcategory' => 'service',
                    'tags' => ['astrologer', 'astrology', 'astrology blog', 'astrology conference', 'astrology event', 'horoscope', 'horoscope forecast', 'horoscope reading', 'horoscope report shop', 'zodiac', 'zodiac forecast', 'zodiac report'],
                ],
                't52-home-astrologer' => [
                    'title' => esc_html__('Home Astrologer', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 52,
                    'category' => 'business',
                    'subcategory' => 'service',
                    'tags' => ['astrologer', 'astrology', 'astrology blog', 'astrology conference', 'astrology event', 'horoscope', 'horoscope forecast', 'horoscope reading', 'horoscope report shop', 'zodiac', 'zodiac forecast', 'zodiac report'],
                ],
                't52-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 52,
                    'category' => 'business',
                    'subcategory' => 'service',
                    'tags' => ['astrologer', 'astrology', 'astrology blog', 'astrology conference', 'astrology event', 'horoscope', 'horoscope forecast', 'horoscope reading', 'horoscope report shop', 'zodiac', 'zodiac forecast', 'zodiac report'],
                ],
                't52-our-team' => [
                    'title' => esc_html__('Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 52,
                    'category' => 'business',
                    'subcategory' => 'service',
                    'tags' => ['astrologer', 'astrology', 'astrology blog', 'astrology conference', 'astrology event', 'horoscope', 'horoscope forecast', 'horoscope reading', 'horoscope report shop', 'zodiac', 'zodiac forecast', 'zodiac report'],
                ],
                't52-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 52,
                    'category' => 'business',
                    'subcategory' => 'service',
                    'tags' => ['astrologer', 'astrology', 'astrology blog', 'astrology conference', 'astrology event', 'horoscope', 'horoscope forecast', 'horoscope reading', 'horoscope report shop', 'zodiac', 'zodiac forecast', 'zodiac report'],
                ],
                't53-the-best-driving-school' => [
                    'title' => esc_html__('The Best Driving School', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 53,
                    'category' => 'business',
                    'subcategory' => 'education',
                    'tags' => ['auto', 'car', 'car driving', 'defensive driving classes', 'driver', 'Driver Education', 'driver license', 'driving', 'driving school', 'driving training', 'Teen Drivers Education', 'training center', 'winter driving courses'],
                ],
                't53-unlock-your-driving-potential' => [
                    'title' => esc_html__('Unlock Your Driving Potential', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 53,
                    'category' => 'business',
                    'subcategory' => 'education',
                    'tags' => ['auto', 'car', 'car driving', 'defensive driving classes', 'driver', 'Driver Education', 'driver license', 'driving', 'driving school', 'driving training', 'Teen Drivers Education', 'training center', 'winter driving courses'],
                ],
                't53-your-driving-skills' => [
                    'title' => esc_html__('Your Driving Skills', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 53,
                    'category' => 'business',
                    'subcategory' => 'education',
                    'tags' => ['auto', 'car', 'car driving', 'defensive driving classes', 'driver', 'Driver Education', 'driver license', 'driving', 'driving school', 'driving training', 'Teen Drivers Education', 'training center', 'winter driving courses'],
                ],
                't53-get-behind-the-wheel' => [
                    'title' => esc_html__('Get Behind the Wheel', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 53,
                    'category' => 'business',
                    'subcategory' => 'education',
                    'tags' => ['auto', 'car', 'car driving', 'defensive driving classes', 'driver', 'Driver Education', 'driver license', 'driving', 'driving school', 'driving training', 'Teen Drivers Education', 'training center', 'winter driving courses'],
                ],
                't53-services' => [
                    'title' => esc_html__('Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 53,
                    'category' => 'business',
                    'subcategory' => 'education',
                    'tags' => ['auto', 'car', 'car driving', 'defensive driving classes', 'driver', 'Driver Education', 'driver license', 'driving', 'driving school', 'driving training', 'Teen Drivers Education', 'training center', 'winter driving courses'],
                ],
                't53-our-team' => [
                    'title' => esc_html__('Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 53,
                    'category' => 'business',
                    'subcategory' => 'education',
                    'tags' => ['auto', 'car', 'car driving', 'defensive driving classes', 'driver', 'Driver Education', 'driver license', 'driving', 'driving school', 'driving training', 'Teen Drivers Education', 'training center', 'winter driving courses'],
                ],
                't53-lessons-gallery' => [
                    'title' => esc_html__('Lessons Gallery', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 53,
                    'category' => 'business',
                    'subcategory' => 'education',
                    'tags' => ['auto', 'car', 'car driving', 'defensive driving classes', 'driver', 'Driver Education', 'driver license', 'driving', 'driving school', 'driving training', 'Teen Drivers Education', 'training center', 'winter driving courses'],
                ],
                't53-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 53,
                    'category' => 'business',
                    'subcategory' => 'education',
                    'tags' => ['auto', 'car', 'car driving', 'defensive driving classes', 'driver', 'Driver Education', 'driver license', 'driving', 'driving school', 'driving training', 'Teen Drivers Education', 'training center', 'winter driving courses'],
                ],
                't54-home-surfing' => [
                    'title' => esc_html__('Home Surfing', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 54,
                    'category' => 'travel',
                    'subcategory' => 'sports',
                    'tags' => ['beach', 'canoeing', 'diving', 'event', 'sailing', 'scuba diving', 'snorkeling', 'sports', 'sports theme', 'surf', 'surf shop', 'surfing', 'surfing theme', 'water sports', 'yachting'],
                ],
                't54-home-surfing-2' => [
                    'title' => esc_html__('Home Surfing 2', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 54,
                    'category' => 'travel',
                    'subcategory' => 'sports',
                    'tags' => ['beach', 'canoeing', 'diving', 'event', 'sailing', 'scuba diving', 'snorkeling', 'sports', 'sports theme', 'surf', 'surf shop', 'surfing', 'surfing theme', 'water sports', 'yachting'],
                ],
                't54-home-scuba-diving' => [
                    'title' => esc_html__('Home Scuba Diving', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 54,
                    'category' => 'travel',
                    'subcategory' => 'sports',
                    'tags' => ['beach', 'canoeing', 'diving', 'event', 'sailing', 'scuba diving', 'snorkeling', 'sports', 'sports theme', 'surf', 'surf shop', 'surfing', 'surfing theme', 'water sports', 'yachting'],
                ],
                't54-home-scuba-diving-2' => [
                    'title' => esc_html__('Home Scuba Diving 2', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 54,
                    'category' => 'travel',
                    'subcategory' => 'sports',
                    'tags' => ['beach', 'canoeing', 'diving', 'event', 'sailing', 'scuba diving', 'snorkeling', 'sports', 'sports theme', 'surf', 'surf shop', 'surfing', 'surfing theme', 'water sports', 'yachting'],
                ],
                't54-home-kayaking' => [
                    'title' => esc_html__('Home Kayaking', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 54,
                    'category' => 'travel',
                    'subcategory' => 'sports',
                    'tags' => ['beach', 'canoeing', 'diving', 'event', 'sailing', 'scuba diving', 'snorkeling', 'sports', 'sports theme', 'surf', 'surf shop', 'surfing', 'surfing theme', 'water sports', 'yachting'],
                ],
                't54-home-windsurfing' => [
                    'title' => esc_html__('Home Windsurfing', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 54,
                    'category' => 'travel',
                    'subcategory' => 'sports',
                    'tags' => ['beach', 'canoeing', 'diving', 'event', 'sailing', 'scuba diving', 'snorkeling', 'sports', 'sports theme', 'surf', 'surf shop', 'surfing', 'surfing theme', 'water sports', 'yachting'],
                ],
                't54-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 54,
                    'category' => 'travel',
                    'subcategory' => 'sports',
                    'tags' => ['beach', 'canoeing', 'diving', 'event', 'sailing', 'scuba diving', 'snorkeling', 'sports', 'sports theme', 'surf', 'surf shop', 'surfing', 'surfing theme', 'water sports', 'yachting'],
                ],
                't54-our-team' => [
                    'title' => esc_html__('Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 54,
                    'category' => 'travel',
                    'subcategory' => 'sports',
                    'tags' => ['beach', 'canoeing', 'diving', 'event', 'sailing', 'scuba diving', 'snorkeling', 'sports', 'sports theme', 'surf', 'surf shop', 'surfing', 'surfing theme', 'water sports', 'yachting'],
                ],
                't54-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 54,
                    'category' => 'travel',
                    'subcategory' => 'sports',
                    'tags' => ['beach', 'canoeing', 'diving', 'event', 'sailing', 'scuba diving', 'snorkeling', 'sports', 'sports theme', 'surf', 'surf shop', 'surfing', 'surfing theme', 'water sports', 'yachting'],
                ],
                't72-supportive-care' => [
                    'title' => esc_html__('Supportive Care', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 72,
                    'category' => 'business',
                    'subcategory' => 'funeral',
                    'tags' => ['burial service', 'casket', 'cemetery', 'church', 'cremation service', 'crematory', 'funeral', 'Funeral agency', 'funeral arrangement', 'grave monument', 'memorial park', 'mortuary', 'obituaries', 'Obituary', 'sermons'],
                ],
                't72-care-and-respect' => [
                    'title' => esc_html__('Care and Respect', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 72,
                    'category' => 'business',
                    'subcategory' => 'funeral',
                    'tags' => ['burial service', 'casket', 'cemetery', 'church', 'cremation service', 'crematory', 'funeral', 'Funeral agency', 'funeral arrangement', 'grave monument', 'memorial park', 'mortuary', 'obituaries', 'Obituary', 'sermons'],
                ],
                't72-lasting-remembrance' => [
                    'title' => esc_html__('Lasting Remembrance', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 72,
                    'category' => 'business',
                    'subcategory' => 'funeral',
                    'tags' => ['burial service', 'casket', 'cemetery', 'church', 'cremation service', 'crematory', 'funeral', 'Funeral agency', 'funeral arrangement', 'grave monument', 'memorial park', 'mortuary', 'obituaries', 'Obituary', 'sermons'],
                ],
                't72-meaningful-ceremonies' => [
                    'title' => esc_html__('Meaningful Ceremonies', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 72,
                    'category' => 'business',
                    'subcategory' => 'funeral',
                    'tags' => ['burial service', 'casket', 'cemetery', 'church', 'cremation service', 'crematory', 'funeral', 'Funeral agency', 'funeral arrangement', 'grave monument', 'memorial park', 'mortuary', 'obituaries', 'Obituary', 'sermons'],
                ],
                't72-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 72,
                    'category' => 'business',
                    'subcategory' => 'funeral',
                    'tags' => ['burial service', 'casket', 'cemetery', 'church', 'cremation service', 'crematory', 'funeral', 'Funeral agency', 'funeral arrangement', 'grave monument', 'memorial park', 'mortuary', 'obituaries', 'Obituary', 'sermons'],
                ],
                't72-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 72,
                    'category' => 'business',
                    'subcategory' => 'funeral',
                    'tags' => ['burial service', 'casket', 'cemetery', 'church', 'cremation service', 'crematory', 'funeral', 'Funeral agency', 'funeral arrangement', 'grave monument', 'memorial park', 'mortuary', 'obituaries', 'Obituary', 'sermons'],
                ],
                't72-arranging-a-funeral' => [
                    'title' => esc_html__('Arranging a Funeral', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 72,
                    'category' => 'business',
                    'subcategory' => 'funeral',
                    'tags' => ['burial service', 'casket', 'cemetery', 'church', 'cremation service', 'crematory', 'funeral', 'Funeral agency', 'funeral arrangement', 'grave monument', 'memorial park', 'mortuary', 'obituaries', 'Obituary', 'sermons'],
                ],
                't72-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 72,
                    'category' => 'business',
                    'subcategory' => 'funeral',
                    'tags' => ['burial service', 'casket', 'cemetery', 'church', 'cremation service', 'crematory', 'funeral', 'Funeral agency', 'funeral arrangement', 'grave monument', 'memorial park', 'mortuary', 'obituaries', 'Obituary', 'sermons'],
                ],
                't55-home-vape-shop' => [
                    'title' => esc_html__('Vape Shop', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 55,
                    'category' => 'retail',
                    'subcategory' => 'retail',
                    'tags' => ['accessories', 'cafe', 'clean', 'electronic cigarette', 'fashion', 'marketplace', 'modern', 'multi vendor', 'smoking', 'store', 'stylish', 'vape', 'vape shop', 'vaping'],
                ],
                't55-home-vape-shop-2' => [
                    'title' => esc_html__('Vape Shop 2', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 55,
                    'category' => 'retail',
                    'subcategory' => 'retail',
                    'tags' => ['accessories', 'cafe', 'clean', 'electronic cigarette', 'fashion', 'marketplace', 'modern', 'multi vendor', 'smoking', 'store', 'stylish', 'vape', 'vape shop', 'vaping'],
                ],
                't55-home-vape-shop-dark' => [
                    'title' => esc_html__('Vape Shop Dark', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 55,
                    'category' => 'retail',
                    'subcategory' => 'retail',
                    'tags' => ['accessories', 'cafe', 'clean', 'electronic cigarette', 'fashion', 'marketplace', 'modern', 'multi vendor', 'smoking', 'store', 'stylish', 'vape', 'vape shop', 'vaping'],
                ],
                't55-home-vape-shop-dark-2' => [
                    'title' => esc_html__('Vape Shop Dark 2', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 55,
                    'category' => 'retail',
                    'subcategory' => 'retail',
                    'tags' => ['accessories', 'cafe', 'clean', 'electronic cigarette', 'fashion', 'marketplace', 'modern', 'multi vendor', 'smoking', 'store', 'stylish', 'vape', 'vape shop', 'vaping'],
                ],
                't55-home-e-liquids' => [
                    'title' => esc_html__('E-Liquids', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 55,
                    'category' => 'retail',
                    'subcategory' => 'retail',
                    'tags' => ['accessories', 'cafe', 'clean', 'electronic cigarette', 'fashion', 'marketplace', 'modern', 'multi vendor', 'smoking', 'store', 'stylish', 'vape', 'vape shop', 'vaping'],
                ],
                't55-home-vaping-pods' => [
                    'title' => esc_html__('Vaping Pods', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 55,
                    'category' => 'retail',
                    'subcategory' => 'retail',
                    'tags' => ['accessories', 'cafe', 'clean', 'electronic cigarette', 'fashion', 'marketplace', 'modern', 'multi vendor', 'smoking', 'store', 'stylish', 'vape', 'vape shop', 'vaping'],
                ],
                't55-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 55,
                    'category' => 'retail',
                    'subcategory' => 'retail',
                    'tags' => ['accessories', 'cafe', 'clean', 'electronic cigarette', 'fashion', 'marketplace', 'modern', 'multi vendor', 'smoking', 'store', 'stylish', 'vape', 'vape shop', 'vaping'],
                ],
                't55-our-team' => [
                    'title' => esc_html__('Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 55,
                    'category' => 'retail',
                    'subcategory' => 'retail',
                    'tags' => ['accessories', 'cafe', 'clean', 'electronic cigarette', 'fashion', 'marketplace', 'modern', 'multi vendor', 'smoking', 'store', 'stylish', 'vape', 'vape shop', 'vaping'],
                ],
                't55-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 55,
                    'category' => 'retail',
                    'subcategory' => 'retail',
                    'tags' => ['accessories', 'cafe', 'clean', 'electronic cigarette', 'fashion', 'marketplace', 'modern', 'multi vendor', 'smoking', 'store', 'stylish', 'vape', 'vape shop', 'vaping'],
                ],
                't56-home-car-washing-4' => [
                    'title' => esc_html__('Car Washing 4', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 56,
                    'category' => 'business',
                    'subcategory' => 'services',
                    'tags' => ['auto care', 'autospa', 'autowash', 'booking', 'car cleaning', 'car repair', 'car spa', 'car wash', 'car washing', 'carwash', 'carwash service', 'cleaning', 'mechanic', 'repair', 'vehicle cleaning'],
                ],
                't56-home-car-washing-5' => [
                    'title' => esc_html__('Car Washing 5', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 56,
                    'category' => 'business',
                    'subcategory' => 'services',
                    'tags' => ['auto care', 'autospa', 'autowash', 'booking', 'car cleaning', 'car repair', 'car spa', 'car wash', 'car washing', 'carwash', 'carwash service', 'cleaning', 'mechanic', 'repair', 'vehicle cleaning'],
                ],
                't56-home-car-hand-washing' => [
                    'title' => esc_html__('Car Hand Washing', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 56,
                    'category' => 'business',
                    'subcategory' => 'services',
                    'tags' => ['auto care', 'autospa', 'autowash', 'booking', 'car cleaning', 'car repair', 'car spa', 'car wash', 'car washing', 'carwash', 'carwash service', 'cleaning', 'mechanic', 'repair', 'vehicle cleaning'],
                ],
                't56-home-car-washing-service' => [
                    'title' => esc_html__('Car Washing Service', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 56,
                    'category' => 'business',
                    'subcategory' => 'services',
                    'tags' => ['auto care', 'autospa', 'autowash', 'booking', 'car cleaning', 'car repair', 'car spa', 'car wash', 'car washing', 'carwash', 'carwash service', 'cleaning', 'mechanic', 'repair', 'vehicle cleaning'],
                ],
                't56-home-car-washing' => [
                    'title' => esc_html__('Car Washing', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 56,
                    'category' => 'business',
                    'subcategory' => 'services',
                    'tags' => ['auto care', 'autospa', 'autowash', 'booking', 'car cleaning', 'car repair', 'car spa', 'car wash', 'car washing', 'carwash', 'carwash service', 'cleaning', 'mechanic', 'repair', 'vehicle cleaning'],
                ],
                't56-home-car-washing-2' => [
                    'title' => esc_html__('Car Washing 2', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 56,
                    'category' => 'business',
                    'subcategory' => 'services',
                    'tags' => ['auto care', 'autospa', 'autowash', 'booking', 'car cleaning', 'car repair', 'car spa', 'car wash', 'car washing', 'carwash', 'carwash service', 'cleaning', 'mechanic', 'repair', 'vehicle cleaning'],
                ],
                't56-home-car-washing-3' => [
                    'title' => esc_html__('Car Washing 3', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 56,
                    'category' => 'business',
                    'subcategory' => 'services',
                    'tags' => ['auto care', 'autospa', 'autowash', 'booking', 'car cleaning', 'car repair', 'car spa', 'car wash', 'car washing', 'carwash', 'carwash service', 'cleaning', 'mechanic', 'repair', 'vehicle cleaning'],
                ],
                't56-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 56,
                    'category' => 'business',
                    'subcategory' => 'services',
                    'tags' => ['auto care', 'autospa', 'autowash', 'booking', 'car cleaning', 'car repair', 'car spa', 'car wash', 'car washing', 'carwash', 'carwash service', 'cleaning', 'mechanic', 'repair', 'vehicle cleaning'],
                ],
                't56-about-us-2' => [
                    'title' => esc_html__('About Us 2', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 56,
                    'category' => 'business',
                    'subcategory' => 'services',
                    'tags' => ['auto care', 'autospa', 'autowash', 'booking', 'car cleaning', 'car repair', 'car spa', 'car wash', 'car washing', 'carwash', 'carwash service', 'cleaning', 'mechanic', 'repair', 'vehicle cleaning'],
                ],
                't56-our-team' => [
                    'title' => esc_html__('Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 56,
                    'category' => 'business',
                    'subcategory' => 'services',
                    'tags' => ['auto care', 'autospa', 'autowash', 'booking', 'car cleaning', 'car repair', 'car spa', 'car wash', 'car washing', 'carwash', 'carwash service', 'cleaning', 'mechanic', 'repair', 'vehicle cleaning'],
                ],
                't56-our-team-2' => [
                    'title' => esc_html__('Our Team 2', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 56,
                    'category' => 'business',
                    'subcategory' => 'services',
                    'tags' => ['auto care', 'autospa', 'autowash', 'booking', 'car cleaning', 'car repair', 'car spa', 'car wash', 'car washing', 'carwash', 'carwash service', 'cleaning', 'mechanic', 'repair', 'vehicle cleaning'],
                ],
                't56-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 56,
                    'category' => 'business',
                    'subcategory' => 'services',
                    'tags' => ['auto care', 'autospa', 'autowash', 'booking', 'car cleaning', 'car repair', 'car spa', 'car wash', 'car washing', 'carwash', 'carwash service', 'cleaning', 'mechanic', 'repair', 'vehicle cleaning'],
                ],
                't56-contact-us-2' => [
                    'title' => esc_html__('Contact Us 2', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 56,
                    'category' => 'business',
                    'subcategory' => 'services',
                    'tags' => ['auto care', 'autospa', 'autowash', 'booking', 'car cleaning', 'car repair', 'car spa', 'car wash', 'car washing', 'carwash', 'carwash service', 'cleaning', 'mechanic', 'repair', 'vehicle cleaning'],
                ],
                't57-home-golf-club' => [
                    'title' => esc_html__('Home Golf Club', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 57,
                    'category' => 'entertainment',
                    'subcategory' => 'sports',
                    'tags' => ['athlete', 'clubhouse', 'coach', 'country club', 'driving range', 'golf', 'golf club', 'golf course', 'luxury', 'mini golf', 'pro shop', 'sport pro', 'sports', 'trainer'],
                ],
                't57-home-golf-club-2' => [
                    'title' => esc_html__('Home Golf Club 2', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 57,
                    'category' => 'entertainment',
                    'subcategory' => 'sports',
                    'tags' => ['athlete', 'clubhouse', 'coach', 'country club', 'driving range', 'golf', 'golf club', 'golf course', 'luxury', 'mini golf', 'pro shop', 'sport pro', 'sports', 'trainer'],
                ],
                't57-home-golf-course' => [
                    'title' => esc_html__('Home Golf Course', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 57,
                    'category' => 'entertainment',
                    'subcategory' => 'sports',
                    'tags' => ['athlete', 'clubhouse', 'coach', 'country club', 'driving range', 'golf', 'golf club', 'golf course', 'luxury', 'mini golf', 'pro shop', 'sport pro', 'sports', 'trainer'],
                ],
                't57-home-golf-event' => [
                    'title' => esc_html__('Home Golf Event', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 57,
                    'category' => 'entertainment',
                    'subcategory' => 'sports',
                    'tags' => ['athlete', 'clubhouse', 'coach', 'country club', 'driving range', 'golf', 'golf club', 'golf course', 'luxury', 'mini golf', 'pro shop', 'sport pro', 'sports', 'trainer'],
                ],
                't57-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 57,
                    'category' => 'entertainment',
                    'subcategory' => 'sports',
                    'tags' => ['athlete', 'clubhouse', 'coach', 'country club', 'driving range', 'golf', 'golf club', 'golf course', 'luxury', 'mini golf', 'pro shop', 'sport pro', 'sports', 'trainer'],
                ],
                't57-our-team' => [
                    'title' => esc_html__('Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 57,
                    'category' => 'entertainment',
                    'subcategory' => 'sports',
                    'tags' => ['athlete', 'clubhouse', 'coach', 'country club', 'driving range', 'golf', 'golf club', 'golf course', 'luxury', 'mini golf', 'pro shop', 'sport pro', 'sports', 'trainer'],
                ],
                't57-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 57,
                    'category' => 'entertainment',
                    'subcategory' => 'sports',
                    'tags' => ['athlete', 'clubhouse', 'coach', 'country club', 'driving range', 'golf', 'golf club', 'golf course', 'luxury', 'mini golf', 'pro shop', 'sport pro', 'sports', 'trainer'],
                ],
                't58-hookah-lounge' => [
                    'title' => esc_html__('Hookah Lounge', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 58,
                    'category' => 'entertainment',
                    'subcategory' => 'nightlife',
                    'tags' => ['cocktails', 'drinks', 'events', 'hookah', 'hookah lounge', 'lounge', 'menu', 'nightlife', 'restaurant', 'shisha', 'shisha bar', 'shop', 'smoking', 'store', 'tobacco'],
                ],
                't58-shisha-bar' => [
                    'title' => esc_html__('Shisha Bar', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 58,
                    'category' => 'entertainment',
                    'subcategory' => 'nightlife',
                    'tags' => ['cocktails', 'drinks', 'events', 'hookah', 'hookah lounge', 'lounge', 'menu', 'nightlife', 'restaurant', 'shisha', 'shisha bar', 'shop', 'smoking', 'store', 'tobacco'],
                ],
                't58-the-home-of-shisha' => [
                    'title' => esc_html__('The Home of Shisha', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 58,
                    'category' => 'entertainment',
                    'subcategory' => 'nightlife',
                    'tags' => ['cocktails', 'drinks', 'events', 'hookah', 'hookah lounge', 'lounge', 'menu', 'nightlife', 'restaurant', 'shisha', 'shisha bar', 'shop', 'smoking', 'store', 'tobacco'],
                ],
                't58-the-shisha-room' => [
                    'title' => esc_html__('The Shisha Room', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 58,
                    'category' => 'entertainment',
                    'subcategory' => 'nightlife',
                    'tags' => ['cocktails', 'drinks', 'events', 'hookah', 'hookah lounge', 'lounge', 'menu', 'nightlife', 'restaurant', 'shisha', 'shisha bar', 'shop', 'smoking', 'store', 'tobacco'],
                ],
                't58-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 58,
                    'category' => 'entertainment',
                    'subcategory' => 'nightlife',
                    'tags' => ['cocktails', 'drinks', 'events', 'hookah', 'hookah lounge', 'lounge', 'menu', 'nightlife', 'restaurant', 'shisha', 'shisha bar', 'shop', 'smoking', 'store', 'tobacco'],
                ],
                't58-menu' => [
                    'title' => esc_html__('Menu', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 58,
                    'category' => 'entertainment',
                    'subcategory' => 'nightlife',
                    'tags' => ['cocktails', 'drinks', 'events', 'hookah', 'hookah lounge', 'lounge', 'menu', 'nightlife', 'restaurant', 'shisha', 'shisha bar', 'shop', 'smoking', 'store', 'tobacco'],
                ],
                't58-venue' => [
                    'title' => esc_html__('Venue', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 58,
                    'category' => 'entertainment',
                    'subcategory' => 'nightlife',
                    'tags' => ['cocktails', 'drinks', 'events', 'hookah', 'hookah lounge', 'lounge', 'menu', 'nightlife', 'restaurant', 'shisha', 'shisha bar', 'shop', 'smoking', 'store', 'tobacco'],
                ],
                't58-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 58,
                    'category' => 'entertainment',
                    'subcategory' => 'nightlife',
                    'tags' => ['cocktails', 'drinks', 'events', 'hookah', 'hookah lounge', 'lounge', 'menu', 'nightlife', 'restaurant', 'shisha', 'shisha bar', 'shop', 'smoking', 'store', 'tobacco'],
                ],
                't59-hookah-bar' => [
                    'title' => esc_html__('Hookah Bar', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 59,
                    'category' => 'retail',
                    'subcategory' => 'retail',
                    'tags' => ['cigarette', 'cigars', 'farm', 'hookah', 'humidors', 'lounge', 'production', 'shisha', 'shop', 'smoking', 'tobacco'],
                ],
                't59-tobacco-shop-lounge' => [
                    'title' => esc_html__('Tobacco Shop & Lounge', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 59,
                    'category' => 'retail',
                    'subcategory' => 'retail',
                    'tags' => ['cigarette', 'cigars', 'farm', 'hookah', 'humidors', 'lounge', 'production', 'shisha', 'shop', 'smoking', 'tobacco'],
                ],
                't59-tobacco-shop' => [
                    'title' => esc_html__('Tobacco Shop', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 59,
                    'category' => 'retail',
                    'subcategory' => 'retail',
                    'tags' => ['cigarette', 'cigars', 'farm', 'hookah', 'humidors', 'lounge', 'production', 'shisha', 'shop', 'smoking', 'tobacco'],
                ],
                't59-tobacco-cigars-landing-page' => [
                    'title' => esc_html__('Tobacco Cigars Landing Page', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 59,
                    'category' => 'retail',
                    'subcategory' => 'retail',
                    'tags' => ['cigarette', 'cigars', 'farm', 'hookah', 'humidors', 'lounge', 'production', 'shisha', 'shop', 'smoking', 'tobacco'],
                ],
                't59-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 59,
                    'category' => 'retail',
                    'subcategory' => 'retail',
                    'tags' => ['cigarette', 'cigars', 'farm', 'hookah', 'humidors', 'lounge', 'production', 'shisha', 'shop', 'smoking', 'tobacco'],
                ],
                't59-our-team' => [
                    'title' => esc_html__('Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 59,
                    'category' => 'retail',
                    'subcategory' => 'retail',
                    'tags' => ['cigarette', 'cigars', 'farm', 'hookah', 'humidors', 'lounge', 'production', 'shisha', 'shop', 'smoking', 'tobacco'],
                ],
                't59-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 59,
                    'category' => 'retail',
                    'subcategory' => 'retail',
                    'tags' => ['cigarette', 'cigars', 'farm', 'hookah', 'humidors', 'lounge', 'production', 'shisha', 'shop', 'smoking', 'tobacco'],
                ],
                't65-shaping-spaces' => [
                    'title' => esc_html__('Shaping Spaces', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 65,
                    'category' => 'business',
                    'subcategory' => 'corporate',
                    'tags' => ['architecture', 'building', 'building company', 'building materials', 'construction', 'construction company', 'construction supplies', 'contractor', 'corporate', 'engineering', 'exterior design', 'industrial', 'remodeling', 'renovation'],
                ],
                't65-standards-in-construction' => [
                    'title' => esc_html__('Standards in Construction', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 65,
                    'category' => 'business',
                    'subcategory' => 'corporate',
                    'tags' => ['architecture', 'building', 'building company', 'building materials', 'construction', 'construction company', 'construction supplies', 'contractor', 'corporate', 'engineering', 'exterior design', 'industrial', 'remodeling', 'renovation'],
                ],
                't65-quality-construction' => [
                    'title' => esc_html__('Quality Construction', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 65,
                    'category' => 'business',
                    'subcategory' => 'corporate',
                    'tags' => ['architecture', 'building', 'building company', 'building materials', 'construction', 'construction company', 'construction supplies', 'contractor', 'corporate', 'engineering', 'exterior design', 'industrial', 'remodeling', 'renovation'],
                ],
                't65-we-build-spaces' => [
                    'title' => esc_html__('We Build Spaces', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 65,
                    'category' => 'business',
                    'subcategory' => 'corporate',
                    'tags' => ['architecture', 'building', 'building company', 'building materials', 'construction', 'construction company', 'construction supplies', 'contractor', 'corporate', 'engineering', 'exterior design', 'industrial', 'remodeling', 'renovation'],
                ],
                't65-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 65,
                    'category' => 'business',
                    'subcategory' => 'corporate',
                    'tags' => ['architecture', 'building', 'building company', 'building materials', 'construction', 'construction company', 'construction supplies', 'contractor', 'corporate', 'engineering', 'exterior design', 'industrial', 'remodeling', 'renovation'],
                ],
                't65-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 65,
                    'category' => 'business',
                    'subcategory' => 'corporate',
                    'tags' => ['architecture', 'building', 'building company', 'building materials', 'construction', 'construction company', 'construction supplies', 'contractor', 'corporate', 'engineering', 'exterior design', 'industrial', 'remodeling', 'renovation'],
                ],
                't65-projects-gallery' => [
                    'title' => esc_html__('Project Gallery', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 65,
                    'category' => 'business',
                    'subcategory' => 'corporate',
                    'tags' => ['architecture', 'building', 'building company', 'building materials', 'construction', 'construction company', 'construction supplies', 'contractor', 'corporate', 'engineering', 'exterior design', 'industrial', 'remodeling', 'renovation'],
                ],
                't65-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 65,
                    'category' => 'business',
                    'subcategory' => 'corporate',
                    'tags' => ['architecture', 'building', 'building company', 'building materials', 'construction', 'construction company', 'construction supplies', 'contractor', 'corporate', 'engineering', 'exterior design', 'industrial', 'remodeling', 'renovation'],
                ],
                't66-your-path-to-knowledge' => [
                    'title' => esc_html__('Your Path to Knowledge', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 66,
                    'category' => 'business',
                    'subcategory' => 'education',
                    'tags' => ['academy', 'classes', 'college', 'course', 'courses', 'e-learning', 'education', 'learning management system', 'online education', 'online courses', 'teacher', 'menthor', 'university', 'school'],
                ],
                't66-learn-anywhere' => [
                    'title' => esc_html__('Learn Anywhere', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 66,
                    'category' => 'business',
                    'subcategory' => 'education',
                    'tags' => ['academy', 'classes', 'college', 'course', 'courses', 'e-learning', 'education', 'learning management system', 'online education', 'online courses', 'teacher', 'menthor', 'university', 'school'],
                ],
                't66-learn-more-grow-faster' => [
                    'title' => esc_html__('Learn More, Grow Faster', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 66,
                    'category' => 'business',
                    'subcategory' => 'education',
                    'tags' => ['academy', 'classes', 'college', 'course', 'courses', 'e-learning', 'education', 'learning management system', 'online education', 'online courses', 'teacher', 'menthor', 'university', 'school'],
                ],
                't66-redefining-education' => [
                    'title' => esc_html__('Redefining Education', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 66,
                    'category' => 'business',
                    'subcategory' => 'education',
                    'tags' => ['academy', 'classes', 'college', 'course', 'courses', 'e-learning', 'education', 'learning management system', 'online education', 'online courses', 'teacher', 'menthor', 'university', 'school'],
                ],
                't66-about-our-platform' => [
                    'title' => esc_html__('About Our Platform', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 66,
                    'category' => 'business',
                    'subcategory' => 'education',
                    'tags' => ['academy', 'classes', 'college', 'course', 'courses', 'e-learning', 'education', 'learning management system', 'online education', 'online courses', 'teacher', 'menthor', 'university', 'school'],
                ],
                't66-our-education-services' => [
                    'title' => esc_html__('About Our Platform', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 66,
                    'category' => 'business',
                    'subcategory' => 'education',
                    'tags' => ['academy', 'classes', 'college', 'course', 'courses', 'e-learning', 'education', 'learning management system', 'online education', 'online courses', 'teacher', 'menthor', 'university', 'school'],
                ],
                't66-our-teachers' => [
                    'title' => esc_html__('Our Teachers', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 66,
                    'category' => 'business',
                    'subcategory' => 'education',
                    'tags' => ['academy', 'classes', 'college', 'course', 'courses', 'e-learning', 'education', 'learning management system', 'online education', 'online courses', 'teacher', 'menthor', 'university', 'school'],
                ],
                't66-contact-our-school' => [
                    'title' => esc_html__('Contact Our School', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 66,
                    'category' => 'business',
                    'subcategory' => 'education',
                    'tags' => ['academy', 'classes', 'college', 'course', 'courses', 'e-learning', 'education', 'learning management system', 'online education', 'online courses', 'teacher', 'menthor', 'university', 'school'],
                ],
                't62-home-glass' => [
                    'title' => esc_html__('Home Glass', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 62,
                    'category' => 'food',
                    'subcategory' => 'retail',
                    'tags' => ['aqua', 'aqua filters', 'bottled water', 'delivery', 'drink water', 'filter', 'filtration', 'mineral water', 'online store', 'water', 'water cleaning', 'water delivery', 'water filter', 'water store'],
                ],
                't62-home-bottles' => [
                    'title' => esc_html__('Home Bottles', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 62,
                    'category' => 'food',
                    'subcategory' => 'retail',
                    'tags' => ['aqua', 'aqua filters', 'bottled water', 'delivery', 'drink water', 'filter', 'filtration', 'mineral water', 'online store', 'water', 'water cleaning', 'water delivery', 'water filter', 'water store'],
                ],
                't62-home-sierra' => [
                    'title' => esc_html__('Home Sierra', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 62,
                    'category' => 'food',
                    'subcategory' => 'retail',
                    'tags' => ['aqua', 'aqua filters', 'bottled water', 'delivery', 'drink water', 'filter', 'filtration', 'mineral water', 'online store', 'water', 'water cleaning', 'water delivery', 'water filter', 'water store'],
                ],
                't62-drinking-water' => [
                    'title' => esc_html__('Drinking Water', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 62,
                    'category' => 'food',
                    'subcategory' => 'retail',
                    'tags' => ['aqua', 'aqua filters', 'bottled water', 'delivery', 'drink water', 'filter', 'filtration', 'mineral water', 'online store', 'water', 'water cleaning', 'water delivery', 'water filter', 'water store'],
                ],
                't62-water-filters' => [
                    'title' => esc_html__('Water Filters', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 62,
                    'category' => 'food',
                    'subcategory' => 'retail',
                    'tags' => ['aqua', 'aqua filters', 'bottled water', 'delivery', 'drink water', 'filter', 'filtration', 'mineral water', 'online store', 'water', 'water cleaning', 'water delivery', 'water filter', 'water store'],
                ],
                't62-home-bottle' => [
                    'title' => esc_html__('Home Bottle', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 62,
                    'category' => 'food',
                    'subcategory' => 'retail',
                    'tags' => ['aqua', 'aqua filters', 'bottled water', 'delivery', 'drink water', 'filter', 'filtration', 'mineral water', 'online store', 'water', 'water cleaning', 'water delivery', 'water filter', 'water store'],
                ],
                't62-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 62,
                    'category' => 'food',
                    'subcategory' => 'retail',
                    'tags' => ['aqua', 'aqua filters', 'bottled water', 'delivery', 'drink water', 'filter', 'filtration', 'mineral water', 'online store', 'water', 'water cleaning', 'water delivery', 'water filter', 'water store'],
                ],
                't62-our-gallery' => [
                    'title' => esc_html__('Our Gallery', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 62,
                    'category' => 'food',
                    'subcategory' => 'retail',
                    'tags' => ['aqua', 'aqua filters', 'bottled water', 'delivery', 'drink water', 'filter', 'filtration', 'mineral water', 'online store', 'water', 'water cleaning', 'water delivery', 'water filter', 'water store'],
                ],
                't62-our-team' => [
                    'title' => esc_html__('Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 62,
                    'category' => 'food',
                    'subcategory' => 'retail',
                    'tags' => ['aqua', 'aqua filters', 'bottled water', 'delivery', 'drink water', 'filter', 'filtration', 'mineral water', 'online store', 'water', 'water cleaning', 'water delivery', 'water filter', 'water store'],
                ],
                't62-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 62,
                    'category' => 'food',
                    'subcategory' => 'retail',
                    'tags' => ['aqua', 'aqua filters', 'bottled water', 'delivery', 'drink water', 'filter', 'filtration', 'mineral water', 'online store', 'water', 'water cleaning', 'water delivery', 'water filter', 'water store'],
                ],
                't60-coffee-house' => [
                    'title' => esc_html__('Coffee House', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 60,
                    'category' => 'food',
                    'subcategory' => 'restaurant',
                    'tags' => ['bakery', 'bar', 'bistro', 'cafe', 'cafe shop', 'coffee', 'coffee house', 'coffee shop', 'drinks', 'food', 'menu', 'organic', 'restaurant', 'store', 'tea'],
                ],
                't60-coffee-bar' => [
                    'title' => esc_html__('Coffee Bar', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 60,
                    'category' => 'food',
                    'subcategory' => 'restaurant',
                    'tags' => ['bakery', 'bar', 'bistro', 'cafe', 'cafe shop', 'coffee', 'coffee house', 'coffee shop', 'drinks', 'food', 'menu', 'organic', 'restaurant', 'store', 'tea'],
                ],
                't60-coffee-shop' => [
                    'title' => esc_html__('Coffee Shop', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 60,
                    'category' => 'food',
                    'subcategory' => 'restaurant',
                    'tags' => ['bakery', 'bar', 'bistro', 'cafe', 'cafe shop', 'coffee', 'coffee house', 'coffee shop', 'drinks', 'food', 'menu', 'organic', 'restaurant', 'store', 'tea'],
                ],
                't60-coffee-palace' => [
                    'title' => esc_html__('Coffee Palace', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 60,
                    'category' => 'food',
                    'subcategory' => 'restaurant',
                    'tags' => ['bakery', 'bar', 'bistro', 'cafe', 'cafe shop', 'coffee', 'coffee house', 'coffee shop', 'drinks', 'food', 'menu', 'organic', 'restaurant', 'store', 'tea'],
                ],
                't60-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 60,
                    'category' => 'food',
                    'subcategory' => 'restaurant',
                    'tags' => ['bakery', 'bar', 'bistro', 'cafe', 'cafe shop', 'coffee', 'coffee house', 'coffee shop', 'drinks', 'food', 'menu', 'organic', 'restaurant', 'store', 'tea'],
                ],
                't60-our-team' => [
                    'title' => esc_html__('Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 60,
                    'category' => 'food',
                    'subcategory' => 'restaurant',
                    'tags' => ['bakery', 'bar', 'bistro', 'cafe', 'cafe shop', 'coffee', 'coffee house', 'coffee shop', 'drinks', 'food', 'menu', 'organic', 'restaurant', 'store', 'tea'],
                ],
                't60-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 60,
                    'category' => 'food',
                    'subcategory' => 'restaurant',
                    'tags' => ['bakery', 'bar', 'bistro', 'cafe', 'cafe shop', 'coffee', 'coffee house', 'coffee shop', 'drinks', 'food', 'menu', 'organic', 'restaurant', 'store', 'tea'],
                ],
                't60-contact-us-2' => [
                    'title' => esc_html__('Contact Us 2', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 60,
                    'category' => 'food',
                    'subcategory' => 'restaurant',
                    'tags' => ['bakery', 'bar', 'bistro', 'cafe', 'cafe shop', 'coffee', 'coffee house', 'coffee shop', 'drinks', 'food', 'menu', 'organic', 'restaurant', 'store', 'tea'],
                ],
                't61-camp-smarter-not-harder' => [
                    'title' => esc_html__('Camp Smarter, Not Harder', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 61,
                    'category' => 'travel',
                    'subcategory' => 'adventure',
                    'tags' => ['accommodation', 'adventure', 'adventure tours', 'adventure travel', 'booking', 'camp', 'camper', 'camping', 'cottages', 'facilities', 'hiking', 'outdoor', 'summer camp', 'travel'],
                ],
                't61-explore-the-wild' => [
                    'title' => esc_html__('Explore the Wild, Not Harder', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 61,
                    'category' => 'travel',
                    'subcategory' => 'adventure',
                    'tags' => ['accommodation', 'adventure', 'adventure tours', 'adventure travel', 'booking', 'camp', 'camper', 'camping', 'cottages', 'facilities', 'hiking', 'outdoor', 'summer camp', 'travel'],
                ],
                't61-explore-camp-repeat' => [
                    'title' => esc_html__('Explore, Camp, Repeat', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 61,
                    'category' => 'travel',
                    'subcategory' => 'adventure',
                    'tags' => ['accommodation', 'adventure', 'adventure tours', 'adventure travel', 'booking', 'camp', 'camper', 'camping', 'cottages', 'facilities', 'hiking', 'outdoor', 'summer camp', 'travel'],
                ],
                't61-essentials-for-every-journey' => [
                    'title' => esc_html__('Essentials for Every Journey', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 61,
                    'category' => 'travel',
                    'subcategory' => 'adventure',
                    'tags' => ['accommodation', 'adventure', 'adventure tours', 'adventure travel', 'booking', 'camp', 'camper', 'camping', 'cottages', 'facilities', 'hiking', 'outdoor', 'summer camp', 'travel'],
                ],
                't61-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 61,
                    'category' => 'travel',
                    'subcategory' => 'adventure',
                    'tags' => ['accommodation', 'adventure', 'adventure tours', 'adventure travel', 'booking', 'camp', 'camper', 'camping', 'cottages', 'facilities', 'hiking', 'outdoor', 'summer camp', 'travel'],
                ],
                't61-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 61,
                    'category' => 'travel',
                    'subcategory' => 'adventure',
                    'tags' => ['accommodation', 'adventure', 'adventure tours', 'adventure travel', 'booking', 'camp', 'camper', 'camping', 'cottages', 'facilities', 'hiking', 'outdoor', 'summer camp', 'travel'],
                ],
                't61-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 61,
                    'category' => 'travel',
                    'subcategory' => 'adventure',
                    'tags' => ['accommodation', 'adventure', 'adventure tours', 'adventure travel', 'booking', 'camp', 'camper', 'camping', 'cottages', 'facilities', 'hiking', 'outdoor', 'summer camp', 'travel'],
                ],

                't73-ink-with-integrity' => [
                    'title' => esc_html__('Ink with Integrity', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 73,
                    'category' => 'health & beauty',
                    'subcategory' => 'tattoo',
                    'tags' => ['piercing studio', 'body art', 'ink', 'inked', 'piercing', 'piercing shop', 'piercing theme', 'studio', 'tattoo', 'tattoo artist', 'tattoo salon', 'tattoo shop', 'tattoo studio'],
                ],
                't73-stories-on-skin' => [
                    'title' => esc_html__('Stories on Skin', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 73,
                    'category' => 'health & beauty',
                    'subcategory' => 'tattoo',
                    'tags' => ['piercing studio', 'body art', 'ink', 'inked', 'piercing', 'piercing shop', 'piercing theme', 'studio', 'tattoo', 'tattoo artist', 'tattoo salon', 'tattoo shop', 'tattoo studio'],
                ],
                't73-precision-art-safe-piercing' => [
                    'title' => esc_html__('Precision Art, Safe Piercing', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 73,
                    'category' => 'health & beauty',
                    'subcategory' => 'tattoo',
                    'tags' => ['piercing studio', 'body art', 'ink', 'inked', 'piercing', 'piercing shop', 'piercing theme', 'studio', 'tattoo', 'tattoo artist', 'tattoo salon', 'tattoo shop', 'tattoo studio'],
                ],
                't73-unforgettable-body-art' => [
                    'title' => esc_html__('Unforgettable Body Art', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 73,
                    'category' => 'health & beauty',
                    'subcategory' => 'tattoo',
                    'tags' => ['piercing studio', 'body art', 'ink', 'inked', 'piercing', 'piercing shop', 'piercing theme', 'studio', 'tattoo', 'tattoo artist', 'tattoo salon', 'tattoo shop', 'tattoo studio'],
                ],
                't73-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 73,
                    'category' => 'health & beauty',
                    'subcategory' => 'tattoo',
                    'tags' => ['piercing studio', 'body art', 'ink', 'inked', 'piercing', 'piercing shop', 'piercing theme', 'studio', 'tattoo', 'tattoo artist', 'tattoo salon', 'tattoo shop', 'tattoo studio'],
                ],
                't73-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 73,
                    'category' => 'health & beauty',
                    'subcategory' => 'tattoo',
                    'tags' => ['piercing studio', 'body art', 'ink', 'inked', 'piercing', 'piercing shop', 'piercing theme', 'studio', 'tattoo', 'tattoo artist', 'tattoo salon', 'tattoo shop', 'tattoo studio'],
                ],
                't73-our-artists' => [
                    'title' => esc_html__('Our Artists', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 73,
                    'category' => 'health & beauty',
                    'subcategory' => 'tattoo',
                    'tags' => ['piercing studio', 'body art', 'ink', 'inked', 'piercing', 'piercing shop', 'piercing theme', 'studio', 'tattoo', 'tattoo artist', 'tattoo salon', 'tattoo shop', 'tattoo studio'],
                ],
                't73-our-works' => [
                    'title' => esc_html__('Our Works', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 73,
                    'category' => 'health & beauty',
                    'subcategory' => 'tattoo',
                    'tags' => ['piercing studio', 'body art', 'ink', 'inked', 'piercing', 'piercing shop', 'piercing theme', 'studio', 'tattoo', 'tattoo artist', 'tattoo salon', 'tattoo shop', 'tattoo studio'],
                ],
                't73-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 73,
                    'category' => 'health & beauty',
                    'subcategory' => 'tattoo',
                    'tags' => ['piercing studio', 'body art', 'ink', 'inked', 'piercing', 'piercing shop', 'piercing theme', 'studio', 'tattoo', 'tattoo artist', 'tattoo salon', 'tattoo shop', 'tattoo studio'],
                ],

                't74-built-for-victory' => [
                    'title' => esc_html__('Built for Victory', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 74,
                    'category' => 'Entertainment',
                    'subcategory' => 'eSports',
                    'tags' => ['esports', 'esports website', 'fantasy', 'game', 'game portal', 'game studio', 'game website', 'gamer', 'gaming', 'gaming community', 'rpg', 'streamer', 'tournament', 'tournament gaming', 'video game'],
                ],
                't74-where-legends-are-made' => [
                    'title' => esc_html__('Where Legends Are Made', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 74,
                    'category' => 'Entertainment',
                    'subcategory' => 'eSports',
                    'tags' => ['esports', 'esports website', 'fantasy', 'game', 'game portal', 'game studio', 'game website', 'gamer', 'gaming', 'gaming community', 'rpg', 'streamer', 'tournament', 'tournament gaming', 'video game'],
                ],
                't74-win-as-one' => [
                    'title' => esc_html__('Win as One', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 74,
                    'category' => 'Entertainment',
                    'subcategory' => 'eSports',
                    'tags' => ['esports', 'esports website', 'fantasy', 'game', 'game portal', 'game studio', 'game website', 'gamer', 'gaming', 'gaming community', 'rpg', 'streamer', 'tournament', 'tournament gaming', 'video game'],
                ],
                't74-play-with-purpose' => [
                    'title' => esc_html__('Play with Purpose', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 74,
                    'category' => 'Entertainment',
                    'subcategory' => 'eSports',
                    'tags' => ['esports', 'esports website', 'fantasy', 'game', 'game portal', 'game studio', 'game website', 'gamer', 'gaming', 'gaming community', 'rpg', 'streamer', 'tournament', 'tournament gaming', 'video game'],
                ],
                't74-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 74,
                    'category' => 'Entertainment',
                    'subcategory' => 'eSports',
                    'tags' => ['esports', 'esports website', 'fantasy', 'game', 'game portal', 'game studio', 'game website', 'gamer', 'gaming', 'gaming community', 'rpg', 'streamer', 'tournament', 'tournament gaming', 'video game'],
                ],
                't74-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 74,
                    'category' => 'Entertainment',
                    'subcategory' => 'eSports',
                    'tags' => ['esports', 'esports website', 'fantasy', 'game', 'game portal', 'game studio', 'game website', 'gamer', 'gaming', 'gaming community', 'rpg', 'streamer', 'tournament', 'tournament gaming', 'video game'],
                ],
                't74-our-team' => [
                    'title' => esc_html__('Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 74,
                    'category' => 'Entertainment',
                    'subcategory' => 'eSports',
                    'tags' => ['esports', 'esports website', 'fantasy', 'game', 'game portal', 'game studio', 'game website', 'gamer', 'gaming', 'gaming community', 'rpg', 'streamer', 'tournament', 'tournament gaming', 'video game'],
                ],
                't74-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 74,
                    'category' => 'Entertainment',
                    'subcategory' => 'eSports',
                    'tags' => ['esports', 'esports website', 'fantasy', 'game', 'game portal', 'game studio', 'game website', 'gamer', 'gaming', 'gaming community', 'rpg', 'streamer', 'tournament', 'tournament gaming', 'video game'],
                ],

                't63-fresh-flowers-fresh-smiles' => [
                    'title' => esc_html__('Fresh Flowers, Fresh Smiles', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 63,
                    'category' => 'retail',
                    'subcategory' => 'retail',
                    'tags' => ['bouquet', 'floral', 'floral design', 'floral shop', 'floriculture', 'florist', 'florist shop', 'flower arrangement', 'flower decoration', 'flower shop', 'flowers', 'garden', 'gardening', 'plant', 'shop'],
                ],
                't63-handcrafted-joy' => [
                    'title' => esc_html__('Handcrafted Joy', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 63,
                    'category' => 'retail',
                    'subcategory' => 'retail',
                    'tags' => ['bouquet', 'floral', 'floral design', 'floral shop', 'floriculture', 'florist', 'florist shop', 'flower arrangement', 'flower decoration', 'flower shop', 'flowers', 'garden', 'gardening', 'plant', 'shop'],
                ],
                't63-more-than-flowers' => [
                    'title' => esc_html__('More Than FLowers', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 63,
                    'category' => 'retail',
                    'subcategory' => 'retail',
                    'tags' => ['bouquet', 'floral', 'floral design', 'floral shop', 'floriculture', 'florist', 'florist shop', 'flower arrangement', 'flower decoration', 'flower shop', 'flowers', 'garden', 'gardening', 'plant', 'shop'],
                ],
                't63-the-art-of-floral-design' => [
                    'title' => esc_html__('The Art of Floral Design', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 63,
                    'category' => 'retail',
                    'subcategory' => 'retail',
                    'tags' => ['bouquet', 'floral', 'floral design', 'floral shop', 'floriculture', 'florist', 'florist shop', 'flower arrangement', 'flower decoration', 'flower shop', 'flowers', 'garden', 'gardening', 'plant', 'shop'],
                ],
                't63-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 63,
                    'category' => 'retail',
                    'subcategory' => 'retail',
                    'tags' => ['bouquet', 'floral', 'floral design', 'floral shop', 'floriculture', 'florist', 'florist shop', 'flower arrangement', 'flower decoration', 'flower shop', 'flowers', 'garden', 'gardening', 'plant', 'shop'],
                ],
                't63-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 63,
                    'category' => 'retail',
                    'subcategory' => 'retail',
                    'tags' => ['bouquet', 'floral', 'floral design', 'floral shop', 'floriculture', 'florist', 'florist shop', 'flower arrangement', 'flower decoration', 'flower shop', 'flowers', 'garden', 'gardening', 'plant', 'shop'],
                ],
                't63-gallery' => [
                    'title' => esc_html__('Gallery', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 63,
                    'category' => 'retail',
                    'subcategory' => 'retail',
                    'tags' => ['bouquet', 'floral', 'floral design', 'floral shop', 'floriculture', 'florist', 'florist shop', 'flower arrangement', 'flower decoration', 'flower shop', 'flowers', 'garden', 'gardening', 'plant', 'shop'],
                ],
                't63-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 63,
                    'category' => 'retail',
                    'subcategory' => 'retail',
                    'tags' => ['bouquet', 'floral', 'floral design', 'floral shop', 'floriculture', 'florist', 'florist shop', 'flower arrangement', 'flower decoration', 'flower shop', 'flowers', 'garden', 'gardening', 'plant', 'shop'],
                ],
                't64-love-in-every-detail' => [
                    'title' => esc_html__('Love in Every Detail', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 64,
                    'category' => 'business',
                    'subcategory' => 'wedding',
                    'tags' => ['bride', 'florist', 'invitation', 'marriage', 'photography', 'wedding', 'wedding business', 'wedding dress', 'wedding dress shop', 'wedding gallery', 'wedding photography', 'wedding planner', 'wedding theme', 'wedding venue'],
                ],
                't64-exceptional-weddings' => [
                    'title' => esc_html__('Exceptional Weddings', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 64,
                    'category' => 'business',
                    'subcategory' => 'wedding',
                    'tags' => ['bride', 'florist', 'invitation', 'marriage', 'photography', 'wedding', 'wedding business', 'wedding dress', 'wedding dress shop', 'wedding gallery', 'wedding photography', 'wedding planner', 'wedding theme', 'wedding venue'],
                ],
                't64-dream-wedding' => [
                    'title' => esc_html__('Dream Wedding', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 64,
                    'category' => 'business',
                    'subcategory' => 'wedding',
                    'tags' => ['bride', 'florist', 'invitation', 'marriage', 'photography', 'wedding', 'wedding business', 'wedding dress', 'wedding dress shop', 'wedding gallery', 'wedding photography', 'wedding planner', 'wedding theme', 'wedding venue'],
                ],
                't64-fairytale-weddings' => [
                    'title' => esc_html__('Fairytale Weddings', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 64,
                    'category' => 'business',
                    'subcategory' => 'wedding',
                    'tags' => ['bride', 'florist', 'invitation', 'marriage', 'photography', 'wedding', 'wedding business', 'wedding dress', 'wedding dress shop', 'wedding gallery', 'wedding photography', 'wedding planner', 'wedding theme', 'wedding venue'],
                ],
                't64-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 64,
                    'category' => 'business',
                    'subcategory' => 'wedding',
                    'tags' => ['bride', 'florist', 'invitation', 'marriage', 'photography', 'wedding', 'wedding business', 'wedding dress', 'wedding dress shop', 'wedding gallery', 'wedding photography', 'wedding planner', 'wedding theme', 'wedding venue'],
                ],
                't64-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 64,
                    'category' => 'business',
                    'subcategory' => 'wedding',
                    'tags' => ['bride', 'florist', 'invitation', 'marriage', 'photography', 'wedding', 'wedding business', 'wedding dress', 'wedding dress shop', 'wedding gallery', 'wedding photography', 'wedding planner', 'wedding theme', 'wedding venue'],
                ],
                't64-our-gallery' => [
                    'title' => esc_html__('Our Gallery', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 64,
                    'category' => 'business',
                    'subcategory' => 'wedding',
                    'tags' => ['bride', 'florist', 'invitation', 'marriage', 'photography', 'wedding', 'wedding business', 'wedding dress', 'wedding dress shop', 'wedding gallery', 'wedding photography', 'wedding planner', 'wedding theme', 'wedding venue'],
                ],
                't64-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 64,
                    'category' => 'business',
                    'subcategory' => 'wedding',
                    'tags' => ['bride', 'florist', 'invitation', 'marriage', 'photography', 'wedding', 'wedding business', 'wedding dress', 'wedding dress shop', 'wedding gallery', 'wedding photography', 'wedding planner', 'wedding theme', 'wedding venue'],
                ],
                't67-exceptional-drinks' => [
                    'title' => esc_html__('Exceptional Drinks', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 67,
                    'category' => 'food',
                    'subcategory' => 'retail',
                    'tags' => ['alcohol', 'blog', 'drinks', 'liquor', 'liquor store', 'store', 'vineyard', 'wine', 'wine bar', 'wine house', 'wine producer', 'wine shop', 'wine store', 'winery'],
                ],
                't67-luxury-in-every-bottle' => [
                    'title' => esc_html__('Luxury in Every Bottle', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 67,
                    'category' => 'food',
                    'subcategory' => 'retail',
                    'tags' => ['alcohol', 'blog', 'drinks', 'liquor', 'liquor store', 'store', 'vineyard', 'wine', 'wine bar', 'wine house', 'wine producer', 'wine shop', 'wine store', 'winery'],
                ],
                't67-premium-wines' => [
                    'title' => esc_html__('Premium Wines', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 67,
                    'category' => 'food',
                    'subcategory' => 'retail',
                    'tags' => ['alcohol', 'blog', 'drinks', 'liquor', 'liquor store', 'store', 'vineyard', 'wine', 'wine bar', 'wine house', 'wine producer', 'wine shop', 'wine store', 'winery'],
                ],
                't67-sparkling-wines' => [
                    'title' => esc_html__('Sparkling Wines', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 67,
                    'category' => 'food',
                    'subcategory' => 'retail',
                    'tags' => ['alcohol', 'blog', 'drinks', 'liquor', 'liquor store', 'store', 'vineyard', 'wine', 'wine bar', 'wine house', 'wine producer', 'wine shop', 'wine store', 'winery'],
                ],
                't67-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 67,
                    'category' => 'food',
                    'subcategory' => 'retail',
                    'tags' => ['alcohol', 'blog', 'drinks', 'liquor', 'liquor store', 'store', 'vineyard', 'wine', 'wine bar', 'wine house', 'wine producer', 'wine shop', 'wine store', 'winery'],
                ],
                't67-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 67,
                    'category' => 'food',
                    'subcategory' => 'retail',
                    'tags' => ['alcohol', 'blog', 'drinks', 'liquor', 'liquor store', 'store', 'vineyard', 'wine', 'wine bar', 'wine house', 'wine producer', 'wine shop', 'wine store', 'winery'],
                ],
                't67-vineyard' => [
                    'title' => esc_html__('Vineyard', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 67,
                    'category' => 'food',
                    'subcategory' => 'retail',
                    'tags' => ['alcohol', 'blog', 'drinks', 'liquor', 'liquor store', 'store', 'vineyard', 'wine', 'wine bar', 'wine house', 'wine producer', 'wine shop', 'wine store', 'winery'],
                ],
                't67-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 67,
                    'category' => 'food',
                    'subcategory' => 'retail',
                    'tags' => ['alcohol', 'blog', 'drinks', 'liquor', 'liquor store', 'store', 'vineyard', 'wine', 'wine bar', 'wine house', 'wine producer', 'wine shop', 'wine store', 'winery'],
                ],

                't68-fast-fixes-lasting-quality' => [
                    'title' => esc_html__('Fast Fixes Lasting Quality', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 68,
                    'category' => 'business',
                    'subcategory' => 'services',
                    'tags' => ['business', 'cleaning', 'tiling', 'constructor', 'consulting', 'corporate', 'handyman', 'industry', 'marketing', 'painter', 'plumber', 'plumbing', 'remodeling', 'repair', 'roofing'],
                ],
                't68-plumbing-repairs' => [
                    'title' => esc_html__('Plumbing Repairs', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 68,
                    'category' => 'business',
                    'subcategory' => 'services',
                    'tags' => ['business', 'cleaning', 'tiling', 'constructor', 'consulting', 'corporate', 'handyman', 'industry', 'marketing', 'painter', 'plumber', 'plumbing', 'remodeling', 'repair', 'roofing'],
                ],
                't68-emergency-repairs' => [
                    'title' => esc_html__('Emergency Repairs', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 68,
                    'category' => 'business',
                    'subcategory' => 'services',
                    'tags' => ['business', 'cleaning', 'tiling', 'constructor', 'consulting', 'corporate', 'handyman', 'industry', 'marketing', 'painter', 'plumber', 'plumbing', 'remodeling', 'repair', 'roofing'],
                ],
                't68-quality-repairs-reliable-service' => [
                    'title' => esc_html__('Quality Repairs Reliable Service', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 68,
                    'category' => 'business',
                    'subcategory' => 'services',
                    'tags' => ['business', 'cleaning', 'tiling', 'constructor', 'consulting', 'corporate', 'handyman', 'industry', 'marketing', 'painter', 'plumber', 'plumbing', 'remodeling', 'repair', 'roofing'],
                ],
                't68-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 68,
                    'category' => 'business',
                    'subcategory' => 'services',
                    'tags' => ['business', 'cleaning', 'tiling', 'constructor', 'consulting', 'corporate', 'handyman', 'industry', 'marketing', 'painter', 'plumber', 'plumbing', 'remodeling', 'repair', 'roofing'],
                ],
                't68-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 68,
                    'category' => 'business',
                    'subcategory' => 'services',
                    'tags' => ['business', 'cleaning', 'tiling', 'constructor', 'consulting', 'corporate', 'handyman', 'industry', 'marketing', 'painter', 'plumber', 'plumbing', 'remodeling', 'repair', 'roofing'],
                ],
                't68-our-team' => [
                    'title' => esc_html__('Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 68,
                    'category' => 'business',
                    'subcategory' => 'services',
                    'tags' => ['business', 'cleaning', 'tiling', 'constructor', 'consulting', 'corporate', 'handyman', 'industry', 'marketing', 'painter', 'plumber', 'plumbing', 'remodeling', 'repair', 'roofing'],
                ],
                't68-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 68,
                    'category' => 'business',
                    'subcategory' => 'services',
                    'tags' => ['business', 'cleaning', 'tiling', 'constructor', 'consulting', 'corporate', 'handyman', 'industry', 'marketing', 'painter', 'plumber', 'plumbing', 'remodeling', 'repair', 'roofing'],
                ],

                't69-premium-barber' => [
                    'title' => esc_html__('Premium Barber', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 69,
                    'category' => 'health & beauty',
                    'subcategory' => 'beauty',
                    'tags' => ['barber', 'barber shop', 'barbershop', 'beard', 'beauty', 'coiffeur', 'hair salon', 'haircut', 'hairdresser', 'hipster', 'mustache'],
                ],
                't69-unleash-your-best-look' => [
                    'title' => esc_html__('Unleash Your Best Look', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 69,
                    'category' => 'health & beauty',
                    'subcategory' => 'beauty',
                    'tags' => ['barber', 'barber shop', 'barbershop', 'beard', 'beauty', 'coiffeur', 'hair salon', 'haircut', 'hairdresser', 'hipster', 'mustache'],
                ],
                't69-elevate-your-look' => [
                    'title' => esc_html__('Elevate Your Look', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 69,
                    'category' => 'health & beauty',
                    'subcategory' => 'beauty',
                    'tags' => ['barber', 'barber shop', 'barbershop', 'beard', 'beauty', 'coiffeur', 'hair salon', 'haircut', 'hairdresser', 'hipster', 'mustache'],
                ],
                't69-perfect-cut' => [
                    'title' => esc_html__('Perfect Cut', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 69,
                    'category' => 'health & beauty',
                    'subcategory' => 'beauty',
                    'tags' => ['barber', 'barber shop', 'barbershop', 'beard', 'beauty', 'coiffeur', 'hair salon', 'haircut', 'hairdresser', 'hipster', 'mustache'],
                ],
                't69-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 69,
                    'category' => 'health & beauty',
                    'subcategory' => 'beauty',
                    'tags' => ['barber', 'barber shop', 'barbershop', 'beard', 'beauty', 'coiffeur', 'hair salon', 'haircut', 'hairdresser', 'hipster', 'mustache'],
                ],
                't69-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 69,
                    'category' => 'health & beauty',
                    'subcategory' => 'beauty',
                    'tags' => ['barber', 'barber shop', 'barbershop', 'beard', 'beauty', 'coiffeur', 'hair salon', 'haircut', 'hairdresser', 'hipster', 'mustache'],
                ],
                't69-pricing' => [
                    'title' => esc_html__('Pricing', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 69,
                    'category' => 'health & beauty',
                    'subcategory' => 'beauty',
                    'tags' => ['barber', 'barber shop', 'barbershop', 'beard', 'beauty', 'coiffeur', 'hair salon', 'haircut', 'hairdresser', 'hipster', 'mustache'],
                ],
                't69-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 69,
                    'category' => 'health & beauty',
                    'subcategory' => 'beauty',
                    'tags' => ['barber', 'barber shop', 'barbershop', 'beard', 'beauty', 'coiffeur', 'hair salon', 'haircut', 'hairdresser', 'hipster', 'mustache'],
                ],

                't70-invest-in-success' => [
                    'title' => esc_html__('Invest in Success', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 70,
                    'category' => 'business',
                    'subcategory' => 'insurance',
                    'tags' => ['accounting', 'advisory', 'agents', 'auto insurance', 'broker', 'consultation', 'finance', 'health insurance', 'insurance', 'insurance agency', 'insurance agent', 'insurance company', 'life insurance', 'loan'],
                ],
                't70-protecting-what-really-matters' => [
                    'title' => esc_html__('Protecting What Really Matters', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 70,
                    'category' => 'business',
                    'subcategory' => 'insurance',
                    'tags' => ['accounting', 'advisory', 'agents', 'auto insurance', 'broker', 'consultation', 'finance', 'health insurance', 'insurance', 'insurance agency', 'insurance agent', 'insurance company', 'life insurance', 'loan'],
                ],
                't70-innovative-insurance-solutions' => [
                    'title' => esc_html__('Innovative Insurance Solutions', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 70,
                    'category' => 'business',
                    'subcategory' => 'insurance',
                    'tags' => ['accounting', 'advisory', 'agents', 'auto insurance', 'broker', 'consultation', 'finance', 'health insurance', 'insurance', 'insurance agency', 'insurance agent', 'insurance company', 'life insurance', 'loan'],
                ],
                't70-empower-your-future' => [
                    'title' => esc_html__('Empower Your Future', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 70,
                    'category' => 'business',
                    'subcategory' => 'insurance',
                    'tags' => ['accounting', 'advisory', 'agents', 'auto insurance', 'broker', 'consultation', 'finance', 'health insurance', 'insurance', 'insurance agency', 'insurance agent', 'insurance company', 'life insurance', 'loan'],
                ],
                't70-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 70,
                    'category' => 'business',
                    'subcategory' => 'insurance',
                    'tags' => ['accounting', 'advisory', 'agents', 'auto insurance', 'broker', 'consultation', 'finance', 'health insurance', 'insurance', 'insurance agency', 'insurance agent', 'insurance company', 'life insurance', 'loan'],
                ],
                't70-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 70,
                    'category' => 'business',
                    'subcategory' => 'insurance',
                    'tags' => ['accounting', 'advisory', 'agents', 'auto insurance', 'broker', 'consultation', 'finance', 'health insurance', 'insurance', 'insurance agency', 'insurance agent', 'insurance company', 'life insurance', 'loan'],
                ],
                't70-our-team' => [
                    'title' => esc_html__('Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 70,
                    'category' => 'business',
                    'subcategory' => 'insurance',
                    'tags' => ['accounting', 'advisory', 'agents', 'auto insurance', 'broker', 'consultation', 'finance', 'health insurance', 'insurance', 'insurance agency', 'insurance agent', 'insurance company', 'life insurance', 'loan'],
                ],
                't70-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 70,
                    'category' => 'business',
                    'subcategory' => 'insurance',
                    'tags' => ['accounting', 'advisory', 'agents', 'auto insurance', 'broker', 'consultation', 'finance', 'health insurance', 'insurance', 'insurance agency', 'insurance agent', 'insurance company', 'life insurance', 'loan'],
                ],

                't71-your-fitness-journey' => [
                    'title' => esc_html__('Your Fitness Journey', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 71,
                    'category' => 'health & beauty',
                    'subcategory' => 'fitness',
                    'tags' => ['bodybuilding', 'class', 'trainer', 'coach', 'fitness', 'fitness gym', 'gym', 'health', 'martial arts', 'personal trainer', 'sport', 'sports', 'training', 'workout'],
                ],
                't71-push-your-limits' => [
                    'title' => esc_html__('Push Your Limits', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 71,
                    'category' => 'health & beauty',
                    'subcategory' => 'fitness',
                    'tags' => ['bodybuilding', 'class', 'trainer', 'coach', 'fitness', 'fitness gym', 'gym', 'health', 'martial arts', 'personal trainer', 'sport', 'sports', 'training', 'workout'],
                ],
                't71-transform-your-body' => [
                    'title' => esc_html__('Transform Your Body', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 71,
                    'category' => 'health & beauty',
                    'subcategory' => 'fitness',
                    'tags' => ['bodybuilding', 'class', 'trainer', 'coach', 'fitness', 'fitness gym', 'gym', 'health', 'martial arts', 'personal trainer', 'sport', 'sports', 'training', 'workout'],
                ],
                't71-strength-starts-here' => [
                    'title' => esc_html__('Strength Starts Here', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 71,
                    'category' => 'health & beauty',
                    'subcategory' => 'fitness',
                    'tags' => ['bodybuilding', 'class', 'trainer', 'coach', 'fitness', 'fitness gym', 'gym', 'health', 'martial arts', 'personal trainer', 'sport', 'sports', 'training', 'workout'],
                ],
                't71-about-us' => [
                    'title' => esc_html__('About Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 71,
                    'category' => 'health & beauty',
                    'subcategory' => 'fitness',
                    'tags' => ['bodybuilding', 'class', 'trainer', 'coach', 'fitness', 'fitness gym', 'gym', 'health', 'martial arts', 'personal trainer', 'sport', 'sports', 'training', 'workout'],
                ],
                't71-our-services' => [
                    'title' => esc_html__('Our Services', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 71,
                    'category' => 'health & beauty',
                    'subcategory' => 'fitness',
                    'tags' => ['bodybuilding', 'class', 'trainer', 'coach', 'fitness', 'fitness gym', 'gym', 'health', 'martial arts', 'personal trainer', 'sport', 'sports', 'training', 'workout'],
                ],
                't71-our-team' => [
                    'title' => esc_html__('Our Team', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 71,
                    'category' => 'health & beauty',
                    'subcategory' => 'fitness',
                    'tags' => ['bodybuilding', 'class', 'trainer', 'coach', 'fitness', 'fitness gym', 'gym', 'health', 'martial arts', 'personal trainer', 'sport', 'sports', 'training', 'workout'],
                ],
                't71-contact-us' => [
                    'title' => esc_html__('Contact Us', 'king-addons'),
                    'plan' => 'premium',
                    'collection' => 71,
                    'category' => 'health & beauty',
                    'subcategory' => 'fitness',
                    'tags' => ['bodybuilding', 'class', 'trainer', 'coach', 'fitness', 'fitness gym', 'gym', 'health', 'martial arts', 'personal trainer', 'sport', 'sports', 'training', 'workout'],
                ],

                // t75 is the next

                /* ================================= */
                /* ================================= */
                /* ================================= */
            ]
        ];
    }
}
