<?php

namespace AxtraEssentialApp\Widgets;

use Elementor\Controls_Manager;
use Elementor\Control_Media;
use Elementor\Utils;
use Elementor\Group_Control_Text_Stroke;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Group_Control_Image_Size;
use Elementor\Repeater;
use Elementor\Group_Control_Css_Filter;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;
use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) {
	exit;   // Exit if accessed directly.
}

class Blog_Search_Form extends \Elementor\Widget_Base {
   
	public function get_name() {
		return 'wcf--blog--search--form';
	}

	public function get_title() {
		return wcf_elementor_widget_concat_prefix( 'Search Form' );
	}
	
	public function get_icon() {
		return 'wcf eicon-search';
	}

	public function get_categories() {
		return [ 'wcf-blog-search' ];
	}

	public function get_keywords() {
		return ['search','form', 'search form' ];
	}
	  	
	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'Content', 'axtra-essential' ),
			]
		);
		
		$this->add_control(
			'preset',
			[
				'label'   => esc_html__( 'Preset', 'axtra-essential' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'default'   => 'default',
					'style1'   => 'Style 1',				
					'style2'   => 'Style 2',				
					'style3'   => 'Style 3',				
					'style4'   => 'Style 4',				
				],
				'default' => 'default',
			]
		);
		
	
		$this->add_control(
			'button_text',
			[
				'label'   => esc_html__( 'Button Text', 'axtra-essential' ),
				'type'    => Controls_Manager::TEXT,
				'default' => 'Submit',
				'ai'      => [
					'active' => false,
				],
				'dynamic' => [
					'active' => false,
				],
				'condition' => ['preset!' => 'default']
			]
		);
		
		$this->add_control(
			'icon',
			[
				'label' => esc_html__( 'Icon', 'axtra-essential' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'condition' => ['preset!' => 'default']
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style',
			[
				'label' => __( 'Input', 'axtra-essential' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Text Color', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} input' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'typography',
				'selector' => '{{WRAPPER}} input',
			]
		);
		
		$this->add_control(
			'placeholder_color',
			[
				'label'     => esc_html__( 'Placeholder Color', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} input::placeholder' => 'color: {{VALUE}};',
					'{{WRAPPER}} input::-webkit-input-placeholder'   => 'color: {{VALUE}};',
					'{{WRAPPER}} input::-moz-placeholder'            => 'color: {{VALUE}};',
					'{{WRAPPER}} input:-ms-input-placeholder'        => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'contactform_input_box_height',
			[
				'label'     => __( 'Height', 'axtra-essential' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'max' => 150,
					],
				],
				'default'   => [
					'size' => 55,
				],

				'selectors' => [
					'{{WRAPPER}} input'   => 'height: {{SIZE}}{{UNIT}};',					
				],
			]
		);
		
		$this->add_responsive_control(
			'contactform_input_box_width',
			[
				'label'     => __( 'Width', 'axtra-essential' ),
				'type'      => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em' ],
				'range'     => [
					'px' => [
						'max' => 150,
					],					
				],				
				'selectors' => [
					'{{WRAPPER}} input'   => 'width: {{SIZE}}{{UNIT}};',					
				],
			]
		);
		
		$this->add_control(
			'contactform_input_box_background',
			[
				'label'     => __( 'Background Color', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} input'   => 'background-color: {{VALUE}};',				
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'contactform_input_box_border',
				'label'    => __( 'Border', 'wcf' ),
				'selector' => '{{WRAPPER}} input',
			]
		);
		
		$this->add_responsive_control(
			'contactform_input_box_border_radius',
			[
				'label'     => __( 'Border Radius', 'axtra-essential' ),
				'type'      => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} input'   => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',					
				],
				'separator' => 'before',
			]
		);
		
		$this->add_responsive_control(
			'contactform_input_box_padding',
			[
				'label'      => __( 'Padding', 'axtra-essential' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} input'   => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'  => 'before',
			]
		);

		$this->add_responsive_control(
			'contactform_input_box_margin',
			[
				'label'      => __( 'Margin', 'axtra-essential' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} input[type*="text"]'   => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'  => 'before',
			]
		);
	
		$this->end_controls_section();
		
		$this->start_controls_section(
			'section_icon_style',
			[
				'label' => __( 'Search Icon / Text', 'axtra-essential' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'search_color',
			[
				'label'     => esc_html__( 'Color', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} button' => 'color: {{VALUE}};',
					'{{WRAPPER}} button i' => 'color: {{VALUE}};',
					'{{WRAPPER}} svg' => 'fill: {{VALUE}};',
				],
			]
		);
		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'search_typography',
				'selector' => '{{WRAPPER}} button',
			]
		);
		
		$this->add_responsive_control(
			'contactform_icon_box_padding',
			[
				'label'      => __( 'Padding', 'axtra-essential' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} button'   => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					
				],
				'separator'  => 'before',
			]
		);
		
		$this->add_responsive_control(
			'contactform_icon_box_margin',
			[
				'label'      => __( 'Margin', 'axtra-essential' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} button'   => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',				
				],
				'separator'  => 'before',
			]
		);
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'contactform_text_box_border',
				'label'    => __( 'Border', 'axtra-essential' ),
				'selector' => '{{WRAPPER}} button',
			]
		);
		
		$this->add_responsive_control(
			'contactform_text_box_border_radius',
			[
				'label'     => __( 'Border Radius', 'axtra-essential' ),
				'type'      => Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} button'   => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px;',					
				],
				'separator' => 'before',
			]
		);
		
		$this->add_control(
			'contactform_button_box_background',
			[
				'label'     => __( 'Background Color', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} button'   => 'background-color: {{VALUE}};',				
				],
			]
		);
		
		$this->add_control(
			'button_width',
			[
				'label' => esc_html__( 'Button Width', 'axtra-essential' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],				
				'selectors' => [
					'{{WRAPPER}} button' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		
		$this->add_control(
			'button__align',
			[
				'label' => esc_html__( 'Alignment', 'axtra-essential' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'axtra-essential' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'axtra-essential' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'axtra-essential' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'left',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} button' => 'text-align: {{VALUE}};',
				],
				'condition' => [
					'preset' => ['style2']
				]
			]
		);
		
		$this->end_controls_section();
	}
	
	protected function render() {	
        $settings = $this->get_settings_for_display();      
		?>
		<?php if($settings['preset'] === 'default'){ ?>
	        <?php echo get_search_form(); ?>
	    <?php } ?>
	    <?php if($settings['preset'] === 'style1'){ ?>
			<div class="default-search__again-form">
				<form  method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>" class="joya-search-form">
				    <input name="s" type="text" value="<?php echo get_search_query(); ?>" placeholder="<?php echo esc_attr__('Search here','axtra-essential'); ?>">
					<button>
					 <?php echo $settings['button_text'] ?>
					 <?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
					</button>
				</form>
			</div>
	    <?php } ?>
		<?php if($settings['preset'] === 'style2' || $settings['preset'] === 'style3'){ ?>
			<div class="default-search__again-form">
				<form  method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>" class="joya-search-form position-static">
				    <input name="s" value="<?php echo get_search_query(); ?>" type="text" placeholder="<?php echo esc_attr__('Search here','axtra-essential'); ?>">
					<button class="position-static text-center <?php echo $settings['preset'] === 'style3' ? 'w-100' : ''; ?>" style="transform:none">
					 <?php echo $settings['button_text']; ?>
					 <?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
					</button>
				</form>
			</div>
	    <?php } ?>
	    
	    <?php if($settings['preset'] === 'style4'){ ?>
			<div class="default-search__again-form">
				<form  method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>" class="joya-search-form position-static d-flex">
				    <input value="<?php echo get_search_query(); ?>" name="s" type="text" placeholder="<?php echo esc_attr__('Search here','axtra-essential'); ?>">
					<button class="position-static" style="transform:none">
					 <?php echo $settings['button_text']; ?>
					 <?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
					</button>
				</form>
			</div>
	    <?php } ?>
		<?php
	}
}