<?php

namespace AxtraEssentialApp\Widgets;

use Elementor\Controls_Manager;
use Elementor\Control_Media;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Text_Stroke;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Group_Control_Image_Size;
use Elementor\Repeater;
use Elementor\Group_Control_Css_Filter;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;
use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) {
	exit;   // Exit if accessed directly.
}

class Blog_Post_Paginate extends \Elementor\Widget_Base {
   
	public function get_name() {
		return 'wcf--blog--post--paginate';
	}

	public function get_title() {
		return wcf_elementor_widget_concat_prefix( 'Post Paginate' );
	}
	
	public function get_icon() {
		return 'wcf eicon-navigation-horizontal';
	}

	public function get_categories() {
		return [ 'wcf-blog-single' ];
	}

	public function get_keywords() {
		return ['navigate', 'post paginate' ];
	}

	public function get_style_depends() {
		wp_register_style( 'meta-info', AXTRA_ESSENTIAL_ASSETS_URL . 'css/meta-info.css' );
		return [ 'meta-info' ];
	}

	  	
	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'Settings', 'axtra-essential' ),
			]
		);
		
		$this->add_control(
			'preset_style',
			[
				'label' => esc_html__( 'Preset Style', 'axtra-essential' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'solid',
				'options' => [
					'' => esc_html__( 'Default', 'axtra-essential' ),
					'layout-2' => esc_html__( 'Layout 2', 'axtra-essential' ),
					
				],				
			]
		);

		$this->add_control(
			'show_title',
			[
				'label' => esc_html__( 'Show Title', 'axtra-essential' ),
				'type' =>Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'axtra-essential' ),
				'label_off' => esc_html__( 'Hide', 'axtra-essential' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		// Previous
		$this->add_control(
			'enable_prev',
			[
				'label' => esc_html__( 'Enable Prev', 'axtra-essential' ),
				'type' =>Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'axtra-essential' ),
				'label_off' => esc_html__( 'No', 'axtra-essential' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'prev_heading',
			[
				'label' => esc_html__( 'Previous', 'axtra-essential' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => ['enable_prev' => ['yes']]
			]
		);

		$this->add_control(
			'prev_title',
			[
				'label'       => esc_html__( 'Title', 'axtra-essential' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'Previous Post', 'axtra-essential' ),
				'placeholder' => esc_html__( 'Type prev title', 'axtra-essential' ),
				'condition'   => ['enable_prev' => ['yes']]
			]
		);

		$this->add_control(
			'prev_icon',
			[
				'label' => esc_html__( 'Icon', 'axtra-essential' ),
				'type' => Controls_Manager::ICONS,
				'default' => [
					
				],
				'condition' => ['enable_prev' => ['yes']]
			]
		);

		// Next
		$this->add_control(
			'enable_next',
			[
				'label'        => esc_html__( 'Enable Next', 'axtra-essential' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', 'axtra-essential' ),
				'label_off'    => esc_html__( 'No', 'axtra-essential' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);
		$this->add_control(
			'next_heading',
			[
				'label' => esc_html__( 'Next', 'axtra-essential' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => ['enable_next' => ['yes']]
			]
		);

		$this->add_control(
			'next_title',
			[
				'label' => esc_html__( 'Title', 'axtra-essential' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Next Post', 'axtra-essential' ),
				'placeholder' => esc_html__( 'Type next title', 'axtra-essential' ),
				'condition' => ['enable_next' => ['yes']]
			]
		);

		$this->add_control(
			'next_icon',
			[
				'label' => esc_html__( 'Icon', 'axtra-essential' ),
				'type' => Controls_Manager::ICONS,
				'default' => [
				
				],
				'condition' => ['enable_next' => ['yes']]
			]
		);

		$this->end_controls_section();


		// Style Tab
		$this->start_controls_section(
			'section_style',
			[
				'label' => __( 'Style', 'axtra-essential' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'gap',
			[
				'label' => esc_html__( 'Gap', 'axtra-essential' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wcf--post-paginate' => 'gap: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);

		$this->add_responsive_control(
			'spacing',
			[
				'label' => esc_html__( 'Spacing', 'axtra-essential' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'selectors' => [
					'{{WRAPPER}} .wcf--post-paginate' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		// Title
		$this->add_control(
			'title_style_heading',
			[
				'label' => esc_html__( 'Title', 'axtra-essential' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
                'condition' => [
                        'show_title' => 'yes',
                ],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'selector' => '{{WRAPPER}} .title',
				'condition' => [
					'show_title' => 'yes',
				],
			]
		);

		$this->add_control(
			'title_spacing',
			[
				'label' => esc_html__( 'Spacing', 'axtra-essential' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .title' => 'margin-bottom: {{SIZE}}{{UNIT}} !important;',
				],
				'condition' => [
					'show_title' => 'yes',
				],
			]
		);

		$this->start_controls_tabs(
			'title_style_tabs'
		);

		$this->start_controls_tab(
			'title_normal_tab',
			[
				'label' => esc_html__( 'Normal', 'axtra-essential' ),
				'condition' => [
					'show_title' => 'yes',
				],
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Color', 'wcf' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}};',
				],
				'condition' => [
					'show_title' => 'yes',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'title_hover_tab',
			[
				'label' => esc_html__( 'Hover', 'axtra-essential' ),
				'condition' => [
					'show_title' => 'yes',
				],
			]
		);

		$this->add_control(
			'title_hover_color',
			[
				'label'     => esc_html__( 'Color', 'wcf' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .title:hover' => 'color: {{VALUE}};',
				],
				'condition' => [
					'show_title' => 'yes',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_hover_typography',
				'selector' => '{{WRAPPER}} .title:hover',
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();


		// Prev / Next
		$this->add_control(
			'prev_style_heading',
			[
				'label' => esc_html__( 'Previous / Next', 'axtra-essential' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'next_prev_typography',
				'selector' => '{{WRAPPER}} .next-prev',
			]
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'next_prev_border',
				'selector' => '{{WRAPPER}} .wcf--post-paginate a',
			]
		);
		
		$this->add_responsive_control(
			'next_prev_border_radious',
			[
				'label' => esc_html__( 'Border radius', 'axtra-essential' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wcf--post-paginate a' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'next_prev_width',
			[
				'label' => esc_html__( 'Width', 'axtra-essential' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 150,
				],
				'selectors' => [
					'{{WRAPPER}} .wcf--post-paginate a' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'next_prev_hth',
			[
				'label' => esc_html__( 'Height', 'axtra-essential' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 150,
				],
				'selectors' => [
					'{{WRAPPER}} .wcf--post-paginate a' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);	
		

		$this->add_responsive_control(
			'next_prev_gap',
			[
				'label' => esc_html__( 'Gap', 'axtra-essential' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .next-prev' => 'gap: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'icon_size',
			[
				'label' => esc_html__( 'Icon Size', 'axtra-essential' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .next-prev i, {{WRAPPER}} .next-prev svg' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->start_controls_tabs(
			'prev_style_tabs'
		);

		$this->start_controls_tab(
			'prev_normal_tab',
			[
				'label' => esc_html__( 'Normal', 'axtra-essential' ),
			]
		);

		$this->add_control(
			'prev_color',
			[
				'label'     => esc_html__( 'Color', 'wcf' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .next-prev' => 'color: {{VALUE}};',
					'{{WRAPPER}} .next-prev svg' => 'fill: {{VALUE}};',
				],
			]
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'prevbackground',
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .wcf--post-paginate a',
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'prev_hover_tab',
			[
				'label' => esc_html__( 'Hover', 'axtra-essential' ),
			]
		);

		$this->add_control(
			'prev_hover_color',
			[
				'label'     => esc_html__( 'Color', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wcf--post-paginate:hover' => 'color: {{VALUE}};',
					'{{WRAPPER}} .next-prev:hover' => 'color: {{VALUE}};',
					'{{WRAPPER}} .next-prev:hover svg' => 'fill: {{VALUE}};',
				],
			]
		);
		
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'prevbhoveackground',
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .wcf--post-paginate a:hover',
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->end_controls_section();
	}
	
	protected function render() {
	
        $settings   = $this->get_settings_for_display();        
        $post_id    = get_the_id();
        $is_editor  = \Elementor\Plugin::$instance->editor->is_edit_mode() || \Elementor\Plugin::$instance->preview->is_preview_mode() || (isset($_GET['preview_id']) && isset($_GET['preview_nonce']));
        
        if($is_editor) {
        
            $recent_posts = wp_get_recent_posts(array(
                'numberposts' => 1, 
                'post_status' => 'publish' 
            ));
            
            if(isset($recent_posts[0])){
                $post_id = $recent_posts[0]['ID'];
                
                global $post; 
                $post = get_post( $post_id, OBJECT );
                setup_postdata( $post );
            } 
            
        }
		$next_post	 = get_next_post();
		$pre_post	 = get_previous_post();
		if ( !$next_post && !$pre_post ) {
			return;
		}
		?>
		<nav class="wcf--post-paginate <?php echo esc_attr($settings['preset_style']); ?>">
			<?php if($settings['enable_prev'] == 'yes'){ ?>
            <div class="post-previous">
				<?php if ( ! empty( $pre_post ) ): ?>
                    <a href="<?php echo get_the_permalink( $pre_post->ID ); ?>">
						<?php if ( 'yes' === $settings['show_title'] ) { ?>
                            <h3 class="title"><?php echo get_the_title( $pre_post->ID ) ?></h3>
						<?php } ?>
                        <span class="next-prev">
                            <?php
                            Icons_Manager::render_icon( $settings['prev_icon'], [ 'aria-hidden' => 'true' ] );
                            if( !empty($settings['prev_title']) ) {
                                echo wp_kses_post($settings['prev_title']);
                            }
                            ?>
                        </span>
                    </a>
				<?php endif; ?>
            </div>
			<?php } ?>
            <?php if($settings['enable_next'] == 'yes'){ ?>
            <div class="post-next">
				<?php if ( ! empty( $next_post ) ): ?>
                    <a href="<?php echo get_the_permalink( $next_post->ID ); ?>">
						<?php if ( 'yes' === $settings['show_title'] ) { ?>
                            <h3 class="title"><?php echo get_the_title( $next_post->ID ) ?></h3>
						<?php } ?>
                        <span class="next-prev">
                            <?php
                            if( !empty($settings['next_title']) ) {
	                            echo wp_kses_post($settings['next_title']);
                            }
                             Icons_Manager::render_icon( $settings['next_icon'], [ 'aria-hidden' => 'true' ] );
                            ?>
                        </span>
                    </a>
				<?php endif; ?>
            </div>
            <?php } ?>
		</nav>
		<?php
		
		if($is_editor) {
		    wp_reset_postdata();
        }
        
		?>
	  	    
		<?php
	}
}