<?php

namespace AxtraEssentialApp\Widgets;

use Elementor\Controls_Manager;
use Elementor\Control_Media;
use Elementor\Utils;
use Elementor\Group_Control_Text_Stroke;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Group_Control_Image_Size;
use Elementor\Repeater;
use Elementor\Group_Control_Css_Filter;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Plugin;
use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) {
	exit;   // Exit if accessed directly.
}

class Blog_Post_Excerpt extends \Elementor\Widget_Base {
   
	public function get_name() {
		return 'wcf--blog--post--excerpt';
	}

	public function get_title() {
		return wcf_elementor_widget_concat_prefix( 'Post Excerp' );
	}
	
	public function get_icon() {
		return 'wcf eicon-post-excerpt';
	}

	public function get_categories() {
		return [ 'wcf-blog-single' ];
	}

	public function get_keywords() {
		return ['post title','title', 'post header' ];
	}
	  	
	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'Content', 'axtra-essential' ),
			]
		);
		
		$this->add_control(
			'limit',
			[
				'label' => esc_html__( 'Limit', 'axtra-essential' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 4,
				'max' => 900,
				'step' => 5,
				'default' => 30,
			]
		);
		$this->add_responsive_control(
			'align',
			[
				'label'     => esc_html__( 'Alignment', 'axtra-essential' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => [
					'left'    => [
						'title' => esc_html__( 'Left', 'axtra-essential' ),
						'icon'  => 'eicon-text-align-left',
					],
					'center'  => [
						'title' => esc_html__( 'Center', 'axtra-essential' ),
						'icon'  => 'eicon-text-align-center',
					],
					'right'   => [
						'title' => esc_html__( 'Right', 'axtra-essential' ),
						'icon'  => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'axtra-essential' ),
						'icon'  => 'eicon-text-align-justify',
					],
				],
				'default'   => '',
				'separator' => 'before',
				'selectors' => [
					'{{WRAPPER}} .wcf-post-excerpt' => 'text-align: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style',
			[
				'label' => __( 'Style', 'axtra-essential' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Text Color', 'axtra-essential' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wcf-post-excerpt' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'typography',
				'selector' => '{{WRAPPER}} .wcf-post-excerpt',
			]
		);

		$this->add_group_control(
			Group_Control_Text_Stroke::get_type(),
			[
				'name'     => 'text_stroke',
				'selector' => '{{WRAPPER}} .wcf-post-excerpt',
			]
		);

		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name'     => 'text_shadow',
				'selector' => '{{WRAPPER}} .wcf-post-excerpt',
			]
		);

		$this->add_control(
			'blend_mode',
			[
				'label'     => esc_html__( 'Blend Mode', 'axtra-essential' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					''            => esc_html__( 'Normal', 'axtra-essential' ),
					'multiply'    => 'Multiply',
					'screen'      => 'Screen',
					'overlay'     => 'Overlay',
					'darken'      => 'Darken',
					'lighten'     => 'Lighten',
					'color-dodge' => 'Color Dodge',
					'saturation'  => 'Saturation',
					'color'       => 'Color',
					'difference'  => 'Difference',
					'exclusion'   => 'Exclusion',
					'hue'         => 'Hue',
					'luminosity'  => 'Luminosity',
				],
				'selectors' => [
					'{{WRAPPER}} .wcf-post-excerpt' => 'mix-blend-mode: {{VALUE}}',
				],
				'separator' => 'none',
			]
		);

		$this->end_controls_section();
	}
	
	protected function render() {
	
        $settings = $this->get_settings_for_display();
        
        $post_id = get_the_id();
       
        if(\Elementor\Plugin::$instance->editor->is_edit_mode() || \Elementor\Plugin::$instance->preview->is_preview_mode() || (isset($_GET['preview_id']) && isset($_GET['preview_nonce']))) {
        
            $recent_posts = wp_get_recent_posts(array(
                'numberposts' => 1, 
                'post_status' => 'publish' 
            ));
            
            if(isset($recent_posts[0])){
                $post_id = $recent_posts[0]['ID'];
            } 
            
        }
        
	    $content = get_the_excerpt($post_id); 
		$content = substr($content, 0, $settings['limit']);		
		if ( '' === $content ) {
			return;
		}
        
		// PHPCS - the variable $title_html holds safe data.
		echo '<div class="wcf-post-excerpt">' .$content .'</div>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		
		?>
	  	    
		<?php
	}
}