<?php 
        
        // footer a top-tab
        CSF::createSection( AXTRA_OPTION_KEY, array(
            'id'    => 'footer_tab',                         // Set a unique slug-like ID
            'title' => esc_html__( 'Footer', 'axtra-essential' ),
            'icon'  => 'fa fa-cog',
        ) ); 

        // Footer
        CSF::createSection( AXTRA_OPTION_KEY, array(
            'parent' => 'footer_tab', // The slug id of the parent section
            'title'  => esc_html__( 'Widget & Style', 'axtra-essential' ),
            'icon'   => 'fa fa-paint-brush',
            'fields' => array(
             
                array(
                'type'    => 'subheading',
                'content' => esc_html__( 'Footer Settings', 'axtra-essential' ),
                ),
                
                array(
                    'id'      => 'elementor_footer',
                    'type'    => 'switcher',
                    'title'   => 'Elementor Footer',
                    'label'   => 'Do you want activate elementor footer?',
                    'default' => false
                ),
                
                array(
                    'id'          => 'builder_footer',
                    'type'        => 'select',
                    'title'       => esc_html__('Elementor Footer','axtra-essential'),            
                    'options'     => axtra_header_footer__custom_ele_type('footer'),
                    'default'     => '',
                    'dependency' => array( 'elementor_footer', '==', 'true' ),                
                ),                 
               
                array(
                    'id'      => 'footer_style',
                    'type'    => 'image_select',
                    'title'   => esc_html__( 'Footer Style', 'axtra-essential' ),
                    'desc'    => esc_html__( 'Select the Footer style which you want to show on your website.', 'axtra-essential' ),
                    'options' => array(                    
                        'style2'       => AXTRA_ESSENTIAL_ASSETS_URL. '/images/footer/footer_2.png',
                    ),
                    'default' => 'style2',
                    'dependency' => array( 'elementor_footer', '==', 'false' ),
                ),               
               
                array(
                    'id'           => 'footer_logo',
                    'type'         => 'upload',
                    'title'        => esc_html__( 'Logo', 'axtra-essential' ),
                    'library'      => 'image',
                    'placeholder'  => 'http://',
                    'button_title' => esc_html__( 'Add Image', 'axtra-essential' ),
                    'remove_title' => esc_html__( 'Remove Image', 'axtra-essential' ),
                    // 'dependency' => array( 'footer_style', '==', 'style1' )
                    'dependency' => array( 'elementor_footer', '==', 'false' ),
                ),
              
                array(
                    'id'      => 'footer_bg',
                    'type'    => 'background',
                    'title'   => esc_html__( 'Footer Background ', 'axtra-essential' ),
                    'desc'    => esc_html__( 'Upload a new background image to set the footer background.', 'axtra-essential' ),
                    'default' => array(
                        'image'      => '',
                        'repeat'     => 'no-repeat',
                        'position'   => 'center center',
                        'attachment' => 'scroll',
                        'size'       => 'cover',
                        'color'      => '#182044',
                    ),
                    'output' => '.jfooter-wrapper',
                    'dependency' => array( 'elementor_footer', '==', 'false' ),
                ),
      
                array(
                        'id'      => 'footer_padding_top',
                        'type'    => 'slider',
                        'title'   => esc_html__( 'Footer Main Padding Top', 'axtra-essential' ),
                        'min'     => 0,
                        'max'     => 200,
                        'step'    => 1,
                        'unit'    => 'px',
                        'dependency' => array( 'elementor_footer', '==', 'false' ),
                ),                
             
                array(
                        'id'      => 'footer_padding_bottom',
                        'type'    => 'slider',
                        'title'   => esc_html__( 'Footer Padding Bottom', 'axtra-essential' ),
                        'min'     => 0,
                        'max'     => 200,
                        'step'    => 1,
                        'unit'    => 'px',
                        'dependency' => array( 'elementor_footer', '==', 'false' ),
                ),

                array(
                    'id'      => 'footer_inner_padding_bottom',
                    'type'    => 'slider',
                    'title'   => esc_html__( 'Widget Padding Bottom', 'axtra-essential' ),
                    'min'     => 0,
                    'max'     => 200,
                    'step'    => 1,
                    'unit'    => 'px',
                    'dependency' => array( 'elementor_footer', '==', 'false' ),
                ),
             
                array(
                  'type'    => 'subheading',
                  'content' => esc_html__( 'Footer Text & Link Color', 'axtra-essential' ),
                  'dependency' => array( 'elementor_footer', '==', 'false' ),
                ),
                array(
                    'id'      => 'footer_widget_title_color',
                    'type'    => 'color',
                    'title'   => esc_html__( 'Widget Title Color', 'axtra-essential' ),
                    'desc'    => esc_html__( 'Set footer widget title color form here.', 'axtra-essential' ),
                    'output' => '.jfooter-wrapper .widget-title',
                    'dependency' => array( 'elementor_footer', '==', 'false' ),
                ),
                array(
                    'id'      => 'footer_widget_content_color',
                    'type'    => 'color',
                    'title'   => esc_html__( 'Widget content Color', 'axtra-essential' ),
                    'desc'    => esc_html__( 'Set footer widget content color form here.', 'axtra-essential' ),
                    'output' => '.jfooter-wrapper .widget,
                    .jfooter-wrapper .widget p,
                    .jfooter-wrapper .widget div,
                    .jfooter-wrapper .widget li,
                    .jfooter-wrapper .widget table td,
                    div#calendar_wrap table > tbody > tr > td,
                    div#calendar_wrap table > thead > tr > th,
                    .jfooter-wrapper .widget *'
                ),
                array(
                    'id'      => 'footer_widget_title_margin_top',
                    'type'    => 'slider',
                    'title'   => esc_html__( 'Widget Title margin Top', 'axtra-essential' ),
                    'min'     => 0,
                    'max'     => 200,
                    'step'    => 1,
                    'unit'    => 'px',
                    
              ),
                array(
                    'id'      => 'footer_widget_title_margin_bottom',
                    'type'    => 'slider',
                    'title'   => esc_html__( 'Widget Title margin bottom', 'axtra-essential' ),
                    'min'     => 0,
                    'max'     => 200,
                    'step'    => 1,
                    'unit'    => 'px',
                    
              ),
              array(
                        'id'      => 'footer_widget_content_bottom_margin',
                        'type'    => 'slider',
                        'title'   => esc_html__( 'Widget Content Margin Bottom', 'axtra-essential' ),
                        'min'     => 0,
                        'max'     => 200,
                        'step'    => 1,
                        'unit'    => 'px',
                        
                ),
                array(
                    'id'      => 'footer_link_color',
                    'type'    => 'color',
                    'title'   => esc_html__( 'Footer links color', 'axtra-essential' ),
                    'desc'    => esc_html__( 'Set the footer area link color', 'axtra-essential' ),
                    'output' => '.jfooter-wrapper .single-blog-post a ,.jfooter-wrapper .tagcloud a, .jfooter-wrapper .widget a, .jfooter-wrapper .widget ul li a.url,.jfooter-wrapper.widget ul li a.rsswidget'
                ),

                array(
                    'id'      => 'footer_link_hover',
                    'type'    => 'color',
                    'title'   => esc_html__( 'Footer links Hover color', 'axtra-essential' ),
                    'desc'    => esc_html__( 'Set the footer area link hover color', 'axtra-essential' ),
                    'output'  => '.jfooter-wrapper .single-blog-post a:hover,.jfooter-wrapper .tagcloud a:hover,.jfooter-wrapper .widget a:hover, .jfooter-wrapper .widget ul li a.url:hover,.jfooter-wrapper .widget ul li a.rsswidget:hover'
                ),
          
            ),

        ) );

        
        // copyright
        CSF::createSection( AXTRA_OPTION_KEY, array(
            'parent' => 'footer_tab', // The slug id of the parent section
            'title'  => esc_html__( 'Copyright', 'axtra-essential' ),
            'icon'   => 'fa fa-copyright',
            'fields' => array(
                array(
                    'id'       => 'copyright_text',
                    'type'     => 'wp_editor',
                    'title'    => esc_html__( 'Footer Copyright', 'axtra-essential' ),
                    'desc'     => esc_html__( 'Set the footer copyright text','axtra-essential' ),
                    'settings' => array(
                        'textarea_rows' => 7,
                        'tinymce'       => true,
                        'media_buttons' => false,
                      ),
                      'default' => 'Copryright &copy; Crowdyflow All Right Reserved.',
                ),
                
                array(
                    'type'    => 'subheading',
                    'content' => esc_html__( 'Copyright', 'axtra-essential' ),
                ),

                array(
                    'id'      => 'copyright_padding_top',
                    'type'    => 'slider',
                    'title'   => esc_html__( 'Copyright Padding top', 'axtra-essential' ),
                    'min'     => 0,
                    'max'     => 200,
                    'step'    => 1,
                    'unit'    => 'px',
                        
                ),

                array(
                    'id'      => 'copyright_padding_bottom',
                    'type'    => 'slider',
                    'title'   => esc_html__( 'Copyright Padding Bottom', 'axtra-essential' ),
                    'min'     => 0,
                    'max'     => 200,
                    'step'    => 1,
                    'unit'    => 'px',
                ),

                array(
                    'id'      => 'copyright_margin_top',
                    'type'    => 'slider',
                    'title'   => esc_html__( 'Copyright margin top', 'axtra-essential' ),
                    'min'     => 0,
                    'max'     => 300,
                    'step'    => 1,
                    'unit'    => 'px',
                        
                ),

                array(
                    'id'      => 'footer_copyright_color',
                    'type'    => 'color',
                    'title'   => esc_html__( 'Copyright Text Color', 'axtra-essential' ),
                    'desc'    => esc_html__( 'Set footer copyright text color form here.', 'axtra-essential' ),
                    'output'  => '.jfooter-wrapper .jcopyright p'
                ),

                array(
                    'id'     => 'footer_copyright_border',
                    'type'   => 'border',
                    'title'   => esc_html__( 'Copyright Border', 'axtra-essential' ),
                    'output'  => '.jfooter-wrapper .jcopyright'
                ),
                
             
            ),

        ) ); 