<?php

namespace AxtraEssentialApp\Blog;

class WCF_Blog_Single
{
    public $option = null;
    
    function __construct() {
      $this->option = axtra_option( 'blog_post_preset_grp' );    
      
      add_filter( 'single_template', [ $this , 'load_our_custom_cpt_editor_single_template' ] ); 
      
      add_filter( 'single_template', [ $this , 'load_our_custom_blog_single_template' ] );
      add_action( 'admin_menu', [ $this, 'register_sub_menu_post' ] );
      // Elementor Template Import      
      add_action( 'wp_ajax_wcf_post_tpl_activate' , [ $this , 'wcf_post_tpl_activate' ] );    
      add_action( 'wp_ajax_wcf_post_tpl_dectivate' , [ $this , 'wcf_post_tpl_dectivate' ] );    
      add_action( 'wp_ajax_wcf_post_tpl_remote_import' , [ $this , 'wcf_post_tpl_import' ] );    
      add_action( 'wp_ajax_wcf_post_tpl_status' , [ $this , 'wcf_post_tpl_status' ] );    
      add_action( 'wp_ajax_wcf_data_table_template_activate' , [ $this , 'wcf_data_table_template_activate' ] );    
   
      add_action( 'init', [ $this,'custom_post_type' ]);
      add_filter( 'save_post_wcf-single-post' , array( $this, 'update_template' ), 10,3 );
      add_filter( 'wcf_elementor_blog_post_layout_id' , array( $this, 'wcf_elementor_blog_post_layout_id' ), 10 );
      
      add_action( 'manage_posts_extra_tablenav' , [ $this,'top_form_edit' ] );
      //add_action( 'admin_footer', [$this,'_footer_popup']);
      
      // Data Table
      add_filter( 'manage_edit-wcf-single-post_columns' , [ $this,'extra_column_add' ]);
      add_action( 'manage_wcf-single-post_posts_custom_column' , [ $this,'active_cpt_column' ], 10, 2);
      add_action( 'manage_wcf-single-post_posts_custom_column' , [ $this,'thumbnail_cpt_column' ], 10, 2);
      add_filter( 'template_redirect', [ $this , 'preview_wp_redirect' ] );      
    }
    
    public function preview_wp_redirect(){
      
      if( isset( $_GET[ 'wcf-edit' ] ) && isset( $_GET[ 'preview_nonce' ] ) && isset( $_GET[ 'preview_id' ] ) ){
      
        if(get_post_type($_GET['preview_id']) === 'wcf-single-post'){  
        
          $preset             = isset($this->option['post_layout']) ? $this->option['post_layout'] : '';
          $is_editor          = false;
          $elementor_id       = get_option('wcf-elementor-post-layout-id');
          $preset_meta_active = axtra_meta_option( get_the_id() , 'override_post_layout' );         
          $latest_cpt         = get_posts("post_type=post&numberposts=1");
          
          if($preset === 'elementor_builder' && is_numeric($elementor_id)){
            if(isset($latest_cpt[0]) && isset($latest_cpt[0]->ID) ){          
               exit( wp_redirect( get_permalink($latest_cpt[0]->ID) ) );
             }  
          }
                  
                   
        }
       
      }
      
    }
    
    public function wcf_elementor_blog_post_layout_id($id){
      $elementor_id = axtra_meta_option( get_the_id() , 'wcf-elementor-post-layout-id' );
      if( is_numeric($elementor_id) ){
        return $elementor_id;
      }
      return $id;
    }
    function extra_column_add( $columns ) {
      unset($columns["date"]);
      $columns["active"]    = esc_html__( 'Active' ,'axtra-essential');
      $columns["thumbnail"] = esc_html__('Thumbnail','axtra-essential');
      
      return $columns;
    }
    function active_cpt_column( $colname, $cptid ) {
      if ( $colname == 'active'){
      
        if(get_option( 'wcf-elementor-post-layout-id' ) == $cptid){
          echo sprintf('<input type="checkbox" data-action="wcf_data_table_template_activate" data-id="%1$d" class="wcf--tpl--switcher" id="wcf--tpl--switcher-%1$d" checked/><label for="wcf--tpl--switcher-%1$d">Toggle</label>', $cptid );
        }else{
          echo sprintf('<input type="checkbox" data-action="wcf_data_table_template_activate" data-id="%1$d" class="wcf--tpl--switcher" id="wcf--tpl--switcher-%1$d" /><label for="wcf--tpl--switcher-%1$d">Toggle</label>', $cptid );
        }
      }
         
    }
    function thumbnail_cpt_column( $colname, $cptid ) {
      if ( $colname == 'thumbnail')
        echo get_the_post_thumbnail( $cptid , 'thumbnail', array( 'class' => 'alignleft' ) );
    }
    
    function top_form_edit( ) {
      static $single_load = null;
      if(isset($_GET['post_type']) && $_GET['post_type'] == 'wcf-single-post' && is_null($single_load)){
        $single_load = 1; 
        ?>
         <script>          
      
            var wcf_button_add = document.querySelector('.page-title-action');
            var wcf_new_button = document.createElement("a");
            wcf_new_button.innerHTML = 'Import Templates';
            wcf_new_button.classList = 'add-new-h2 wcf-post-layout-import-modal';
            wcf_new_button.setAttribute('href', 'javascript:void(0)');
            wcf_new_button.setAttribute('data-id', 'post_layout');
            wcf_new_button.onclick = function(e){
              jQuery('.wcf-modal-state').prop("checked", true);
            };
            if(wcf_button_add){             
              wcf_button_add.after(wcf_new_button);
            }
            jQuery(document).on('click', ".wcf-modal__close-import" ,function(){
                location.reload();
            });
         </script>         
        <?php 

      }
      
    }
    public function add_elementor_editor_support() {
    	add_post_type_support( 'wcf-single-post', 'elementor' );
    }
    public function update_template( $post_id,$post ,$update ){
      
      if($update):
          if(isset($_POST['page_template'])):
              $template = sanitize_text_field($_POST['page_template']);
              if(get_post_type($post_id) =='wcf-single-post'):
                  update_post_meta( $post_id, '_wp_page_template', $template );
              endif;
          endif;
      else:
          update_post_meta( $post_id, '_wp_page_template', 'elementor_canvas' );
      endif;  

  }
    
  function custom_post_type(){
  
    register_post_type('wcf-single-post',
      array(
        'labels'      => array(
          'name'          => __('Post Layouts', 'AXTRA_ESSENTIAL'),
          'singular_name' => __('Post Layout', 'AXTRA_ESSENTIAL'),
        ),
          'public'              => true,
          'menu_icon'           => 'dashicons-text-page',
          'supports'            => [ 'title' , 'editor' , 'thumbnail' ],            
          'exclude_from_search' => false,
          'has_archive'         => false,     
          'publicly_queryable'  => true,     
          'hierarchical'        => false,
          'show_in_menu'        => false,
          'show_in_nav_menus' => false
      )
    );
    
    $this->add_elementor_editor_support();
  }
    
  public function register_sub_menu_post() {
      $preset = isset($this->option['post_layout']) ? $this->option['post_layout'] : '';
      if($preset === 'elementor_builder'){
        add_submenu_page( 'wcf-axtra-theme-parent', 'Post Layout', 'Post Layout',
        'manage_options', 'edit.php?post_type=wcf-single-post');
      } 
   
  }
  function load_our_custom_cpt_editor_single_template($template){
    
      if ( is_singular('wcf-single-post') ) {
        $preset = isset($this->option['post_layout']) ? $this->option['post_layout'] : '';
        
        $is_editor  = false;
        if( defined( 'ELEMENTOR_VERSION' ) ){
          $is_editor  = \Elementor\Plugin::$instance->editor->is_edit_mode() || \Elementor\Plugin::$instance->preview->is_preview_mode() || (isset($_GET['preview_id']) && isset($_GET['preview_nonce']));
          if($is_editor && $preset === 'elementor_builder'){
            $template = AXTRA_ESSENTIAL_DIR_PATH . "templates/header-footer.php";
            return $template;
          }
        }
      }
      
      return $template;
    }
    function load_our_custom_blog_single_template($template) {
         
        if ( is_singular('post') ) {   
        
          axtra_set_postview();          
          $preset       = isset($this->option['post_layout']) ? $this->option['post_layout'] : '';
          $is_editor    = false;
          $elementor_id = get_option('wcf-elementor-post-layout-id');
          
          if( defined( 'ELEMENTOR_VERSION' ) ){
              $is_editor  = \Elementor\Plugin::$instance->editor->is_edit_mode() || \Elementor\Plugin::$instance->preview->is_preview_mode() || (isset($_GET['preview_id']) && isset($_GET['preview_nonce']));
              if($is_editor && $preset === 'elementor_builder'){
                $template = AXTRA_ESSENTIAL_DIR_PATH . "templates/header-footer.php";
                return $template;
              }
          }
          
          $preset_meta_active = axtra_meta_option( get_the_id() , 'override_post_layout' );          
          if( $preset_meta_active ){            
            $elementor_id   = axtra_meta_option( get_the_id() , 'wcf-elementor-post-layout-id' );
            $preset         = axtra_meta_option( get_the_id() , 'post_layout' );
          }     
         
          if( file_exists( AXTRA_ESSENTIAL_DIR_PATH . "templates/single/{$preset}.php" ) ){
          
            if($elementor_id && $preset == 'elementor_builder'){
              $template = AXTRA_ESSENTIAL_DIR_PATH . "templates/single/elementor_builder.php";
            }else{
              $template = AXTRA_ESSENTIAL_DIR_PATH . "templates/single/{$preset}.php";
            }
            
          }
        }
    
        return $template;
    }
    public function wcf_data_table_template_activate(){
      $tpl       = $_REQUEST['tpl_id'];
      $is_active = $_REQUEST['is_active'];
      if($is_active){
        $return['message']  = '<b>Activation Done</b> <br/> <p>Please Check Blog Post</p>';  
        update_option( 'wcf-elementor-post-layout-id', $tpl );
        delete_post_meta_by_key('wcf_essential_settings_post_layoutactivate');
        update_post_meta($tpl, 'wcf_essential_settings_post_layoutactivate' , 'yes');       
      }else{
        $return['message']  = '<b>deactivation Done</b> <br/> <p>Please Check Blog Post</p>';  
        update_option( 'wcf-elementor-post-layout-id', null );
        delete_post_meta_by_key('wcf_essential_settings_post_layoutactivate');
        update_post_meta($tpl, 'wcf_essential_settings_post_layoutactivate' , 'no');  
      }
     
      wp_send_json($return);
    }
    public function wcf_post_tpl_activate(){
      $tpl = $_REQUEST['tpl_id'];
      $return['message']  = '<b>Activation Done</b> <br/> <p>Please Check Blog Post</p>';
      $return['next_step'] = 'action_deactivate';
      update_option( 'wcf-elementor-post-layout-id', $tpl );
      delete_post_meta_by_key('wcf_essential_settings_post_layoutactivate');
      update_post_meta($tpl, 'wcf_essential_settings_post_layoutactivate' , 'yes');    
      wp_send_json($return);
    }
    
    public function wcf_post_tpl_status(){
      $tpl = $_REQUEST['tpl_id'];
      $return['message']  = '';
      $return['tpl_id']  = $tpl;
      $return['next_step'] = 'action_fetch';
      $is_active = $this->wcf_check_template_available($tpl);
      if($is_active){
        $return['next_step'] = 'action_activate';
        $return['message']  = 'Already Imported';
        $return['current_layout_id'] = $is_active->ID;
        $tpl = $is_active->ID;
      }
      if( get_option('wcf-elementor-post-layout-id') == $tpl ){
        $return['next_step'] = 'action_deactivate';
      }
      wp_send_json($return);
    }
    public function wcf_post_tpl_dectivate(){
      $tpl = $_REQUEST['tpl_id'];
      $return['message']  = '<b>Deactivation Done</b>';
      $return['next_step'] = 'action_activate';
      update_option( 'wcf-elementor-post-layout-id', '' );
      update_post_meta($tpl, 'wcf_essential_settings_post_layoutactivate' , 'no');        
      wp_send_json($return);
    }

    public function wcf_check_template_available($tpld_id){

      $args = array(
          'numberposts' => 1,
          'post_type'   => 'wcf-single-post',
          'meta_query'  => array(
              array(
                  'key'       => 'wcf_spost_file_imported',
                  'value'     => $tpld_id,
                  'compare'   => '='
              )
          )
      );
    
      $posts = get_posts($args);

      if($posts && isset($posts[0])){
        return $posts[0];
      }

      return false;
    }
    public function wcf_post_tpl_import(){
      global $wpdb;
      $return = array(
        'message'  => ''
      );
      
      $tpl = $_REQUEST['tpl_id'];
      // Detect duplicate
      $is_active = $this->wcf_check_template_available($tpl);
      if($is_active){
        $return['message'] = '<i>Duplicate</i> <span>File Already Imported</span>';
        $return['next_step'] = 'action_activate';
        $return['current_layout_id'] = $is_active->ID;        
        wp_send_json($return);
      }
      $return['message'] = esc_html__('Successfully Imported the content','axtra-essential');
      $path = AXTRA_ESSENTIAL_DEMO_BASE_PATH.'post-layouts/'.$tpl;
     
      $fileContent = file_get_contents( $path );
      $fileJson    = json_decode( $fileContent, true );
  
      $result      = \Elementor\Plugin::instance()->templates_manager->import_template( [
              'fileData' => base64_encode( $fileContent ),
              'fileName' => 'test.json',
          ]
      );
  
      if ( empty( $result ) || empty( $result[0] ) ) {
        $return['message'] = '<b>File Not found</b> <br/> <p>Please Contact Theme Author</p>';
        wp_send_json($return);
      }
      $return['imported_id']  = $result[0]['template_id'];
      set_post_type($result[0]['template_id'],'wcf-single-post');
      if(isset($_REQUEST['thumbnail']) && $_REQUEST['thumbnail'] !=''){
        $thumbnail_url = $_REQUEST['thumbnail'];
        $attachment_id = axtra_remote_sideloader($thumbnail_url,$result[0]['template_id'],$_REQUEST['title']);
        set_post_thumbnail( $result[0]['template_id'] , $attachment_id );
      }
      
      // update_option( 'wcf-elementor-post-layout-id', $result[0]['template_id'] );
      update_post_meta( $result[0]['template_id'] , 'wcf_spost_file_imported', $tpl );
      update_post_meta( $result[0]['template_id'] , '_wp_page_template', 'elementor_header_footer' );
      $return['next_step'] = 'action_activate';
      $return['current_layout_id'] = $result[0]['template_id'];    
      wp_send_json($return);
    }
  
    
}

new WCF_Blog_Single();




