/* global WCF_ADDONS_JS */
(function($) {
	/**
	 * @param $scope The Widget wrapper element as a jQuery element
	 * @param $ The jQuery alias
	 */

	var getSliderOptions = function getSliderOptions($scope) {
		var slider = $($('.helo_team_slider', $scope)[0]);
		var sliderSettings = $($('.helo_team_wrapper', $scope)[0]).data('settings') || {};
		sliderSettings.handleElementorBreakpoints = true;

		//pagination fractions
		if (sliderSettings.hasOwnProperty('pagination')) {
			sliderSettings.pagination.el = $('.swiper-pagination', $scope)[$('.swiper-pagination', $scope).length - 1];
			if (sliderSettings.pagination.hasOwnProperty('type') && 'fraction' === sliderSettings.pagination.type) {
				sliderSettings.pagination.formatFractionCurrent = function(number) {
					return ('0' + number).slice(-2);
				};
				sliderSettings.pagination.formatFractionTotal = function(number) {
					return ('0' + number).slice(-2);
				};
				sliderSettings.pagination.renderFraction = function(currentClass, totalClass) {
					return '<span class="' + currentClass + '"></span>' + '<span class="dash">/</span>' + '<span class="' + totalClass + '"></span>';
				};
			}
		}

		//remove the attribute after getting the slider settings
		// $($('.helo_team_wrapper', $scope)[0]).removeAttr('data-settings');

		return {
			slider: slider,
			options: sliderSettings
		};
	};
	var getThumbSliderOptions = function getThumbSliderOptions($scope) {
		var slider = $('.team_thumb_slider', $scope);
		var sliderSettings = $('.team_thumb_wrapper', $scope).data('settings') || {};
		sliderSettings.handleElementorBreakpoints = true;

		//remove the attribute after getting the slider settings
		$('.team_thumb_wrapper', $scope).removeAttr('data-settings');
		return {
			thumbSlider: slider,
			thumbOptions: sliderSettings
		};
	};
	var HeloteamSlider = function HeloteamSlider($scope, $) {
		var _getThumbSliderOption = getThumbSliderOptions($scope),
			thumbSlider = _getThumbSliderOption.thumbSlider,
			thumbOptions = _getThumbSliderOption.thumbOptions;
		var _getSliderOptions = getSliderOptions($scope),
			slider = _getSliderOptions.slider,
			options = _getSliderOptions.options;

		//if thumb slider enable
		if (thumbSlider.length) {
			new elementorFrontend.utils.swiper(thumbSlider, thumbOptions).then(function(newSwiperInstance) {
				return newSwiperInstance;
			}).then(function(thumbSliderInstance) {
				new elementorFrontend.utils.swiper(slider, options).then(function(newSwiperInstance) {
					return newSwiperInstance;
				}).then(function(newSwiperInstance) {
					newSwiperInstance.controller.control = thumbSliderInstance;
					thumbSliderInstance.controller.control = newSwiperInstance;
				});
			});
		} else {
			new elementorFrontend.utils.swiper(slider, options).then(function(newSwiperInstance) {
				return newSwiperInstance;
			});
		}
	};

	// Make sure you run this code under Elementor.
	$(window).on('elementor/frontend/init', function() {
		elementorFrontend.hooks.addAction('frontend/element_ready/helo--team-slider.default', HeloteamSlider);
	});
})(jQuery);
//# sourceMappingURL=team-slider.js.map
