(function($) {
	var WCF_Feature_Posts = function WCF_Feature_Posts($scope, $) {
		var $popup_id = $scope.attr('data-id');
		var popup_content = $(".wcf--popup-video-wrapper").first();
		// Move popup content to body if not already moved
		if (!popup_content.parent().is('body')) {
			if (!$('body > .wcf--popup-video-wrapper').length) {
				popup_content.appendTo('body');
			}
		}
		var open_popup = $(".elementor-element-".concat($popup_id, " .wcf-post-popup"));
		open_popup.each(function(index) {
			$(this).next('.wcf--popup-video-wrapper').remove();
			$(this).off('click').on('click', function() {
				var $_url = $(this).attr('data-src');
				$(".wcf--popup-video-wrapper").find('.aae-popup-content-container').html('');
				if ($(this).hasClass('audio')) {
					$('.wcf--popup-video-wrapper').find('.aae-popup-content-container').html("<div class=\"audio wcf-audio-wrapper-clean\">\n                        <audio controls>\n                            <source src=\"".concat($_url, "\" type=\"audio/mpeg\">\n                        </audio>\n                    </div>"));
				}
				if ($(this).hasClass('video')) {
					$('.wcf--popup-video-wrapper').find('.aae-popup-content-container').html("<iframe  src=\"".concat($_url, "\" ></iframe>"));
				}
				if ($(this).hasClass('gallery')) {
					var gallery = $scope.find('.aae-post-gallery-wrapper').clone();
					$('.wcf--popup-video-wrapper').find('.aae-popup-content-container').html(gallery);
					var swiper = new Swiper(".aae-popup-content-container .gallery-slider", {
						'speed': '1500',
						navigation: {
							nextEl: ".btn-next",
							prevEl: ".btn-prev"
						}
					});
				}
				window.VideoAnimation = gsap.timeline({
					defaults: {
						ease: "power2.inOut"
					}
				}).to("body > .wcf--popup-video-wrapper", {
					scaleY: 0.01,
					x: 1,
					opacity: 1,
					visibility: 'visible',
					duration: 0.4
				}).to("body > .wcf--popup-video-wrapper", {
					scaleY: 1,
					duration: 0.6
				}).to("body > .wcf--popup-video-wrapper .wcf--popup-video", {
					scaleY: 1,
					opacity: 1,
					visibility: 'visible',
					duration: 0.6
				}, "-=0.4");
			});
		});

		// Calculate audio duration
		$('.audio-duration-wrapper', $scope).each(function() {
			var wrapper = $(this);
			var link = wrapper.attr('data-link');
			if (link) {
				var audio = new Audio(link);
				audio.addEventListener('loadedmetadata', function() {
					var totalDuration = Math.floor(audio.duration);
					var minutes = Math.floor(totalDuration / 60);
					var seconds = totalDuration % 60;
					wrapper.find('.audio-duration').text("".concat(minutes, ":").concat(seconds < 10 ? '0' : '').concat(seconds));
				});
				wrapper.find('.audio-icon').on('click', function() {
					if (audio.paused) {
						audio.play();
						$(this).find('.play-icon').hide();
						$(this).find('.pause-icon').show();
						var interval = setInterval(function() {
							var remainingTime = Math.floor(audio.duration - audio.currentTime);
							var minutes = Math.floor(remainingTime / 60);
							var seconds = remainingTime % 60;
							wrapper.find('.audio-duration').text("".concat(minutes, ":").concat(seconds < 10 ? '0' : '').concat(seconds));
							if (remainingTime <= 0) {
								clearInterval(interval);
								wrapper.find('.play-icon').show();
								// wrapper.find('.play-icon').text('▶');
							}
						}, 1000);
					} else {
						audio.pause();
						$(this).find('.pause-icon').hide();
						$(this).find('.play-icon').show();
					}
				});
				audio.addEventListener('error', function() {
					console.error("Could not load audio from: ".concat(link));
					wrapper.find('.audio-duration').text('Error');
				});
			}
		});
	};

	// Make sure you run this code under Elementor.
	$(window).on('elementor/frontend/init', function() {
		elementorFrontend.hooks.addAction('frontend/element_ready/wcf--feature-posts.default', WCF_Feature_Posts);
		elementorFrontend.hooks.addAction('frontend/element_ready/wcf--posts-pro.default', WCF_Feature_Posts);
		elementorFrontend.hooks.addAction('frontend/element_ready/wcf--banner-posts.default', WCF_Feature_Posts);
		elementorFrontend.hooks.addAction("frontend/element_ready/wcf--filterable-gallery.default", WCF_Feature_Posts);
		elementorFrontend.hooks.addAction("frontend/element_ready/wcf--posts-filter.default", WCF_Feature_Posts);
		elementorFrontend.hooks.addAction("frontend/element_ready/wcf--posts-slider.default", WCF_Feature_Posts);
	});
})(jQuery);
//# sourceMappingURL=post.js.map
