/* global WCF_ADDONS_JS */
(function($) {
	/**
	 * @param $scope The Widget wrapper element as a jQuery element
	 * @param $ The jQuery alias
	 */
	var WcfPosts = function WcfPosts($scope, $) {
		var $buttons = $scope.find(".wcf__portfolio .filter button");
		var $items = $scope.find(".enable-filter .wcf-post");
		$buttons.on("click", function() {
			var filter = $(this).data("filter");
			$(this).addClass('mixitup-control-active').siblings().removeClass('mixitup-control-active');
			portfolioFilterItems(filter);
		});

		function portfolioFilterItems(filter) {
			var state = Flip.getState($items.toArray());
			$items.each(function() {
				var $item = $(this);
				if (filter === "all" || $item.hasClass(filter)) {
					$item.show();
				} else {
					$item.hide();
				}
			});
			Flip.from(state, {
				duration: 0.5,
				ease: "power1.inOut",
				stagger: 0.1
			});
		}

		//load more
		var loadMore = $('.pf-load-more a', $scope);
		var elementId = $('.load-more-anchor', $scope).data('e-id');
		var isLoading = false;
		var currentPage = $('.load-more-anchor', $scope).data('page');
		var maxPage = $('.load-more-anchor', $scope).data('max-page');
		loadMore.on('click', function(e) {
			e.preventDefault();
			if (currentPage < maxPage) {
				handlePostsQuery();
			}
		});
		var handlePostsQuery = function handlePostsQuery() {
			handleUiBeforeLoading();
			if (isLoading) {
				$('.wcf__btn', $scope).addClass('loading');
			}
			currentPage++;
			var nextPageUrl = $('.load-more-anchor', $scope).attr('data-next-page');
			return fetch(nextPageUrl).then(function(response) {
				return response.text();
			}).then(function(html) {
				// Convert the HTML string into a document object
				var parser = new DOMParser();
				var doc = parser.parseFromString(html, 'text/html');
				handleSuccessFetch(doc);
			});
		};
		var handleSuccessFetch = function handleSuccessFetch(result) {
			handleUiAfterLoading();
			var postsElements = result.querySelectorAll("[data-id=\"".concat(elementId, "\"] .wcf-posts > article"));
			var nextPageUrl = result.querySelector("[data-id=\"".concat(elementId, "\"] .load-more-anchor")).getAttribute('data-next-page');
			postsElements.forEach(function(element) {
				return $("[data-id=\"".concat(elementId, "\"] .wcf-posts")).append(element);
			});
			$('.load-more-anchor', $scope).attr('data-page', currentPage);
			$('.load-more-anchor', $scope).attr('data-next-page', nextPageUrl);
			if (!isLoading) {
				$('.wcf__btn', $scope).removeClass('loading');
			}
			if (currentPage === maxPage) {
				loadMore.hide();
			}
		};
		var handleUiBeforeLoading = function handleUiBeforeLoading() {
			isLoading = true;
		};
		var handleUiAfterLoading = function handleUiAfterLoading() {
			isLoading = false;
		};
	};

	// Make sure you run this code under Elementor.
	$(window).on('elementor/frontend/init', function() {
		elementorFrontend.hooks.addAction('frontend/element_ready/wcf--portfolio.default', WcfPosts);
	});
})(jQuery);
//# sourceMappingURL=portfolio.js.map
