(function($) {
	var AAE_Filter_Posts = function AAE_Filter_Posts($scope, $) {
		var $buttons = $scope.find(".aae--filterable-posts .posts-filter li");
		var $items = $scope.find(".aae--filterable-posts .wcf-post");

		// Handle filter button click
		$buttons.on("click", function() {
			var filter = $(this).data("filter");
			$(this).addClass('mixitup-control-active').siblings().removeClass('mixitup-control-active');
			portfolioFilterItems(filter);
		});

		function portfolioFilterItems(filter) {
			var state = Flip.getState($items.toArray());
			$items.each(function() {
				var $item = $(this);
				if (filter === "all" || $item.hasClass(filter)) {
					$item.show();
				} else {
					$item.hide();
				}
			});
			Flip.from(state, {
				duration: 0.5,
				ease: "power1.inOut",
				stagger: 0.1
			});
		}

		// Handle item click (show post content in popup)
		var $popup_enabled = $scope.find('.popup-enabled');
		if ($popup_enabled.length > 0) {
			$items.each(function() {
				$(this).off('click').on('click', function(e) {
					e.preventDefault();

					// Add the "popup-opened" class to the container
					$scope.find('.aae--filterable-posts').addClass('popup-opened');
					var $popup_id = $scope.attr('data-id');
					var $pageElement = $('[class*="page-id-"]');
					if ($pageElement.length) {
						// Get all class names
						var classList = $pageElement.attr('class').split(/\s+/);

						// Find the class that starts with "page-id-"
						var pageIdClass = classList.find(function(cls) {
							return cls.startsWith('page-id-');
						});
						if (pageIdClass) {
							// Extract the numeric part of page-id
							var numericPageId = pageIdClass.split('page-id-')[1];

							// Update the content to include the dynamic page ID class
							var content = "\n                            <div class=\"aae-post-popup-content\">".concat($(this).html(), "</div>\n                            ");

							// Add post content to the popup
							var $popupWrapper = $('.wcf--popup-video-wrapper');
							$popupWrapper.addClass('elementor elementor-' + numericPageId);
							$popupWrapper.find('.wcf--popup-video').addClass('post-details-popup elementor-element elementor-element-' + $popup_id);
							$popupWrapper.find('.aae-popup-content-container').html(content);

							// Popup animation
							window.VideoAnimation = gsap.timeline({
								defaults: {
									ease: "power2.inOut"
								}
							}).to("body > .wcf--popup-video-wrapper", {
								scaleY: 0.01,
								x: 1,
								opacity: 1,
								visibility: 'visible',
								duration: 0.4
							}).to("body > .wcf--popup-video-wrapper", {
								scaleY: 1,
								duration: 0.6
							}).to("body > .wcf--popup-video-wrapper .wcf--popup-video", {
								scaleY: 1,
								opacity: 1,
								visibility: 'visible',
								duration: 0.6
							}, "-=0.4");
						}
					}
				});
			});
		}
	};

	// Elementor Frontend Hook
	$(window).on('elementor/frontend/init', function() {
		elementorFrontend.hooks.addAction('frontend/element_ready/wcf--posts-filter.default', AAE_Filter_Posts);
	});
})(jQuery);
//# sourceMappingURL=filterable-posts.js.map
