=== Animation Addons for Elementor ===
Contributors: wealcoder, wcrayhan, jhshakil
Tags: Animation, Elementor Addon, Elementor, elementor widget, GSAP Animation
Requires at least: 6.0
Tested up to: 6.7
Requires PHP: 7.4
Stable tag: 2.3.4
License: GPL v2 or later
License URI: https://www.gnu.org/licenses/gpl-2.0.html

The Animation Addons comes with GSAP Animation, 100+ Widgets, 25+ Extensions, Custom Animation Builder, 150+ Pre-Designed Websites, and many more.

== Description ==

Animation Addons for Elementor is the **No.1 Animation Plugin** with creative & premium design capabilities. This Elementor addons has advanced animation features that allow you to create an advanced animated website with the full features of GSAP in Elementor without writing a single line of code.

Animation Addons for Elementor has all required website builders, including the **Custom Header & Footer Builder, Animation Builder, Single Page and Single Post Builder, Mega Menu Builder, Archive Page Builder, 404 Builder, etc.** The Animation Addons for Elementor plugin is designed to be lightweight and to ensure fast page loading times.

**Exclusive Features:**
* Preloaders
* 3D Transformations
* Micro-Interactions Animation
* Custom Keyframe Animations
* Advanced Stagger Animations
* Word by Word Text Animation
* Animation Builder Integration
* Custom Scroll Progress Indicators
* 3D Text Move and Character Animation
* Text Invert and timeline-based animations
* Dynamic Timelines with Play, Pause, and Reverse

**GSAP Features:**
* DrawSVG Animation
* MorphSVG Animation
* Draggable Animations
* MotionPath Animation
* ScrambleText Animation
* Interactive Cursor Effects
* Advanced Parallax Scrolling
* Observer Plugin Integration
* Intersection-Based Animations
* ScrollTrigger and ScrollSmoother
* Hover and Scrolling Animations
* SplitText and Text Reveal Animation
* Advanced Easing and Motion Animation
* Looped Animations with Repeat and Yoyo Effects
* Intuitive navigation with smooth scrolling effects

Animation Addons for Elementor is a game-changer in animation-focused web design. The blend of its advanced animations, customizable features, and unique functionality set it apart from competitors. Whether you’re a web developer, designer, agency owner, or website owner, the plugin caters to your holistic professional needs.

## Animation Addons for Elementor Extensions List 
Once you have designed your dream website with all the requisite elements, you may further need to upgrade the functionality, animations, and look. In this case, you can make use of our intuitive extensions. Below is a curated list that provides a brief description of our exclusive extensions.

### General Extensions:
**Custom CSS:** Add custom CSS styles directly within Elementor for precise design control.

**Wrapper Link:** Transform entire container sections into clickable links for seamless navigation.

**Popup:** Create engaging popups to enhance user interaction and showcase important content.

**Tilt Effect:** Tilt an element based on the visitor’s mouse movement for a visual experience.

**Advanced Tooltip:** Display additional information about elements when users hover over them.

**Custom Fonts:** Integrate unique custom fonts to maintain a consistent brand identity.

**Mega Menu:** Create a customizable, expansive mega menu for seamless navigation.

### GSAP Extension:
**Smooth Scroller:** Allow users to navigate web pages more smoothly and naturally.

**Animation:** Implement diverse advanced animations for a visually appealing website.

**Pin Element:** Fix elements in a particular space during scrolling to make them always visible.

**Text Animation:** Create smooth text effects to make headings and content engaging.

**Image Animation:** Add dynamic animations to images to capture the user's attention.

**Cursor Hover Effect:** Add unique hover animations based on the cursor to increase interactivity.

**Hover Effect Image:** Ensure hover-specific image transformation for a modern touch.

**Cursor Move Effect:** Add immersive animations based on the cursor movement.

**Horizontal ScrollTrigger:** Create animations when the user performs horizontally scrolling.

**DrawSVG:** Allows users to progressively reveal or hide the stroke of an SVG.

**Portfolio Filter:** Implement animated filters to organize and showcase portfolio items.

**Animation Builder:** Create and customize animations with an intuitive, user-friendly interface.

## Animation Addons For Elementor Widget List 
Take your website design to the next level with 100+ Elementor widgets. Whether you need dynamic sliders, service boxes, headers, portfolios, progress bars, breadcrumbs, accordions, post-feature images, or excerpts, Animation Addons got you covered.

### Header and Footer Widgets:
**Site Logo:** Display the logo of the website at a prominent location to establish brand identity and recognition.

**Nav Menu:** Present a collection of links or buttons representing various destinations within the website to allow users to easily navigate to specific areas.

### Dynamic Widgets:
**Post Title:** Dynamically displays the title of a specific post or page within a website’s layout.

**Post Feature Image:** Displays the featured image associated with a specific post or page within a website’s layout.

**Post Excerpt:** Showcases a summary or excerpt of a specific post or page within a website’s layout.

**Post Content:** Present the core content, including text, images, videos, and other multimedia elements.

**Post comment:** Enable users to leave comments, feedback, and discussions on individual posts or pages.

**Post Meta Info:** Provide supplementary information about individual posts or pages.

**Post Paginate:** Break down content into manageable chunks or pages, allowing users to browse through multiple posts.

**Post Social Share:** Facilitate social media sharing of individual posts or articles in order to expand the reach and visibility.

**Post:** Showcase a list of blog posts or any custom post types on your website in multiple unique styles.

**Archive Title:** Dynamically displays the title of an archive page based on specific criteria, such as date, category, tag, or author.

**Portfolio:** Display website pages, posts, and custom post types in a filterable grid.

**Search Form:** Provide users with a simple and intuitive interface to input search queries and retrieve relevant results from the website’s database.

**Search Query:** Display search results in real-time as users type their query into the search field.

**Search No Result:** Provide users with helpful guidance and options when their search attempts fail to return any relevant content.

### Form Widgets
**Contact Form 7:** Personalize your Contact Form 7 forms as per your specific needs.

**Mailchimp:** Enable users to add opt-in forms to your website for collecting emails.

### Video Widgets
**Video Popup:** Display a video on top of a website to increase engagement.

**Video Box:** Display external and self-hosted videos on websites from various sources.

**Video Box Slider:** Let users create a slider of videos from various sources on your website.

**Video Mask:** Create transitions, visual effects, and isolate video effects in a video.

### Advanced Widgets
**Toggle Switcher:** Enable users to select between two mutually exclusive states, on or off.

**Advanced Portfolio:** Add a responsive portfolio slider or grid to showcase images, videos, or projects.

**Table of Content:** Generate a list of navigation links to different sections of a page.

**Flip Box:** Provide design flexibility through flip, slide, fade, zoom-in, and zoom-out effects.

**Advanced Accordion:**  Enable users to create collapsible content sections on a website.

**Advanced Pricing Table:** Showcase complete pricing information in a structured, effective way.

**Filterable Gallery:** Create an organized, attractive image gallery for the website.

**Image Accordion:** Display a series of images in an interactive, compact way.

**Advanced Slider:** Empower users to customize and create advanced-level sliders on a website.

**Scroll Elements:** Provide scroll-driven interactions when the user scrolls down the pages.

**Breadcrumbs:** Show the path to the current page to ensure easy navigation.

**Author Box:**  Display full information about the author of a particular page or post.

**Filterable Slider:** Allows users to filter data in a report by removing unwanted data.

### General Widgets 
Even though it’s named General Widgets, every widget is fully animatable with our plugin.

**Animated Title:** Animate your title as you want, fade, animate by character, animate with word, animate with line, text reveal, 3d text move, and more.

**Animated Text:** Animate your text as you want, fade, animate by character, animate with word, animate with line, text reveal, and more.

**Image Box:** Present any image with unique animation with 5 different styles.

**Image Box Slider:** Present any image with a unique slider with 5 different Styles.

**Image:** Display images such as a company logo, photo, or illustration, in PNG, JPEG, WebP, or GIF format.

**Image Gallery:** Make an image gallery with multiple styles and animation.

**Brand Slider:** Show your client, or brand slider with multiple styles including text and image.


**Text Hover Image:** Allows users to add a text overlay to an image when they hover over it.

**Counter:** Add an animated numbered counter to count numbers.

**Icon Box:**  Showcase information using icons, titles, and descriptions with multiple styles.

**Testimonial:** Showcase your client feedback with 11 unique styles.

**Testimonial 2:** Showcase your client feedback with 3 unique styles.

**Testimonial 3:**  Showcase your client feedback with 1 unique style.

**Button:** Include next-generation buttons with 7  different styles.

**Image Compare:** Compare two images side by side to show the differences between them.

**Progress Bar:** Display the completion of tasks or processes to users in different styles.

**Social Icons:** Add multiple icons to your website that link to your social media profiles.

**Team:** Showcase your team in style and build credibility effortlessly.

**One Page Nav:** Simplify navigation with smooth scrolling effect.

**Timeline:** Easily create timelines for your journey or events with multiple styles.

**Tabs:** Simplify navigation and make your website more user-friendly.

**Services Tab:** Effortlessly showcase your services with multiple styles.

**Floating Elements:** Effortlessly add captivating animations like floating, moving, zooming in/out, and rounding.

**Event Slider:** Display special events with captivating sliders.

**Content slider:** Create captivating sliders to showcase your information seamlessly.

**Countdown:** Easily incorporate countdowns to create excitement for events or promotions.

**Typewriter:** Create a dynamic and engaging typing effect to captivate your audience.

**Animated Heading:** Allows users to create captivating and engaging website headlines.

##  Animation Addons for Elementor: Key Features

### GSAP Animations:
GSAP, or GreenSock Animation Platform, uses a robust JavaScript library for high-performance animation on websites. In combination with GSAP, the Animation Addons WordPress plugin lets users create ScrollTrigger, ScrollSmoother, ScrollTo, SplitText, ScrambleText, DrawSVG, Easing Effects, MorphSVG and many more motion animations.

**Here’s the complete, all-encompassing list of GSAP's features:**

#### Core GSAP Animation Features
– Tweens 
– Timelines 
– Keyframes
– Easing Functions
– Delays and Stagger
– Repeat and Yoyo
– Reversing
– Duration Control
– Dynamic Updates
– Immediate Render
– Overwrite Modes
– Custom Eases
– Target Independent Units

#### Scroll-Based Animations
– ScrollTrigger 
– ScrollSmoother
– ScrollToPlugin

#### SVG and Shape Animations
– MorphSVG
– DrawSVG
– MotionPath
– MotionPath

#### Text Animations
– SplitText
– ScrambleText
– Text Move
– Text Invert

#### 3D and Transform Animations
– 3D Rotations
– Perspective Control
– 3D Scaling
– 3D Spin

### 100+ Elementor Widgets:
Explore limitless website design possibilities with a custom library of **100+ powerful widgets** exclusively built for Elementor. Some of these widgets include dynamic slider, service, header, portfolio, progress bar, breadcrumb, accordion, post feature image, excerpt, and much more.

### Text and Image Animation:
Transform static text and images into interactive elements with advanced animation features. You can select from the different effects, like typewriter text, text split, 3D rotation for images, etc. In addition, you can create attention-grabbing parallax scrolling, reveals, mouseovers, and rotating effects on your website.

### Custom Animation Builder:
Create animations using the custom animation builder of your own choice. This Elementor Addons allows you to design, preview, and deploy animations with creativity. Everything is customizable and based on duration, timing, triggers, easing effects, etc.

To craft tailored animations such as fade-in, fade-out, slide-in, slide-out, zoom-in, zoom-out, and other intricate motion paths, the intuitive builder gives you full control. The easy-to-use tool allows newcomers to build complex animations without requiring any form of coding knowledge.

### Header Footer Builder:
Create custom headers and footers that perfectly align with your site’s branding with the pre-built header footer builder. You can add logos, menus, call-to-action buttons, and even animated elements to these key areas with drag & drop functionality. 

### Custom Mega Menu Builder:
With the custom mega menu builder, you can create an expandable menu to display multiple categories of links in a grid layout. This intuitive tool lets you include icons, images, and animations in your navigation menus.

### Smooth Scrolling Effects:
Add a sleek and modern touch to your scrolling experience with the smooth scrolling feature of the addons. It’s ideal for long-form content or one-page designs, where things move from one section. Smooth scrolling significantly minimizes sudden jumps and improves flow.

### Pin Elements:
Use the pinning elements to keep the important content always visible. This Elementor animation plugin ensures that key elements like a sticky navigation bar, promotional banner, or call-to-action button remain accessible as users scroll through your site. 

### Archive Page Builder:
The archive page builder will allow you to craft custom templates for the category, taxonomies, or tag archive pages. You can create beautiful and organized archive pages in no time by implementing its elegant template system from page to page.

### Single Page & Post Builder:
With this WordPress plugin’s single page and post builder, you can add custom single pages and post templates. It lets you personalize every page element, including the header, content structure, interactions, and animations.

### Unique Popup Builder:
Unique popup builder, powered by Animation Addons for Elementor, streamlines the creation of some of the most engaging and highly customizable pop-ups. It helps you to set up a pop-up with lots of design and targeting options.

### One Page Scroll:
Create modern, one-page websites with the one-page scroll feature of the Animation Addons. This tool lets you build fluid navigation with easy transitions as you can scroll through an entire page at once. 

## Why Use Animation Addons for Elementor?

### Custom CSS:
Animation Addons for Elementor empower you to take full control in custom CSS. You can personalize your website just the way you like by changing layouts, colors, animations, and typography. It offers pinpoint accuracy to build a website that meets your specific vision.

### Completely Customizable:
Experience unrivaled versatility with fully customizable design options. A website built with the help of the comprehensive customizability of Animation Addons for Elementor is always incredibly beautiful to look at.

### Multi-Widget Area:
Animation Addons for Elementor focuses on maximizing your website’s overall functionality with a multi-widget area. You can insert multiple widgets in different areas of your website anytime you desire

### Instant Loading:
Animation Addons for Elementor is built to minimize delays and let you experience immediate loading times. Unlike other animation plugins, our plugin is super fast and SEO-friendly.  With a view to keeping visitors engaged and reducing bounce rates, the plugin will make your content appear quickly.

This plugin using the modified version of [WP import 2.0] (https://github.com/humanmade/WordPress-Importer).

== Frequently Asked Questions ==

= What is Animation Addons for Elementor? =

Animations Addons for Elementor is a cutting-edge WordPress plugin that enhances the built-in Elementor functionality. It’s packed with advanced widgets, pre-designed builders, and custom animations to empower users to build dynamic, interactive, and professional websites. All the widgets and features cater to enhancing the functionality, interactivity, and design aesthetics of websites. 

Some of its premium widgets include Advanced Accordion, Advanced Portfolio, Toggle Switcher, Table of Content, Flip Box, Filterable Slider, Video Mask, and so on. The Elementor Addons also has an intuitive widget to create a mega menu. It enables users to easily create and customize mega menus by adding layouts, animations, and other functionality. 

= Why Animation Addons for Elementor is the Best Plugin for WordPress Animation? =

Animation Addons for Elementor combines GSAP’s animation power with Elementor’s user-friendly design, which makes it the ultimate tool for WordPress animations. 

**Here’s why it’s the best WordPress animation plugin:**

**Seamless Elementor Integration:** Easily animate any element without coding.

**Extensive Animation Library:** Pre-built animations for diverse design needs.

**GSAP-Powered Features:** Access advanced tools like **ScrollTrigger, ScrollSmoother, MotionPath, SplitText, ScrollTo, Observer, Draggable, ScrambleText, DrawSVG, Easing Effects, and MorphSVG.**

**Advanced Control:** Manage timelines, easing functions, and triggers with precision.

**Optimized for Performance:** Ensures smooth animations without impacting site speed.

**Developer-Friendly:** Offers intuitive previews for beginners and custom options for experts.

**Regular Updates:** Actively maintained with frequent updates and excellent 24/7 chat support.

= How do Animation Addons for Elementor outperform other GSAP plugins for WordPress? =

**Animation Addons for Elementor outperforms other GSAP plugins for WordPress in several key ways:**
**Complete GSAP Integration:** Unlike other plugins, it fully integrates with GSAP’s suite of features, offering tools like ScrollTrigger, ScrollSmoother, MotionPath, MorphSVG, and Flip, providing greater flexibility and control over animations.

**Performance-Focused:** Built to ensure high-performance animations, it avoids the performance issues that some other plugins might introduce by offering smooth, fluid animations that don’t impact site speed.

**Superior Ease of Use:** While other GSAP plugins may require extensive coding, Animation Addons for Elementor provides an intuitive interface with visual previews, allowing for easy animation creation without any development knowledge.

 **Advanced Control Over Animations:** It offers granular control over animation sequences, timelines, and triggers, giving designers and developers the ability to create complex, custom animations with precision.

**Frequent Updates:** Unlike some other plugins that lack regular updates, this plugin is consistently improved, with new features and bug fixes released to ensure long-term reliability and compatibility with WordPress and Elementor.

= How do I enable smooth scrolling with Animation Addons for Elementor? = 

To enable smooth scrolling, go to Animation Addons > Settings in your WordPress dashboard. Then navigate to the “Extensions” tab. Under the “Gsap Extension” option, enable the “Smooth Scroller” option. Finally, click on “Save Settings” to activate the effect. 

= Can I use Animation Addons for Elementor without any coding experience? =

Yes, you can use Animation Addons for Elementor without any coding experience. The plugin is designed with a user-friendly interface that allows you to create stunning animations easily through Elementor’s drag-and-drop editor. You can select from a wide range of pre-built animations, customize them visually, and apply them to any element on your page—no coding required. The intuitive setup and real-time visual previews make it simple for anyone, regardless of coding knowledge, to create professional animations.

= What types of animations can I add with Animation Addons for Elementor? =

You can animate anything with our addon. It empowers you to add a wide variety of advanced animations, including scroll-triggered animations, hover effects, and other custom animations tailored to your unique design needs. From text to image, you can animate everything you want.

= Do the Animation Addons For Elementor have any issues with performance, speed, and CLS? = 

No, our Elementor Addons ensure the best website speed & performance. Despite using GSAP and other animations like Lottie, it doesn’t affect the loading times. Our animations are SEO-friendly and lightweight. Our plugin also complies with CLS (Cumulative Layout Shift) to ensure the Core Web Vital performance. 

= How do I resolve plugin conflicts or errors? = 

To resolve a conflict or error, you have to download the latest version of Animation Addons for Elementor and Elementor plugins. We continuously update our plugin with new features and animations.

= Is there any documentation or support available for the plugin? =

Yes, our website provides detailed, easy-to-understand documentation and dedicated 24/7 support to troubleshoot technical issues. 

= Can I use the plugin without Elementor Page Builder? =

No. You cannot use it without Elementor since it’s an addon for Elementor.

= Do I need to know the code to use Animation Addons for Elementor? =

You don’t need to know the code to use the widgets and modules of Animation Addons for Elementor. That means, without any coding expertise, you can leverage all the elements to enhance your web design experience.

= Is Animation Addons for Elementor Plugin Free? =

The Animation Addons for Elementor provide a 3-month free trial for new users. Most widgets and extensions are free, and paid options are available. You can choose the pro version to use its advanced features. But its free version has plenty of options for professionals.


== Changelog ==

## **v2.0 – 03 March 2025**

- ❌ **Removed:** GoodShare Library from social share widget 
- 🔄 **Updated:** Updated Dashboard UI
- 🆕 **New Feature:** Added **Template Library** 

## **v1.1.9 – 20 February 2025**
- 🔄 **Updated:** Upgraded `SweetAlert.js` and `Typed.js` to the latest versions for improved performance and security.  
- ✅ **Compatibility:** Verified full compatibility with **Elementor core**.  
- ❌ **Removed:** Deprecated donation link for a cleaner user experience.  
- 🔒 **Fixed:** Resolved **nonce security vulnerabilities** to enhance website security.  

## **v1.1.8 – 17 December 2024**
- 🎨 **Fixed:** Resolved **Swiper slider styling issues** for better mobile and desktop responsiveness.  
- ✅ **Compatibility:** Ensured smooth integration with **Elementor core**.  

## **v1.1.7 – 10 December 2024**
- 🔒 **Security Fixes:**  
  - Patched security vulnerabilities in **Tab Widget** and **Content Slider Widget**.  
  - Implemented additional security layers for safer user interaction.  
- 🆕 **New Feature:** Added **role-based access control** for **template selection** in Tab and Content Slider Widgets.  

## **v1.1.6 – 27 November 2024**
- 🛠️ **Fixed:** Corrected **text domain issues** for better multilingual support.  
- ✅ **Tested:** Conducted compatibility tests with WordPress and Elementor updates.  

## **v1.1.5 – 22 October 2024**
- 🚀 **Performance Boost:** Optimized **Social Share Widget** for **faster loading speed** and **improved SEO performance**.  

## **v1.1.4 – 22 October 2024**
- 🆕 **New Addition:** Added a **download link** for the **"Extension for Animation Addons" plugin**, enabling **GSAP animation features**.  

## **v1.1.3 – 21 October 2024**
- 🎨 **UI Enhancements:**  
  - Introduced **responsive title margin controls** in the **Counter Widget** for improved layout customization.  
- 🔄 **Bug Fixes:**  
  - Resolved **meta description duplication** issue for better SEO indexing.  
  - Fixed **GoodShare console errors** to prevent script conflicts.  

## **v1.1.2 – 22 September 2024**
- 🎨 **UI Enhancement:** Added **responsive input field height controls** in the **Contact Form 7 Widget** for better mobile optimization.  

## **v1.1.1 – 14 September 2024**
- ⚡ **Performance Upgrade:**  
  - Replaced the outdated `Waypoints.js` library with the **native Intersection Observer API** for **faster and more efficient animations**.  
- 🛠️ **Fixed:** **Progress Bar Widget** issue where progress was not displaying correctly.  

## **v1.0.0 – 1 April 2024**
- 🚀 **Initial Release**
