<?php
ob_start();
?>

<main class="container-fluid p-0">
  
<div class="modal fade" id="addWeekModal" tabindex="-1">
    <div class="modal-dialog">
        <form id="addWeekForm" enctype="multipart/form-data">
            <div class="modal-content">
                <div class="modal-header">
                    <h5>Add Week</h5>
                    <button class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input class="form-control mb-2" name="weekname" placeholder="Week Name">
                    <input class="form-control mb-2" name="weeknumber" placeholder="Week Number">
                    <input class="form-control mb-2" name="title" placeholder="Title">
                    <input type="file" class="form-control" name="image">
                </div>
              <button class="btn btn-primary" id="addWeekBtn">
    Save
</button>
            </div>
        </form>
    </div>
</div>
<div class="modal fade" id="editWeekModal" tabindex="-1">
    <div class="modal-dialog">
        <form id="editWeekForm" enctype="multipart/form-data">
            <input type="hidden" name="id" id="edit_id">

            <div class="modal-content">
                <div class="modal-header">
                    <h5>View / Edit Week</h5>
                    <button class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input class="form-control mb-2" name="weekname" id="edit_weekname">
                    <input class="form-control mb-2" name="weeknumber" id="edit_weeknumber">
                    <input class="form-control mb-2" name="title" id="edit_title">
                    <input type="file" class="form-control" name="image">
                </div>
               <button class="btn btn-success" id="editWeekBtn">
    Save Changes
</button>

            </div>
        </form>
    </div>
</div>


    <div class="px-6 px-lg-7 pt-8 border-bottom mb-4">
        <div class="row mb-5">
            <div class="col-12 col-md-6">
                <h2>Weeks</h2>
            </div>
            <div class="col-12 col-md-6 d-flex justify-content-end">
               <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addWeekModal">+ Add</button>

            </div>
            <div class="hstack gap-2 ms-auto"></div>
        </div>
    </div>

    <!-- Search Field -->
    <div class="row float-end m-auto d-flex justify-content-end mt-4">
        <div class="px-6 col-md-4">
            <div class="mb-3">
                <input type="text" id="userSearch" class="form-control" placeholder="Search Users...">
            </div>
        </div>
    </div>

    <div class="container">
       <table class="table" id="weeksTable">
    <thead>
        <tr>
            <th>#</th>
            <th>Week Name</th>
            <th>Week Number</th>
            <th>Title</th>
            <th>Image</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody id="weeksTableBody">
        <tr>
            <td colspan="6">Loading...</td>
        </tr>
    </tbody>
</table>

    </div>

    <div class="py-4 px-6">
        <div class="row align-items-center justify-content-between">
            <div class="col-md-6 d-none d-md-block"></div>
            <div class="col-md-auto">
                <nav aria-label="Page navigation"></nav>
            </div>
        </div>
    </div>
</main>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
const API_BASE = "https://projects.funtashtechnologies.com/gomeetapi";

/* ===============================
   LOAD ALL WEEKS
================================ */
function loadWeeks() {
    $.get(`${API_BASE}/getallweekcategories.php`, function(res) {
        let rows = '';
        if (res.Result === "true") {
            res.Data.forEach((w, i) => {
                rows += `
                <tr>
                    <td>${i + 1}</td>
                    <td>${w.weekname || '-'}</td>
                    <td>${w.weeknumber || '-'}</td>
                    <td>${w.title || '-'}</td>
                    <td>${w.image ? `<img src="https://projects.funtashtechnologies.com/gomeetapi/${w.image}" width="90">` : '-'}</td>
                    <td>
                        <button class="btn btn-sm btn-primary viewBtn" data-id="${w.id}">View</button>
                        <button class="btn btn-sm btn-danger delBtn" data-id="${w.id}">Delete</button>
                    </td>
                </tr>`;
            });
        }
        $("#weeksTableBody").html(rows);
    });
}
loadWeeks();

/* ===============================
   ADD WEEK (POST)
================================ */
$("#addWeekForm").on("submit", function(e) {
    e.preventDefault();

    let $btn = $("#addWeekBtn");
    let originalText = $btn.text();

    $btn.prop("disabled", true).text("Saving...");

    let formData = new FormData(this);

    $.ajax({
        url: `${API_BASE}/weekcategories.php`,
        type: "POST",
        data: formData,
        processData: false,
        contentType: false,
        success: () => {
            $("#addWeekModal").modal('hide');
            loadWeeks();
            $("#addWeekForm")[0].reset();
        },
        error: () => {
            alert("Something went wrong");
        },
        complete: () => {
            $btn.prop("disabled", false).text(originalText);
        }
    });
});


/* ===============================
   VIEW WEEK (GET BY ID)
================================ */
$(document).on("click", ".viewBtn", function() {
    let id = $(this).data("id");

    $.get(`${API_BASE}/getweekcategories.php?id=${id}`, function(res) {
        let w = res.Data;
        $("#edit_id").val(w.id);
        $("#edit_weekname").val(w.weekname);
        $("#edit_weeknumber").val(w.weeknumber);
        $("#edit_title").val(w.title);
        $("#editWeekModal").modal("show");
    });
});

/* ===============================
   UPDATE WEEK (PUT)
================================ */
$("#editWeekForm").on("submit", function(e) {
    e.preventDefault();

    let $btn = $("#editWeekBtn");
    let originalText = $btn.text();

    $btn.prop("disabled", true).text("Saving...");

    let formData = new FormData(this);

    $.ajax({
        url: `${API_BASE}/updateweekcategories.php`,
        type: "PUT",
        data: formData,
        processData: false,
        contentType: false,
        success: () => {
            $("#editWeekModal").modal('hide');
            loadWeeks();
        },
        error: () => {
            alert("Update failed");
        },
        complete: () => {
            $btn.prop("disabled", false).text(originalText);
        }
    });
});


/* ===============================
   DELETE WEEK
================================ */
$(document).on("click", ".delBtn", function() {
    if (!confirm("Delete this week?")) return;
    let id = $(this).data("id");

    $.ajax({
        url: `${API_BASE}/deleteweekcategories.php?id=${id}`,
        type: "DELETE",
        success: () => loadWeeks()
    });
});
</script>

<?php
$content = ob_get_clean();
include '../layouts/master.php';
?>