<?php
ob_start();
?>

<main class="container-fluid p-0">
    <div id="imagePopup">
        <img src="" alt="Full Image">
    </div>
    <div class="px-6 px-lg-7 pt-8 border-bottom mb-4">
        <div class="row">
            <div class="col-12 col-md-6">
                <h2 id="fullNameHeading">User Details</h2>
            </div>
            <div class="col-12 col-md-6 d-flex justify-content-end">
                <select class="form-select fw-semibold w-max" id="status">

                </select>
            </div>


            <div class="my-2 my-md-3">
                <hr>
            </div>
            <div class="col-12">

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">First Name</label>
                        <input type="text" class="form-control" id="firstname">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Last Name</label>
                        <input type="text" class="form-control" id="lastname">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Email Address</label>
                        <input type="email" class="form-control" id="email">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Password</label>
                        <input type="text" class="form-control" id="password">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Gender</label>
                        <input type="text" class="form-control" id="gender">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Date of Birth</label>
                        <input type="text" class="form-control" id="dateofbirth">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Height</label>
                        <input type="text" class="form-control" id="height">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Marital Status</label>
                        <input type="text" class="form-control" id="maritalstatus">
                    </div>
                    
                   
                 
                    
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Employment Status</label>
                        <input type="text" class="form-control" id="employmentstatus">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Monthly Income</label>
                        <input type="text" class="form-control" id="monthlyincome">
                    </div>
                   

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Religion </label>
                        <input type="text" class="form-control" id="religion">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Religion Looking For</label>
                        <input type="text" class="form-control" id="religionlookingfor">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Country</label>
                        <input type="text" class="form-control" id="country">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Country Looking for</label>
                        <input type="text" class="form-control" id="countrylookingfor">
                    </div>
                       <div class="col-md-6 mb-3">
                        <label class="form-label">City</label>
                        <input type="text" class="form-control" id="city">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">City Looking For</label>
                        <input type="text" class="form-control" id="citylookingfor">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Education</label>
                        <input type="text" class="form-control" id="education">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Education Looking For</label>
                        <input type="text" class="form-control" id="educationlookingfor">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Cast</label>
                        <input type="text" class="form-control" id="cast">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Cast Looking For</label>
                        <input type="text" class="form-control" id="castlookingfor">
                    </div>
                   
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Sect</label>
                        <input type="text" class="form-control" id="sect">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Sect Looking For</label>
                        <input type="text" class="form-control" id="sectlookingfor">
                    </div>
                   
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Ethnicity </label>
                        <input type="text" class="form-control" id="ethnicity">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Ethnicity Looking For</label>
                        <input type="text" class="form-control" id="ethnicitylookingfor">
                    </div>

                    <div class="col-md-4 col-12 mb-3">
                        <label class="form-label">Profile Image</label>
                        <div>
                            <img id="profileimage" src="" alt="Selfie" width="150" class="img-user">
                        </div>
                    </div>
                    <div class="col-md-4 col-12 mb-3">
                        <label class="form-label">Selfie Image</label>
                        <div>
                            <img id="selfieimage" src="" alt="Selfie" width="150" class="img-user">
                        </div>
                    </div>

                    <div class="col-md-4 col-12 mb-3">
                        <label class="form-label">CNIC Front</label><br>
                        <img id="cnic_front" src="" class="img-user" />
                    </div>
                    <div class="col-md-4 col-12 mb-3">
                        <label class="form-label">CNIC Back</label><br>
                        <img id="cnic_back" src="" class="img-user" />
                    </div>
                    <div class="col-md-4 col-12mb-3">
                        <label class="form-label">Passport Front</label><br>
                        <img id="passport_front" src="" class="img-user" />
                    </div>
                    <div class="col-md-4 col-12 mb-3">
                        <label class="form-label">Passport Back</label><br>
                        <img id="passport_back" src="" class="img-user" />
                    </div>
                </div>

            </div>
        </div>
    </div>
</main>

<!-- JS SECTION -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function() {
        function getQueryParam(name) {
            const urlParams = new URLSearchParams(window.location.search);
            return urlParams.get(name);
        }

        const userId = getQueryParam("id");
        const apiUrl = `https://projects.funtashtechnologies.com/gomeetapi/adminpanel/getuserdetail.php?id=${userId}`;

        if (userId) {
            $.getJSON(apiUrl, function(response) {
                if (response.Result === "true") {
                    const user = response.Data;

                    $("#firstname").val(user.firstname ?? '');
                    $("#lastname").val(user.lastname ?? '');
                    $("#email").val(user.email ?? '');
                    $("#password").val(user.password ?? '');
                    $("#gender").val(user.gender ?? '');
                    $("#dateofbirth").val(user.dateofbirth ?? '');
                    $("#height").val(user.height ?? '');
                    $("#maritalstatus").val(user.maritalstatus ?? '');
                    $("#religion").val(user.religion ?? '');
                    $("#country").val(user.country ?? '');
                    $("#city").val(user.city ?? '');
                    $("#education").val(user.education ?? '');
                    $("#employmentstatus").val(user.employmentstatus ?? '');
                    $("#monthlyincome").val(user.monthlyincome ?? '');
                    $("#cast").val(user.cast ?? '');
                    $("#sect").val(user.sect ?? '');
                    $("#ethnicity").val(user.ethnicity ?? '');
                    $("#religionlookingfor").val(user.religionlookingfor ?? '');
                    $("#religion").val(user.religion ?? '');
                    $("#countrylookingfor").val(user.countrylookingfor ?? '');
                    $("#country").val(user.country ?? '');
                    $("#city").val(user.city ?? '');
                    $("#citylookingfor").val(user.citylookingfor ?? '');
                    $("#education").val(user.education ?? '');
                    $("#educationlookingfor").val(user.educationlookingfor ?? '');
                    $("#castlookingfor").val(user.castlookingfor ?? '');
                    $("#cast").val(user.cast ?? '');
                    $("#subcast").val(user.subcast ?? '');
                    $("#subcastlookingfor").val(user.subcastlookingfor ?? '');
                    $("#sect").val(user.sect ?? '');
                    $("#sectlookingfor").val(user.sectlookingfor ?? '');
                    $("#subsect").val(user.subsect ?? '');
                    $("#subsectlookingfor").val(user.subsectlookingfor ?? '');
                    $("#ethnicity").val(user.ethnicity ?? '');
                    $("#ethnicitylookingfor").val(user.ethnicitylookingfor ?? '');

                    const status = (user.status ?? '').toLowerCase();

                    if (status === 'verified') {
                        $("#status").html(`
        <option value="verified" selected>Verified</option>
        <option value="unverified">Not Verified</option>
    `);
                    } else {
                        $("#status").html(`
        <option value="unverified" selected>Not Verified</option>
        <option value="verified">Verified</option>
    `);
                    }

                    $("#fullNameHeading").text(`${user.firstname ?? ''} ${user.lastname ?? ''}`);

                    if (user.profileimage) {
                        $("#profileimage").attr("src", `https://projects.funtashtechnologies.com/gomeetapi/${user.profileimage}`).show();
                    } else {
                        $("#profileimage").hide();
                    }
                    if (user.selfieimage) {
                        $("#selfieimage").attr("src", `https://projects.funtashtechnologies.com/gomeetapi/${user.selfieimage}`).show();
                    } else {
                        $("#selfieimage").hide();
                    }

                    // CNIC Front
                    if (user.cnic_front) {
                        $("#cnic_front").attr("src", `https://projects.funtashtechnologies.com/gomeetapi/${user.cnic_front}`).show();
                    } else {
                        $("#cnic_front").hide();
                    }

                    // CNIC Back
                    if (user.cnic_back) {
                        $("#cnic_back").attr("src", `https://projects.funtashtechnologies.com/gomeetapi/${user.cnic_back}`).show();
                    } else {
                        $("#cnic_back").hide();
                    }

                    // Passport Front
                    if (user.passport_front) {
                        $("#passport_front").attr("src", `https://projects.funtashtechnologies.com/gomeetapi/${user.passport_front}`).show();
                    } else {
                        $("#passport_front").hide();
                    }

                    // Passport Back
                    if (user.passport_back) {
                        $("#passport_back").attr("src", `https://projects.funtashtechnologies.com/gomeetapi/${user.passport_back}`).show();
                    } else {
                        $("#passport_back").hide();
                    }
                } else {
                    alert("User not found.");
                }
            }).fail(function() {
                alert("Failed to fetch user data.");
            });
        } else {
            alert("No user ID provided in URL.");
        }


        $(".img-user").on("click", function() {
            const imgSrc = $(this).attr("src");
            if (imgSrc) {
                $("#imagePopup img").attr("src", imgSrc);
                $("#imagePopup").fadeIn();
            }
        });

        $("#imagePopup").on("click", function() {
            $(this).fadeOut();
        });

        $("#status").on("change", function() {
            const newStatus = $(this).val();
            console.log(newStatus)
            if (!userId) return;

            $.ajax({
                url: "https://projects.funtashtechnologies.com/gomeetapi/adminpanel/updatestatus.php",
                method: "POST",
                contentType: "application/json",
                data: JSON.stringify({
                    id: userId,
                    status: newStatus
                }),
                success: function(res) {
                    if (res.Result === "true") {
                        alert("You have changed the user verification to " + newStatus + ".");

                    } else {
                        alert("Failed to update status: " + res.ResponseMsg);
                    }
                },
                error: function() {
                    alert("Error sending status update.");
                }
            });
        });

    });
</script>

<?php
$content = ob_get_clean();
include '../layouts/master.php';
?>