<?php

ob_start();
// Assuming you've fetched the city data from a database as mentioned above
$countryId = $_GET['id'];  // Get city ID
$pdo = new PDO('mysql:host=localhost;dbname=meetup', 'root', '');  // Adjust connection details
$stmt = $pdo->prepare('SELECT * FROM tableCountries WHERE id = :id');
$stmt->execute(['id' => $countryId]);
$countryData = $stmt->fetch(PDO::FETCH_ASSOC);

?>
<main class="container-fluid px-6 pb-10">
  <header class="py-4 border-bottom">
    <div class="row align-items-center">
      <div class="col">
        <div class="d-flex align-items-center gap-4">
          <h1 class="h4 ls-tight">Update Country</h1>
        </div>
      </div>
    </div>
  </header>
    <form id="updatecountryForm">
    <div class="row">
      <div class="col-md-4 d-none">
        <div class="form-group">
        <label for="id" class="form-lable ">Country ID:</label>
        <input type="hidden" class="form-control"  id="id" name="id" value="<?php echo $countryData['id']; ?>" required>
      </div>
      </div>
        <div class="col-md-6">
          <div class="form-group">
          <label for="country" class="form-lable">Country Name:</label>
          <input type="text" id="country" name="country" class="form-control" value="<?php echo $countryData['country']; ?>" required>
          </div>
        </div>
          <div class="col-md-6">
            <div class="form-group">
              <label for="country_iso" class="form-lable">Country Iso:</label>
              <input type="text" id="country_iso" class="form-control" name="country_iso" value="<?php echo $countryData['country_iso']; ?>" required>
          </div>
        </div>
    </div>
    <div class="float-end mt-4">
      <button class="btn btn-success text-white" type="submit">Update Country</button>
    </div>
    </form>
</main>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
    $(document).ready(function() {
        $('#updatecountryForm').on('submit', function(e) {
            e.preventDefault(); // Prevent the default form submission

            let formData = {
                id: $('#id').val(),
                country: $('#country').val(),
                country_iso: $('#country_iso').val(),
            };

            $.ajax({
                url: 'http://localhost/gomeetapi/updatecountry.php',  // Replace with the correct API URL
                type: 'PUT',
                contentType: 'application/json',
                data: JSON.stringify(formData),
                success: function(response) {
                    if (response.status) {
                        $('#responseMessage').html('<p class="btn btn-success">Country updated successfully!</p>');
                        // Redirect to cities list page after 2 seconds
                        setTimeout(function() {
                            window.location.href = 'allcountries.php'; // Replace with the correct cities list page URL
                        }, 1000);
                    } else {
                        $('#responseMessage').html('<p class="btn btn-warning">Failed to update Country: ' + response.message + '</p>');
                    }
                },
                error: function(xhr, status, error) {
                    $('#responseMessage').html('<p>Error occurred while updating Country: ' + error + '</p>');
                }
            });
        });
    });
</script>

<?php
$content = ob_get_clean();
include '../layouts/master.php';
?>